package com.icetech.park.service.monthcar.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.api.ManageService;
import com.icetech.cloudcenter.api.month.MonthCarService;
import com.icetech.cloudcenter.api.month.MonthrenewePubcheckService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.constants.CardStatusConstants;
import com.icetech.cloudcenter.domain.enumeration.DataCollectionEnum;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.pay.MonthOpenCardDto;
import com.icetech.cloudcenter.domain.pay.MonthRenewCardDto;
import com.icetech.cloudcenter.domain.request.*;
import com.icetech.cloudcenter.domain.response.*;
import com.icetech.common.constants.*;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.DateUtils;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.fee.dao.monthcar.*;
import com.icetech.fee.domain.entity.monthcar.*;
import com.icetech.fee.service.monthcar.MonthProductRegionService;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.park.domain.dto.InvoiceParksDto;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.down.pnc.impl.IssuedCardServiceImpl;
import com.icetech.park.service.down.pnc.impl.ShowAndSayServiceImpl;
import com.icetech.park.service.monthcar.MonthCarServiceBase;
import com.icetech.third.anno.DS_SLAVE;
import com.icetech.third.dao.send.SendinfoDao;
import com.icetech.third.domain.entity.third.SendInfo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import static com.icetech.common.utils.DateTools.DF_CN_DATE;
import static com.icetech.common.utils.DateTools.judge;


/**
 * 月卡服务类
 * @author wangzw
 */
@Slf4j
@Service("monthCarService")
public class MonthCarServiceImpl extends MonthCarServiceBase implements MonthCarService {

    @Autowired
    private MonthOrderDao monthOrderDao;
    @Autowired
    private MonthRecordDao monthRecordDao;
    @Autowired
    private MonthProductDao monthProductDao;
    @Autowired
    private MonthInfoDao monthInfoDao;
    @Autowired
    private SendinfoDao sendInfoDao;
    @Autowired
    private MonthRegionDao monthRegionDao;
    @Autowired
    private MonthProductRegionService monthProductRegionService;

    @Autowired
    private ParkService parkService;

    @Autowired
    private OrderService orderService;
    @Autowired
    private ParkRegionDao parkRegionDao;

    @Autowired
    private MonthrenewePubcheckService monthrenewePubcheckService;

    @Autowired
    private ManageService manageService;

    @Autowired
    private ShowAndSayServiceImpl showAndSayServiceImpl;

    @Autowired
    private IssuedCardServiceImpl issuedCardService;

    @Autowired
    private CacheHandle cacheHandle;

    @Autowired
    private PhpOpenCarServiceImpl phpOpenCarService;

    @Autowired
    private ParkRegionDao regionDao;

    /**
     *  缴费来源:0公众号; 1:H5场内缴费; 2出口H5缴费
     */
    public static final Integer SOURCE = 2;

    @Autowired
    private MonthPlateDao monthPlateDao;

    @Override
    //@DS_SLAVE
    public ObjectResponse<MonthReportDto> countMonthCarReport(MonthReportRequest monthReportRequest) {
        try {
            MonthReportDto monthReportDto = monthInfoDao.getMonthCardReport(monthReportRequest.getParkIdList(), monthReportRequest.getStartTime(), monthReportRequest.getEndTime());
            if (Objects.isNull(monthReportDto)) {
                MonthReportDto dto = new MonthReportDto();
                dto.setMonthTotalCount(0);
                dto.setAddMonthCount(0);
                dto.setAddMonthMoney(0);
                dto.setRenewMonthMoney(0);
                dto.setRenewMonthCount(0);
                dto.setRefundMoney(0);
                return ObjectResponse.success(dto);
            }
            //计算总金额
            double total = monthReportDto.getAddMonthMoney() + monthReportDto.getRenewMonthMoney() - monthReportDto.getRefundMoney();
            monthReportDto.setMonthTotalCount(total);
            return ObjectResponse.success(monthReportDto);
        }catch (Exception e){
            log.error("处理失败: {}. monthReportRequest[{}]", e.getMessage(), monthReportRequest, e);
        }
        return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
    }

    @Override
    //@DS_SLAVE
    public ObjectResponse<List<MonthInfoDto>> getMonthCarList(String parkCode, String plateNumber,List<Integer> cardStatus, Integer pageNo,Integer pageSize, String startTime, String endTime, String  cardOwner,String telephone,String productName,Integer validDays,Integer cardProperty) {
        try {
            String[] split = parkCode.split(",");
            String parkid = parkDao.selectByCodes(split);
            if(parkid.endsWith(",")){
                parkid = parkid.substring(0,parkid.length()-1);
            }
            PageHelper.startPage(pageNo,pageSize);
            String validDay = "";
            if(validDays != null){
                SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
                Calendar c = Calendar.getInstance();
                c.add(Calendar.DAY_OF_MONTH, validDays);
                validDay = sf.format(c.getTime());
            }

            List<MonthInfoDto> records = monthInfoDao.selectMonthRecords(parkid,plateNumber,cardStatus, startTime, endTime, cardOwner, telephone, productName, validDay, cardProperty);
            if (CollectionUtils.isEmpty(records)){
                //暂无记录
                return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
            }
            return ObjectResponse.success(records);
        } catch (Exception e){
            log.error("[车场管家获取月卡接口]异常: {}. parkCode[{}], plateNumber[{}], cardStatus[{}], pageNo[{}], pageSize[{}], startTime[{}], endTime[{}], cardOwner[{}], telephone[{}], productName[{}], validDays[{}], cardProperty[{}]", e.getMessage(), parkCode, plateNumber, cardStatus, pageNo, pageSize, startTime, endTime, cardOwner, telephone, productName, validDays, cardProperty, e);
            return ObjectResponse.failed(CodeConstantsEnum.ERROR);
        }
    }

    @Override
    //@DS_SLAVE
    public ObjectResponse<Map<String, Object>> countMonthCarList(String parkCode, String plateNumber, List<Integer> cardStatus, String startTime, String endTime, String cardOwner,String telephone,String productName,Integer validDays,Integer cardProperty) {
        try {
            String[] split = parkCode.split(",");
            String parkid = parkDao.selectByCodes(split);
            String validDay = "";
            if(validDays != null){
                SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
                Calendar c = Calendar.getInstance();
                c.add(Calendar.DAY_OF_MONTH, validDays);
                validDay = sf.format(c.getTime());
            }
            int records = monthInfoDao.countMonthRecords(parkid,plateNumber,cardStatus, startTime, endTime, cardOwner, telephone, productName, validDay, cardProperty);
            Map<String, Object> retMap = new HashMap<>();
            retMap.put("count", records);
            return ObjectResponse.success(retMap);
        } catch (Exception e){
            log.error("[车场管家获取月卡接口]异常: {}. parkCode[{}], plateNumber[{}], cardStatus[{}], startTime[{}], endTime[{}], cardOwner[{}], telephone[{}], productName[{}], validDays[{}], cardProperty[{}]", e.getMessage(), parkCode, plateNumber, cardStatus, startTime, endTime, cardOwner, telephone, productName, validDays, cardProperty, e);
            return ObjectResponse.failed(CodeConstantsEnum.ERROR);
        }
    }

    @Override
    public ObjectResponse<MonthInfoDto> getMonthCarDetail(String parkCode,Integer recordId) {
        try {
            Park park = parkService.findByParkCode(parkCode).getData();
            if(Objects.isNull(park)){
                return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
            }
            //获取月卡记录信息
            MonthInfoDto monthInfoDto = monthInfoDao.selectMonthRecord(park.getId(),recordId);
            if (monthInfoDto == null) {
                return ObjectResponse.failed(CodeConstants.ERROR_404, "月卡记录不存在");
            }
            monthInfoDto.setParkName(park.getParkName());
            return ObjectResponse.success(monthInfoDto);
        } catch (Exception e){
            log.error("[车场管家获取月卡详情接口]异常: {}. parkCode[{}], recordId[{}]", e.getMessage(), parkCode, recordId, e);
            return ObjectResponse.failed(CodeConstantsEnum.ERROR);
        }
    }

    @Override
    public ObjectResponse<MonthRecord> getMonthRecordById(Integer recordId) {
        MonthRecord record = monthRecordDao.selectById(recordId);
        return ObjectResponse.returnNotFoundIfNull(record);
    }

    @Override
    public ObjectResponse<MonthInfo> getValidMonthCar(Long parkId, String plateNum) {
        //获取有效月卡记录信息
        MonthInfo monthInfo = getMonthInfo(parkId, plateNum);
        if (judgeMonthCar(parkId, plateNum, null, monthInfo)){
            return ObjectResponse.success(monthInfo);
        }
        return ObjectResponse.failed(CodeConstants.ERROR_404, CodeConstants.getName(CodeConstants.ERROR_404));
    }

    @Override
    public ObjectResponse<MonthInfo> getValidMonthCar(Long parkId, String plateNum, String channelCode) {
        Long regionId = null;
        if (StringUtils.isNotBlank(channelCode)) {
            ObjectResponse<ParkInoutdevice> objectResponse = parkService.getInOutDeviceByCode(parkId, channelCode);
            if (objectResponse.getData() != null) {
                ParkInoutdevice parkInoutdevice = objectResponse.getData();
                regionId = parkInoutdevice.getRegionId();
            }
        }
        //获取有效月卡记录信息
        MonthInfo monthInfo = findMonthInfo(parkId, plateNum, regionId, VALID_CARD);
        if (judgeMonthCar(parkId, plateNum, regionId, monthInfo)){
            return ObjectResponse.success(monthInfo);
        }
        return ObjectResponse.failed(CodeConstants.ERROR_404, CodeConstants.getName(CodeConstants.ERROR_404));
    }

    @Override
    public ObjectResponse<MonthInfo> getValidMonthCar(Long parkId, String plateNum, Long regionId) {
        //获取有效月卡记录信息
        MonthInfo monthInfo = findMonthInfo(parkId, plateNum, regionId, VALID_CARD);
        if (monthInfo != null){
            if (judgeMonthCar(parkId, plateNum, regionId, monthInfo)){
                return ObjectResponse.success(monthInfo);
            }
        }
        return ObjectResponse.failed(CodeConstants.ERROR_404, CodeConstants.getName(CodeConstants.ERROR_404));
    }

    @Override
    public ObjectResponse<MonthProduct> getValidMonthProduct(Long parkId, String plateNum) {
        //获取有效月卡记录信息
        MonthInfo monthInfo = getMonthInfo(parkId, plateNum);
        if (monthInfo != null){
            long productId = monthInfo.getProductId();
            MonthProduct monthProduct = monthProductDao.selectById(productId);
            return ObjectResponse.success(monthProduct);
        }
        return ObjectResponse.failed(CodeConstants.ERROR_404, CodeConstants.getName(CodeConstants.ERROR_404));
    }

    @Override
    public ObjectResponse<MonthProduct> getValidMonthProduct(Long parkId, String plateNum, Long regionId) {
        //获取有效月卡记录信息
        MonthInfo monthInfo = findMonthInfo(parkId, plateNum, regionId, VALID_CARD);
        if (monthInfo != null){
            long productId = monthInfo.getProductId();
            MonthProduct monthProduct = monthProductDao.selectById(productId);
            return ObjectResponse.success(monthProduct);
        }
        return ObjectResponse.failed(CodeConstants.ERROR_404, CodeConstants.getName(CodeConstants.ERROR_404));
    }

    @Override
    public ObjectResponse<MonthInfoDto> getNewestMonthCar(Long parkId, String plateNum, String phone) {
        MonthCarRequest monthCarRequest = new MonthCarRequest();
        monthCarRequest.setParkId(parkId);
        monthCarRequest.setPlateNum(plateNum);
        monthCarRequest.setPhone(phone);
        MonthInfoDto monthInfo = monthInfoDao.selectMonthCarExtend(monthCarRequest);
        if (monthInfo != null){
            return ObjectResponse.success(monthInfo);
        }
        return ObjectResponse.failed(CodeConstants.ERROR_404);
    }

    @Override
    @DS_SLAVE
    public ObjectResponse<List<MonthInfoDto>> getMonthCarList(String searchKey,List<String> plateNums,Integer pageNo, Integer pageSize) {
        PageHelper.startPage(pageNo,pageSize);
        boolean hasChinese = false;
        if (searchKey != null) {
            searchKey = searchKey.toUpperCase();
            hasChinese = searchKey.length() != searchKey.getBytes().length;
        }
        List<MonthInfoDto> monthInfoDtos;
        if (hasChinese) {
            monthInfoDtos = monthInfoDao.selectMonthCarListByPlateNum(searchKey);
        } else {
            monthInfoDtos = monthInfoDao.selectMonthCarList(searchKey);
        }
        if (CollectionUtil.isEmpty(monthInfoDtos)){
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
        }
        return ObjectResponse.success(monthInfoDtos);
    }

    @Override
    @DS_SLAVE
    public ObjectResponse<List<MonthInfoDto>> getAppletMonthCarList(String searchKey,List<String> plateNums,Integer pageNo, Integer pageSize) {
        PageHelper.startPage(pageNo,pageSize);
        //查询条件，1：车牌，2：手机号
        int searchType = 1;
        if (searchKey != null && searchKey.trim().length() == 11) {
            searchType = 2;
        }
        List<MonthInfoDto> monthInfoDtos;
        if (searchType == 1) {
            monthInfoDtos = monthInfoDao.selectAppletMonthCarListByPlateNum(searchKey,plateNums);
        } else {
            monthInfoDtos = monthInfoDao.selectAppletMonthCarListByPhone(searchKey,plateNums);
        }
        if (CollectionUtil.isEmpty(monthInfoDtos)){
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
        }
        monthInfoDtos.forEach(monthInfoDto -> {
            Park park = parkService.findByParkId(monthInfoDto.getParkId()).getData();
            ParkConfig parkConfig = parkService.getParkConfig(monthInfoDto.getParkId()).getData();
            if (Objects.nonNull(parkConfig)){
                monthInfoDto.setRenewLimitDay(parkConfig.getRenewLimitDay());
            }
            if (Objects.nonNull(park)){
                monthInfoDto.setParkName(park.getParkName());
                monthInfoDto.setParkCode(park.getParkCode());
            }
        });

        return ObjectResponse.success(monthInfoDtos);
    }
    @Override
    @DS_SLAVE
    public ObjectResponse<MonthInfoDto> getAppletMonthCarDetail(Long monthId) {
        MonthInfoDto monthInfoDto = new MonthInfoDto();
        //获取月卡信息
        MonthInfo monthInfo = monthInfoDao.load(monthId);
        monthInfoDto.setId(Math.toIntExact(monthId));
        monthInfoDto.setCardOwner(monthInfo.getCardOwner());
        monthInfoDto.setPlotCount(monthInfo.getPlotCount());
        monthInfoDto.setStatus(monthInfo.getCardStatus());
        monthInfoDto.setPhone(monthInfo.getPhone());
        monthInfoDto.setCardProperty(monthInfo.getCardProperty());

        //获取区域信息
        List<MonthRegion> monthRegions = monthRegionDao.selectByMonthId(monthId);
        if (CollectionUtil.isNotEmpty(monthRegions)){
            Set<Long> regionIds = monthRegions.stream().map(MonthRegion::getRegionId).collect(Collectors.toSet());
            List<ParkRegion> parkRegions = parkRegionDao.selectBatchIds(regionIds);
            if (CollectionUtil.isNotEmpty(parkRegions)){
                monthInfoDto.setRegionName(parkRegions.stream().map(ParkRegion::getRegionName).collect(Collectors.joining(",")));
            }
        }

        ParkConfig parkConfig = parkConfigDao.selectByParkId(monthInfo.getParkId());
        monthInfoDto.setRenewLimitDay(parkConfig.getRenewLimitDay());

        return ObjectResponse.success(monthInfoDto);
    }

    @Override
    //@DS_SLAVE
    public ObjectResponse<List<MonthProductDto>> getMonthProductList(String parkCode,Long monthInfoId) {
        Park park = parkService.findByParkCode(parkCode).getData();
        if (park == null) {
            return ObjectResponse.failed("1000","车场信息不存在");
        }
        // 这里没有过滤审核状态
        List<MonthProduct> monthProducts = monthProductDao.selectListByParkId(park.getId());
        List<MonthProductDto> results = Lists.newArrayList();
        MonthInfo monthInfo = monthInfoDao.load(Math.toIntExact(monthInfoId));
        if (monthInfo == null) {
            return ObjectResponse.success(results);
        }
        MonthProduct monthProduct = monthProductDao.selectById(monthInfo.getProductId());
        results = results.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(MonthProductDto::getId))), ArrayList::new));
        results.addAll(monthProducts.stream()
                .filter(Objects::nonNull)
                .filter(m -> m.getCheckStatus() == 1)
                .filter(m -> m.getPaymoney().compareTo(BigDecimal.ZERO) > 0)
                .filter(m -> m.getBuyChannel() == 1)
                .filter(m -> m.getRenewAlscope() != null && m.getRenewAlscope()  ==  0)
                .map(product -> {
                    MonthProductDto dto = new MonthProductDto();
                    dto.setId(product.getId());
                    dto.setDuration(product.getDuration());
                    dto.setPaymoney(product.getPaymoney());
                    dto.setName(product.getName());
                    if (product.getSupportRegion() == 1){
                        dto.setRegionName(monthProductRegionService.getRegionName(product.getId()));
                    } else {
                        String regionName = null;
                        if (product.getId().equals(monthProduct.getId())){
                            //获取原区域信息
                            List<MonthRegion> monthRegions = monthRegionDao.selectByMonthId(monthInfoId);

                            if (CollectionUtils.isNotEmpty(monthRegions)){
                                List<ParkRegion> parkRegions = parkRegionDao.selectBatchIds(monthRegions.stream().map(MonthRegion::getRegionId).collect(Collectors.toList()));
                                regionName = StrUtil.join("/",parkRegions.stream().map(ParkRegion::getRegionName).collect(Collectors.toList()));
                            }else {
                                regionName = "全车场";
                            }
                        }
                        if(StringUtils.isEmpty(regionName)){
                            regionName = "全车场";
                        }
                        dto.setRegionName(regionName);
                    }
                    return dto;
                }).collect(Collectors.toList()));

        if (monthProduct != null
                && monthProduct.getStatus() == 1
                && NumberUtils.toDouble(monthProduct.getPaymoney()) > 0
                && monthProduct.getRenewAlscope() == 1
                && monthProduct.getBuyChannel() == 1) {
            MonthProductDto monthProductDto = new MonthProductDto();
            monthProductDto.setId(monthProduct.getId());
            monthProductDto.setDuration(monthProduct.getDuration());
            monthProductDto.setPaymoney(monthProduct.getPaymoney());
            monthProductDto.setName(monthProduct.getName());
            if (monthProduct.getSupportRegion() == 1){
                monthProductDto.setRegionName(monthProductRegionService.getRegionName(monthProduct.getId()));
            } else {
                //获取原区域信息
                List<MonthRegion> monthRegions = monthRegionDao.selectByMonthId(monthInfoId);
                String regionName;
                if (CollectionUtils.isNotEmpty(monthRegions)){
                    List<ParkRegion> parkRegions = parkRegionDao.selectBatchIds(monthRegions.stream().map(MonthRegion::getRegionId).collect(Collectors.toList()));
                    regionName = StrUtil.join("/",parkRegions.stream().map(ParkRegion::getRegionName).collect(Collectors.toList()));
                }else {
                    regionName = "全车场";
                }
                if(StringUtils.isEmpty(regionName)){
                    regionName = "全车场";
                }
                monthProductDto.setRegionName(regionName);
            }
            results.add(monthProductDto);
        }
        return ObjectResponse.success(results);
    }
    @Override
    //@DS_SLAVE
    public ObjectResponse<List<MonthProductDto>> getMonthProductList(String parkCode) {
        Park park = parkService.findByParkCode(parkCode).getData();
        List<MonthProduct> monthProducts = monthProductDao.selectListByParkId(park.getId());
        //封装返回参数
        List<MonthProductDto> monthProductDtos = Lists.newArrayList();
        if (CollectionUtil.isEmpty(monthProducts)){
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
        }
        monthProducts.forEach(monthProduct -> {
            MonthProductDto monthProductDto = new MonthProductDto();
            monthProductDto.setId(monthProduct.getId());
            monthProductDto.setDuration(monthProduct.getDuration());
            monthProductDto.setPaymoney(monthProduct.getPaymoney());
            monthProductDto.setName(monthProduct.getName());
            monthProductDtos.add(monthProductDto);
        });
        return ObjectResponse.success(monthProductDtos);
    }

    @Override
    //@DS_SLAVE
    public ObjectResponse<List<MonthOrderDto>> getMonthOrderList(Integer mpUserId,Date startTime, Date endTime, List<Integer> optionTypes,Integer pageNo, Integer pageSize) {
        PageHelper.startPage(pageNo,pageSize);
        List<MonthOrderDto> monthOrderDtos = monthOrderDao.selectMonthOrderList(mpUserId,optionTypes,Objects.isNull(startTime)?null:startTime.getTime()/1000,Objects.isNull(endTime)?null:endTime.getTime()/1000);
        if (CollectionUtil.isEmpty(monthOrderDtos)){
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
        }
        monthOrderDtos.forEach(monthOrderDto -> {
            if (Objects.isNull(monthOrderDto.getMonthRecordId())){
                MonthrenewePubcheck monthrenewePubcheck = monthrenewePubcheckService.selectByTradeNo(monthOrderDto.getTradeNo());
                if (Objects.nonNull(monthrenewePubcheck)){
                    monthOrderDto.setStartTime(monthrenewePubcheck.getStartTime());
                    monthOrderDto.setEndTime(monthrenewePubcheck.getEndTime());
                    monthOrderDto.setCardOwner(monthrenewePubcheck.getCardOwner());
                    monthOrderDto.setPhone(monthrenewePubcheck.getPhone());
                    monthOrderDto.setPlateNumber(monthrenewePubcheck.getPlateNum());
                    if (monthrenewePubcheck.getCardOpertype() == 1){
                        monthOrderDto.setCardStatus(98);
                    }
                    if (monthrenewePubcheck.getCardOpertype() == 3){
                        monthOrderDto.setCardStatus(99);
                    }
                    monthOrderDto.setCardOpertype(monthrenewePubcheck.getCardStatus());
                }

            }
        });
        return ObjectResponse.success(monthOrderDtos);
    }
    @Override
    //@DS_SLAVE
    public ObjectResponse<List<MonthOrderDto>> getMonthOrderList(Long accountId, String plateNum,Date startTime, Date endTime,Integer bizType,Integer pageNo, Integer pageSize) {
        PageHelper.startPage(pageNo,pageSize);
        List<MonthOrderDto> monthOrderDtos = monthOrderDao.selectMonthOrderListV2(accountId,plateNum,bizType,Objects.isNull(startTime)?null:startTime.getTime()/1000,Objects.isNull(endTime)?null:endTime.getTime()/1000);
        if (CollectionUtil.isEmpty(monthOrderDtos)){
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
        }
        monthOrderDtos.forEach(monthOrderDto -> {
            if (Objects.isNull(monthOrderDto.getMonthRecordId())){
                MonthrenewePubcheck monthrenewePubcheck = monthrenewePubcheckService.selectByTradeNo(monthOrderDto.getTradeNo());
                if (Objects.nonNull(monthrenewePubcheck)){
                    monthOrderDto.setStartTime(monthrenewePubcheck.getStartTime());
                    monthOrderDto.setEndTime(monthrenewePubcheck.getEndTime());
                    monthOrderDto.setCardOwner(monthrenewePubcheck.getCardOwner());
                    monthOrderDto.setPhone(monthrenewePubcheck.getPhone());
                    monthOrderDto.setPlateNumber(monthrenewePubcheck.getPlateNum());
                    if (monthrenewePubcheck.getCardOpertype() == 1){
                        monthOrderDto.setCardStatus(98);
                    }
                    if (monthrenewePubcheck.getCardOpertype() == 3){
                        monthOrderDto.setCardStatus(99);
                    }
                    monthOrderDto.setCardOpertype(monthrenewePubcheck.getCardStatus());
                }

            }
        });
        return ObjectResponse.success(monthOrderDtos);
    }

    @Override
    public ObjectResponse<MonthOrderDto> getMonthOrderDetail(Long monthOrderId) {
        MonthOrderDto monthOrderDetail = monthOrderDao.getMonthOrderDetail(monthOrderId);
        if (Objects.isNull(monthOrderDetail)){
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
        }
        if (Objects.isNull(monthOrderDetail.getMonthRecordId())){
            //查询审核信息
            MonthrenewePubcheck monthrenewePubcheck = monthrenewePubcheckService.selectByTradeNo(monthOrderDetail.getTradeNo());
            if (Objects.nonNull(monthrenewePubcheck)){
                MonthProduct monthProduct = monthProductDao.selectById(monthrenewePubcheck.getProductId());
                monthOrderDetail.setId(monthOrderId);
                monthOrderDetail.setParkId(monthOrderDetail.getParkId());
                monthOrderDetail.setParkCode(monthOrderDetail.getParkCode());
                monthOrderDetail.setParkName(monthOrderDetail.getParkName());
                monthOrderDetail.setPlateNumber(monthrenewePubcheck.getPlateNum());
                monthOrderDetail.setCardOwner(monthrenewePubcheck.getCardOwner());
                monthOrderDetail.setProductName(monthProduct.getName());
                monthOrderDetail.setProductId(Math.toIntExact(monthProduct.getId()));
                monthOrderDetail.setPaymoney(monthProduct.getPaymoney().setScale(2,BigDecimal.ROUND_HALF_UP).toString());
                monthOrderDetail.setDuration(monthProduct.getDuration());
                monthOrderDetail.setPlotCount(monthrenewePubcheck.getPlotCount());
                monthOrderDetail.setCount(monthrenewePubcheck.getCount());
                monthOrderDetail.setStartTime(monthrenewePubcheck.getStartTime());
                monthOrderDetail.setEndTime(monthrenewePubcheck.getEndTime());
                monthOrderDetail.setRemark("续费时间："+DateTools.getFormat(DF_CN_DATE,monthrenewePubcheck.getStartTime())+"-"+DateTools.getFormat(DF_CN_DATE,monthrenewePubcheck.getEndTime()));
                monthOrderDetail.setPhone(monthrenewePubcheck.getPhone());
                monthOrderDetail.setCardOpertype(monthrenewePubcheck.getCardStatus());
                monthOrderDetail.setOperAccount(monthrenewePubcheck.getOperAccount());
                monthOrderDetail.setOperTime(monthrenewePubcheck.getCreateTime());
                monthOrderDetail.setCardStatus(2);
                monthOrderDetail.setPayChannel(monthOrderDetail.getPayChannel());
                monthOrderDetail.setPayMethod(monthOrderDetail.getPayMethod());
                monthOrderDetail.setPayTime(monthOrderDetail.getPayTime());
                monthOrderDetail.setTotalPrice(monthOrderDetail.getTotalPrice());
            }
        }
        //设置区域信息
        Integer productId = monthOrderDetail.getProductId();
        String regionName = monthProductRegionService.getRegionName(Long.valueOf(productId));
        monthOrderDetail.setRegionName(regionName);
        return ObjectResponse.success(monthOrderDetail);
    }

    @Override
    public MonthProduct selectMonthProductById(Integer monthProductId) {
        return monthProductDao.selectById(monthProductId);
    }
    @Override
    public MonthInfo selectMonthInfotById(Integer monthInfoId) {
        return monthInfoDao.load(monthInfoId);
    }

    @Override
    public ObjectResponse<Void> saveMonthOrder(MonthOrder monthOrder) {
        Long parkId = monthOrder.getParkId();
        ObjectResponse<ParkConfig> configObjectResponse = parkService.getParkConfig(parkId);
        if (ObjectResponse.isSuccess(configObjectResponse) && configObjectResponse.getData().getIsEpayment() == 1) {
            monthOrder.setEpayment(configObjectResponse.getData().getEPayment());
        }
        monthOrderDao.insert(monthOrder);
        return ObjectResponse.success();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ObjectResponse<Void> finishMonthPay(MonthPayRequest monthPayRequest) {
        Date startDate = monthPayRequest.getStartTime();
        String tradeNo = monthPayRequest.getTradeNo();
        long productId = monthPayRequest.getProductId();
        long monthInfoId = monthPayRequest.getMonthInfoId();
        //查询支付中的月卡订单
        MonthOrder monthOrder = monthOrderDao.selectByTradeNoAndPayStatus(tradeNo, PayStatusConstants.PAYING);
        if (Objects.isNull(monthOrder) || monthOrder.getPayStatus() == PayStatusConstants.PAID) {
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_405);
        }
        //查询续费的月卡
        MonthInfo monthInfo = monthInfoDao.load(monthInfoId);
        if (Objects.isNull(monthInfo)) {
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_710);
        }
        int cardStatus = monthInfo.getCardStatus();
        long id = monthInfo.getId();
        //获取所选月卡产品
        MonthProduct monthProduct = monthProductDao.selectById(productId);
        if (Objects.isNull(monthProduct)){
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_710);
        }
        int diftDay = 0;
        if (monthProduct.getIsDiftDay() == 1){
            diftDay = monthProduct.getDiftDays();
        }
        //查询车牌
        List<String> plateNums = monthInfoDao.selectPlateNums(monthInfo.getId());
        log.info("车牌号[{}]", plateNums);
        List<String> spaces = monthInfoDao.selectSpaces(monthInfo.getId());
        List<MonthRegion> monthRegions = monthRegionDao.selectByMonthId(monthInfo.getId());
        //添加月卡操作记录
        MonthRecord monthRecord = new MonthRecord();
        // 获取高级配置并对自动
        ObjectResponse<ParkConfig> configObject = parkService.getParkConfig(monthInfo.getParkId());
        if (!ObjectResponse.isSuccess(configObject) || Objects.isNull(configObject.getData())) {
            throw new ResponseBodyException("1000", "车场配置信息不存在");
        }
        ParkConfig parkConfig = configObject.getData();
        List<Integer> regionIds = monthRegions.stream().filter(Objects::nonNull).map(m->Math.toIntExact(m.getRegionId())).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(regionIds)){
            regionIds = Collections.singletonList(0);
        }
        if (monthProduct.getRenewstatusValid() == 1) {
            log.info("月卡进入人工审核,交易单号:[{}] 月卡订状态[{}]", tradeNo, monthOrder.getPayStatus());
            // 人工审核
            //续费 套餐为新套餐则采用套餐区域
            if (monthProduct.getSupportRegion() == 1){
                regionIds = monthProductRegionService.getRegionIds(monthProduct.getId());
            }
            addMonthCardRenewRecode(MonthrenewePubcheck.builder()
                    .monthId((int) monthInfoId)
                    .productId((int) productId)
                    .parkId(Math.toIntExact(parkConfig.getParkId()))
                    .cardProperty(monthInfo.getCardProperty())
                    .cardOwner(monthInfo.getCardOwner())
                    .plateNum(plateNums.stream().filter(Objects::nonNull).collect(Collectors.joining(",")))
                    .spaceNum(spaces.stream().filter(Objects::nonNull).collect(Collectors.joining(",")))
                    .regionId(StrUtil.join(",",regionIds))
                    .phone(monthInfo.getPhone())
                    .cardStatus(monthInfo.getProductId() != productId || DateTools.differentDays(monthInfo.getEndTime(),startDate)> 1 ? 1 : 2)
                    .cardOpertype(1)
                    .plotCount(monthInfo.getPlotCount())
                    .count(monthPayRequest.getProductNum())
                    .payMoney(monthOrder.getTotalPrice() == null ? BigDecimal.ZERO : monthOrder.getTotalPrice())
                    .payMethod(2)
                    .tradeNo(monthOrder.getTradeNo())
                    .refund(BigDecimal.ZERO)
                    .startTime(monthPayRequest.getStartTime())
                    .endTime(monthPayRequest.getEndTime())
                    .renewAccount(String.valueOf(monthOrder.getMpUserId()))
                    .operAccount(monthPayRequest.getUserName())
                    .addDay(String.valueOf(diftDay))
                    .payChannel(3)
                    .build());
            //修改月卡订单状态
            monthOrder.setPayStatus(PayStatusConstants.PAID);
            monthOrder.setPayTime(Math.toIntExact(monthPayRequest.getPayTime()));
            monthOrderDao.update(monthOrder);
            return ObjectResponse.success();
        }
        // 月卡产品变更 时间不连续属于新开卡
        if (monthInfo.getProductId() != productId
                || DateTools.differentDays(monthInfo.getEndTime(),startDate)>1){
            log.info("[月卡续费]新卡开处理请求参数[{}]", monthPayRequest);
            //新开卡
            monthInfo.setProductId(productId);
            monthInfo.setStartTime(startDate);
            if (startDate.getTime()>System.currentTimeMillis()){
                monthInfo.setCardStatus(CardStatusConstants.待生效);
            }else {
                monthInfo.setCardStatus(CardStatusConstants.生效中);
            }
            monthInfo.setOperAccount(monthPayRequest.getUserName());
            //重新结算时间
            monthInfo.setEndTime(monthPayRequest.getEndTime());
            monthInfo.setCount(monthPayRequest.getProductNum());
            monthInfo.setPayMoney(monthOrder.getTotalPrice() == null ? BigDecimal.ZERO : monthOrder.getTotalPrice());
            monthInfoDao.insert(monthInfo);
            if (cardStatus == 4) {
                MonthInfo updateEntity = new MonthInfo();
                updateEntity.setId(id);
                updateEntity.setDeleteStatus(1);
                updateEntity.setOperAccount("system");
                monthInfoDao.updateById(updateEntity);
                log.info("[月卡续费] 过期月卡按新开卡, 更新过期卡为删除, id[{}]", id);
            }
            //添加绑定车牌数
            plateNums.forEach(s -> {
                MonthPlate monthPlate = new MonthPlate();
                monthPlate.setMonthId(monthInfo.getId());
                monthPlate.setParkId(monthInfo.getParkId());
                monthPlate.setPlateNum(s);
                monthPlateDao.insert(monthPlate);
            });
            // 添加绑定车位数
            spaces.forEach(s -> {
                MonthSpace monthSpace = new MonthSpace();
                monthSpace.setMonthId(monthInfo.getId());
                monthSpace.setSpaceNum(s);
                monthPlateDao.insertSpace(monthSpace);
            });
            log.info("[新开月卡] monthInfo:{}",JsonUtils.toString(monthInfo));
            monthRecord.setMonthId(monthInfo.getId());
            monthRecord.setCardOpertype(MonthRecord.CardOpertype.新增.getType());
            if (monthProduct.getSupportRegion() == 1){
                //新开卡选择的产品为新套餐产品 套餐的可停区域是什么区域 就是什么区域
                regionIds = monthProductRegionService.getRegionIds(monthProduct.getId());
            }else{
                regionIds = Collections.singletonList(0);
            }
            if (CollectionUtils.isNotEmpty(regionIds)){
                monthRegionDao.deleteByMonthId(Math.toIntExact(monthInfo.getId()));
                regionIds.forEach(regionId->{
                    MonthRegion monthRegion = new MonthRegion();
                    monthRegion.setMonthId(monthInfo.getId());
                    monthRegion.setRegionId(Long.valueOf(regionId));
                    monthRegionDao.insert(monthRegion);
                });
            }
        }else {
            // 更新
            monthInfo.setCardStatus(CardStatusConstants.生效中);
            monthInfo.setOperAccount(monthPayRequest.getUserName());
            monthInfo.setEndTime(monthPayRequest.getEndTime());
            monthInfo.setCount(monthPayRequest.getProductNum());
            monthInfo.setUpdateTime(DateUtil.date());
            monthInfo.setPayMoney(monthOrder.getTotalPrice() == null ? BigDecimal.ZERO : monthOrder.getTotalPrice());
            monthInfoDao.update(monthInfo);
            monthRecord.setMonthId(monthInfoId);
            monthRecord.setCardOpertype(MonthRecord.CardOpertype.续费.getType());
            monthRecord.setIsOverdue(0);
            //续费 套餐为新套餐则采用套餐区域
            if (monthProduct.getSupportRegion() == 1){
                regionIds = monthProductRegionService.getRegionIds(monthProduct.getId());
            }
            if (CollectionUtils.isNotEmpty(regionIds)){
                monthRegionDao.deleteByMonthId(Math.toIntExact(monthInfo.getId()));
                regionIds.forEach(regionId->{
                    MonthRegion monthRegion = new MonthRegion();
                    monthRegion.setMonthId(monthInfo.getId());
                    monthRegion.setRegionId(Long.valueOf(regionId));
                    monthRegionDao.insert(monthRegion);
                });
            }
        }
        monthRecord.setProductId(productId);
        monthRecord.setParkId(monthProduct.getParkId());
        monthRecord.setCardProperty(monthInfo.getCardProperty());
        monthRecord.setCardOwner(monthInfo.getCardOwner());
        monthRecord.setPhone(monthInfo.getPhone());
        monthRecord.setPlotCount(monthInfo.getPlotCount());
        monthRecord.setCount(monthPayRequest.getProductNum());
        monthRecord.setPayMoney(monthOrder.getTotalPrice() == null ? 0 : monthOrder.getTotalPrice().doubleValue());
        monthRecord.setPayMethod(MonthRecord.PayMethod.微信.getType());
        monthRecord.setOperAccount(monthInfo.getOperAccount());
        monthRecord.setRemark("续费时间："+DateTools.getFormat(DF_CN_DATE,startDate)+"-"+DateTools.getFormat(DF_CN_DATE,monthPayRequest.getEndTime()));
        //查询车位号
        String pj = String.join(",", plateNums);
        String sj = String.join(",", spaces);
        String rg = StrUtil.join(",", regionIds);
        monthRecord.setPlateNum(pj);
        monthRecord.setSpaceNum(sj);
        monthRecord.setRegionId(rg);
        monthRecord.setStartTime(monthInfo.getStartTime());
        monthRecord.setEndTime(monthInfo.getEndTime());
        monthRecord.setCreateTime(new Date());
        monthRecord.setUpdateTime(new Date());
        monthRecord.setPayChannel(3);
        monthRecordDao.insert(monthRecord);
        SendInfo sendInfo = new SendInfo(monthRecord.getParkId(), monthRecord.getId(), DownServiceEnum.月卡.getServiceType());
        sendInfoDao.insert(sendInfo);
        log.info("[添加月卡记录] monthRecord:{}", JsonUtils.toString(monthRecord));
        //修改月卡订单状态
        monthOrder.setPayStatus(PayStatusConstants.PAID);
        monthOrder.setPayTime(Math.toIntExact(monthPayRequest.getPayTime()));
        monthOrder.setMonthRecordId(monthRecord.getId());
        monthOrder.setOutTradeNo(monthPayRequest.getOutTradeNo());
        monthOrderDao.update(monthOrder);
        // 是否出口缴费
        boolean result = Objects.nonNull(monthPayRequest.getSource()) && SOURCE.equals(monthPayRequest.getSource());
        // 自动续费判断处理
        if(result && monthProduct.getRenewstatusValid() == 0 && StringUtils.isNotBlank(monthPayRequest.getOrderNum())) {
            ObjectResponse<OrderInfo> orderObject = orderService.findByOrderNum(monthPayRequest.getOrderNum());
            if (!ObjectResponse.isSuccess(orderObject) || Objects.isNull(orderObject.getData())) {
                throw new ResponseBodyException("1000", "出口月卡缴费未找到停车订单");
            }
            OrderInfo order = orderObject.getData();
            if (CollectionUtils.isEmpty(plateNums)
                    || !plateNums.contains(order.getPlateNum())) {
                log.info("当前续费车牌[{}]和通道车牌[{}]没有关系, 直接返回", plateNums, order.getPlateNum());
                return ObjectResponse.success();
            }
            // 存在交集
            Date exitTime = order.getExitTime() == null ? new Date() : new Date(order.getExitTime() * 1000L);
            Date enterTime = new Date(order.getEnterTime() * 1000L);
            if (judge(monthPayRequest.getStartTime(),monthPayRequest.getEndTime(), enterTime, exitTime)) {
                log.info("自动续费存在交集月卡开始时间[{}],月卡结束时间[{}],入场时间[{}],离场时间[{}]",
                        monthPayRequest.getStartTime(),
                        monthPayRequest.getEndTime(),
                        enterTime,
                        exitTime);
                ObjectResponse<Park> parkObjectResponse = parkService.findByParkId(monthInfo.getParkId());
                Park park = parkObjectResponse.getData();
                if (!parkConfig.getDataCollection().equals(DataCollectionEnum.端网云.getType())) {
                    // 获取缓存信息
                    CarExitRequest exit = cacheHandle.getExit(park.getParkCode(), monthPayRequest.getChannelCode());
                    if (exit != null) {
                        log.info("自动续费进入端云业务获取缓冲车道信息[{}]",exit);
                        // 重新计费
                        ObjectResponse<QueryOrderFeeResponse> feeObject = orderService.p2cQueryFee(order, parkConfig, monthPayRequest.getChannelCode());
                        if (ObjectResponse.isSuccess(feeObject) && feeObject.getData() != null) {
                            QueryOrderFeeResponse fee = feeObject.getData();
                            log.info("自动续费进入端云重新计费[{}]", fee);
                            BigDecimal payPrice = new BigDecimal(fee.getUnpayPrice());
                            // 修改通道费用
                            QueryOrderFeeResponse channelFee = cacheHandle.getChannelFee(park.getParkCode(), monthPayRequest.getChannelCode());
                            if (channelFee != null) {
                                if (exit.getOrderNum() != null
                                        && exit.getOrderNum().equals(channelFee.getOrderNum())) {
                                    cacheHandle.removeChannelFee(park.getParkCode(), monthPayRequest.getChannelCode());
                                }
                            }
                            // 无费用下发屏显下发开闸
                            if (BigDecimal.ZERO.compareTo(payPrice) == 0) {
                                DataExitRequest request = new DataExitRequest();
                                request.setParkCode(park.getParkCode());
                                request.setOrderNum(order.getOrderNum());
                                request.setAisleCode(monthPayRequest.getChannelCode());
                                request.setPlateNum(exit.getPlateNum());
                                request.setType(order.getType());
                                request.setCarType(order.getCarType());
                                request.setEnterTime(new Date(fee.getEnterTime() * 1000));
                                request.setExitTime(new Date(exit.getExitTime() * 1000));
                                manageService.allowExit(request);
                            } else {
                                // 有费用下发屏显
                                manageService.callVoiceReport(VoiceReportRequest.builder()
                                        .parkCode(park.getParkCode())
                                        .aisleCode(monthPayRequest.getChannelCode())
                                        .plateNum(exit.getPlateNum())
                                        .orderNum(order.getOrderNum())
                                        .fee(fee.getUnpayPrice())
                                        .parkTime(fee.getParkTime())
                                        .build());
                            }
                        }
                    }
                }else {
                    // 端网云下发月卡
                    SendRequest request = new SendRequest();
                    request.setServiceType(DownServiceEnum.月卡.getServiceType());
                    request.setParkId(park.getId());
                    request.setServiceId(monthRecord.getId());
                    issuedCardService.send(request);
                    // 端网云下发语音显示屏幕刷新
                    showAndSayServiceImpl.execute(VoiceReportRequest.builder()
                            .parkCode(park.getParkCode())
                            .aisleCode(monthPayRequest.getChannelCode())
                            .plateNum(order.getPlateNum())
                            .fee("")
                            .orderNum(order.getOrderNum())
                            .parkTime((order.getExitTime() == null ? DateTools.unixTimestamp() : order.getExitTime()) - order.getEnterTime())
                            .build());
                }
            }
        }
        return ObjectResponse.success();
    }

    @Override
    public ObjectResponse<MonthOrderDto> getMonthOrder(String tradeNo) {
        MonthOrderDto monthOrder = monthOrderDao.getMonthOrderDetailByTradeno(tradeNo);
        return ObjectResponse.success(monthOrder);
    }

    @Override
    public boolean isAbCar(Long parkId, String plateNum, long monthId, int plotCount) {
        List<String> plateNumList = monthPlateDao.selectByMonthId(monthId);
        //如果车牌个数和车位个数不相等，并且车牌个数小于车位个数时，定义为多位多车
        return isAbCarMonth(plotCount, plateNumList);
    }

    @Override
    public ObjectResponse<MonthAbDto> abMonthCar(Long parkId, String plateNum, long monthId, int plotCount) {
        return ObjectResponse.success(abCar(parkId, plateNum, monthId, plotCount, null));
    }

    @Override
    public ObjectResponse<MonthAbDto> abMonthCar(Long parkId, String plateNum, long monthId, int plotCount, Long regionId) {
        return ObjectResponse.success(abCar(parkId, plateNum, monthId, plotCount, regionId));
    }

    @Override
    public ObjectResponse<MonthAbDto> groupAbMonthCar(String plateNum, long monthId, int plotCount){
        return ObjectResponse.success(groupAbCar(plateNum, monthId, plotCount));
    }

    @Override
    public MonthAbDto abMonthCar(Long parkId, String plateNum, Long regionId) {
        ObjectResponse<MonthInfo> monthInfoResp = getMonthInfo(parkId, plateNum, MonthCarServiceBase.VALID_CARD, regionId);
        if (ObjectResponse.isSuccess(monthInfoResp)) {
            MonthInfo monthInfo = monthInfoResp.getData();
            if (monthInfo.getMoreMonthType()!= null && monthInfo.getMoreMonthType() ==  1){
                log.info("进入集团月卡的处理逻辑 {},{}", monthInfo, plateNum);
                //集团多位多车
                return groupAbMonthCar(plateNum, monthInfo.getId(), monthInfo.getPlotCount()).getData();
            }else{
                return abCar(parkId, plateNum, monthInfo.getId(), monthInfo.getPlotCount(), regionId);
            }
        } else {
            monthInfoResp = getMonthInfo(parkId, plateNum, MonthCarServiceBase.TIMEOUT_CARD, regionId);
            if (ObjectResponse.isSuccess(monthInfoResp)) {
                MonthInfo monthInfo = monthInfoResp.getData();
                if (byExpireMonth(parkId, monthInfo)) {
                    return abCar(parkId, plateNum, monthInfo.getId(), monthInfo.getPlotCount(), regionId);
                }
            }
        }
        return null;
    }

    @Override
    public ObjectResponse<MonthInfo> getMonthCar(Long parkId, String plateNum) {
        MonthInfo monthInfo = getMonthInfo(parkId, plateNum);
        if(monthInfo == null){
            monthInfo = monthInfoDao.selectByPlateNum(parkId, plateNum, TIMEOUT_CARD);
        }
        if(monthInfo == null){
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
        return ObjectResponse.success(monthInfo);
    }

    @Override
    public ObjectResponse<MonthInfo> getMonthCar(Long parkId, String plateNum, Long regionId) {
        MonthInfo monthInfo = findMonthInfo(parkId, plateNum, regionId, VALID_CARD);
        if (monthInfo == null){
            monthInfo = findMonthInfo(parkId, plateNum, regionId, TIMEOUT_CARD);
        }
        if(monthInfo == null){
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
        return ObjectResponse.success(monthInfo);
    }

    @Override
    public ObjectResponse<MonthInfo> getMonthInfo(long parkId, String plateNum, int cardStatus, Long regionId) {
        MonthInfo monthInfo = findMonthInfo(parkId, plateNum, regionId, cardStatus);
        return ObjectResponse.returnNotFoundIfNull(monthInfo);
    }

    @Override
    public ObjectResponse<MonthDetailDto> getMonthCarDetail(Long parkId, String plateNum) {
        return ObjectResponse.success(getMonthCarDetailDto(parkId, plateNum, null));
    }
    @Override
    public ObjectResponse<MonthDetailDto> getMonthCarDetail(Long parkId, String plateNum, Long regionId) {
        return ObjectResponse.success(getMonthCarDetailDto(parkId, plateNum, regionId));
    }

    @Override
    //@DS_SLAVE
    public ObjectResponse<List<MonthCardDto>> getValidByParkId(Long parkId) {
        List<MonthCardDto> monthCardDtos = monthInfoDao.selectValidByParkId(parkId);
        if (monthCardDtos != null && monthCardDtos.size() > 0){
            return ObjectResponse.success(monthCardDtos);
        }else{
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
    }

    @Override
    public ObjectResponse<List<MonthCardDto>> getValidByIds(List<String> isList) {
        List<MonthCardDto> monthCardDtos = monthInfoDao.selectValidByIds(isList);
        if (monthCardDtos != null && monthCardDtos.size() > 0){
            return ObjectResponse.success(monthCardDtos);
        }else{
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
    }

    @Override
    public ObjectResponse<Void> renewMonthCard(MonthInfo renewMonthInfo,String parkCode,String plateNum,String plotNum) {
        Date currDate = new Date();
        Date startDate = renewMonthInfo.getStartTime();
        Date endData = renewMonthInfo.getEndTime();

        Park park = parkService.findByParkCode(parkCode).getData();
        if (Objects.isNull(park)){
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
        }

        //查询续费的月卡
        MonthInfo monthInfo;
        monthInfo = monthInfoDao.load(renewMonthInfo.getId());
        if (!Objects.isNull(monthInfo)) {//获取所选月卡产品
            /*if (monthInfo.getParkId() != park.getId()){
                return ObjectResponse.failed(CodeConstantsEnum.ERROR_2006);
            }*/
            MonthProduct monthProduct = monthProductDao.selectById(renewMonthInfo.getProductId());
            if (Objects.isNull(monthProduct)) {
                return ObjectResponse.failed(CodeConstantsEnum.ERROR_710);
            }
            int diftDay;
            diftDay = 0;
            if (monthProduct.getIsDiftDay() == 1) {
                diftDay = monthProduct.getDiftDays();
            }

            //查询车牌
            List<String> plateNums;
            //plateNums = monthInfoDao.selectPlateNums(monthInfo.getId());
            plateNums = Arrays.asList(plateNum.split(","));
            List<String> spaces;
            //spaces = monthInfoDao.selectSpaces(monthInfo.getId());
            spaces = plotNum == null ? new ArrayList<>() : Arrays.asList(plotNum.split(","));

            monthInfo.setCardOwner(renewMonthInfo.getCardOwner());
            monthInfo.setPlotCount(renewMonthInfo.getPlotCount());
            monthInfo.setPhone(renewMonthInfo.getPhone());

            //添加月卡操作记录
            MonthRecord monthRecord = new MonthRecord();
            // 月卡产品变更 时间不连续属于新开卡
            if (!monthInfo.getProductId().equals(renewMonthInfo.getProductId())
                    || DateTools.differentDays(monthInfo.getEndTime(),currDate)>1 || DateTools.differentDays(currDate,startDate)>1){
                //新开卡
                monthInfo.setProductId(renewMonthInfo.getProductId());
                monthInfo.setCardStatus(DateTools.differentDays(startDate,currDate)>1?CardStatusConstants.待生效:CardStatusConstants.生效中);
                monthInfo.setStartTime(startDate);
                monthInfo.setEndTime(DateTools.addMonth(endData,monthProduct.getDuration(),diftDay));
                monthInfoDao.insert(monthInfo);
                //添加绑定车牌数
                plateNums.forEach(s -> {
                    MonthPlate monthPlate = new MonthPlate();
                    monthPlate.setMonthId(monthInfo.getId());
                    monthPlate.setParkId(monthInfo.getParkId());
                    monthPlate.setPlateNum(s);
                    monthPlateDao.insert(monthPlate);
                });
                // 添加绑定车位数
                spaces.forEach(s -> monthInfoDao.insertMonthSpace(monthInfo.getId(),s));
                log.info("[新开月卡] monthInfo:{}",JsonUtils.toString(monthInfo));
                monthRecord.setMonthId(monthInfo.getId());
                monthRecord.setCardOpertype(MonthRecord.CardOpertype.新增.getType());
            }else {
                // 更新
                monthInfo.setCardStatus(CardStatusConstants.生效中);
                monthInfo.setEndTime(DateTools.addMonth(endData,monthProduct.getDuration(),diftDay));
                monthInfoDao.update(monthInfo);
                monthRecord.setMonthId(renewMonthInfo.getId());
                monthRecord.setCardOpertype(MonthRecord.CardOpertype.续费.getType());
                monthRecord.setIsOverdue(0);
            }

            monthRecord.setProductId(renewMonthInfo.getProductId());
            monthRecord.setParkId(monthProduct.getParkId());
            monthRecord.setCardProperty(monthInfo.getCardProperty());
            monthRecord.setCardOwner(monthInfo.getCardOwner());
            monthRecord.setPhone(monthInfo.getPhone());
            monthRecord.setPlotCount(monthInfo.getPlotCount());
            monthRecord.setCount(monthInfo.getCount());
            monthRecord.setOperAccount(monthInfo.getOperAccount());
            monthRecord.setRemark(monthInfo.getRemark());
            //查询车位号
            String pj = String.join(",", plateNums);
            String sj = String.join(",", spaces);
            List<MonthRegion> monthRegions = monthRegionDao.selectByMonthId(monthInfo.getId());
            String regions = monthRegions.stream().map(monthRegion -> String.valueOf(monthRegion.getRegionId())).collect(Collectors.joining(","));
            monthRecord.setPlateNum(pj);
            monthRecord.setSpaceNum(sj);
            monthRecord.setRegionId(regions);
            monthRecord.setStartTime(monthInfo.getStartTime());
            monthRecord.setEndTime(monthInfo.getEndTime());
            monthRecord.setCreateTime(new Date());
            monthRecord.setUpdateTime(new Date());
            monthRecordDao.insert(monthRecord);
            SendInfo sendInfo = new SendInfo(monthProduct.getParkId(), monthRecord.getId(), DownServiceEnum.月卡.getServiceType());
            sendInfoDao.insert(sendInfo);
            log.info("[添加月卡记录] renewMonthRecord:{}", JsonUtils.toString(monthRecord));
            return ObjectResponse.success();
        } else {
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_710);
        }
    }

    @Override
    public ObjectResponse<List<MonthInfo>> getMonthCarByPlateNum(Long monthId, Long parkId) {
        List<String> plateNums = monthPlateDao.selectByMonthId(monthId);
        if (CollectionUtil.isEmpty(plateNums)){
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
        }
        //获取所有续费的车牌号
        List<MonthInfo> monthInfos = monthInfoDao.selectMonthCarByPlateNum(plateNums, parkId);
        if (CollectionUtil.isEmpty(monthInfos)){
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
        }
        //根据车牌号获取所有的
        return ObjectResponse.success(monthInfos);
    }

    @Override
    public ObjectResponse<List<Long>> getRecordIdListByIds(List<Long> ids){
        List<Long> recordIdListByMonthIds = monthRecordDao.getRecordIdListByIds(ids);
        if (recordIdListByMonthIds != null && recordIdListByMonthIds.size() > 0){
            return ObjectResponse.success(recordIdListByMonthIds);
        }else{
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
    }

    @Override
    public List<MonthCardDto> getMonthListByParkId(Long parkId) {
        List<MonthCardDto> infos = monthInfoDao.selectMonthListByParkId(parkId);
        if (infos == null || infos.isEmpty()) {
            return Collections.emptyList();
        }
        return infos;
    }

    @Override
    public ObjectResponse<Boolean> addMonthCardRenewRecode(MonthrenewePubcheck monthrenewePubcheck) {
        MonthrenewePubcheck pubcheck = monthrenewePubcheckService.selectByTradeNo(monthrenewePubcheck.getTradeNo());
        boolean result;
        if (Objects.isNull(pubcheck)){
            result = monthrenewePubcheckService.save(monthrenewePubcheck);
        }else {
            monthrenewePubcheck.setId(pubcheck.getId());
            result = monthrenewePubcheckService.updateById(monthrenewePubcheck);
        }
        return result ? ObjectResponse.success(Boolean.TRUE) :  ObjectResponse.failed();
    }

    @Override
    public List<MpMonthInvoiceResponse> getMonthInvoiceRecords(String parkCode, List<String> plateNums, Integer pageNo, Integer pageSize) {
        ObjectResponse<ParkConfig> configObjectResponse = parkService.getParkConfig(parkCode);
        if (!ObjectResponse.isSuccess(configObjectResponse)) {
            return null;
        }
        ParkConfig parkConfig = configObjectResponse.getData();
        Integer monthcardInvoiceDays = parkConfig.getMonthcardInvoiceDays();
        if (monthcardInvoiceDays == null) {
            monthcardInvoiceDays = 365;
        }
        Date startDate = DateUtil.offsetDay(DateUtil.date(), -monthcardInvoiceDays);
        Long startTime =  startDate.getTime() / 1000;
        Long endTime = DateTools.unixTimestamp();
        PageHelper.startPage(pageNo,pageSize);
        return monthOrderDao.getMonthInvoiceRecords(parkConfig.getParkId(), null,startTime,endTime, null,plateNums);
    }

    @Override
    public List<MpMonthInvoiceResponse> getMonthInvoiceRecords(String parkCode, Long accountId, Integer bizType,Long startTime,Long endTime,Integer pageNo, Integer pageSize) {
        Long parkId = null;
        if(StringUtils.isNotEmpty(parkCode)){
            parkId = parkService.findByParkCode(parkCode).getData().getId();
        }
        PageHelper.startPage(pageNo,pageSize);
        List<MpMonthInvoiceResponse> monthInvoiceRecords = monthOrderDao.getMonthInvoiceRecords(parkId, bizType,startTime, endTime, accountId, null);
        if (CollectionUtil.isNotEmpty(monthInvoiceRecords)){
            monthInvoiceRecords.forEach(item->{
                ParkConfig parkConfig = parkService.getParkConfig(item.getParkId()).getData();
                if (parkConfig.getIsInvoice() == 2){
                    item.setInvoice(Boolean.FALSE);
                    item.setReason("车场管理方未开通线上开票服务，无法开票");
                }else {
                    Integer monthcardInvoiceDays = parkConfig.getMonthcardInvoiceDays();
                    if (monthcardInvoiceDays != null){
                        Date startDate = DateUtil.offsetDay(DateUtil.date(), -monthcardInvoiceDays);
                        if (item.getPayTime() < startDate.getTime()/1000){
                            item.setInvoice(Boolean.FALSE);
                            item.setReason(String.format("该车场管理设置了，办理月卡和续租仅支持开具%s天内的支付记录",monthcardInvoiceDays));
                        }
                    }
                }
            });
        }
        return monthInvoiceRecords;
    }

    @Override
    public List<InvoiceParksDto> getMonthInvoiceParks(List<String> plateNums, Long startTime, Long endTime) {
        return monthOrderDao.getMonthInvoiceParks(null,null,startTime,endTime,plateNums);
    }

    @Override
    public List<InvoiceParksDto> getMonthInvoiceParks(Long accountId, Integer bizType,Long startTime, Long endTime){
        return monthOrderDao.getMonthInvoiceParks(accountId,bizType,startTime,endTime,null);
    }

    @Override
    public List<MonthRecord> getMonthRecordByIds(List<Long> recordIds){
        return monthRecordDao.selectBatchIds(recordIds);
    }

    @Override
    public List<MonthOrder> getMonthMonthOrderByTradeNos(List<String> tradeNos) {
        return monthOrderDao.getMonthMonthOrderByTradeNos(tradeNos);
    }

    @Override
    public void batchUpdateInvoiceStatus(List<String> tradeNos) {
        monthOrderDao.batchUpdateInvoiceStatus(tradeNos);
    }

    @Override
    public ObjectResponse<Object> openCard(MonthOpenCardDto monthOpenCardDto, Boolean isCheck) {
        try {
            if (isCheck) {
                //直接调用校验接口
                return phpOpenCarService.openAndCheckMonthCard(monthOpenCardDto, Boolean.TRUE);
            } else {
                //查询支付中的月卡订单
                MonthOrder monthOrder = monthOrderDao.selectByTradeNoAndPayStatus(monthOpenCardDto.getTradeNo(), PayStatusConstants.PAYING);
                if (Objects.isNull(monthOrder)) {
                    return ObjectResponse.success();
                }
                //查看是否需要审核
                MonthProduct monthProduct = monthProductDao.selectById(monthOpenCardDto.getProductId());
                if (monthProduct.getAddstatusValid() == 1) {
                    //套餐为新套餐则采用套餐区域
                    List<Integer> regionIds = Lists.newArrayList();
                    if (monthProduct.getSupportRegion() == 1){
                        regionIds = monthProductRegionService.getRegionIds(monthProduct.getId());
                    }
                    addMonthCardRenewRecode(MonthrenewePubcheck.builder()
                            .productId(monthOpenCardDto.getProductId())
                            .parkId(Math.toIntExact(monthProduct.getParkId()))
                            .cardProperty(monthOpenCardDto.getCardProperty())
                            .cardOwner(monthOpenCardDto.getCardOwner())
                            .plateNum(monthOpenCardDto.getPlateNumData().stream().map(MonthOpenCardDto.PlateNumData::getPlateNum).collect(Collectors.joining(",")))
                            .regionId(StrUtil.join(",",regionIds))
                            .phone(monthOpenCardDto.getPhone())
                            .cardStatus(1)
                            .cardOpertype(monthOpenCardDto.getCardProperty())
                            .plotCount(1)
                            .count(1)
                            .remark(monthOpenCardDto.getRemark())
                            .mainAddress(monthOpenCardDto.getMainAddress())
                            .payMoney(monthOrder.getTotalPrice() == null ? BigDecimal.ZERO : monthOrder.getTotalPrice())
                            .payMethod(monthOrder.getPayMethod())
                            .tradeNo(monthOrder.getTradeNo())
                            .attachment(JsonUtils.toString(monthOpenCardDto.getPicData()))
                            .refund(BigDecimal.ZERO)
                            .startTime(monthOpenCardDto.getStartDate())
                            .endTime(monthOpenCardDto.getEndDate())
                            .renewAccount(monthOpenCardDto.getUserName())
                            .payChannel(monthOrder.getPayChannel())
                            .build());
                    //修改月卡订单状态
                    monthOrder.setPayStatus(PayStatusConstants.PAID);
                    monthOrder.setPayTime(Math.toIntExact(monthOpenCardDto.getPayTime()));
                    monthOrder.setOutTradeNo(monthOpenCardDto.getOutTradeNo());
                    monthOrder.setRemark(monthOpenCardDto.getRemark());
                    monthOrderDao.update(monthOrder);
                    return ObjectResponse.success();
                }
                //调用开卡接口
                ObjectResponse<Object> objectObjectResponse = phpOpenCarService.openAndCheckMonthCard(monthOpenCardDto, Boolean.FALSE);
                if (!ObjectResponse.isSuccess(objectObjectResponse)) {
                    log.error("[调用saas月卡开卡接口] {}", objectObjectResponse);
                }
                //查询月卡记录id
                String s = JSONUtil.toJsonStr(objectObjectResponse.getData());
                JSONObject jsonObject = new JSONObject(s);
                String cardIdStr = (String) jsonObject.get("cardId");
                Integer cardId= Integer.valueOf(cardIdStr);
                MonthRecord monthRecord = monthRecordDao.selectOne(Wrappers.lambdaQuery(MonthRecord.class).eq(MonthRecord::getMonthId, cardId).orderByDesc(MonthRecord::getId).last(SqlConstant.LIMIT_ONE));
                //修改月卡订单状态
                monthOrder.setPayStatus(PayStatusConstants.PAID);
                monthOrder.setPayTime(Math.toIntExact(monthOpenCardDto.getPayTime()));
                monthOrder.setOutTradeNo(monthOpenCardDto.getOutTradeNo());
                monthOrder.setMonthRecordId(Objects.nonNull(monthRecord)?monthRecord.getId():null);
                monthOrder.setRemark(monthOpenCardDto.getRemark());
                monthOrderDao.update(monthOrder);
                return ObjectResponse.success();
            }
        }catch(Exception e){
            log.error("[月卡开通异常] monthOpenCardDto {}",monthOpenCardDto,e);
            return ObjectResponse.failed(CodeConstantsEnum.ERROR);
        }
    }

    @Override
    public ObjectResponse<Object> renewCard(MonthRenewCardDto monthRenewCardDto, Boolean isCheck) {
        try {
            if (isCheck) {
                //直接调用校验接口
                return phpOpenCarService.renewAndCheckMonthCard(monthRenewCardDto, Boolean.TRUE);
            } else {
                //查询支付中的月卡订单
                MonthOrder monthOrder = monthOrderDao.selectByTradeNoAndPayStatus(monthRenewCardDto.getTradeNo(), PayStatusConstants.PAYING);
                if (Objects.isNull(monthOrder)) {
                    return ObjectResponse.success();
                }
                //查看是否需要审核
                MonthProduct monthProduct = monthProductDao.selectById(monthRenewCardDto.getProductId());
                int diftDay = 0;
                if (monthProduct.getIsDiftDay() == 1){
                    diftDay = monthProduct.getDiftDays();
                }
                MonthInfo monthInfo = monthInfoDao.load(monthRenewCardDto.getMonthId());
                //查询车牌
                List<String> plateNums = monthInfoDao.selectPlateNums(monthInfo.getId());
                log.info("车牌号[{}]", plateNums);
                List<String> spaces = monthInfoDao.selectSpaces(monthInfo.getId());
                if (monthProduct.getAddstatusValid() == 1) {
                    //套餐为新套餐则采用套餐区域
                    List<Integer> regionIds = Lists.newArrayList();
                    if (monthProduct.getSupportRegion() == 1){
                        regionIds = monthProductRegionService.getRegionIds(monthProduct.getId());
                    }
                    addMonthCardRenewRecode(MonthrenewePubcheck.builder()
                            .monthId(monthRenewCardDto.getMonthId())
                            .productId(monthRenewCardDto.getProductId())
                            .parkId(Math.toIntExact(monthProduct.getParkId()))
                            .cardProperty(monthInfo.getCardProperty())
                            .cardOwner(monthInfo.getCardOwner())
                            .plateNum(plateNums.stream().filter(Objects::nonNull).collect(Collectors.joining(",")))
                            .spaceNum(spaces.stream().filter(Objects::nonNull).collect(Collectors.joining(",")))
                            .regionId(StrUtil.join(",",regionIds))
                            .phone(monthInfo.getPhone())
                            .cardStatus(Math.toIntExact(monthInfo.getProductId()) != monthRenewCardDto.getProductId() || DateTools.differentDays(monthInfo.getEndTime(),monthRenewCardDto.getStartDate())> 1 ? 1 : 2)
                            .cardOpertype(1)
                            .plotCount(monthInfo.getPlotCount())
                            .count(monthRenewCardDto.getBuyNum())
                            .payMoney(monthOrder.getTotalPrice() == null ? BigDecimal.ZERO : monthOrder.getTotalPrice())
                            .payMethod(2)
                            .tradeNo(monthOrder.getTradeNo())
                            .refund(BigDecimal.ZERO)
                            .startTime(monthRenewCardDto.getStartDate())
                            .endTime(monthRenewCardDto.getEndDate())
                            .renewAccount(String.valueOf(monthOrder.getMpUserId()))
                            .operAccount("公众号")
                            .addDay(String.valueOf(diftDay))
                            .payChannel(3)
                            .build());
                    //修改月卡订单状态
                    monthOrder.setPayStatus(PayStatusConstants.PAID);
                    monthOrder.setPayTime(Math.toIntExact(monthRenewCardDto.getPayTime()));
                    monthOrder.setOutTradeNo(monthRenewCardDto.getOutTradeNo());
                    monthOrder.setRemark(monthRenewCardDto.getRemark());
                    monthOrderDao.update(monthOrder);
                    return ObjectResponse.success();
                }
                //调用开卡接口
                ObjectResponse<Object> objectObjectResponse = phpOpenCarService.renewAndCheckMonthCard(monthRenewCardDto, Boolean.FALSE);
                if (!ObjectResponse.isSuccess(objectObjectResponse)) {
                    log.error("[调用saas月卡开卡接口] {}", objectObjectResponse);
                }
                //查询月卡记录id
                String s = JSONUtil.toJsonStr(objectObjectResponse.getData());
                JSONObject jsonObject = new JSONObject(s);
                String cardIdStr = (String) jsonObject.get("cardId");
                Integer cardId= Integer.valueOf(cardIdStr);
                MonthRecord monthRecord = monthRecordDao.selectOne(Wrappers.lambdaQuery(MonthRecord.class).eq(MonthRecord::getMonthId, cardId).orderByDesc(MonthRecord::getId).last(SqlConstant.LIMIT_ONE));
                //修改月卡订单状态
                monthOrder.setPayStatus(PayStatusConstants.PAID);
                monthOrder.setPayTime(Math.toIntExact(monthRenewCardDto.getPayTime()));
                monthOrder.setOutTradeNo(monthRenewCardDto.getOutTradeNo());
                monthOrder.setMonthRecordId(Objects.nonNull(monthRecord)?monthRecord.getId():null);
                monthOrder.setRemark(monthRenewCardDto.getRemark());
                monthOrderDao.update(monthOrder);
                return ObjectResponse.success();
            }
        }catch(Exception e){
            log.error("[月卡开通异常] monthOpenCardDto {}",monthRenewCardDto,e);
            return ObjectResponse.failed(CodeConstantsEnum.ERROR);
        }
    }

    @Override
    public ObjectResponse<MonthProductDto> getMonthProduct(String parkCode, Integer productId) {
        //获取车场信息
        Park park = parkService.findByParkCode(parkCode).getData();
        //获取月卡产品信息
        MonthProduct monthProduct = monthProductDao.selectById(productId);
        //获取区域信息
        String regionName = monthProductRegionService.getRegionName(monthProduct.getId());
        MonthProductDto monthProductDto = new MonthProductDto();
        monthProductDto.setId(monthProduct.getId());
        monthProductDto.setParkName(park.getParkName());
        monthProductDto.setParkCode(park.getParkCode());
        monthProductDto.setName(monthProduct.getName());
        monthProductDto.setDuration(monthProduct.getDuration());
        monthProductDto.setCardType(monthProduct.getCardType());
        monthProductDto.setPaymoney(monthProduct.getPaymoney());
        monthProductDto.setRegionName(regionName);
        monthProductDto.setRenewstatusValid(monthProduct.getRenewstatusValid());
        monthProductDto.setAddstatusValid(monthProduct.getAddstatusValid());
        monthProductDto.setStartDate(DateUtil.date());
        monthProductDto.setEndDate(DateUtil.offsetDay(DateUtil.offsetMonth(DateUtil.date(),monthProduct.getDuration()),-1));
        monthProductDto.setStartTime(monthProduct.getStartTime());
        monthProductDto.setEndTime(monthProduct.getEndTime());
        monthProductDto.setTelphone(park.getTelphone());
        monthProductDto.setTagContent(monthProduct.getTagContent());
        monthProductDto.setUserChareg(monthProduct.getUserChareg());
        return ObjectResponse.success(monthProductDto);
    }

    @Override
    public ObjectResponse<List<MonthInfoDto>> getMpUserMonthInfo(Integer mpUserId) {
        List<MonthInfoDto> monthInfoDtos = monthInfoDao.getMpUserMonthInfo(mpUserId);
        //查询审核表中待审核的月卡信息
        List<MonthInfoDto> monthInfoDtoList = monthrenewePubcheckService.selectMonthInfo(mpUserId);
        if (CollectionUtils.isEmpty(monthInfoDtos)){
            monthInfoDtos = Lists.newArrayList();
        }
        monthInfoDtos.addAll(monthInfoDtoList);
        return ObjectResponse.success(monthInfoDtos);
    }
    @Override
    public ParkRegion findMonthCardOtherRegion(Long parkId, String plateNum, String channelCode) {
        ObjectResponse<Park> parkObjectResponse = parkService.findByParkId(parkId);
        ObjectResponse.notError(parkObjectResponse);
        Park park = parkObjectResponse.getData();
        if (park.getIsInterior() == null || park.getIsInterior() == 0 || channelCode == null) {
            return null;
        }
        //场中场通道
        ObjectResponse<ParkInoutdevice> inoutDeviceByCode = parkService.getInoutDeviceByCode(channelCode);
        if (!ObjectResponse.isSuccess(inoutDeviceByCode) || Integer.valueOf(0).equals(inoutDeviceByCode.getData().getIsMaster())) {
            return null;
        }
        //检查是不是其他区域的月卡
        MonthInfo monthInfo = monthInfoDao.selectByPlateNum(parkId, plateNum, VALID_CARD);
        if (monthInfo != null) {
            List<MonthRegion> monthRegions = monthRegionDao.selectByMonthId(monthInfo.getId());
            if (!CollectionUtils.isEmpty(monthRegions)) {
                Optional<MonthRegion> any = monthRegions.stream()
                        .filter(region -> 0 != region.getRegionId()
                                && !region.getRegionId().equals(inoutDeviceByCode.getData().getRegionId()))
                        .findAny();
                if (any.isPresent()) {
                    return regionDao.selectById(any.get().getRegionId());
                }
            }
        }
        return null;
    }

    @Override
    public MonthInfo findMonthInfo(Long parkId, String plateNum, Long regionId, Integer cardStatus) {
        if (regionId == null) {
            return monthInfoDao.selectByRegionPlateNum(parkId, plateNum, null, cardStatus);
        }
        ObjectResponse<Park> parkObjectResponse = parkService.findByParkId(parkId);
        ObjectResponse.notError(parkObjectResponse);
        Park park = parkObjectResponse.getData();
        if (NumberUtils.toPrimitive(park.getIsInterior()) == 1) {
            return monthInfoDao.selectByRegionPlateNum(parkId, plateNum, regionId, cardStatus);
        } else {
            return monthInfoDao.selectByRegionPlateNum(parkId, plateNum, null, cardStatus);
        }
    }

    @Override
    public ObjectResponse<MonthCardConfigDto> limitConfig(Long monthInfoId) {
        //获取车场配置
        MonthInfo monthInfo = monthInfoDao.load(monthInfoId);
        ParkConfig parkConfig = parkConfigDao.selectByParkId(monthInfo.getParkId());
        MonthCardConfigDto monthCardConfigDto = new MonthCardConfigDto();
        if (Objects.nonNull(parkConfig.getRenewLimitDay())){
            if(parkConfig.getRenewLimitDay() == -1 ){
                return ObjectResponse.failed(CodeConstantsEnum.ERROR_402.getCode(),"车场不支持月卡线上续费");
            }
            if (parkConfig.getRenewLimitDay() != 0) {
                LocalDate nowDate = LocalDate.now();
                LocalDate monthEndDate = DateUtils.toLocalDate(monthInfo.getEndTime());
                long betweenDay = nowDate.toEpochDay() - monthEndDate.toEpochDay();
                if (betweenDay > parkConfig.getRenewLimitDay()) {
                    // 提示不可以续费
                    return ObjectResponse.failed(CodeConstantsEnum.ERROR_402.getCode(), "月卡过期超过" + parkConfig.getRenewLimitDay() + "天，车主不可在公众号续费，请联系车场管理方进行线下处理。");
                }
            }
        }
        monthCardConfigDto.setRenewCardLimitDays(parkConfig.getRenewLimitDay());
        monthCardConfigDto.setCardLimitMonths(parkConfig.getCardLimitMonth());
        monthCardConfigDto.setRenewCardStarttimeType(parkConfig.getRenewStarttimeType());
        if (Objects.isNull(parkConfig.getRenewLimitDay())||parkConfig.getRenewLimitDay() == 0){
            //不限制续费
            monthCardConfigDto.setRenewCardLimitDays(-1);
        }
        if (Objects.isNull(parkConfig.getCardLimitMonth())||parkConfig.getCardLimitMonth() == 0){
            monthCardConfigDto.setCardLimitMonths(-1);
        }

        return ObjectResponse.success(monthCardConfigDto);
    }

    @Override
    public ObjectResponse<MonthOrderCountDto> countMonthOrderList(Long accountId, String plateNum, Date startTime, Date endTime, Integer bizType) {
        MonthOrderCountDto monthOrderCountDto = monthOrderDao.countMonthOrder(accountId,plateNum,bizType,Objects.isNull(startTime)?null:startTime.getTime()/1000,Objects.isNull(endTime)?null:endTime.getTime()/1000);
        return ObjectResponse.success(monthOrderCountDto);
    }

    @Override
    public ObjectResponse<List<MonthOrderResponseVo>> getMonthOrderListBy(Integer cardType, List<String> plateNums) {
        List<MonthPlate> monthPlates = monthPlateDao.selectMonthIdByPlateNums(plateNums);
        if (CollectionUtils.isEmpty(monthPlates)) {
            return ObjectResponse.success();
        }
        Map<Long, List<String>> groupedByMonthId = monthPlates.stream()
                .collect(Collectors.groupingBy(
                        MonthPlate::getMonthId,
                        Collectors.mapping(MonthPlate::getPlateNum, Collectors.toList())
                ));
        List<Long> parkIds = monthPlates.stream().map(MonthPlate::getParkId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<Park> parks = parkService.findByParkIds(parkIds);
        Map<Long,String> parkMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(parks)) {
            parkMap = parks.stream().collect(Collectors.toMap(Park::getId,Park::getParkName,(a, b) -> b));
        }
        // 两年前
        LocalDateTime twoYear = LocalDateTime.now().minusYears(2);
        Date date = Date.from(twoYear.atZone(ZoneId.systemDefault()).toInstant());
        List<Long> monthIds = monthPlates.stream().map(MonthPlate::getMonthId).filter(Objects::nonNull).collect(Collectors.toList());
        List<MonthInfo> monthInfos = monthInfoDao.getMonthInfoBy(monthIds, cardType, date);
        if (CollectionUtils.isEmpty(monthInfos)) {
            return ObjectResponse.success();
        }
        List<Long> productIds = monthInfos.stream().map(MonthInfo::getProductId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<MonthProduct> products = monthProductDao.selectByIds(productIds);
        Map<Long, MonthProduct> productMap = products.stream().collect(Collectors.toMap(MonthProduct::getId, Function.identity()));
        Map<Long, String> finalParkMap = parkMap;
        List<MonthOrderResponseVo> responseVos = monthInfos.stream().filter(info -> NumberUtils.toPrimitive(info.getPayMethod()) != 0).map(info -> {
            MonthOrderResponseVo vo = new MonthOrderResponseVo();
            MonthProduct monthProduct = productMap.get(info.getProductId());
            if (monthProduct != null) {
                vo.setProductName(monthProduct.getName());
                vo.setUserChareg(monthProduct.getUserChareg());
                vo.setProductId(monthProduct.getId());
                vo.setDeposit(monthProduct.getDeposit());
                vo.setIsHaveDeposit(monthProduct.getIsHaveDeposit());
            }
            vo.setPlateNum(String.join(",", groupedByMonthId.get(info.getId())));
            vo.setUseBeginDate(info.getStartTime());
            vo.setUseEndDate(info.getEndTime());
            vo.setParkName(finalParkMap.get(info.getParkId()));
            vo.setPayTime(info.getCreateTime());
            vo.setCardStatus(info.getCardStatus());
            vo.setPayChannel(info.getPayMethod());
            vo.setPayAmount(info.getPayMoney());
            return vo;
        }).collect(Collectors.toList());
        return ObjectResponse.success(responseVos);
    }

    @Override
    public ObjectResponse<List<MonthInfo>> getMonthInfos(Long parkId, Date date) {
        List<MonthInfo> monthInfos = monthInfoDao.selectMonthInfos(parkId, date);
        if (CollectionUtils.isEmpty(monthInfos)) {
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
        }
        return ObjectResponse.success(monthInfos);
    }

    @Override
    public ObjectResponse<List<MonthOrder>> getMonthOrders(Long parkId, Date date) {
        List<MonthOrder> monthOrders = monthOrderDao.selectMonthOrderListBy(parkId, date);
        if (CollectionUtils.isEmpty(monthOrders)) {
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
        }
        return ObjectResponse.success(monthOrders);
    }

    public String getTime(Date time, int type) {
        String format = DateUtil.format(time, DatePattern.PURE_DATE_PATTERN);
        if (type == 1) {
            format  = format + "000000";
            return format;
        }
        return format + "235959";
    }

    @Override
    public boolean addMonthCarInfo(MonthInfo monthInfo) {
        int insert = monthInfoDao.insert(monthInfo);
        return insert > 0;
    }

    public MonthDetailDto getMonthCarDetailDto(Long parkId, String plateNum, Long regionId) {
        MonthDetailDto monthDetailDto = new MonthDetailDto();
        MonthInfo monthInfo = findMonthInfo(parkId, plateNum, regionId, VALID_CARD);
        if (monthInfo == null){
            MonthInfo monthInfoTimeout = findMonthInfo(parkId, plateNum, regionId, TIMEOUT_CARD);
            if (monthInfoTimeout == null){
                monthDetailDto.setMonthType(MonthDetailDto.MonthType.非月卡车);
            }else{
                monthDetailDto.setMonthType(MonthDetailDto.MonthType.过期临时车);
                monthDetailDto.setMonthInfo(monthInfoTimeout);
                ObjectResponse<ParkConfig> configObjectResponse = parkService.getParkConfig(parkId);
                ObjectResponse.notError(configObjectResponse);
                ParkConfig parkConfig = configObjectResponse.getData();
                //过期多少天按过期月卡车
                int expireMcDays = NumberUtils.toPrimitive(parkConfig.getExpireMcDays());
                int expireDaysMonth = NumberUtils.toPrimitive(parkConfig.getIsExpireMc());
                //过期天数
                int differentDays = DateTools.differentDays(monthInfoTimeout.getEndTime(), new Date());
                if (expireDaysMonth == 1) {
                    MonthProduct monthProduct = monthProductDao.selectById(monthInfoTimeout.getProductId());
                    int cardType = monthProduct.getCardType();
                    if (cardType == 1) {
                        monthDetailDto.setCardType(MonthDetailDto.CardType.全天卡);
                    } else {
                        monthDetailDto.setCardType(MonthDetailDto.CardType.错时卡);
                    }
                    if (differentDays <= expireMcDays) {
                        long monthId = monthInfoTimeout.getId();
                        int plotCount = monthInfoTimeout.getPlotCount();
                        boolean isMonth = isAbCarMonth(parkId, plateNum, monthId, plotCount, regionId);
                        if (isMonth) {
                            monthDetailDto.setMonthType(MonthDetailDto.MonthType.过期月卡车);
                        } else {
                            monthDetailDto.setMonthType(MonthDetailDto.MonthType.多位多车占用);
                        }
                    }
                }
            }
        }else{
            monthDetailDto.setMonthInfo(monthInfo);
            MonthProduct monthProduct = monthProductDao.selectById(monthInfo.getProductId());
            int cardType = monthProduct.getCardType();
            if (cardType == 1) {
                monthDetailDto.setCardType(MonthDetailDto.CardType.全天卡);
            } else {
                monthDetailDto.setCardType(MonthDetailDto.CardType.错时卡);
            }
            monthDetailDto.setMonthType(MonthDetailDto.MonthType.月卡车);
            long monthId = monthInfo.getId();
            int plotCount = monthInfo.getPlotCount();
            boolean isMonth = isAbCarMonth(parkId, plateNum, monthId, plotCount, regionId);
            if (!isMonth) {
                monthDetailDto.setMonthType(MonthDetailDto.MonthType.多位多车占用);
            }
        }
        return monthDetailDto;
    }
    public Boolean judgeMonthCar(Long parkId, String plateNum) {
        MonthInfo monthInfo = getMonthInfo(parkId, plateNum);
        return judgeMonthCar(parkId, plateNum, null, monthInfo);
    }
    public Boolean judgeMonthCar(Long parkId, String plateNum, Long regionId) {
        MonthInfo monthInfo = findMonthInfo(parkId, plateNum, regionId, VALID_CARD);
        return judgeMonthCar(parkId, plateNum, regionId, monthInfo);
    }

    public Boolean judgeMonthCar(Long parkId, String plateNum, Long regionId, MonthInfo monthInfo) {
        if (monthInfo == null){
            monthInfo = findMonthInfo(parkId, plateNum, regionId, TIMEOUT_CARD);
            if (monthInfo == null || !byExpireMonth(parkId, monthInfo)){
                return false;
            }
        }
        long monthId = monthInfo.getId();
        int plotCount = monthInfo.getPlotCount();
        return isAbCarMonth(parkId, plateNum, monthId, plotCount, regionId);
    }

    /**
     * 内区月卡多位多车离场处理
     * @param parkId 车场ID
     * @param plateNum 车牌号
     * @param exitTime 离场时间
     */
    public void innerAreaExitAbMonthDeal(Long parkId, String plateNum, Long exitTime, Long regionId){
        if (regionId == null || regionId == 0) {
            exitAbMonthDeal(parkId, plateNum, exitTime);
            return;
        }
        log.info("[内区多位多车离场处理] 进入，plateNum：{}，exitTime：{}，regionId：{}", plateNum, exitTime, regionId);
        MonthInfo monthInfoDto = monthInfoDao.selectByRegionPlateNum(parkId, plateNum, regionId, VALID_CARD);;
        if (monthInfoDto == null){
            return;
        }
        Long monthId = monthInfoDto.getId();
        //判断是不是内场月卡
        List<MonthRegion> monthRegions = monthRegionDao.selectByMonthId(monthId);
        if (CollectionUtils.isEmpty(monthRegions)) {
            log.info("[内区多位多车离场处理] 未关联到区域信息, plateNum[{}], regionId[{}]", plateNum, regionId);
            return;
        }
        Optional<MonthRegion> optional = monthRegions.stream()
                .filter(monthRegion -> regionId.equals(monthRegion.getRegionId())).findAny();
        if (!optional.isPresent()) {
            log.info("[内区多位多车离场处理] 不是内区月卡, plateNum[{}], regionId[{}]", plateNum, regionId);
            return;
        }
        int plotCount = monthInfoDto.getPlotCount();
        List<String> plateNumList = monthPlateDao.selectByMonthId(monthId);
        if (!isAbCarMonth(plotCount, plateNumList)) {
            return;
        }
        log.info("[内区多位多车离场处理] 是AB车，plateNum：{}", plateNum);
        plateNumList.remove(plateNum);
        OrderInfo recentOne = getMultipleAreaRecentOrder(parkId, regionId, plateNumList);
        /*
         * 判断在场车辆是否存在与此车辆同一用户的临时车
         */
        if (recentOne == null) {
            log.info("[内区多位多车离场处理] 在场车辆中不存在与[{}]同一用户的临时车", plateNum);
            return;
        }
        log.info("[内区多位多车离场处理] 最近入场的场内车辆：{}", recentOne);
        ObjectResponse<ParkConfig> configObjectResponse = parkService.getParkConfig(parkId);
        ObjectResponse.notError(configObjectResponse);
        ParkConfig parkConfig = configObjectResponse.getData();
        /*
         * 判断场内切换时间是否大于0
         */
        long intervalTime = exitTime - recentOne.getEnterTime();
        log.info("[内区多位多车离场处理] 当前车牌离场时间到上个订单的入场时间间隔是：{}，plateNum：{}", intervalTime, plateNum);
        if (intervalTime <= parkConfig.getSwitchTm() * 60) {
            if (recentOne instanceof OrderSonInfo) {
                OrderSonInfo orderInfoUpdate = new OrderSonInfo();
                orderInfoUpdate.setOrderNum(recentOne.getOrderNum());
                orderInfoUpdate.setType(PlateTypeEnum.月卡车.getType());
                orderInfoUpdate.setRegionId(regionId);
                orderSonInfoDao.updateByOrderNumAndRegionId(orderInfoUpdate);
            } else {
                OrderInfo orderInfo = new OrderInfo();
                orderInfo.setOrderNum(recentOne.getOrderNum());
                orderInfo.setType(PlateTypeEnum.月卡车.getType());
                orderInfo.setRegionId(regionId);
                orderInfoDao.updateByOrderNumAndRegionId(orderInfo);
                if (Integer.valueOf(1).equals(recentOne.getHasSon())) {
                    OrderSonInfo orderInfoUpdate = new OrderSonInfo();
                    orderInfoUpdate.setOrderNum(recentOne.getOrderNum());
                    orderInfoUpdate.setType(PlateTypeEnum.月卡车.getType());
                    orderInfoUpdate.setRegionId(regionId);
                    orderSonInfoDao.updateByOrderNumAndRegionId(orderInfoUpdate);
                }
            }
            log.info("[内区多位多车离场处理] 从在场记录中查找到[{}]最近入场并且是临时车，未超过切换时间，车辆类型更新为月卡车", plateNum);
        } else {
            //switchType解释：支持多车位管理超时处理规则1:B车计费结束时间按A车出场时间收费 2:B车计费结束时间按B车出场时间收费
            if (parkConfig.getSwitchType() == 1) {
                if (recentOne instanceof OrderSonInfo) {
                    OrderSonInfo orderSonInfo = new OrderSonInfo();
                    orderSonInfo.setOrderNum(recentOne.getOrderNum());
                    orderSonInfo.setType(PlateTypeEnum.月卡车.getType());
                    orderSonInfo.setSwitchTime(exitTime);
                    orderSonInfo.setRegionId(regionId);
                    orderSonInfoDao.updateByOrderNumAndRegionId(orderSonInfo);
                } else {
                    OrderInfo orderInfo = new OrderInfo();
                    orderInfo.setOrderNum(recentOne.getOrderNum());
                    orderInfo.setType(PlateTypeEnum.月卡车.getType());
                    orderInfo.setSwitchTime(exitTime);
                    orderInfo.setRegionId(regionId);
                    orderInfoDao.updateByOrderNumAndRegionId(orderInfo);
                    if (Integer.valueOf(1).equals(recentOne.getHasSon())) {
                        OrderSonInfo orderSonInfo = new OrderSonInfo();
                        orderSonInfo.setOrderNum(recentOne.getOrderNum());
                        orderSonInfo.setType(PlateTypeEnum.月卡车.getType());
                        orderSonInfo.setSwitchTime(exitTime);
                        orderSonInfo.setRegionId(regionId);
                        orderSonInfoDao.updateByOrderNumAndRegionId(orderSonInfo);
                    }
                }
                log.info("[内区多位多车离场处理] 从在场记录中查找到[{}]最近入场并且是临时车，已超过切换时间，车辆类型更新为月卡车，车辆切换时间更新为当前车辆的出场时间[{}]",
                        recentOne.getPlateNum(), exitTime);
            }
        }
    }

    /**
     * 场中场主通道离场多位多车离场处理
     * @param parkId 车场ID
     * @param plateNum 车牌号
     * @param exitTime 离场时间
     * @param regionId 离场时间
     */
    public void masterAreaExitAbMonthDeal(Long parkId, String plateNum, Long exitTime, Long regionId){
        MonthInfo monthInfoDto = monthInfoDao.selectByRegionPlateNum(parkId, plateNum, regionId, VALID_CARD);
        if (monthInfoDto == null) {
            return;
        }
        long monthId = monthInfoDto.getId();
        int plotCount = monthInfoDto.getPlotCount();
        List<String> plateNumList = monthPlateDao.selectByMonthId(monthId);
        if (!isAbCarMonth(plotCount, plateNumList)) {
            return;
        }
        log.info("[多位多车离场处理] plateNum[{}]是AB车", plateNum);
        plateNumList.remove(plateNum);
        //业务类型，1：全车场月卡，2：非全车场月卡
        int bizType = 1;
        List<MonthRegion> monthRegions = monthRegionDao.selectByMonthId(monthId);
        if (CollectionUtils.isNotEmpty(monthRegions)) {
            MonthRegion monthRegion = monthRegions.stream().filter(mr ->
                    NumberUtils.toPrimitive(mr.getRegionId()) != 0).findFirst().orElse(null);
            if (monthRegion != null) {
                bizType = 2;
                if (!monthRegion.getRegionId().equals(regionId)) {
                    log.info("[多位多车离场处理] 离场区域不是当前月卡生效区域, plateNum[{}], regionId[{}]", plateNum, regionId);
                    return;
                }
            }
        }
        OrderInfo recentOne;
        /*
         * 判断在场车辆是否存在与此车辆同一用户的临时车
         */
        if (bizType == 1) {
            List<OrderInfo> orderInfoList = getInParkOrderInfos(parkId, plateNumList, null);
            recentOne = orderInfoList.get(0);
        } else {
            recentOne = getMultipleAreaRecentOrder(parkId, regionId, plateNumList);
        }
        if (recentOne == null) {
            log.info("[多位多车离场处理] 在场车辆中不存在与[{}]同一用户的临时车", plateNum);
            return;
        }
        log.info("[多位多车离场处理] 最近入场的场内车辆：{}", recentOne);
        ObjectResponse<ParkConfig> configObjectResponse = parkService.getParkConfig(parkId);
        ObjectResponse.notError(configObjectResponse);
        ParkConfig parkConfig = configObjectResponse.getData();

        /*
         * 判断场内切换时间是否大于0
         */
        long intervalTime = exitTime - recentOne.getEnterTime();
        log.info("[多位多车离场处理] 当前车牌离场时间到上个订单的入场时间间隔是：{}，plateNum：{}", intervalTime, plateNum);
        if (intervalTime <= parkConfig.getSwitchTm() * 60) {
            if (bizType == 1) {
                OrderInfo orderInfoUpdate = new OrderInfo();
                orderInfoUpdate.setOrderNum(recentOne.getOrderNum());
                orderInfoUpdate.setType(PlateTypeEnum.月卡车.getType());
                orderInfoDao.updateByOrderNum(orderInfoUpdate);
                if (Integer.valueOf(1).equals(recentOne.getHasSon())) {
                    OrderSonInfo orderSonInfoUpdate = new OrderSonInfo();
                    orderSonInfoUpdate.setOrderNum(recentOne.getOrderNum());
                    orderSonInfoUpdate.setType(PlateTypeEnum.月卡车.getType());
                    orderSonInfoDao.updateByOrderNum(orderSonInfoUpdate);
                }
            } else {
                if (recentOne instanceof OrderSonInfo) {
                    OrderSonInfo orderSonInfoUpdate = new OrderSonInfo();
                    orderSonInfoUpdate.setOrderNum(recentOne.getOrderNum());
                    orderSonInfoUpdate.setType(PlateTypeEnum.月卡车.getType());
                    orderSonInfoUpdate.setRegionId(regionId);
                    orderSonInfoDao.updateByOrderNumAndRegionId(orderSonInfoUpdate);
                } else {
                    OrderInfo orderInfoUpdate = new OrderInfo();
                    orderInfoUpdate.setOrderNum(recentOne.getOrderNum());
                    orderInfoUpdate.setType(PlateTypeEnum.月卡车.getType());
                    orderInfoUpdate.setRegionId(regionId);
                    orderInfoDao.updateByOrderNumAndRegionId(orderInfoUpdate);
                    if (Integer.valueOf(1).equals(recentOne.getHasSon())) {
                        OrderSonInfo orderSonInfoUpdate = new OrderSonInfo();
                        orderSonInfoUpdate.setOrderNum(recentOne.getOrderNum());
                        orderSonInfoUpdate.setType(PlateTypeEnum.月卡车.getType());
                        orderSonInfoUpdate.setRegionId(regionId);
                        orderSonInfoDao.updateByOrderNumAndRegionId(orderSonInfoUpdate);
                    }
                }
            }
            log.info("[多位多车离场处理] 从在场记录中查找到[{}]最近入场并且是临时车，未超过切换时间，车辆类型更新为月卡车", plateNum);
        } else {
            if (parkConfig.getSwitchType() == 1) {
                //switchType解释：支持多车位管理超时处理规则1:B车计费结束时间按A车出场时间收费 2:B车计费结束时间按B车出场时间收费
                if (bizType == 1) {
                    OrderInfo orderInfoUpdate = new OrderInfo();
                    orderInfoUpdate.setOrderNum(recentOne.getOrderNum());
                    orderInfoUpdate.setType(PlateTypeEnum.月卡车.getType());
                    orderInfoUpdate.setSwitchTime(exitTime);
                    orderInfoDao.updateByOrderNum(orderInfoUpdate);
                    if (Integer.valueOf(1).equals(recentOne.getHasSon())) {
                        OrderSonInfo orderSonInfoUpdate = new OrderSonInfo();
                        orderSonInfoUpdate.setOrderNum(recentOne.getOrderNum());
                        orderSonInfoUpdate.setType(PlateTypeEnum.月卡车.getType());
                        orderSonInfoUpdate.setSwitchTime(exitTime);
                        orderSonInfoDao.updateByOrderNum(orderSonInfoUpdate);
                    }
                } else {
                    if (recentOne instanceof OrderSonInfo) {
                        OrderSonInfo orderSonInfoUpdate = new OrderSonInfo();
                        orderSonInfoUpdate.setOrderNum(recentOne.getOrderNum());
                        orderSonInfoUpdate.setType(PlateTypeEnum.月卡车.getType());
                        orderSonInfoUpdate.setRegionId(regionId);
                        orderSonInfoUpdate.setSwitchTime(exitTime);
                        orderSonInfoDao.updateByOrderNumAndRegionId(orderSonInfoUpdate);
                    } else {
                        OrderInfo orderInfoUpdate = new OrderInfo();
                        orderInfoUpdate.setOrderNum(recentOne.getOrderNum());
                        orderInfoUpdate.setType(PlateTypeEnum.月卡车.getType());
                        orderInfoUpdate.setRegionId(regionId);
                        orderInfoUpdate.setSwitchTime(exitTime);
                        orderInfoDao.updateByOrderNumAndRegionId(orderInfoUpdate);
                        if (Integer.valueOf(1).equals(recentOne.getHasSon())) {
                            OrderSonInfo orderSonInfoUpdate = new OrderSonInfo();
                            orderSonInfoUpdate.setOrderNum(recentOne.getOrderNum());
                            orderSonInfoUpdate.setType(PlateTypeEnum.月卡车.getType());
                            orderSonInfoUpdate.setRegionId(regionId);
                            orderSonInfoUpdate.setSwitchTime(exitTime);
                            orderSonInfoDao.updateByOrderNumAndRegionId(orderSonInfoUpdate);
                        }
                    }
                }
                log.info("[多位多车离场处理] 从在场记录中查找到[{}]最近入场并且是临时车，已超过切换时间，车辆类型更新为月卡车，车辆切换时间更新为当前车辆的出场时间[{}]", recentOne.getPlateNum(), exitTime);
            }
        }
    }

    private OrderInfo getMultipleAreaRecentOrder(Long parkId, Long regionId, List<String> plateNumList) {
        OrderInfo recentOne;
        List<OrderInfo> orderInfoList = getInParkOrderInfos(parkId, plateNumList, regionId);
        List<OrderSonInfo> orderSonInfoList = getInParkOrderSonInfos(parkId, plateNumList, regionId);
        OrderInfo recentOrder = CollectionUtils.isEmpty(orderInfoList) ? null : orderInfoList.get(0);
        OrderSonInfo recentOrderSon = CollectionUtils.isEmpty(orderSonInfoList) ? null : orderSonInfoList.get(0);
        if (recentOrder != null && recentOrderSon != null
                && !recentOrder.getOrderNum().equals(recentOrderSon.getOrderNum())) {
            recentOne = recentOrder.getEnterTime() < recentOrderSon.getEnterTime() ? recentOrder : recentOrderSon;
        } else {
            recentOne = recentOrder == null ? recentOrderSon : recentOrder;
        }
        return recentOne;
    }
    @Override
    public ObjectResponse<List<MonthRecord>> getMonthRecordList(List<Long> ids) {
        List<MonthRecord> monthRecords = monthRecordDao.selectBatchIds(ids);
        if (CollectionUtils.isEmpty(monthRecords)) {
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
        }
        return ObjectResponse.success(monthRecords);
    }

    @Override
    public ObjectResponse<List<MonthPlate>> getMonthPlatesByMonthId(Long monthId) {
        List<MonthPlate> monthPlates = monthPlateDao.selectAllByMonthId(monthId);
        if (CollectionUtils.isEmpty(monthPlates)) {
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
        }
        return ObjectResponse.success(monthPlates);
    }
}
