package com.icetech.park.service.makeup;

import java.util.concurrent.ScheduledThreadPoolExecutor;

import com.icetech.park.service.handle.P2cDownHandle;
import com.icetech.common.thread.ScheduleUtils;
import lombok.extern.slf4j.Slf4j;

/**
 * 端云WS下发补偿机制
 * @author fangct
 */
@Slf4j
public class WsRepeatPush {
    /**
     * 重新发送的最大时间，单位毫秒
     */
    private static final int OFF_SET_TIME = 60000;
    /**
     * 关闭连接后，等待注册的时间，单位毫秒
     */
    private static final int PRE_TIME = 500;
    /**
     * 每次间隔时间，单位毫秒
     */
    private static final int INTERVAL_TIME = 500;
    /**
     * ws 处理业务类
     */
    private P2cDownHandle p2cDownHandle;
    /**
     * 车场编号
     */
    private String parkCode;
    /**
     *
     */
    private String serialNumber;

    public WsRepeatPush(P2cDownHandle p2cDownHandle, String parkCode, String serialNumber){
        this.p2cDownHandle = p2cDownHandle;
        this.parkCode = parkCode;
        this.serialNumber = serialNumber;
    }

    public void push(ScheduledThreadPoolExecutor scheduler, IRepeatTask repeatTask) {
        //首先主动关闭连接
        p2cDownHandle.closeAllOld(parkCode + "_" + serialNumber);
        p2cDownHandle.closeAll(serialNumber);
        long maxTimeMillis = System.currentTimeMillis() + OFF_SET_TIME;
        ScheduleUtils.scheduleFixTimesWithFixDelay(scheduler, index -> {
            if (repeatTask.run()) {
                log.info("[{}_{}]第{}次重发成功", parkCode, serialNumber, index);
                return true;
            } else if (System.currentTimeMillis() > maxTimeMillis) {
                log.info("[{}_{}]第{}次重发达到最大时间", parkCode, serialNumber, index);
                return false;
            }
            log.info("[{}_{}]第{}次重发失败", parkCode, serialNumber, index);
            return null;
        }, 100, PRE_TIME, INTERVAL_TIME);
    }
}
