package com.icetech.park.service.jindi.impl;

import com.alibaba.csp.sentinel.annotation.SentinelResource;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.icetech.third.anno.DS_SLAVE;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.third.JinDiService;
import com.icetech.fee.dao.monthcar.MonthInfoDao;
import com.icetech.fee.dao.monthcar.MonthPlateDao;
import com.icetech.fee.dao.monthcar.MonthProductDao;
import com.icetech.fee.dao.monthcar.MonthRecordDao;
import com.icetech.order.dao.OrderCarInfoDao;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.dao.OrderPayDao;
import com.icetech.cloudcenter.domain.constants.CardStatusConstants;
import com.icetech.fee.domain.entity.monthcar.MonthInfo;
import com.icetech.fee.domain.entity.monthcar.MonthPlate;
import com.icetech.fee.domain.entity.monthcar.MonthProduct;
import com.icetech.fee.domain.entity.monthcar.MonthRecord;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.third.domain.entity.third.SendInfo;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.JinDiParkRequest;
import com.icetech.cloudcenter.domain.response.CheckOrderResponse;
import com.icetech.cloudcenter.domain.response.CheckStatusResponse;
import com.icetech.cloudcenter.domain.response.EnterRecordsResponse;
import com.icetech.cloudcenter.domain.response.ExitRecordsResponse;
import com.icetech.basics.sentinel.ExceptionUtils;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.constants.OrderStatusConstants;
import com.icetech.common.domain.Page;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.oss.OssService;
import com.icetech.third.dao.send.SendinfoDao;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;

import static com.icetech.cloudcenter.domain.request.JinDiParkRequest.convertJinDiPayMethod;
import static com.icetech.cloudcenter.domain.response.ExitRecordsResponse.convertLocalCarType;
import static com.icetech.cloudcenter.domain.response.ExitRecordsResponse.convertLocalPayMethod;

@Service
@Slf4j
public class JinDiServiceImpl implements JinDiService {
    @Autowired
    private ParkService parkService;
    @Autowired
    private MonthInfoDao monthInfoDao;
    @Autowired
    private MonthProductDao monthProductDao;
    @Autowired
    private MonthRecordDao monthRecordDao;
    @Autowired
    private OrderCarInfoDao orderCarInfoDao;
    @Autowired
    private OrderPayDao orderPayDao;
    @Autowired
    private OrderInfoDao orderInfoDao;
    @Autowired
    private MonthPlateDao monthPlateDao;
    @Autowired
    private OssService ossService;
    @Autowired
    private SendinfoDao sendInfoDao;
    @Override
    public ObjectResponse<List<CheckStatusResponse>> batchCheckStatus(List<String> carNums, String parkCode) {
        //获取当前车场信息
        Park park = parkService.findByParkCode(parkCode).getData();
        List<CheckStatusResponse> list = Lists.newArrayList();
        carNums.forEach(s -> {
            CheckStatusResponse checkStatusResponse = getCheckStatusResponse(s, park);
            list.add(checkStatusResponse);
        });
        return ObjectResponse.success(list);
    }

    @Override
    @Transactional
    public ObjectResponse parkingCars(JinDiParkRequest jinDiParkRequest) {
        Park park = parkService.findByParkCode(jinDiParkRequest.getParkCode()).getData();
        Date startTime = jinDiParkRequest.getStartTime();
        Date endTime = jinDiParkRequest.getEndTime();
        //获取开卡的车牌号列表
        List<Map> carNum = jinDiParkRequest.getCars();
        List<String> carNums = Lists.newArrayList();
        carNum.forEach(map -> {
            String num = (String) map.get("car_num");
            carNums.add(num);
        });
        //判断当前车场是否存在月卡产品
        MonthProduct monthProduct = monthProductDao.selectOneByParkId(park.getId());
        //根据主车牌号查询上次开卡记录
        MonthInfo monthInfo = monthInfoDao.selectByPlateNum(park.getId(), jinDiParkRequest.getMainCar(), null);
        //时间限制(不允许存在交叉的时间)
        if (Objects.nonNull(monthInfo) && monthInfo.getCardStatus() == 1){
            Date oldEndTime = monthInfo.getEndTime();
            if (startTime.getTime()<oldEndTime.getTime()){
                return ObjectResponse.failed(CodeConstantsEnum.ERROR_402);
            }
        }
        if (Objects.isNull(monthProduct)){
            //创建月卡产品
            monthProduct = new MonthProduct();
            monthProduct.setName("自定义月卡产品");
            monthProduct.setParkId(park.getId());
            monthProduct.setDuration(0);
            monthProduct.setCardType(1);
            monthProduct.setPaymoney(BigDecimal.ZERO);
            monthProduct.setStartDate(startTime);
            monthProduct.setEndDate(endTime);
            monthProduct.setCheckStatus(1);
            monthProduct.setBuyChannel(1);
            monthProduct.setStatus(1);
            monthProductDao.insert(monthProduct);
        }else {
            //修改月卡产品
            monthProduct.setStartDate(startTime);
            monthProduct.setEndDate(endTime);
            monthProductDao.update(monthProduct);
        }
        MonthRecord monthRecord = new MonthRecord();
        if (monthInfo == null || DateTools.differentDays(monthInfo.getEndTime(),startTime)>1){
            //新开卡
            monthInfo = new MonthInfo();
            monthInfo.setParkId(park.getId());
            monthInfo.setCardProperty(1);
            monthInfo.setCardOwner("");
            monthInfo.setProductId(monthProduct.getId());
            monthInfo.setPlotCount(jinDiParkRequest.getCount());
            monthInfo.setCount(jinDiParkRequest.getCount());
            monthInfo.setMainPlate(jinDiParkRequest.getMainCar());
            monthInfo.setSaleMoney(jinDiParkRequest.getTotalPrice() == null ? new BigDecimal(0) : BigDecimal.valueOf(jinDiParkRequest.getTotalPrice()));
            monthInfo.setPayMoney(jinDiParkRequest.getTotalPrice() == null ? new BigDecimal(0) : BigDecimal.valueOf(jinDiParkRequest.getTotalPrice()));
            monthInfo.setPayMethod(convertJinDiPayMethod(jinDiParkRequest.getPaymentMethod()));
            monthInfo.setStartTime(startTime);
            monthInfo.setEndTime(endTime);
            monthInfo.setCardStatus(CardStatusConstants.生效中);
            monthInfoDao.insert(monthInfo);
            //添加绑定车牌数
            for (String num : carNums) {
                MonthPlate monthPlate = new MonthPlate();
                monthPlate.setMonthId(monthInfo.getId());
                monthPlate.setParkId(monthInfo.getParkId());
                monthPlate.setPlateNum(num);
                monthPlateDao.insert(monthPlate);
            }
            log.info("[金地新开月卡] monthInfo:{}", JsonUtils.toString(monthInfo));
            monthRecord.setMonthId(monthInfo.getId());
            monthRecord.setCardOpertype(MonthRecord.CardOpertype.新增.getType());
        }else {
            // 更新
            monthInfo.setCardStatus(CardStatusConstants.生效中);
            monthInfo.setEndTime(endTime);
            monthInfo.setCount(jinDiParkRequest.getCount());
            monthInfo.setMainPlate(jinDiParkRequest.getMainCar());
            monthInfo.setPlotCount(jinDiParkRequest.getCount());
            monthInfoDao.update(monthInfo);
            //删除旧的绑定车牌
            monthInfoDao.deleteMonthPlate(monthInfo.getId());
            //添加新的绑定车牌
            for (String num : carNums) {
                MonthPlate monthPlate = new MonthPlate();
                monthPlate.setMonthId(monthInfo.getId());
                monthPlate.setParkId(monthInfo.getParkId());
                monthPlate.setPlateNum(num);
                monthPlateDao.insert(monthPlate);
            }

            monthRecord.setMonthId(monthInfo.getId());
            monthRecord.setCardOpertype(MonthRecord.CardOpertype.续费.getType());
            monthRecord.setIsOverdue(0);
        }
        monthRecord.setProductId(monthProduct.getId());
        monthRecord.setParkId(monthProduct.getParkId());
        monthRecord.setCardProperty(monthInfo.getCardProperty());
        monthRecord.setCardOwner(monthInfo.getCardOwner());
        monthRecord.setPhone(monthInfo.getPhone());
        monthRecord.setPlotCount(monthInfo.getPlotCount());
        monthRecord.setCount(monthInfo.getCount());
        monthRecord.setPayMoney(jinDiParkRequest.getTotalPrice());
        monthRecord.setPayMethod(convertJinDiPayMethod(jinDiParkRequest.getPaymentMethod()));
        monthRecord.setOperAccount(monthInfo.getOperAccount());
        monthRecord.setRemark(monthInfo.getRemark());
        //查询车位号
        StringJoiner pj = new StringJoiner(",");
        carNums.forEach(s -> {
            pj.add(s);
        });
        monthRecord.setPlateNum(pj.toString());
        monthRecord.setStartTime(monthInfo.getStartTime());
        monthRecord.setEndTime(monthInfo.getEndTime());
        monthRecord.setCreateTime(new Date());
        monthRecord.setUpdateTime(new Date());
        monthRecordDao.insert(monthRecord);
        SendInfo sendInfo = new SendInfo(monthProduct.getParkId(), monthRecord.getId(), DownServiceEnum.月卡.getServiceType());
        sendInfoDao.insert(sendInfo);
        return ObjectResponse.success();
    }

    @Override
    @Transactional
    public ObjectResponse cancelParking(String parkCode, String carNum) {
        Park park = parkService.findByParkCode(parkCode).getData();
        //根据主车牌号查询月卡信息
        MonthInfo monthInfo = monthInfoDao.selectByMainPlateNum(park.getId(),carNum);
        if (monthInfo == null){
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
        }else if (monthInfo.getCardStatus() == 3){
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_405);
        }
        //查询该车辆的月卡信息
        List<MonthRecord> monthRecords = monthRecordDao.selectByMonthId(monthInfo.getId());
        //如果最后一次为续费状态则下发为修改状态
        Boolean flag= Boolean.FALSE;
        Date endTime = null;
        if (!CollectionUtils.isEmpty(monthRecords)&&monthRecords.size()>1){
            MonthRecord last = monthRecords.get(monthRecords.size() - 1);
            MonthRecord second = monthRecords.get(monthRecords.size() - 2);
            if (MonthRecord.CardOpertype.续费.getType().equals(last.getCardOpertype()) && second!=null) {
                flag = Boolean.TRUE;
                endTime = second.getEndTime();
            }
        }

        //添加操作记录
        MonthRecord monthRecord = new MonthRecord();
        // 判断最后的操作记录是不是续卡,修改月卡的时间为前一次的结束时间
        if (flag){
            //变更月卡时间
            monthInfo.setEndTime(endTime);
            //添加修改下发
            monthRecord.setCardOpertype(MonthRecord.CardOpertype.修改.getType());
            monthRecord.setStartTime(monthInfo.getStartTime());
            monthRecord.setEndTime(endTime);
        }else {
            //变更月卡状态为退费
            monthInfo.setCardStatus(CardStatusConstants.已退费);
            //添加退费下发
            monthRecord.setCardOpertype(MonthRecord.CardOpertype.退卡.getType());
            monthRecord.setStartTime(monthInfo.getStartTime());
            monthRecord.setEndTime(monthInfo.getEndTime());
        }

        //传当前月卡所关联的月卡记录信息
        List<String> carNums = monthInfoDao.selectPlateNums(monthInfo.getId());
        monthInfoDao.update(monthInfo);
        monthRecord.setMonthId(monthInfo.getId());
        monthRecord.setProductId(monthInfo.getProductId());
        monthRecord.setParkId(park.getId());
        monthRecord.setCardProperty(monthInfo.getCardProperty());
        monthRecord.setCardOwner(monthInfo.getCardOwner());
        monthRecord.setPhone(monthInfo.getPhone());
        monthRecord.setPlotCount(monthInfo.getPlotCount());
        monthRecord.setCount(monthInfo.getCount());
        monthRecord.setPayMoney(monthInfo.getPayMoney() == null ? 0 : monthInfo.getPayMoney().doubleValue());
        monthRecord.setPayMethod(convertJinDiPayMethod(monthInfo.getPayMethod()));
        monthRecord.setOperAccount(monthInfo.getOperAccount());
        //查询车位号
        StringJoiner pj = new StringJoiner(",");
        carNums.forEach(s -> {
            pj.add(s);
        });
        monthRecord.setIsOverdue(0);
        monthRecord.setPlateNum(pj.toString());
        monthRecord.setRemark(monthInfo.getRemark());
        monthRecordDao.insert(monthRecord);
        SendInfo sendInfo = new SendInfo(monthRecord.getParkId(), monthRecord.getId(), DownServiceEnum.月卡.getServiceType());
        sendInfoDao.insert(sendInfo);
        return ObjectResponse.success();
    }

    @Override
    @Transactional
    public ObjectResponse updateCarsInfo(List<Map> carNums,String parkCode) {
        Park park = parkService.findByParkCode(parkCode).getData();
        //查询该车辆的月卡信息

        //更新月卡车牌绑定记录
        carNums.forEach(map -> {
            String current_num = (String) map.get("current_num");
            String changed_num = (String) map.get("changed_num");
            //查询车牌绑定的月卡信息
            MonthInfo monthInfo = monthInfoDao.selectByPlateNum(park.getId(), current_num, null);
            //更新车牌信息
            MonthPlate monthPlate = monthPlateDao.selectByMonthIdAndPlate(monthInfo.getId(),current_num);
            monthPlate.setPlateNum(changed_num);
            monthPlate.setParkId(monthInfo.getParkId());
            monthPlateDao.update(monthPlate);
            List<String> carNum = monthInfoDao.selectPlateNums(monthInfo.getId());
            //添加操作记录
            MonthRecord monthRecord = new MonthRecord();
            monthRecord.setMonthId(monthInfo.getId());
            monthRecord.setCardOpertype(MonthRecord.CardOpertype.修改.getType());
            monthRecord.setIsOverdue(0);
            monthRecord.setProductId(monthInfo.getProductId());
            monthRecord.setParkId(park.getId());
            monthRecord.setCardProperty(monthInfo.getCardProperty());
            monthRecord.setCardOwner(monthInfo.getCardOwner());
            monthRecord.setPhone(monthInfo.getPhone());
            monthRecord.setPlotCount(monthInfo.getPlotCount());
            monthRecord.setCount(monthInfo.getCount());
            monthRecord.setPayMoney(monthInfo.getPayMoney() == null ? 0 : monthInfo.getPayMoney().doubleValue());
            monthRecord.setPayMethod(convertJinDiPayMethod(monthInfo.getPayMethod()));
            monthRecord.setOperAccount(monthInfo.getOperAccount());
            monthRecord.setRemark(monthInfo.getRemark());
            //查询车位号
            StringJoiner pj = new StringJoiner(",");
            carNum.forEach(s -> {
                pj.add(s);
            });
            monthRecord.setPlateNum(pj.toString());
            monthRecord.setCreateTime(new Date());
            monthRecord.setUpdateTime(new Date());
            monthRecordDao.insert(monthRecord);
            SendInfo sendInfo = new SendInfo(monthRecord.getParkId(), monthRecord.getId(), DownServiceEnum.月卡.getServiceType());
            sendInfoDao.insert(sendInfo);
        });
        return ObjectResponse.success();
    }

    @Override
    public ObjectResponse<CheckOrderResponse> checkStatus(String carNum, String parkCode) {
        //获取当前车场信息
        Park park = parkService.findByParkCode(parkCode).getData();
        CheckOrderResponse checkStatusResponse = getCheckOrderResponse(carNum, park);
        return ObjectResponse.success(checkStatusResponse);
    }

    @Override
    @DS_SLAVE
    @SentinelResource(value = "JinDiService.getEnterList", defaultFallback = "defaultFallbackHandle", fallbackClass = {ExceptionUtils.class})
    public ObjectResponse<Page<EnterRecordsResponse>> getEnterList(Integer pageNum, Integer pageSize, String parkCode, Date startDate, Date endDate) {
        Park park = parkService.findByParkCode(parkCode).getData();
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<OrderInfo> orderInfoPage = new com.baomidou.mybatisplus.extension.plugins.pagination.Page<>(pageNum, pageSize);
        OrderInfo orderInfoParam = new OrderInfo();
        orderInfoParam.setParkId(park.getId());
        orderInfoParam.setServiceStatus(OrderStatusConstants.IN_PARK);
        orderInfoParam.setEnterTime(startDate == null ? null : startDate.getTime() / 1000);
        orderInfoParam.setExitTime(endDate == null ? null : endDate.getTime() / 1000);
        orderInfoPage = orderInfoDao.selectPage(orderInfoPage, Wrappers.query(orderInfoParam));
        List<OrderInfo> orderInfos = orderInfoPage.getRecords();
        PageInfo pageInfo = new PageInfo(orderInfos);
        List<EnterRecordsResponse> enterRecordsResponses = orderInfos.stream().map(orderInfo -> {
            EnterRecordsResponse enterRecordsResponse = new EnterRecordsResponse();
            enterRecordsResponse.setRecordId(String.valueOf((orderInfo.getId())));
            enterRecordsResponse.setCarNum(orderInfo.getPlateNum());
            enterRecordsResponse.setEnterTime(DateTools.getFormat(orderInfo.getEnterTime() * 1000));
            OrderCarInfo carInfo = orderCarInfoDao.selectByOrderNum(orderInfo.getOrderNum());
            enterRecordsResponse.setEnterUrl(StringUtils.isEmpty(carInfo.getEnterImage()) ? "" : ossService.getImageUrl(carInfo.getEnterImage()));
            enterRecordsResponse.setCarType(convertLocalCarType(orderInfo.getCarType()));
            return enterRecordsResponse;
        }).collect(Collectors.toList());
        return ObjectResponse.success(Page.instance(pageInfo.getPages(), pageInfo.getTotal(), enterRecordsResponses));
    }

    @Override
    @DS_SLAVE
    @SentinelResource(value = "JinDiService.getExitList", defaultFallback = "defaultFallbackHandle", fallbackClass = {ExceptionUtils.class})
    public ObjectResponse<Page<ExitRecordsResponse>> getExitList(Integer pageNum, Integer pageSize, String parkCode, Date startDate, Date endDate) {
        Park park = parkService.findByParkCode(parkCode).getData();
        PageHelper.startPage(pageNum,pageSize);
        List<OrderInfo> orderInfos = orderInfoDao.selectExitRecords(park.getId().toString(),
                startDate.getTime() / 1000, endDate.getTime() / 1000,
                null, null, null, null,null, null, null, null, null, null);
        PageInfo pageInfo = new PageInfo(orderInfos);
        List<ExitRecordsResponse> exitRecordsResponses = orderInfos.stream().map(orderInfo -> {
            //获取订单支付信息
            List<OrderPay> orderPays = orderPayDao.selectByOrderNum(orderInfo.getOrderNum());
            OrderCarInfo carInfo = orderCarInfoDao.selectByOrderNum(orderInfo.getOrderNum());

            ExitRecordsResponse exitRecordsResponse = new ExitRecordsResponse();
            exitRecordsResponse.setRecordId(String.valueOf(orderInfo.getId()));
            exitRecordsResponse.setCarNum(orderInfo.getPlateNum());
            exitRecordsResponse.setEnterTime(DateTools.getFormat(orderInfo.getEnterTime() * 1000));
            exitRecordsResponse.setLeaveTime(DateTools.getFormat(orderInfo.getExitTime() * 1000));
            exitRecordsResponse.setCarType(convertLocalCarType(orderInfo.getType()));
            if(carInfo != null) {
                if(StringUtils.isNotBlank(carInfo.getEnterImage())) {
                    exitRecordsResponse.setEnterUrl(ossService.getImageUrl(carInfo.getEnterImage()));
                }
                if(StringUtils.isNotBlank(carInfo.getExitImage())) {
                    exitRecordsResponse.setLeaveUrl(ossService.getImageUrl(carInfo.getExitImage()));
                }
            }
            exitRecordsResponse.setPayableAmount(orderInfo.getTotalPrice());
            exitRecordsResponse.setPaidAmount(orderInfo.getPaidPrice());
            if (!CollectionUtils.isEmpty(orderPays)){
                OrderPay orderPay = orderPays.get(0);
                exitRecordsResponse.setPayMethod(Objects.nonNull(orderPay)?convertLocalPayMethod((orderPay.getPayWay())):10);
            }
            return exitRecordsResponse;
        }).collect(Collectors.toList());
        return ObjectResponse.success(Page.instance(pageInfo.getPages(), pageInfo.getTotal(), exitRecordsResponses));
    }

    private CheckStatusResponse getCheckStatusResponse(String carNum, Park park) {
        CheckStatusResponse checkStatusResponse = new CheckStatusResponse();
        //查询当前车辆最近的开卡信息
        MonthInfo monthInfo = monthInfoDao.selectByPlateNum(park.getId(), carNum, null);
        if (Objects.isNull(monthInfo)) {
            checkStatusResponse.setStatus(1);
            checkStatusResponse.setCarNum(carNum);
        } else {
            //判断是否在有效期
            if (monthInfo.getCardStatus() == 1) {
                checkStatusResponse.setStatus(2);
                checkStatusResponse.setCarNum(carNum);
                checkStatusResponse.setStartTime(DateTools.getFormat(DateTools.DF_, monthInfo.getStartTime()));
                checkStatusResponse.setEndTime(DateTools.getFormat(DateTools.DF_, monthInfo.getEndTime()));
            } else {
                checkStatusResponse.setStatus(3);
                checkStatusResponse.setCarNum(carNum);
                checkStatusResponse.setStartTime(DateTools.getFormat(DateTools.DF_, monthInfo.getStartTime()));
                checkStatusResponse.setEndTime(DateTools.getFormat(DateTools.DF_, monthInfo.getEndTime()));
            }
        }
        return checkStatusResponse;
    }
    private CheckOrderResponse getCheckOrderResponse(String carNum, Park park) {
        CheckOrderResponse checkOrderResponse = new CheckOrderResponse();
        //查询当前车辆最近的开卡信息
        MonthInfo monthInfo = monthInfoDao.selectByPlateNum(park.getId(), carNum, null);
        if (Objects.nonNull(monthInfo)){
            List<Map> list = new ArrayList<>();
            List<String> plateNums = monthInfoDao.selectPlateNums(monthInfo.getId());
            plateNums.forEach(plateNum -> {
                Map map = new HashMap();
                map.put("car_num", plateNum);
                list.add(map);
            });
            checkOrderResponse.setCars(list);
            checkOrderResponse.setCount(monthInfo.getCount());
        }
        if (Objects.isNull(monthInfo) || monthInfo.getCardStatus() == 3) {
            // 未存在记录
            checkOrderResponse.setStatus(1);
            checkOrderResponse.setCount(0);
            checkOrderResponse.setMainCar(carNum);
        } else {
            // 判断是否在有效期
            if (monthInfo.getCardStatus() == 1) {
                // 已生效
                checkOrderResponse.setStatus(2);
                checkOrderResponse.setMainCar(StringUtils.isEmpty(monthInfo.getMainPlate())?carNum:monthInfo.getMainPlate());
                checkOrderResponse.setStartTime(DateTools.getFormat(DateTools.DF_, monthInfo.getStartTime()));
                checkOrderResponse.setEndTime(DateTools.getFormat(DateTools.DF_, monthInfo.getEndTime()));
            } else {
                // 已过期
                checkOrderResponse.setStatus(3);
                checkOrderResponse.setMainCar(carNum);
                checkOrderResponse.setStartTime(DateTools.getFormat(DateTools.DF_, monthInfo.getStartTime()));
                checkOrderResponse.setEndTime(DateTools.getFormat(DateTools.DF_, monthInfo.getEndTime()));
            }
        }
        return checkOrderResponse;
    }
}
