package com.icetech.park.service.invoice;

import com.icetech.cloudcenter.api.invoice.InvoiceTradeService;
import com.icetech.park.dao.invoice.InvoiceTradeDao;
import com.icetech.park.domain.entity.invoice.InvoiceTrade;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author kate
 */
@Service
@Slf4j
public class InvoiceTradeServiceImpl implements InvoiceTradeService {
    @Autowired
    private InvoiceTradeDao invoiceTradeDao;
    @Override
    public int deleteByPrimaryKey(Integer id){
        return invoiceTradeDao.deleteByPrimaryKey(id);
    }

    @Override
    public InvoiceTrade insert(InvoiceTrade record){
        int insert = invoiceTradeDao.insert(record);
        return record;
    }

    @Override
    public List<InvoiceTrade> selectByTradeNos(String[] tradeNos){
        return invoiceTradeDao.selectByTradeNos(tradeNos);
    }

    @Override
    public List<InvoiceTrade> selectAll(){
        return invoiceTradeDao.selectAll();
    }

    /**
     * 根据开票号获取所有的订单明细
     * @param orderId
     * @return
     */
    @Override
    public List<InvoiceTrade> selectByOrderId(String orderId){
        return invoiceTradeDao.selectByOrderId(orderId);
    }

    @Override
    public int updateByPrimaryKey(InvoiceTrade record){
        return invoiceTradeDao.updateByPrimaryKey(record);
    }
}
