package com.icetech.park.service.invoice;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.icetech.cloudcenter.api.invoice.InvoiceBlueService;
import com.icetech.cloudcenter.api.invoice.InvoiceMerchantService;
import com.icetech.cloudcenter.api.invoice.InvoiceTradeService;
import com.icetech.cloudcenter.domain.request.BaseQueryRequest;
import com.icetech.cloudcenter.domain.response.InvoiceDetailResponse;
import com.icetech.cloudcenter.domain.response.InvoiceRecordResponse;
import com.icetech.park.dao.invoice.InvoiceMerchantDao;
import com.icetech.park.domain.entity.invoice.InvoiceMerchant;
import com.icetech.park.domain.entity.invoice.InvoiceTrade;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.response.ObjectResponse;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
@Service
@Slf4j
public class InvoiceMerchantServiceImpl implements InvoiceMerchantService {
    @Autowired
    private InvoiceMerchantDao invoiceMerchantDao;
    @Autowired
    private InvoiceBlueService invoiceBlueService;
    @Autowired
    private InvoiceTradeService invoiceTradeService;
    @Override
    public int deleteByPrimaryKey(Integer id){
        return invoiceMerchantDao.deleteByPrimaryKey(id);
    }

    @Override
    public InvoiceMerchant insert(InvoiceMerchant record){
        int insert = invoiceMerchantDao.insert(record);
        return record;
    }

    @Override
    public InvoiceMerchant selectByPrimaryKey(Integer id){
        return invoiceMerchantDao.selectByPrimaryKey(id);
    }

    @Override
    public InvoiceMerchant selectByParkId(Long parkId){
        return invoiceMerchantDao.selectByParkId(parkId);
    }

    @Override
    public int updateByTaxpayerInfo(InvoiceMerchant record){
        return invoiceMerchantDao.updateByTaxpayerInfo(record);
    }

    @Override
    public InvoiceMerchant selectByTaxnum(String taxpayerNum){
        return invoiceMerchantDao.selectByTaxnum(taxpayerNum);
    }

    @Override
    public ObjectResponse<List<InvoiceRecordResponse>> getInvoiceRecords(Integer mpUserId, BaseQueryRequest baseQueryRequest, Integer source) {
        try (Page<InvoiceRecordResponse> page = PageHelper.startPage(baseQueryRequest.getPageNo(), baseQueryRequest.getPageSize(), baseQueryRequest.isCount())) {
            List<InvoiceRecordResponse> invoiceBlues = invoiceBlueService.selectByMpUserId(mpUserId, baseQueryRequest.getStartTime(), baseQueryRequest.getEndTime(), source);
            return ObjectResponse.success(invoiceBlues);
        }
    }

    @Override
    public ObjectResponse<InvoiceDetailResponse> getInvoiceDetail(String orderId) {
        InvoiceDetailResponse invoiceDetailResponse = invoiceBlueService.selectInvoiceDetailByOrderId(orderId);
        if (Objects.isNull(invoiceDetailResponse)) return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
        //获取交易信息
        List<InvoiceTrade> invoiceTrades = invoiceTradeService.selectByOrderId(invoiceDetailResponse.getOrderId());
        List<String> strings = invoiceTrades.stream().map(InvoiceTrade::getTradeNo).collect(Collectors.toList());
        String join = StringUtils.join(strings, ",");
        invoiceDetailResponse.setTradeNo(join);
        return ObjectResponse.success(invoiceDetailResponse);
    }

}
