package com.icetech.park.service.invoice;


import com.icetech.cloudcenter.api.invoice.InvoiceBlueService;
import com.icetech.cloudcenter.domain.response.InvoiceDetailResponse;
import com.icetech.cloudcenter.domain.response.InvoiceRecordResponse;
import com.icetech.park.dao.invoice.InvoiceBlueDao;
import com.icetech.park.domain.entity.invoice.InvoiceBlue;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

@Service
@Slf4j
public class InvoiceBlueServiceImpl implements InvoiceBlueService {
    @Autowired
    private InvoiceBlueDao invoiceBlueDao;
    @Override
    public int deleteByPrimaryKey(Integer id){
        return invoiceBlueDao.deleteByPrimaryKey(id);
    }

    @Override
    public InvoiceBlue insert(InvoiceBlue record){
        invoiceBlueDao.insert(record);
        return record;
    }

    @Override
    public InvoiceBlue selectByOrderId(String orderId){
        return invoiceBlueDao.selectByOrderId(orderId);
    }

    @Override
    public int updateByOrderId(InvoiceBlue record){
        return invoiceBlueDao.updateByOrderId(record);
    }

    /**
     * 获取 公众号下的所有开票记录
     * @param mpUserId
     * @param startTime
     * @param endTime
     * @return
     */
    @Override
    public List<InvoiceRecordResponse> selectByMpUserId(Integer mpUserId, Date startTime, Date endTime,Integer source){
        return invoiceBlueDao.selectByMpUserId(mpUserId,startTime, endTime,source);
    }

    /**
     * 获取订单发票明细的返回
     * @param orderId
     * @return
     */
    @Override
    public InvoiceDetailResponse selectInvoiceDetailByOrderId(String orderId){
        return invoiceBlueDao.selectInvoiceDetailByOrderId(orderId);
    }

    /**
     * 根据订单号删除
     * @param orderId
     */
    @Override
    public int deleteByOrderId(String orderId){
        return invoiceBlueDao.deleteByOrderId(orderId);
    }

    @Override
    public InvoiceBlue selectByThirdId(String thirdId){
        return invoiceBlueDao.selectByThirdId(thirdId);
    }

    @Override
    public List<InvoiceBlue> selectByChannelAndStatus(Integer channel, Integer status){
        return invoiceBlueDao.selectByChannelAndStatus(channel, status);
    }

    @Override
    public List<String> selectCheckedTradeNoList(Integer source, String plateNum, List<String> plateNumList) {
        return invoiceBlueDao.selectCheckedTradeNoList(source, plateNum, plateNumList);
    }
}
