package com.icetech.park.service.impl.manage;

import com.icetech.cloudcenter.domain.request.ApplyNoPlateEnterRequest;
import com.icetech.cloudcenter.domain.request.CloseBrakeRequest;
import com.icetech.cloudcenter.domain.request.DataEnterRequest;
import com.icetech.cloudcenter.domain.request.DataExitRequest;
import com.icetech.cloudcenter.domain.request.ModifyFeeRequest;
import com.icetech.cloudcenter.domain.request.OpenBrakeRequest;
import com.icetech.cloudcenter.domain.request.PullfeeRequest;
import com.icetech.cloudcenter.domain.request.VoiceReportRequest;
import com.icetech.cloudcenter.domain.response.EnexCarInfoBaseResponse;
import com.icetech.cloudcenter.domain.response.EnterCarInfoResponse;
import com.icetech.cloudcenter.domain.response.PullfeeResponse;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;

/**
 * 车场管理
 * @author wangzw
 */
public interface CloudManageService {

    /**
     * 请求从缓存中获取车辆信息
     * @param parkCode 车厂编码
     * @param aisleCode 通道编码
     * @param type 类型
     * @return
     */
    ObjectResponse<EnexCarInfoBaseResponse> getCarInfoFromRedis(String parkCode, String aisleCode, Integer type, String topic);

    /**
     * Description: 缓存中获取入场车辆信息
     * Version1.0 2021-05-19 by wgy 创建
     *
     * @param parkCode      车厂编码
     * @param aisleCode     通道编码
     * @return com.icetech.common.domain.response.ObjectResponse<com.icetech.datacenter.api.response.EnterCarInfoResponse>
     */
    ObjectResponse<EnterCarInfoResponse> getCarEnterTraceFromRedis(String parkCode, String aisleCode);

    /**
     * 请求从相机端中获取车辆信息
     * @param parkCode 车厂编码
     * @param aisleCode 通道编码
     * @param type 类型
     * @return
     */
    ObjectResponse<EnexCarInfoBaseResponse> getCarInfoFromCamera(String parkCode, String aisleCode, Integer type, String topic);

    /**
     * 异步返回触发逻辑
     * @param parkCode
     * @param version 协议版本号
     * @param sn
     * @param aisleCode
     * @param type
     * @return
     */
    ObjectResponse<String> getCarInfoFromCameraAsync(String parkCode,String version, String sn,String aisleCode, Integer type);

    /**
     * 根据订单号查询是否已上报识别结果
     * @param parkCode 车场编号
     * @param orderNum 订单编号
     * @return 响应
     */
    ObjectResponse<Object> getCarExitInfoFromCacheByOrderNum(String parkCode, String orderNum);

    /**
     * 请求允许入场
     * @param enterRequest
     * @return
     */
    ObjectResponse<Void> allowEnter(DataEnterRequest enterRequest);

    /**
     * 请求允许出场
     * @param exitRequest
     * @return
     */
    ObjectResponse<Void> allowExit(DataExitRequest exitRequest);

    /**
     * 请求拉取费用
     * @param pullfeeRequest
     * @return
     */
    ObjectResponse<PullfeeResponse> pullFee(PullfeeRequest pullfeeRequest);

    /**
     * 请求语音播报
     * @param voiceReportRequest
     * @return
     */
    ObjectResponse<Void> callVoiceReport(VoiceReportRequest voiceReportRequest);

    /**
     * 请求开闸
     * @param openBrakeRequest
     * @return
     */
    ObjectResponse<Void> requestOpenBrake(OpenBrakeRequest openBrakeRequest);
    /**
     * 请求关闸
     * @param closeBrakeRequest
     * @return
     */
    ObjectResponse<Void> requestCloseBrake(CloseBrakeRequest closeBrakeRequest);
    /**
     * 修改费用
     * @param modifyFeeRequest
     * @return
     */
    ObjectResponse<Void> modifyCacheFee(ModifyFeeRequest modifyFeeRequest);


    /**
     * 申请无牌车入场，目前只支持端云
     * @param applyNoPlateEnterRequest 参数
     * @return 处理结果
     */
    ObjectResponse<Void> applyNoPlateEnter(ApplyNoPlateEnterRequest applyNoPlateEnterRequest);


    /**
     * 车队模式
     * @param parkCode
     * @param parkId
     * @param sn
     * @param enable
     * @return
     */
    ObjectResponse<Void> fleetMode(String parkCode, Long parkId, String sn, Integer enable);
}
