package com.icetech.park.service.impl.manage;

import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.order.OrderPayService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.cloudcenter.domain.constants.RedisConstants;
import com.icetech.cloudcenter.domain.enumeration.SwitchTypeEnum;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.request.CloseBrakeRequest;
import com.icetech.cloudcenter.domain.request.DataEnterRequest;
import com.icetech.cloudcenter.domain.request.DataExitRequest;
import com.icetech.cloudcenter.domain.request.OpenBrakeRequest;
import com.icetech.cloudcenter.domain.request.OpeningDtoRequest;
import com.icetech.cloudcenter.domain.request.PullfeeRequest;
import com.icetech.cloudcenter.domain.request.QueryOrderFeeRequest;
import com.icetech.cloudcenter.domain.request.VoiceReportRequest;
import com.icetech.cloudcenter.domain.request.p2c.SoftTriggerRequest;
import com.icetech.cloudcenter.domain.response.ExitCarInfoResponse;
import com.icetech.cloudcenter.domain.response.PullfeeResponse;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.cloudcenter.domain.response.p2c.CarEnterResult;
import com.icetech.cloudcenter.domain.response.p2c.RemoteSwitchResponse;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.EnexRecordTypeConstants;
import com.icetech.common.constants.OrderCarInfoConstant;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.down.CaptureService;
import com.icetech.park.service.down.RemoteOperaService;
import com.icetech.park.service.down.p2c.impl.FleetModeServiceImpl;
import com.icetech.park.service.down.p2c.impl.HintServiceImpl;
import com.icetech.park.service.down.p2c.impl.P2cRemoteSwitchServiceImpl;
import com.icetech.park.service.down.p2c.impl.SoftTriggerServiceImpl;
import com.icetech.park.service.down.p2c.impl.TakePicturesServiceImpl;
import com.icetech.park.service.flow.p2c.FlowCondition;
import com.icetech.park.service.handle.PublicHandle;
import com.icetech.park.service.handle.showsay.DownShowSayHandle;
import com.icetech.park.service.handle.showsay.LedSayHandle;
import com.icetech.park.service.handle.showsay.LedShowHandle;
import com.icetech.park.service.impl.base.ManageServiceBase;
import com.icetech.third.utils.RedisUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * 端云/纯云下发通用处理接口
 * @author fnagct
 */
@Slf4j
public class CloudManageCommon extends ManageServiceBase {
    @Autowired
    protected SoftTriggerServiceImpl softTriggerService;
    @Autowired
    protected TakePicturesServiceImpl takePicturesService;
    @Autowired
    protected OrderService orderService;
    @Autowired
    protected P2cRemoteSwitchServiceImpl remoteSwitchService;
    @Autowired
    protected HintServiceImpl hintService;
    @Autowired
    protected OrderPayService orderPayService;
    @Autowired
    protected LedShowHandle ledShowHandle;
    @Autowired
    protected LedSayHandle ledSayHandle;
    @Autowired
    protected DownShowSayHandle downShowSayHandle;
    @Autowired
    protected PublicHandle publicHandle;
    @Autowired
    protected RedisUtils redisUtils;

    protected ObjectResponse<Void> noConExit(DataExitRequest exitRequest, Long parkId, String plateNum) {
        CarExitRequest carExitRequest = new CarExitRequest();
        carExitRequest.setParkCode(exitRequest.getParkCode());
        carExitRequest.setParkId(parkId);
        carExitRequest.setOrderNum(exitRequest.getOrderNum());
        carExitRequest.setType(exitRequest.getType());
        carExitRequest.setCarType(exitRequest.getCarType());
        carExitRequest.setExitTime(exitRequest.getExitTime() == null ? DateTools.unixTimestamp() : exitRequest.getExitTime().getTime()/1000);
        carExitRequest.setPlateNum(plateNum);
        carExitRequest.setTriggerType(2);
        carExitRequest.setParkCode(exitRequest.getParkCode());
        carExitRequest.setInandoutCode(exitRequest.getAisleCode());
        if (exitRequest.getAisleCode() != null) {
            ObjectResponse<ParkInoutdevice> objectResponse = parkService.getInOutDeviceByCode(parkId, exitRequest.getAisleCode());
            ObjectResponse.notError(objectResponse, "通道编号不存在");
            carExitRequest.setInandoutName(objectResponse.getData().getInandoutName());
        }
        carExitRequest.setExitWay(exitRequest.getExitWay());
        carExitRequest.setOperAccount(exitRequest.getOperAccount());
        carExitRequest.setExitTerminal(exitRequest.getExitTerminal());
        ObjectResponse<Map<String, Object>> enterObjectResponse = carOrderExitService.exit(carExitRequest);
        if (ObjectResponse.isSuccess(enterObjectResponse)) {
            return ObjectResponse.success();
        }else{
            log.info("[平台离场] 无牌车离场失败，返回：{}", enterObjectResponse);
            return ObjectResponse.failed(enterObjectResponse.getCode(), enterObjectResponse.getMsg());
        }
    }

    /**
     * 获取离场通道信息
     * @param parkId
     * @param parkCode
     * @param carExitRequest
     * @return
     */
    protected ExitCarInfoResponse getExitCarInfoResponse(Long parkId, String parkCode, CarExitRequest carExitRequest) {
        return getExitCarInfoResponse(parkId, parkCode, carExitRequest, null);
    }
    protected ExitCarInfoResponse getExitCarInfoResponse(Long parkId, String parkCode, CarExitRequest carExitRequest, String localOrderNum) {
        ExitCarInfoResponse exitCarInfoResponse = new ExitCarInfoResponse();
        String orderNum = carExitRequest.getOrderNum();
        exitCarInfoResponse.setExitNum(carExitRequest.getPlateNum());
        exitCarInfoResponse.setCarType(carExitRequest.getCarType());
        exitCarInfoResponse.setType(carExitRequest.getType());
        if (StringUtils.isNotBlank(orderNum)){
            OrderInfo orderInfo = new OrderInfo();
            orderInfo.setOrderNum(orderNum);
            orderInfo.setParkId(parkId);
            ObjectResponse<OrderInfo> byOrderInfo = orderService.findByOrderInfo(orderInfo);
            if (byOrderInfo.getCode().equals(CodeConstants.SUCCESS)){
                OrderInfo data = byOrderInfo.getData();
                exitCarInfoResponse.setEnterTime(new Date(data.getEnterTime() * 1000L));
                exitCarInfoResponse.setEnterNum(data.getPlateNum());
                exitCarInfoResponse.setLocalOrderNum(data.getLocalOrderNum());
                exitCarInfoResponse.setNoneEnterFlag(data.getNoneEnterFlag());
            }
            exitCarInfoResponse.setOrderNum(carExitRequest.getOrderNum());
        }else{
            String plateNum = carExitRequest.getPlateNum();
            ObjectResponse<OrderInfo> byOrderInfo = orderService.findInPark(plateNum, parkCode);
            if (byOrderInfo.getCode().equals(CodeConstants.SUCCESS)){
                OrderInfo data = byOrderInfo.getData();
                exitCarInfoResponse.setEnterTime(new Date(data.getEnterTime() * 1000L));
                exitCarInfoResponse.setEnterNum(data.getPlateNum());
                exitCarInfoResponse.setOrderNum(data.getOrderNum());
                exitCarInfoResponse.setLocalOrderNum(data.getLocalOrderNum());
                exitCarInfoResponse.setNoneEnterFlag(data.getNoneEnterFlag());
            }
        }
        Long exitTime = carExitRequest.getExitTime();
        if (exitTime != null){
            exitCarInfoResponse.setExitTime(new Date(exitTime * 1000L));
        }else{
            //离场时间默认为当前时间
            exitCarInfoResponse.setExitTime(new Date());
        }
        String maxImage = carExitRequest.getMaxImage();
        if (maxImage != null){
            exitCarInfoResponse.setImgUrl(ossService.getImageUrl(maxImage));
            exitCarInfoResponse.setImgPath(maxImage);
        }

        if (exitCarInfoResponse.getOrderNum() == null && localOrderNum != null){
            exitCarInfoResponse.setLocalOrderNum(localOrderNum);
            exitCarInfoResponse.setNoneEnterFlag(1);
        }
        return exitCarInfoResponse;
    }
    /**
     * 异常离场
     * @param openBrakeRequest
     * @param parkCode
     * @param plateNum
     */
    protected void exceptionExit(CaptureService captureService, OpenBrakeRequest openBrakeRequest, String parkCode, String plateNum, String topic) {
        ObjectResponse<OrderInfo> inPark = orderService.findInPark(plateNum, parkCode);
        if (ObjectResponse.isSuccess(inPark)){
            OrderInfo orderInfo = inPark.getData();
            CarExitRequest exit = cacheHandle.getExit(parkCode, openBrakeRequest.getAisleCode());
            if (exit == null){
                ObjectResponse objectResponse = captureService.execute(orderInfo.getParkId(), parkCode,
                        openBrakeRequest.getAisleCode(), topic, SoftTriggerRequest.ExceptionExit.builder().biz(SoftTriggerRequest.ExtraInfoEnum.EXCEPTION_EXIT.val)
                                .type(EnexRecordTypeConstants.EXIT)
                                .plateNum(plateNum)
                                .orderNum(orderInfo.getOrderNum())
                                .operAccount(openBrakeRequest.getOperAccount())
                                .exitTerminal(openBrakeRequest.getExitTerminal())
                                .reasonType(openBrakeRequest.getReasonType()).build());
                if (CodeConstants.ERROR_12002.equals(objectResponse.getCode())){
                    return;
                } else {
                    exit = new CarExitRequest();
                }
            }else{
                if (!exit.getPlateNum().equals(plateNum)){
                    log.info("[手动开闸] 离场通道缓存的当前车牌号：{} 与开闸请求的车牌号：{} 不同", exit.getPlateNum(), plateNum);
                }
            }
            exit.setPlateNum(plateNum);
            exit.setOrderNum(orderInfo.getOrderNum());
            QueryOrderFeeResponse channelFee = cacheHandle.getChannelFee(parkCode, openBrakeRequest.getAisleCode());
            if (channelFee != null){
                exit.setTotalAmount(channelFee.getTotalAmount());
                exit.setPaidAmount(channelFee.getPaidAmount());
                //String discountPrice = NumberUtils.decimalAdd(channelFee.getDiscountPrice(), channelFee.getDiscountAmount()).toString();
                exit.setDiscountAmount(channelFee.getDiscountAmount());
            }
            exit.setExitWay(OrderCarInfoConstant.IN_OUT_WAY_SOFTWARE_MANUAL);
            if (openBrakeRequest.getOperAccount() != null) {
                exit.setOperAccount(openBrakeRequest.getOperAccount());
            }
            if (openBrakeRequest.getExitTerminal() != null) {
                exit.setExitTerminal(openBrakeRequest.getExitTerminal());
            }
            ObjectResponse<Map<String, Object>> exceptionExit = carOrderExitService.exceptionExit(exit, openBrakeRequest.getReasonType());
            if (!ObjectResponse.isSuccess(exceptionExit)){
                log.info("[手动开闸] 异常离场失败，车牌号：{}", plateNum);
            }else{
                log.info("[手动开闸] 异常离场成功，车牌号：{}", plateNum);
            }
        }
    }

    /**
     * 通过车场编号获取车场ID
     * @param parkCode
     * @return
     */
    protected Long getParkId(String parkCode) {
        ObjectResponse<Park> byParkCode = parkService.findByParkCode(parkCode);
        ObjectResponse.notError(byParkCode);
        Park park = byParkCode.getData();
        return park.getId();
    }
    protected ObjectResponse<Void> callVoiceReport(CaptureService captureService, VoiceReportRequest voiceReportRequest) {
        /*
         * 语音显示
         */
        String parkCode = voiceReportRequest.getParkCode();
        String aisleCode = voiceReportRequest.getAisleCode();
        String fee = voiceReportRequest.getFee();
        if (NumberUtils.parseDouble(fee) <= 0) {
            log.info("[端云-语音播报] 0元费用无需下发屏显语音, {}", voiceReportRequest);
            return ObjectResponse.success();
        }
        String serialNumber;
        try{
            serialNumber = cacheHandle.getSerialNumber(parkCode, aisleCode);
        }catch (ResponseBodyException e){
            return ObjectResponse.failed(CodeConstants.ERROR_3003);
        }
        String plateNum = voiceReportRequest.getPlateNum();
        ObjectResponse<Park> byParkCode = parkService.findByParkCode(parkCode);
        ObjectResponse.notError(byParkCode);
        Park park = byParkCode.getData();

        ObjectResponse<ParkInoutdevice> channelResp = parkService.getInOutDeviceByCode(park.getId(), aisleCode);
        ObjectResponse.notError(channelResp, "通道号不存在");
        Integer exType = channelResp.getData().getInandoutType();

        String orderNum = voiceReportRequest.getOrderNum();

        //车辆类型
        int type = 1;
        CarExitRequest exit = null;
        CarEnterRequest enterRequest = null;
        if (exType == 2) {
            ObjectResponse<OrderInfo> orderInfoObjectResponse = orderService.findByOrderNum(orderNum);
            ObjectResponse.notError(orderInfoObjectResponse, "当前车辆不在场内");
            type = orderInfoObjectResponse.getData().getType();
            exit = cacheHandle.getExit(parkCode, aisleCode);
        } else {
            enterRequest = cacheHandle.getEntrance(parkCode,aisleCode);
            if (enterRequest != null) {
                type = enterRequest.getType();
            }
        }
        Map<String, Object> para = new HashMap<>();
        para.put("fee", voiceReportRequest.getFee());
        para.put("parkTime", voiceReportRequest.getParkTime());
        para.put("orderNum", voiceReportRequest.getOrderNum());
        ObjectResponse objectResponse = downShowSayHandle.showSayExec(park.getId(), parkCode, channelResp.getData().getId(), plateNum, type,
                (voiceReportRequest.isHasNotPay() ? FlowCondition.ResultCode.欠费补缴 : FlowCondition.ResultCode.需缴费), para,
                serialNumber, exType, aisleCode, true);

        /*
         * 更新当前通道的缓存车牌，如果没有缓存记录，则软触发获取后放入缓存
         */
        if (exType == 2) {
            if (exit == null){
                log.info("[端云-语音播报] 疑似出口相机识别成了无牌车，参数：{},{}", parkCode, aisleCode);
                ObjectResponse objectResponse2 = captureService.execute(park.getId(), parkCode, aisleCode, voiceReportRequest.getTopic(),
                        SoftTriggerRequest.CallVoiceReport.builder().biz(SoftTriggerRequest.ExtraInfoEnum.CALL_VOICE_REPORT.val)
                                .plateNum(plateNum)
                                .type(exType)
                                .orderNum(voiceReportRequest.getOrderNum())
                                .code(objectResponse.getCode())
                                .msg(objectResponse.getMsg()).build());
                if (CodeConstants.ERROR_12002.equals(objectResponse2.getCode())) {
                    return objectResponse2;
                }else{
                    exit = new CarExitRequest();
                    exit.setParkCode(parkCode);
                    exit.setParkId(park.getId());
                    exit.setInandoutCode(voiceReportRequest.getAisleCode());
                    log.info("[端云-语音播报] 软触发未获取到结果，会影响到离场，参数：{},{}", parkCode, aisleCode);
                }
            }
            exit.setPlateNum(plateNum);
            exit.setOrderNum(voiceReportRequest.getOrderNum());
            cacheHandle.setExit(parkCode, aisleCode, exit);
        } else {
            if (enterRequest == null){
                log.info("[端云-语音播报] 疑似入口相机识别成了无牌车，参数：{},{}", parkCode, aisleCode);
                ObjectResponse objectResponse2 = captureService.execute(park.getId(), parkCode, aisleCode, voiceReportRequest.getTopic(),
                        SoftTriggerRequest.CallVoiceReport.builder().biz(SoftTriggerRequest.ExtraInfoEnum.CALL_VOICE_REPORT.val)
                                .plateNum(plateNum)
                                .type(exType)
                                .orderNum(voiceReportRequest.getOrderNum())
                                .code(objectResponse.getCode())
                                .msg(objectResponse.getMsg()).build());
                if (CodeConstants.ERROR_12002.equals(objectResponse2.getCode())) {
                    return objectResponse2;
                }else{
                    enterRequest = new CarEnterRequest();
                    enterRequest.setParkCode(parkCode);
                    enterRequest.setParkId(park.getId());
                    enterRequest.setInandoutCode(voiceReportRequest.getAisleCode());
                    log.info("[端云-语音播报] 软触发未获取到结果，会影响到离场，参数：{},{}", parkCode, aisleCode);
                }
            }
            enterRequest.setPlateNum(plateNum);
            enterRequest.setOrderNum(voiceReportRequest.getOrderNum());
            cacheHandle.setEntrance(parkCode, aisleCode, enterRequest);
        }

        if (objectResponse != null && objectResponse.getCode().equals(CodeConstants.SUCCESS)){
            return ObjectResponse.success();
        }else{
            log.info("[端云-语音播报] 语音显示指令下发失败，车牌号：{}", plateNum);
            return ObjectResponse.failed(CodeConstants.ERROR_3003);
        }
    }

    protected ObjectResponse<Void> allowEnter(RemoteOperaService remoteOperaService, DataEnterRequest enterRequest) {
        String parkCode = enterRequest.getParkCode();
        Long parkId = getParkId(parkCode);
        String plateNum = enterRequest.getPlateNum();
        String serialNumber;
        if (enterRequest.isOffLine()) {
            return p2cEnter(enterRequest, plateNum, parkId, parkCode);
        }
        try{
            serialNumber = cacheHandle.getSerialNumber(parkCode, enterRequest.getAisleCode());
        }catch (ResponseBodyException e){
            return ObjectResponse.failed(CodeConstants.ERROR_3003);
        }
        // 开闸
        String msgId = remoteOperaService.open(SwitchTypeEnum.开闸.getType(), parkId, enterRequest.getParkCode(), serialNumber, enterRequest.getPlateNum());
        if (msgId == null){
            log.info("[平台入场] 开闸指令下发失败");
            return  ObjectResponse.failed(CodeConstants.ERROR_3002);
        }
        // 语音显示
        ObjectResponse<ParkInoutdevice> channelResp = parkService.getInOutDeviceByCode(parkId, enterRequest.getAisleCode());
        ParkInoutdevice channel = channelResp.getData();
        if (channel == null) {
            return ObjectResponse.failed(CodeConstants.ERROR, "无效的通道编号");
        }
        downShowSayHandle.showSayExec(parkId, parkCode, channel.getId(), plateNum, enterRequest.getType(), null,
                serialNumber, 1, enterRequest.getAisleCode(), false);
        return enter(enterRequest, parkCode, enterRequest.getAisleCode(), parkId, plateNum, enterRequest.getTopic());
    }
    private ObjectResponse<Void> p2cEnter(DataEnterRequest enterRequest, String plateNum, Long parkId, String parkCode) {
        CarEnterRequest carEnterRequest = new CarEnterRequest();
        carEnterRequest.setPlateNum(plateNum);
        carEnterRequest.setType(1);
        carEnterRequest.setEnterTime(enterRequest.getEnterTime());
        carEnterRequest.setCarType(1);
        carEnterRequest.setInandoutCode(enterRequest.getAisleCode());
        ObjectResponse<ParkInoutdevice> objectResponse = parkService.getInOutDeviceByCode(parkId, enterRequest.getAisleCode());
        ObjectResponse.notError(objectResponse);
        carEnterRequest.setInandoutName(objectResponse.getData().getInandoutName());
        carEnterRequest.setOpenFlag(0);
        carEnterRequest.setTriggerType(2);
        carEnterRequest.setProperty(2);
        carEnterRequest.setParkId(parkId);
        carEnterRequest.setParkCode(parkCode);
        carEnterRequest.setEnterWay(enterRequest.getEnterWay() != null
                ? enterRequest.getEnterWay() : OrderCarInfoConstant.IN_OUT_WAY_SOFTWARE_MANUAL);
        carEnterRequest.setNoneEnterFlag(false);
        carEnterRequest.setRemark(enterRequest.getRemark());
        carEnterRequest.setEnterTerminal(enterRequest.getEnterTerminal());
        carEnterRequest.setOperaUser(enterRequest.getOperaUser());
        ObjectResponse<?> resp = carOrderEnterService.enter(carEnterRequest);
        return ObjectResponse.instance(resp);
    }

    protected ObjectResponse<Void> exit(CaptureService captureService, DataExitRequest exitRequest, String parkCode, String aisleCode, Long parkId, String plateNum, String topic) {
        //保存订单信息
        if (exitRequest.isOffLine()) {
            log.debug("isOffLine:{}", exitRequest.isOffLine());
            return noConExit(exitRequest, parkId, plateNum);
        }
        CarExitRequest exit = cacheHandle.getExit(parkCode, aisleCode);
        if (exit == null) {
            ObjectResponse<Void> objectResponse = captureService.execute(parkId, parkCode, aisleCode, topic,
                    SoftTriggerRequest.AllowExit.builder().biz(SoftTriggerRequest.ExtraInfoEnum.ALLOW_EXIT.val)
                            .type(EnexRecordTypeConstants.EXIT)
                            .requestVO(exitRequest).build());
            if (objectResponse.getCode().equals(CodeConstants.ERROR_12002)) {
                //后续逻辑在软触发实现的notify方法中
                return objectResponse;
            } else {
                return noConExit(exitRequest, parkId, plateNum);
            }
        }
        String cacheOrderNum = exit.getOrderNum();
        if (cacheOrderNum != null && !exitRequest.getOrderNum().equals(cacheOrderNum)) {
            log.warn("[平台离场] 订单与缓存中的异常订单不匹配，缓存数据为:{},请求参数为:{}", exit, exitRequest);
        }
        String orderNum = exitRequest.getOrderNum();
        ObjectResponse<OrderInfo> orderInfoObjectResponse = orderService.findByOrderNum(orderNum);
        if (ObjectResponse.isSuccess(orderInfoObjectResponse)){
            OrderInfo orderInfo = orderInfoObjectResponse.getData();
            Long enterTime = orderInfo.getEnterTime();
            //如果入场时间大于参数中的离场时间，则使用当前时间作为离场时间
            if (enterTime > exitRequest.getExitTime().getTime() / 1000){
                exitRequest.setExitTime(new Date());
            }
        }
        exit.setType(exitRequest.getType());
        exit.setInandoutCode(aisleCode);
        if (exit.getInandoutName() == null && aisleCode != null) {
            ObjectResponse<ParkInoutdevice> objectResponse = parkService.getInOutDeviceByCode(parkId, aisleCode);
            ObjectResponse.notError(objectResponse, "通道编号不存在");
            exit.setInandoutName(objectResponse.getData().getInandoutName());
        }
        exit.setCarType(exitRequest.getCarType() != null ? exitRequest.getCarType() : exit.getCarType());
        exit.setOrderNum(orderNum == null ? cacheOrderNum : orderNum);
        exit.setPlateNum(exitRequest.getPlateNum());
        exit.setExitTime(exit.getExitTime() != null ? exit.getExitTime() : (exitRequest.getExitTime().getTime() / 1000));
        if (exitRequest.getOperAccount() != null) {
            exit.setOperAccount(exitRequest.getOperAccount());
        }
        if (exitRequest.getExitWay() != null) {
            exit.setExitWay(exitRequest.getExitWay());
        }
        if (exitRequest.getExitTerminal() != null) {
            exit.setExitTerminal(exitRequest.getExitTerminal());
        }
        ObjectResponse<Map<String, Object>> objectResponse = carOrderExitService.exit(exit);
        if (ObjectResponse.isSuccess(objectResponse)) {
            //清除缓存中的上次异常记录
            cacheHandle.removeExit(parkCode, aisleCode);
            cacheHandle.removeChannelFee(parkCode, aisleCode);
            return ObjectResponse.success();
        } else {
            return ObjectResponse.failed(objectResponse.getCode(), objectResponse.getMsg());
        }
    }

    public void addOpeningRecord(Object openBrakeRequest, String image, Long executeTime) {
        //添加开闸记录
        OpeningDtoRequest openingDtoRequest = new OpeningDtoRequest();
        BeanUtils.copyProperties(openBrakeRequest, openingDtoRequest);
        openingDtoRequest.setImgUrl(image);
        openingDtoRequest.setExecuteTime(executeTime);
        parkService.saveOpeningRecord(openingDtoRequest);
    }

    protected ObjectResponse<PullfeeResponse> p2cPullFee(PullfeeRequest pullfeeRequest, QueryOrderFeeRequest queryOrderFeeRequest, String parkCode, String channelId) {
        PullfeeResponse pullfeeResponse = new PullfeeResponse();
        QueryOrderFeeResponse channelFee = cacheHandle.getChannelFee(pullfeeRequest.getParkCode(), pullfeeRequest.getAisleCode());

        ObjectResponse<ParkInoutdevice> inoutObjectResponse = parkService.getInoutDeviceByCode(channelId);
        ObjectResponse.notError(inoutObjectResponse, "通道编号不存在");
        queryOrderFeeRequest.setExType(inoutObjectResponse.getData().getInandoutType());
        //入口欠费查询
        if (inoutObjectResponse.getData().getInandoutType() == 1) {
            if (channelFee == null || !channelFee.getPlateNum().equals(pullfeeRequest.getPlateNum())) {
                log.warn("[入口查费] 当前通道费用缓存为空或车牌号不一致, 当前缓存[{}], 参数车牌号[{}]", channelFee, pullfeeRequest.getPlateNum());
                ObjectResponse<QueryOrderFeeResponse> objectResponse = orderService.p2cQueryFee(queryOrderFeeRequest);
                if (ObjectResponse.isSuccess(objectResponse)) {
                    cacheHandle.setChannelFee(parkCode, channelId, objectResponse.getData());
                }
            }
            return ObjectResponse.success();
        }
        // 缓存为空，或车牌不同，或车型与缓存不一致时，则重新查询费用
        if (channelFee == null || !channelFee.getPlateNum().equals(pullfeeRequest.getPlateNum())
                || channelFee.getCarType() != null && !channelFee.getCarType().equals(pullfeeRequest.getCarType())){
            log.info("[人工查询费用] 缓存中无费用信息，查询最新费用，参数[{}]", pullfeeRequest);
            CarExitRequest cacheExit = cacheHandle.getExit(parkCode, channelId);
            if (cacheExit != null){
                log.info("[人工查询费用] 以缓存中的离场时间作为计费截止时间, 车牌号[{}],计费截止时间[{}]", pullfeeRequest.getPlateNum(), cacheExit.getExitTime());
                queryOrderFeeRequest.setExitTime(cacheExit.getExitTime());
            }
            ObjectResponse<QueryOrderFeeResponse> queryOrderFeeResponseObjectResponse = queryOrderFee(queryOrderFeeRequest);
            if (!ObjectResponse.isSuccess(queryOrderFeeResponseObjectResponse)){
                if (CodeConstants.ERROR_3004.equals(queryOrderFeeResponseObjectResponse.getCode())) {
                    ObjectResponse<OrderSumFeeDto> sumFee = orderPayService.getSumFee(pullfeeRequest.getParkCode(), pullfeeRequest.getOrderNum());
                    if (sumFee != null && sumFee.getCode().equals(CodeConstants.SUCCESS)) {
                        OrderSumFeeDto orderSumFeeDto = sumFee.getData();
                        pullfeeResponse.setTotalPrice(String.valueOf(orderSumFeeDto.getTotalPrice()));
                        pullfeeResponse.setDiscountPrice(String.valueOf(orderSumFeeDto.getDiscountPrice()));
                        pullfeeResponse.setCurrentDiscountPrice("0.00");
                        pullfeeResponse.setPaidPrice(String.valueOf(orderSumFeeDto.getPaidPrice()));
                        pullfeeResponse.setNeedPayPrice("0.00");
                        pullfeeResponse.setOrderNum(orderSumFeeDto.getOrderNum());
                        //pullfeeResponse.setTradeNo(orderSumFeeDto.get());
                        pullfeeResponse.setQueryTime(orderSumFeeDto.getLastOrderTime());
                        pullfeeResponse.setLastPayTime(orderSumFeeDto.getLastPayTime());
                        return ObjectResponse.success(pullfeeResponse);
                    }
                }
                log.info("[人工查询费用] 查询最新费用失败，参数[{}]", pullfeeRequest);
                return ObjectResponse.failed(CodeConstants.ERROR_3001, queryOrderFeeResponseObjectResponse.getMsg());
            }
            QueryOrderFeeResponse data = queryOrderFeeResponseObjectResponse.getData();
            String discountPrice = data.getDiscountPrice();
            String unpayPrice = data.getUnpayPrice();
            String discountAmount = data.getDiscountAmount();
            //总应收
            pullfeeResponse.setTotalPrice(data.getTotalAmount());
            //总优惠
            pullfeeResponse.setDiscountPrice(NumberUtils.decimalAdd(discountPrice, discountAmount).toString());
            pullfeeResponse.setCurrentDiscountPrice(discountPrice);
            pullfeeResponse.setPaidPrice(data.getPaidAmount());
            pullfeeResponse.setNeedPayPrice(unpayPrice);
            pullfeeResponse.setQueryTime(data.getQueryTime());
            pullfeeResponse.setLastPayTime(data.getPayTime());
            pullfeeResponse.setOrderNum(data.getOrderNum());
            if (NumberUtils.toPrimitive(pullfeeRequest.getSource()) == 1) {
                String tradeNo = CodeTools.GenerateTradeNo();
                pullfeeResponse.setTradeNo(tradeNo);
                data.setTradeNo(tradeNo);
                data.setIsOffline(true);
            }
            // 存储费用缓存
            log.info("[人工查询费用] 将费用保存到缓存，费用[{}]", data);
            cacheHandle.setChannelFee(parkCode, channelId, data);
            if (cacheExit == null || !data.getOrderNum().equals(cacheExit.getOrderNum())) {
                cacheExit = new CarExitRequest();
                cacheExit.setOpenFlag(0);
                cacheExit.setCarType(pullfeeRequest.getCarType());
                cacheExit.setExitTime(data.getQueryTime());
                cacheExit.setOrderNum(data.getOrderNum());
                cacheExit.setPlateNum(data.getPlateNum());
                cacheExit.setInandoutCode(channelId);
                ObjectResponse<Park> parkObjectResponse = parkService.findByParkCode(parkCode);
                ObjectResponse<ParkInoutdevice> objectResponse = parkService.getInOutDeviceByCode(parkObjectResponse.getData().getId(), channelId);
                if (ObjectResponse.isSuccess(objectResponse)) {
                    cacheExit.setInandoutName(objectResponse.getData().getInandoutName());
                }
                cacheExit.setParkId(parkObjectResponse.getData().getId());
                cacheExit.setParkCode(parkCode);
                cacheExit.setOperAccount(pullfeeRequest.getOperaAccount());
                cacheExit.setExitTerminal(pullfeeRequest.getExitTerminal());
                cacheExit.setExitWay(OrderCarInfoConstant.IN_OUT_WAY_SOFTWARE_MANUAL);
                String softImage = redisUtils.get(RedisConstants.SOFT_TRIGGER_IMAGE_KEY + channelId, String.class);
                cacheExit.setMaxImage(softImage);
                cacheHandle.setExit(parkCode, channelId, cacheExit);
            }
        }else {
            //是否有新产生支付记录
            boolean newPayFlag = false;
            String cacheUnpayPrice = channelFee.getUnpayPrice();
            if (NumberUtils.toFloat(cacheUnpayPrice) > 0) {
                ObjectResponse<OrderSumFeeDto> sumFee = orderPayService.getSumFee(pullfeeRequest.getParkCode(), pullfeeRequest.getOrderNum());
                if (sumFee != null && sumFee.getCode().equals(CodeConstants.SUCCESS)) {
                    float unpayPrice = NumberUtils.toFloat(channelFee.getUnpayPrice());
                    float paidAmount = NumberUtils.toFloat(channelFee.getPaidAmount());
                    OrderSumFeeDto data = sumFee.getData();
                    float paidPrice = data.getPaidPrice();
                    if (paidPrice == NumberUtils.decimalAdd(paidAmount, unpayPrice).floatValue()) {
                        log.info("[人工查询费用] 查询到用户已支付，参数[{}]", pullfeeRequest);
                        newPayFlag = true;
                        pullfeeResponse.setTotalPrice(channelFee.getTotalAmount());
                        pullfeeResponse.setDiscountPrice(String.valueOf(data.getDiscountPrice()));
                        pullfeeResponse.setCurrentDiscountPrice("0.00");
                        pullfeeResponse.setPaidPrice(String.valueOf(paidPrice));
                        pullfeeResponse.setNeedPayPrice("0.00");
                        pullfeeResponse.setTradeNo(channelFee.getTradeNo());
                        pullfeeResponse.setOrderNum(channelFee.getOrderNum());
                        // 更新费用缓存
                        channelFee.setUnpayPrice("0.00");
                        channelFee.setPaidAmount(String.valueOf(paidPrice));
                        channelFee.setDiscountAmount(String.valueOf(data.getDiscountPrice()));
                        channelFee.setDiscountPrice("0.00");
                        channelFee.setPayTime(data.getLastPayTime());
                        if (channelFee.getTradeNo() == null && NumberUtils.toPrimitive(pullfeeRequest.getSource()) == 1) {
                            String tradeNo = CodeTools.GenerateTradeNo();
                            channelFee.setTradeNo(tradeNo);
                            channelFee.setIsOffline(true);
                            pullfeeResponse.setTradeNo(tradeNo);
                        }
                        cacheHandle.setChannelFee(parkCode, channelId, channelFee);
                        CarExitRequest cacheExit = cacheHandle.getExit(parkCode, channelId);
                        if (cacheExit == null || !cacheExit.getOrderNum().equals(channelFee.getOrderNum())) {
                            cacheExit = new CarExitRequest();
                            cacheExit.setOpenFlag(0);
                            cacheExit.setCarType(pullfeeRequest.getCarType());
                            cacheExit.setExitTime(channelFee.getQueryTime());
                            cacheExit.setOrderNum(channelFee.getOrderNum());
                            cacheExit.setPlateNum(channelFee.getPlateNum());
                            cacheExit.setInandoutCode(channelId);
                            ObjectResponse<Park> parkObjectResponse = parkService.findByParkCode(parkCode);
                            ObjectResponse<ParkInoutdevice> objectResponse = parkService.getInOutDeviceByCode(parkObjectResponse.getData().getId(), channelId);
                            if (ObjectResponse.isSuccess(objectResponse)) {
                                cacheExit.setInandoutName(objectResponse.getData().getInandoutName());
                            }
                            cacheExit.setParkId(parkObjectResponse.getData().getId());
                            cacheExit.setParkCode(parkCode);
                            cacheExit.setOperAccount(pullfeeRequest.getOperaAccount());
                            cacheExit.setExitTerminal(pullfeeRequest.getExitTerminal());
                            cacheExit.setExitWay(OrderCarInfoConstant.IN_OUT_WAY_SOFTWARE_MANUAL);
                            String softImage = redisUtils.get(RedisConstants.SOFT_TRIGGER_IMAGE_KEY + channelId, String.class);
                            cacheExit.setMaxImage(softImage);
                            cacheHandle.setExit(parkCode, channelId, cacheExit);
                        }
                    }
                }
            }
            if (!newPayFlag) {
                log.info("[人工查询费用] 直接从缓存中加载费用，参数[{}]", pullfeeRequest);
                pullfeeResponse.setTotalPrice(channelFee.getTotalAmount());
                float discountAmount = NumberUtils.toFloat(channelFee.getDiscountAmount());
                float discountPrice = NumberUtils.toFloat(channelFee.getDiscountPrice());
                pullfeeResponse.setDiscountPrice(String.valueOf(discountAmount + discountPrice));
                pullfeeResponse.setCurrentDiscountPrice(String.valueOf(discountPrice));
                pullfeeResponse.setPaidPrice(channelFee.getPaidAmount());
                pullfeeResponse.setNeedPayPrice(channelFee.getUnpayPrice());
                pullfeeResponse.setOrderNum(channelFee.getOrderNum());
                pullfeeResponse.setTradeNo(channelFee.getTradeNo());
            }
            pullfeeResponse.setQueryTime(channelFee.getQueryTime());
            pullfeeResponse.setLastPayTime(channelFee.getPayTime());
            pullfeeResponse.setInsideDetails(channelFee.getInsideDetails());
        }
        return ObjectResponse.success(pullfeeResponse);
    }
    /**
     * 查询费用，包含无入场记录固定入场费用
     *
     * @param queryOrderFeeRequest 参数
     * @return 结果
     */
    private ObjectResponse<QueryOrderFeeResponse> queryOrderFee(QueryOrderFeeRequest queryOrderFeeRequest) {
        ObjectResponse<Park> parkObjectResponse = parkService.findByParkCode(queryOrderFeeRequest.getParkCode());
        ObjectResponse.notError(parkObjectResponse);
        Park park = parkObjectResponse.getData();
        ObjectResponse<ParkConfig> parkConfigObjectResponse = parkService.getParkConfig(park.getId());
        ObjectResponse.notError(parkConfigObjectResponse);
        ParkConfig parkConfig = parkConfigObjectResponse.getData();
        if (org.apache.commons.lang3.StringUtils.isBlank(queryOrderFeeRequest.getOrderNum())) {
            if (Integer.valueOf(3).equals(parkConfig.getNoenterHandleType())
                    || (Integer.valueOf(2).equals(parkConfig.getNoenterHandleType())
                    && Integer.valueOf(1).equals(parkConfig.getIsfixedfees()))) {
                float fixedFee = (queryOrderFeeRequest.getCarType() != null && queryOrderFeeRequest.getCarType() == 2)
                        ? parkConfig.getFixedFeeValueBig() : parkConfig.getFixedfeevalue();
                ObjectResponse<ParkInoutdevice> inOutDeviceByCode = parkService.getInOutDeviceByCode(park.getId(), queryOrderFeeRequest.getChannelId());
                ObjectResponse.notError(inOutDeviceByCode);
                String orderNum = replenishOrder(queryOrderFeeRequest.getPlateNum(), park.getId(), park.getParkCode(),
                        queryOrderFeeRequest.getCarType(), queryOrderFeeRequest.getChannelId(), inOutDeviceByCode.getData().getInandoutName(),
                        queryOrderFeeRequest.getExitTime() == null ? DateTools.unixTimestamp() : queryOrderFeeRequest.getExitTime());
                queryOrderFeeRequest.setOrderNum(orderNum);
                return fixedFeeRet(queryOrderFeeRequest, parkConfig, park, fixedFee);
            } else {
                throw new ResponseBodyException(CodeConstants.ERROR, "无入场记录");
            }
        }
        //如果是场中场，则判断当前通道是否要收费，不收费时返回0元
        if (Integer.valueOf(1).equals(park.getIsInterior()) && queryOrderFeeRequest.getChannelId() != null) {
            ObjectResponse<ParkInoutdevice> inOutDeviceByCode = parkService.getInOutDeviceByCode(park.getId(), queryOrderFeeRequest.getChannelId());
            ObjectResponse.notError(inOutDeviceByCode);
            ParkInoutdevice parkInoutdevice = inOutDeviceByCode.getData();
            if (Integer.valueOf(0).equals(parkInoutdevice.getIsFee())) {
                return fixedFeeRet(queryOrderFeeRequest, parkConfig, park, 0);
            }
        }
        queryOrderFeeRequest.setWithNotPay(true);
        return orderService.p2cQueryFee(queryOrderFeeRequest);
    }

    private ObjectResponse<QueryOrderFeeResponse> fixedFeeRet(QueryOrderFeeRequest queryOrderFeeRequest, ParkConfig parkConfig, Park park, float fixedFee) {
        QueryOrderFeeResponse queryOrderFeeResponse = new QueryOrderFeeResponse();
        queryOrderFeeResponse.setOrderNum(queryOrderFeeRequest.getOrderNum());
        queryOrderFeeResponse.setParkName(park.getParkName());
        queryOrderFeeResponse.setPlateNum(queryOrderFeeRequest.getPlateNum());
        queryOrderFeeResponse.setEnterTime(DateTools.unixTimestamp());
        queryOrderFeeResponse.setCarType(queryOrderFeeRequest.getCarType());
        queryOrderFeeResponse.setQueryTime(DateTools.unixTimestamp());
        queryOrderFeeResponse.setParkTime(0L);
        queryOrderFeeResponse.setTotalAmount(String.valueOf(fixedFee));
        queryOrderFeeResponse.setUnpayPrice(String.valueOf(fixedFee));
        queryOrderFeeResponse.setPaidAmount(String.valueOf(0));
        queryOrderFeeResponse.setDiscountAmount(String.valueOf(0));
        queryOrderFeeResponse.setDiscountPrice(String.valueOf(0));
        queryOrderFeeResponse.setStatus(2);
        queryOrderFeeResponse.setFreeTime((long) parkConfig.getIsfreeAfterpay(15));
        return ObjectResponse.success(queryOrderFeeResponse);
    }

    private String replenishOrder(String plateNum, Long parkId, String parkCode,
                                  Integer carType, String channelId, String channelName, Long exitTime) {
        CarEnterRequest carEnterRequest = new CarEnterRequest();
        carEnterRequest.setPlateNum(plateNum);
        carEnterRequest.setType(1);
        carEnterRequest.setEnterTime(exitTime);
        carEnterRequest.setCarType(carType);
        carEnterRequest.setInandoutCode(channelId);
        carEnterRequest.setInandoutName(channelName);
        carEnterRequest.setOpenFlag(1);
        carEnterRequest.setTriggerType(2);
        carEnterRequest.setProperty(2);
        carEnterRequest.setParkId(parkId);
        carEnterRequest.setParkCode(parkCode);
        carEnterRequest.setEnterWay(OrderCarInfoConstant.IN_OUT_WAY_PLATE_NUM);
        carEnterRequest.setNoneEnterFlag(true);
        String orderNum = CodeTools.GenerateOrderNum();
        carEnterRequest.setOrderNum(orderNum);
        ObjectResponse<CarEnterResult> objectResponse = carOrderEnterService.enter(carEnterRequest);
        if (!ObjectResponse.isSuccess(objectResponse)) {
            log.warn("补订单失败, {} {}", carEnterRequest, objectResponse);
            return null;
        }
        return orderNum;
    }
    public boolean sendClose(CloseBrakeRequest closeBrakeRequest, String parkCode, Long parkId, String deviceNo, ObjectResponse<RemoteSwitchResponse> objectResponse) {
        log.info("关闸失败，尝试二次关闸：{}", closeBrakeRequest);
        ObjectResponse<RemoteSwitchResponse> objectResponse2 = remoteSwitchService.execute(SwitchTypeEnum.关闸.getType(), parkId, parkCode, deviceNo, closeBrakeRequest.getPlateNum());
        if (objectResponse2 != null && objectResponse2.getCode().equals(CodeConstants.SUCCESS)){
            RemoteSwitchResponse remoteSwitchResponse2 = objectResponse.getData();
            if (remoteSwitchResponse2.getResult().equals(1)){
                addOpeningRecord(closeBrakeRequest, remoteSwitchResponse2.getImage(), remoteSwitchResponse2.getExecuteTime());
                return true;
            }
        }
        log.info("第二次关闸失败，返回：{}", objectResponse2);
        return false;
    }

}
