package com.icetech.park.service.impl.base;

import com.icetech.cloudcenter.api.order.CarOrderEnterService;
import com.icetech.cloudcenter.api.order.CarOrderExitService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.request.DataEnterRequest;
import com.icetech.cloudcenter.domain.request.p2c.SoftTriggerRequest;
import com.icetech.cloudcenter.domain.response.EnterCarInfoResponse;
import com.icetech.cloudcenter.domain.response.p2c.CarEnterResult;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.OrderCarInfoConstant;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.DateTools;
import com.icetech.oss.OssService;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.handle.DeviceDownServiceFactory;
import com.icetech.park.service.AbstractService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 为外部程序提供接口服务
 */
@Slf4j
public class ManageServiceBase extends AbstractService {
    @Autowired
    protected CacheHandle cacheHandle;
    @Autowired
    protected ParkService parkService;
    @Autowired
    protected OssService ossService;
    @Autowired
    protected CarOrderExitService carOrderExitService;
    @Autowired
    protected CarOrderEnterService carOrderEnterService;
    @Autowired
    protected OrderService orderService;
    @Autowired
    protected DeviceDownServiceFactory deviceDownServiceFactory;

    protected ObjectResponse<Void> enter(DataEnterRequest enterRequest, String parkCode, String channelId, Long parkId, String plateNum, String topic) {
        CarEnterRequest entrance = cacheHandle.getEntrance(parkCode, channelId);
        if (entrance == null){
            ObjectResponse<Void> objectResponse = deviceDownServiceFactory.buildCaptureService(parkCode).execute(parkId, enterRequest.getParkCode(),
                    enterRequest.getAisleCode(), topic, SoftTriggerRequest.AllowEnter.builder()
                            .biz(SoftTriggerRequest.ExtraInfoEnum.ALLOW_ENTER.val)
                            .plateNum(plateNum)
                            .type(1)
                            .remark(enterRequest.getRemark())
                            .requestVO(enterRequest).build());
            if (objectResponse.getCode().equals(CodeConstants.ERROR_12002)) {
                return objectResponse;
            } else {
                return noConEnter(enterRequest, parkId, plateNum);
            }
        }
        entrance.setPlateNum(plateNum);
        entrance.setType(enterRequest.getType());
        entrance.setCarType(enterRequest.getCarType());
        entrance.setCarDesc(enterRequest.getSpecialCar());
        entrance.setDebug(enterRequest.isDebug());
        entrance.setEnterTime(enterRequest.getEnterTime() == null ? DateTools.unixTimestamp() : enterRequest.getEnterTime());
        entrance.setOperaUser(enterRequest.getOperaUser());
        entrance.setRemark(enterRequest.getRemark());
        entrance.setEnterWay(enterRequest.getEnterWay() != null
                ? enterRequest.getEnterWay() : OrderCarInfoConstant.IN_OUT_WAY_SOFTWARE_MANUAL);
        entrance.setEnterTerminal(enterRequest.getEnterTerminal());
        ObjectResponse<CarEnterResult> objectResponse = carOrderEnterService.enter(entrance);
        if (ObjectResponse.isSuccess(objectResponse)) {
            //清除缓存中的上次异常记录
            cacheHandle.removeEntrace(parkCode, channelId);
            return ObjectResponse.success();
        } else {
            log.info("[平台入场] 入场失败, 返回:{}", objectResponse);
            return ObjectResponse.failed(objectResponse.getCode(), objectResponse.getMsg());
        }
    }

    /**
     * 无连接相机时的入场记录
     * @param enterRequest
     * @param parkId
     * @param plateNum
     * @return
     */
    protected ObjectResponse<Void> noConEnter(DataEnterRequest enterRequest, Long parkId, String plateNum) {
        CarEnterRequest carEnterRequest = new CarEnterRequest();
        carEnterRequest.setParkId(parkId);
        carEnterRequest.setOrderNum(enterRequest.getOrderNum());
        carEnterRequest.setType(enterRequest.getType());
        carEnterRequest.setCarType(enterRequest.getCarType());
        carEnterRequest.setEnterTime(enterRequest.getEnterTime() == null ? DateTools.unixTimestamp() : enterRequest.getEnterTime());
        carEnterRequest.setPlateNum(plateNum);
        carEnterRequest.setTriggerType(2);
        carEnterRequest.setParkCode(enterRequest.getParkCode());
        carEnterRequest.setInandoutCode(enterRequest.getAisleCode());
        carEnterRequest.setEnterWay(enterRequest.getEnterWay() != null
                ? enterRequest.getEnterWay() : OrderCarInfoConstant.IN_OUT_WAY_SOFTWARE_MANUAL);
        carEnterRequest.setOperaUser(enterRequest.getOperaUser());
        carEnterRequest.setEnterTerminal(enterRequest.getEnterTerminal());
        ObjectResponse<CarEnterResult> enterObjectResponse = carOrderEnterService.enter(carEnterRequest);
        if (ObjectResponse.isSuccess(enterObjectResponse)){
            return ObjectResponse.success();
        }else{
            log.info("[平台入场] 无牌车入场失败，返回：{}", enterObjectResponse);
            return ObjectResponse.failed(enterObjectResponse.getCode(), enterObjectResponse.getMsg());
        }
    }

    /**
     * 获取当前入口的通道车辆信息
     * @param entrace
     * @return
     */
    protected EnterCarInfoResponse getEntranceCarInfoResponse(CarEnterRequest entrace){
        EnterCarInfoResponse enterCarInfoResponse = new EnterCarInfoResponse();
        enterCarInfoResponse.setEnterNum(entrace.getPlateNum());
        enterCarInfoResponse.setCarType(entrace.getCarType());
        enterCarInfoResponse.setType(entrace.getType());
        enterCarInfoResponse.setOrderNum(entrace.getOrderNum());
        String maxImage = entrace.getMaxImage();
        if (maxImage != null) {
            enterCarInfoResponse.setImgUrl(ossService.getImageUrl(maxImage));
            enterCarInfoResponse.setImgPath(maxImage);
        }
        return enterCarInfoResponse;
    }

}
