package com.icetech.park.service.impl;

import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.fee.dao.monthcar.MonthRecordDao;
import com.icetech.fee.domain.entity.monthcar.MonthRecord;
import com.icetech.third.domain.entity.third.SendInfo;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import com.icetech.cloudcenter.domain.request.NotifyRequest;
import com.icetech.cloudcenter.api.third.SendInfoService;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.ServiceEnum;
import com.icetech.common.domain.response.ObjectResponse;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;
import java.util.concurrent.ThreadPoolExecutor;

/**
 * 通知定时任务结果
 * @author fangct
 */
@Slf4j
@Service
public class TaskCenterServiceImpl {
    @Autowired
    private SendInfoService sendInfoService;

    @Autowired
    private ThreadPoolExecutor asyncExecutor;

    @Autowired
    private MonthRecordDao monthRecordDao;
    
    public String notify(Integer serviceType, Integer serviceId){
        return notify(serviceType, serviceId, null);
    }

    /***
     * 通知定时任务
     * @param serviceType
     * @param serviceId
     * @return
     */
    public String notify(Integer serviceType, Integer serviceId, String cause){
        try {
            ObjectResponse objectResponse = null;
            if (cause == null){
                objectResponse = sendInfoService.notifySuccess(serviceType, serviceId);
            }else {
                objectResponse = sendInfoService.notifyFail(serviceType, serviceId, ServiceEnum.Data.getType(), cause);
            }
            if (objectResponse != null && objectResponse.getCode().equals(CodeConstants.SUCCESS)){
                return CodeConstants.SUCCESS;
            }else{
                log.info("<通知定时任务> 返回未成功，serviceType:{}, serviceId:{}", serviceType, serviceId);
                return CodeConstants.ERROR;
            }
        }catch (Exception e){
            log.error("<通知定时任务> 异常，serviceType：{}，serviceId：{}，errorMsg：{}", serviceType, serviceId, e.getMessage(), e);
            return CodeConstants.ERROR;
        }
    }

    public String notify(SendInfoRecord record, String cause) {
        if (record.getRecordId() == null) {
            return notify(record.getServiceType(), record.getServiceId() == null ? null : record.getServiceId().intValue(), cause);
        } else {
            NotifyRequest notifyRequest = new NotifyRequest();
            notifyRequest.setTargetService(ServiceEnum.Data.getType());
            notifyRequest.setOne(record.getTarget());
            notifyRequest.setServiceId(record.getServiceId());
            notifyRequest.setServiceType(record.getServiceType());
            notifyRequest.setTaskId(record.getTaskId());
            notifyRequest.setSuccess(cause == null);
            notifyRequest.setCause(cause);
            notifyRequest.setRecordId(record.getRecordId());
            return notify(notifyRequest);
        }
    }

    public String notify(NotifyRequest notifyRequest) {
        asyncExecutor.execute(ThreadUtils.wrapTrace(() -> {
            ObjectResponse objectResponse = sendInfoService.notify(notifyRequest);
            if (ObjectResponse.isSuccess(objectResponse)) {
                int serviceType = NumberUtils.toPrimitive(notifyRequest.getServiceType());
                // 修改月卡下发状态
                if (serviceType == DownServiceEnum.月卡.getServiceType()) {
                    MonthRecord monthRecord = monthRecordDao.selectById(notifyRequest.getServiceId());
                    if (Objects.nonNull(monthRecord)) {
                        monthRecord.setSendStatus(notifyRequest.isSuccess() ? SendInfo.StatusEnum._SUCCESS.getCode() : SendInfo.StatusEnum._FAIL.getCode());
                        monthRecordDao.updateById(monthRecord);
                    }
                }
            }
        }));
        return CodeConstants.SUCCESS;
    }
}
