package com.icetech.park.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.icetech.third.domain.entity.third.ThirdInfo;
import com.icetech.cloudcenter.domain.request.ThirdFeeRequest;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.cloudcenter.domain.response.ThirdFeeResponse;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.HttpTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.SignTools;
import com.icetech.third.domain.enums.PushServiceEnum;
import com.icetech.partner.domain.request.ApiBaseRequest;
import com.icetech.sdk.client.OpenClient;
import com.icetech.sdk.request.CommonRequest;
import com.icetech.sdk.response.CommonResponse;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.util.TextUtils;
import org.springframework.stereotype.Service;

import java.text.DecimalFormat;
import java.util.Objects;

/**
 * 查询第三方费用
 * @author fangct
 */
@Service
@Slf4j
public class QueryThirdFeeServiceImpl {

    /**
     * 请求三方计费
     * @param thirdInfo 第三方信息
     * @param request 请求参数
     * @return 响应
     */
    public ObjectResponse<QueryOrderFeeResponse> getThirdFeeFromUrl(ThirdInfo thirdInfo, ThirdFeeRequest request) {
        String resultString;
        if (Objects.nonNull(thirdInfo.getCUserId())) {
            resultString = sendCommonOpenPlatform(thirdInfo, request);
        } else {
            ApiBaseRequest<ThirdFeeRequest> apiBaseRequest = new ApiBaseRequest<>();
            //三方计费服务名
            apiBaseRequest.setServiceName("queryThirdFee");
            apiBaseRequest.setPid(thirdInfo.getPid());
            apiBaseRequest.setTimestamp(System.currentTimeMillis());
            apiBaseRequest.setBizContent(request);
            try {
                apiBaseRequest.setSign(SignTools.sign(apiBaseRequest, thirdInfo.getSecretKey()));
            } catch (Exception e) {
                log.warn("签名失败", e);
            }
            String jsonString = JsonUtils.toString(apiBaseRequest);
            resultString = HttpTools.postJson(thirdInfo.getPushUrl(),jsonString );
        }
        if (resultString != null && resultString.contains("<html>")) {
            return ObjectResponse.failed(CodeConstants.ERROR_408, "第三方服务访问内容非JSON");
        }
        ObjectResponse<ThirdFeeResponse> thirdFeeResponse = JSON.parseObject(resultString, new TypeReference<ObjectResponse<ThirdFeeResponse>>(){});
        log.info("[三方计费] 参数[{}] 响应[{}]", request, resultString);
        if (thirdFeeResponse == null){
            throw new ResponseBodyException(CodeConstants.ERROR_3001, "第三方计费失败");
        }
        if (ObjectResponse.isSuccess(thirdFeeResponse) && thirdFeeResponse.getData() != null){
            return ObjectResponse.success(transformationQueryOrderFeeResponse(thirdFeeResponse.getData(),request));
        }
        return ObjectResponse.failed(CodeConstants.ERROR_3001, "第三方计费失败" + thirdFeeResponse.getMsg());
    }

    private String sendCommonOpenPlatform(ThirdInfo thirdInfo, Object obj) {
        try {
            CommonRequest commonRequest = new CommonRequest(PushServiceEnum.三方计费.getMethod(), obj);
            OpenClient client = new OpenClient(thirdInfo.getPushUrl(), thirdInfo.getPid(), thirdInfo.getSecretKey());
            CommonResponse response = client.execute(commonRequest);
            log.info("[三方计费] 返回信息[{}]", response.getBody());
            return response.getBody();
        } catch (Exception e) {
            return JsonUtils.toString(ObjectResponse.failed(CodeConstants.ERROR));
        }
    }
    /**
     * 三方计费参数转成本地计费参数
     * @param thirdFeeResponse
     * @return
     */
    private QueryOrderFeeResponse transformationQueryOrderFeeResponse(ThirdFeeResponse thirdFeeResponse, ThirdFeeRequest thirdFeeRequest){
        QueryOrderFeeResponse queryOrderFeeResponse = new QueryOrderFeeResponse();
        queryOrderFeeResponse.setOrderNum(thirdFeeRequest.getOrderNum());
        queryOrderFeeResponse.setPlateNum(thirdFeeRequest.getPlateNum());
        queryOrderFeeResponse.setEnterTime(thirdFeeRequest.getEnterTime() == null ? DateTools.unixTimestamp() : thirdFeeRequest.getEnterTime());
        queryOrderFeeResponse.setCarType(thirdFeeRequest.getCarType());
        queryOrderFeeResponse.setParkTime(thirdFeeRequest.getExitTime() - queryOrderFeeResponse.getEnterTime());
        queryOrderFeeResponse.setTotalAmount(TextUtils.isEmpty(thirdFeeResponse.getTotalPrice()) ? "0.00" : thirdFeeResponse.getTotalPrice());
        queryOrderFeeResponse.setDiscountAmount("0.00");
        queryOrderFeeResponse.setDiscountPrice(TextUtils.isEmpty(thirdFeeResponse.getDiscountPrice()) ? "0.00" : thirdFeeResponse.getDiscountPrice());
        queryOrderFeeResponse.setUnpayPrice("1".equals(thirdFeeResponse.getIsNeedPay()) ? new DecimalFormat("#0.00").format(Double.valueOf(thirdFeeResponse.getNeedPayPrice())) : "0.00");
        queryOrderFeeResponse.setQueryTime(thirdFeeRequest.getExitTime());
        String needPayPrice = thirdFeeResponse.getNeedPayPrice();
        if (StrUtil.isEmpty(needPayPrice) || NumberUtils.toDouble(needPayPrice) == 0) {
            queryOrderFeeResponse.setStatus(1);
        } else {
            queryOrderFeeResponse.setStatus(2);
        }
        return queryOrderFeeResponse;
    }
}
