package com.icetech.park.service.impl;

import java.util.Map;
import java.util.Objects;

import javax.annotation.Resource;

import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.common.constants.RedisMsg;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.*;
import com.icetech.cloudcenter.api.IPncWsOperService;
import com.icetech.cloudcenter.domain.response.pnc.PncBaseResponse;
import com.icetech.cloudcenter.domain.constants.RedisConstants;
import com.icetech.third.dao.send.SendinfoRecordDao;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import com.icetech.cloudcenter.domain.enumeration.DataCollectionEnum;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.enumeration.SendOperTypeEnum;
import com.icetech.third.utils.RedisUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
@Slf4j
@Deprecated
public class PncWsOperServiceImpl implements IPncWsOperService {
    @Autowired
    private ParkService parkService;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private TaskCenterServiceImpl taskCenterService;
    @Autowired
    private SendinfoRecordDao sendinfoRecordDao;
    @Resource
    private StringRedisTemplate stringRedisTemplate;

    @Override
    public boolean connection(Map<String, Object> conInfo) {
        String parkCode = (String) conInfo.get("parkCode");
        String timestamp = (String) conInfo.get("timestamp");
        String channelCode = (String) conInfo.get("channelId");
        if (StringUtils.isBlank(parkCode) || StringUtils.isNotBlank(timestamp)){
            return false;
        }
        ObjectResponse<Park> byParkCode = parkService.findByParkCode(parkCode);
        if (!ObjectResponse.isSuccess(byParkCode)){
            return false;
        }
        Park park = byParkCode.getData();
        try {
            boolean verifyResult = SignTools.verifyMD5Sign(conInfo, park.getKey());
            if (!verifyResult){
                return false;
            }
        }catch (Exception e){
            log.warn(String.valueOf(e.getMessage()), e);
            return false;
        }
        ObjectResponse<ParkConfig> parkConfigResponse = parkService.getParkConfig(parkCode);
        if (!ObjectResponse.isSuccess(parkConfigResponse)){
            return false;
        }
        ParkConfig parkConfig = parkConfigResponse.getData();
        if (DataCollectionEnum.端网云.getType().equals(parkConfig.getDataCollection())){
            if (!"0".equals(channelCode)){
                ObjectResponse<ParkInoutdevice> channelInfo = parkService.getInOutDeviceByCode(park.getId(), channelCode);
                if (channelInfo != null && channelInfo.getData() != null){
                    return true;
                }else{
                    log.info("<端网云ws协议连接> 根据parkCode:{}和deviceNo:{}未查询到设备信息，不允许连接", parkCode, channelCode);
                    return false;
                }
            }else{
                redisUtils.set(RedisConstants.PNC_HEART_PROFILE + parkCode,System.currentTimeMillis(), (long)180);
                return true;
            }
        }else{
            log.info("<ws协议连接> 连接模式不正确，当前为端网云模式，parkCode：{}", parkCode);
            return false;
        }

    }

    /**
     * 端网云支持ws
     * @param clientName
     * @param params
     * @return
     */
    @Override
    public String redirect(String clientName, String params) {
        //签名验证
        String[] clientNameArr = clientName.split("_");
        PncBaseResponse pncBaseResponse = JsonUtils.parseObject(params, PncBaseResponse.class);
        String serviceName = pncBaseResponse.getServiceName();
        if("parkStatusWs".equals(serviceName)){ //心跳数据
            pncBaseResponse.setCode(200);
            pncBaseResponse.setSign("");
            pushAll(clientName, JsonUtils.toString(pncBaseResponse));
            redisUtils.set(RedisConstants.PNC_HEART_PROFILE + pncBaseResponse.getParkCode(),System.currentTimeMillis(), (long)180);
            log.info("<端网云> 客户端:{}上报心跳，回复：{}",clientNameArr[0], JsonUtils.toString(pncBaseResponse));
        }else{
            //业务数据
            ObjectResponse objectResponse = new ObjectResponse();
            Object data = pncBaseResponse.getData();
            if(!Objects.isNull(data)){
                objectResponse.setData(JsonUtils.toString(data));
            }
            objectResponse.setMsg(pncBaseResponse.getMsg());
            objectResponse.setCode(String.valueOf(pncBaseResponse.getCode()));
            redisUtils.set(RedisConstants.RESP_MSG_PROFILE + pncBaseResponse.getMessageId(),objectResponse);
            log.info("<端网云> 客户端:{}回复标识：{},存入redis成功",clientNameArr[0], pncBaseResponse.getMessageId());
            if("notifyPrepay".equals(serviceName)){
                log.info("<端网云> 客户端:{}回复标识：{},存入redis成功",clientNameArr[0], pncBaseResponse.getMessageId());
                Integer serviceType = DownServiceEnum.getServiceType(serviceName);
                SendInfoRecord sendinfoRecord = sendinfoRecordDao.selectOneByMsgId(pncBaseResponse.getMessageId(), SendOperTypeEnum.请求.getOperType());
                Integer serviceId = sendinfoRecord.getServiceId() == null ? null : sendinfoRecord.getServiceId().intValue();
                String notify = taskCenterService.notify(serviceType, serviceId);
                log.info("<端网云 ws> 预缴费通知taskcenter结果：{}",notify);
            }
        }
        return JsonUtils.toString(pncBaseResponse);
    }

    @Override
    public void init(String clientName) {
        return;
    }

    /**
     * 广播消息到各个订阅者
     * @param clientName
     * @param content
     */
    public boolean pushAll(String clientName, String content){
        try{
            content = clientName + content;
            stringRedisTemplate.convertAndSend(RedisMsg.TOPIC_PNC, content);
        }catch (Exception e){
            log.error("<redis广播发送> clientName：{} 广播失败", clientName, e);
            return false;
        }
        return true;
    }

}
