package com.icetech.park.service.impl;

import com.icetech.cloudcenter.api.IBatchSendService;
import com.icetech.cloudcenter.api.IBatchDownSendService;
import com.icetech.cloudcenter.api.IPhp2DataService;
import com.icetech.cloudcenter.domain.request.BatchSendActionRequest;
import com.icetech.cloudcenter.domain.request.BatchSendProgressRequest;
import com.icetech.cloudcenter.domain.request.BatchSendRepeatRequest;
import com.icetech.cloudcenter.domain.request.OpenBaseRequest;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.validator.Validator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class Php2DataServiceImpl implements IPhp2DataService {

    @Autowired
    private IBatchSendService batchSendService;
    @Autowired
    private IBatchDownSendService batchDownSendService;

    @Override
    public ObjectResponse execute(OpenBaseRequest baseRequest) {
        String serviceName = baseRequest.getServiceName();
        if (serviceName.equals("batchSend.action")){
            BatchSendActionRequest batchSendActionRequest = JsonUtils.convert2bean(baseRequest.getBizContent(), BatchSendActionRequest.class);
            if (Validator.validate(batchSendActionRequest)){
                return batchSendService.action(batchSendActionRequest);
            }
        }else if (serviceName.equals("batchSend.progress")){
            BatchSendProgressRequest batchSendProgressRequest = JsonUtils.convert2bean(baseRequest.getBizContent(), BatchSendProgressRequest.class);
            if (Validator.validate(batchSendProgressRequest)){
                return batchSendService.progress(batchSendProgressRequest);
            }
        }else if (serviceName.equals("batchSend.repeat")){
            BatchSendRepeatRequest batchSendRepeatRequest = JsonUtils.convert2bean(baseRequest.getBizContent(), BatchSendRepeatRequest.class);
            if (Validator.validate(batchSendRepeatRequest)){
                return batchSendService.repeat(batchSendRepeatRequest);
            }
        }else if (serviceName.equals("batch.downSend")){
            List<SendRequest> sendRequestList = JsonUtils.parseArray(
                    JsonUtils.toString(baseRequest.getBizContent()), SendRequest.class);
            if (Validator.validate(sendRequestList)){
                return batchDownSendService.execute(sendRequestList);
            }
        }
        return ObjectResponse.failed(CodeConstants.ERROR_400);
    }
}
