package com.icetech.park.service.impl;

import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.park.dao.ParkSignPlateDao;
import com.icetech.park.domain.entity.park.ParkSignPlate;
import com.icetech.cloudcenter.api.park.ParkSignPlateService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * Description ParkSignPlateServiceImpl
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2023/7/10 10:43
 */
@Slf4j
@Service
public class ParkSignPlateServiceImpl implements ParkSignPlateService {

    @Autowired
    private ParkSignPlateDao parkSignPlateDao;

    @Override
    public ObjectResponse addPlateSign(ParkSignPlate parkSignPlate) {
        try {
            ParkSignPlate parkSignPlate1 = parkSignPlateDao.selectByRequestId(parkSignPlate.getRequestId());
            if(Objects.nonNull(parkSignPlate1)) {
                return ObjectResponse.success();
            }
            ParkSignPlate parkSignPlate2 = parkSignPlateDao.selectByPalteNum(parkSignPlate.getParkCode(), parkSignPlate.getPlateNum());
            if(Objects.nonNull(parkSignPlate2)) {
                //车牌已经下发过--更新
                parkSignPlate2.setNoSense(parkSignPlate.getNoSense());
                parkSignPlate2.setDeparturePay(parkSignPlate.getDeparturePay());
                parkSignPlate2.setMoneyLimit(parkSignPlate.getMoneyLimit());
                parkSignPlateDao.update(parkSignPlate2);
            }else{
                parkSignPlateDao.insert(parkSignPlate);
            }

        }catch (Exception e) {
            log.error("处理失败: {}. parkSignPlate[{}]", e.getMessage(), parkSignPlate, e);
            return ObjectResponse.failed(CodeConstants.ERROR);
        }
        return ObjectResponse.success();
    }

    @Override
    public ObjectResponse<ParkSignPlate> selectPlateSign(String parkCode, String plateNum) {
        ParkSignPlate parkSignPlate = parkSignPlateDao.selectByPalteNum(parkCode, plateNum);
        if(Objects.nonNull(parkSignPlate)){
            return ObjectResponse.success(parkSignPlate);
        }
        return ObjectResponse.failed(CodeConstants.ERROR_404);
    }
}
