package com.icetech.park.service.impl;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import javax.annotation.Resource;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.redis.handle.RedisHandle;
import com.icetech.common.constants.RedisKeyConstants;
import com.icetech.park.dao.ParkRemoteconfigDao;
import com.icetech.park.domain.entity.park.ParkRemoteConfig;
import com.icetech.cloudcenter.api.ParkRemoteConfigService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class ParkRemoteConfigServiceImpl implements ParkRemoteConfigService {
    @Resource
    private ParkRemoteconfigDao parkRemoteConfigDao;
    @Resource
    private RedisHandle redisHandle;

    @Override
    public List<ParkRemoteConfig> selectByParkId(long parkId, int enexType) {
        String cacheKey = RedisKeyConstants.KEY_PREFIX_PARK_REMOTE_CONFIG_PARK + parkId;
        List<ParkRemoteConfig> configs = redisHandle.getListFromMap(cacheKey, String.valueOf(enexType), ParkRemoteConfig.class,
                cacheRemoteConfig(parkId), RedisKeyConstants.EXPIRE_PARK_REMOTE_CONFIG);
        return configs;
    }

    @Override
    public Map<String, List<ParkRemoteConfig>> getRemoteConfigMapByPark(long parkId) {
        String cacheKey = RedisKeyConstants.KEY_PREFIX_PARK_REMOTE_CONFIG_PARK + parkId;
        return redisHandle.cacheListMap(cacheKey, ParkRemoteConfig.class, cacheRemoteConfig(parkId), RedisKeyConstants.EXPIRE_PARK_REMOTE_CONFIG);
    }

    private Supplier<Map<String, List<ParkRemoteConfig>>> cacheRemoteConfig(long parkId) {
        return () -> {
            ParkRemoteConfig param = new ParkRemoteConfig();
            param.setParkId(parkId);
            List<ParkRemoteConfig> configs = parkRemoteConfigDao.selectList(Wrappers.lambdaQuery(param));
            Map<String, List<ParkRemoteConfig>> typeMap = null;
            if (CollectionUtils.isNotEmpty(configs)) {
                typeMap = configs.stream().collect(Collectors.groupingBy(config -> config.getEnexType().toString()));
            }
            return typeMap;
        };
    }
}
