package com.icetech.park.service.impl;

import com.github.pagehelper.PageHelper;
import com.icetech.basics.dao.park.ParkDao;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.request.CallLogRequest;
import com.icetech.cloudcenter.domain.request.QueryCallLogRequest;
import com.icetech.cloudcenter.domain.response.ParkCallLogDto;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.DateTools;
import com.icetech.park.dao.ParkCallLogDao;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.domain.entity.park.ParkCallLog;
import com.icetech.park.service.ParkCallLogService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.*;

/**
 * Description ParkCallLogServiceImpl
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2023/7/10 11:14
 */
@Slf4j
@Service
public class ParkCallLogServiceImpl implements ParkCallLogService {

    @Autowired
    private ParkCallLogDao parkCallLogDao;

    @Autowired
    private ParkService parkService;

    @Autowired
    private ParkDao parkDao;

    @Override
    public ObjectResponse countCallLogList(QueryCallLogRequest queryCallLogRequest) {
        try {
            String[] split = queryCallLogRequest.getParkCode().split(",");
            String parkid = parkDao.selectByCodes(split);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String startTime = null;
            String endTime = null;
            if(!Objects.isNull(queryCallLogRequest.getStartTime())){
                startTime =  simpleDateFormat.format(queryCallLogRequest.getStartTime());
            }
            if(!Objects.isNull(queryCallLogRequest.getEndTime())){
                endTime =  simpleDateFormat.format(queryCallLogRequest.getEndTime());
            }
            Integer status = queryCallLogRequest.getStatus();
            if(!Objects.isNull(queryCallLogRequest.getStatus()) && queryCallLogRequest.getStatus() == 0){
                status = null;
            }
            int count = parkCallLogDao.countCallLogList(parkid, status, Objects.isNull(startTime) ? null : startTime, Objects.isNull(endTime) ? null : endTime,
                    queryCallLogRequest.getDirection());
            Map<String, Object> map = new HashMap<>();
            map.put("count", count);
            return ObjectResponse.success(map);
        }catch (Exception e){
            log.error("操作失败: {}. queryCallLogRequest[{}]", e.getMessage(), queryCallLogRequest, e);
            return ObjectResponse.failed(CodeConstantsEnum.ERROR);
        }
    }

    @Override
    public ObjectResponse<List<ParkCallLogDto>> getCallLogList(QueryCallLogRequest queryCallLogRequest) {
        try {
            String[] split = queryCallLogRequest.getParkCode().split(",");
            String parkid = parkDao.selectByCodes(split);
            PageHelper.startPage(queryCallLogRequest.getPageNo(), queryCallLogRequest.getPageSize());
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String startTime = null;
            String endTime = null;
            if(!Objects.isNull(queryCallLogRequest.getStartTime())){
                startTime =  simpleDateFormat.format(queryCallLogRequest.getStartTime());
            }
            if(!Objects.isNull(queryCallLogRequest.getEndTime())){
                endTime =  simpleDateFormat.format(queryCallLogRequest.getEndTime());
            }
            Integer status = queryCallLogRequest.getStatus();
            if(!Objects.isNull(queryCallLogRequest.getStatus()) && queryCallLogRequest.getStatus() == 0){
                status = null;
            }
            List<ParkCallLog> parkCallLogs = parkCallLogDao.selectCallLogList(parkid, status, Objects.isNull(startTime) ? null : startTime, Objects.isNull(endTime) ? null : endTime,
                    queryCallLogRequest.getDirection());
            if (CollectionUtils.isEmpty(parkCallLogs)) {
                return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
            }
            List<ParkCallLogDto> list = new ArrayList<>(parkCallLogs.size());
            for (int i = 0; i < parkCallLogs.size(); i++) {
                ParkCallLogDto parkCallLogDto = new ParkCallLogDto();
                ParkCallLog parkCallLog = parkCallLogs.get(i);
                Park park = parkService.findByParkId(parkCallLog.getParkId()).getData();
                parkCallLogDto.setId(parkCallLog.getId());
                parkCallLogDto.setParkName(park.getParkName());
                parkCallLogDto.setCallTime(simpleDateFormat.format(parkCallLog.getCreateTime()));
                ObjectResponse<ParkInoutdevice> channelResp = parkService.getInoutDeviceByCode(parkCallLog.getAisleCode());
                if(ObjectResponse.isSuccess(channelResp)){
                    parkCallLogDto.setAisleName(channelResp.getData().getInandoutName());
                }
                if(parkCallLog.getDirection() == 1){
                    parkCallLogDto.setDirection("呼入");
                }else{
                    parkCallLogDto.setDirection("呼出");
                }
                int time = parkCallLog.getCallTime().intValue();
                if(time >= 60){
                    parkCallLogDto.setCallTimeStr(DateTools.secondToSecondsTime(time));
                }else{
                    parkCallLogDto.setCallTimeStr(time+"秒");
                }
                parkCallLogDto.setOperAccount(parkCallLog.getOperAccount());
                parkCallLogDto.setStatus(parkCallLog.getStatus());
                list.add(parkCallLogDto);
            }
            return ObjectResponse.success(list);
        }catch (Exception e){
            log.error("操作失败: {}. queryCallLogRequest[{}]", e.getMessage(), queryCallLogRequest, e);
        }
        return ObjectResponse.failed(CodeConstantsEnum.ERROR.getCode());
    }

    @Override
    public ObjectResponse addCallLog(CallLogRequest callLogRequest) {
        Park park = parkService.findByParkCode(callLogRequest.getParkCode()).getData();
        ParkCallLog hislog = parkCallLogDao.selectByCode(callLogRequest.getMessageCode());
        ParkCallLog parkCallLog = new ParkCallLog();
        int result;
        if(Objects.isNull(hislog)){
            if(callLogRequest.getDirection() == 2){
                parkCallLog.setStatus(1);
            }else{
                parkCallLog.setStatus(3);
            }
            parkCallLog.setMessageCode(callLogRequest.getMessageCode());
            parkCallLog.setAisleCode(callLogRequest.getAisleCode());
            parkCallLog.setParkId(park.getId());
            parkCallLog.setCreateTime(new Date());
            parkCallLog.setDeviceNumber(callLogRequest.getDeviceCode());
            parkCallLog.setDirection(callLogRequest.getDirection());
            parkCallLog.setOperAccount(callLogRequest.getOperAccount());
            parkCallLog.setChannelType(callLogRequest.getChannelType());
            result = parkCallLogDao.insert(parkCallLog);
        }else{
            if(callLogRequest.getDirection() == 2 ){
                hislog.setCallTime((System.currentTimeMillis() - hislog.getCreateTime().getTime())/1000);
                hislog.setUpdateTime(new Date());
            }else{
                if(callLogRequest.getAction() == 1){
                    hislog.setUpdateTime(new Date());
                    hislog.setStatus(2);
                }
                if(callLogRequest.getAction() == 2){
                    if(Objects.isNull(hislog.getUpdateTime())){
                        hislog.setCallTime((long)0);
                    }else{
                        hislog.setCallTime((System.currentTimeMillis() - hislog.getUpdateTime().getTime())/1000);
                    }
                }
            }
            result = parkCallLogDao.update(hislog);
        }
        if(result > 0){
            return  ObjectResponse.success();
        }
        return ObjectResponse.failed(CodeConstantsEnum.ERROR.getCode());
    }

    @Override
    public ObjectResponse<Boolean> saveCallLog(ParkCallLog parkCallLog) {
        return ObjectResponse.success(parkCallLogDao.insert(parkCallLog) == 1);
    }

}
