package com.icetech.park.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.icetech.cloudcenter.api.IP2cWsOperService;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.constants.DingZhiFuncConstants;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.cloudcenter.domain.enumeration.CodeEnum;
import com.icetech.cloudcenter.domain.enumeration.DataCollectionEnum;
import com.icetech.cloudcenter.domain.enumeration.P2cVersionEnum;
import com.icetech.cloudcenter.domain.enumeration.ReportCmdEnum;
import com.icetech.cloudcenter.domain.enumeration.TriggerTypeEnum;
import com.icetech.cloudcenter.domain.request.p2c.RegisterDeviceRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.ParkConnectedDeviceVo;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.park.service.down.p2c.ResponseService;
import com.icetech.park.service.factory.SendServiceFactory;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.handle.P2cOperHandle;
import com.icetech.park.service.report.CallService;
import com.icetech.park.service.report.p2c.impl.RegisterDeviceServiceImpl;
import com.icetech.basics.utils.Spring;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 *  使用mq 消费者进行转发处理
 */
@Slf4j
@Deprecated
@Service
public class P2cWsOperServiceImpl implements IP2cWsOperService {
    @Autowired
    private DualCameraServiceImpl dualCameraService;
    @Autowired
    private P2cOperHandle  p2cOperHandle;
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private ParkService parkService;
    @Autowired
    private CacheHandle cacheHandle;
    //车场定制
    private static String CUSTOM_PARKS = "";

    @Override
    public boolean checkDevice(String serialNumber) {
        try {
            ObjectResponse<ParkDevice> parkDeviceResp = parkDeviceService.getDeviceBySerialNumber(serialNumber);
            if (ObjectResponse.isSuccess(parkDeviceResp) && parkDeviceResp.getData() != null && parkDeviceResp.getData().getType() == 1) {
                ObjectResponse<ParkConfig> parkConfigResponse = parkService.getParkConfig(parkDeviceResp.getData().getParkId().longValue());
                ObjectResponse.notError(parkConfigResponse);
                ParkConfig parkConfig = parkConfigResponse.getData();
                if (!DataCollectionEnum.端网云.getType().equals(parkConfig.getDataCollection())){
                    return true;
                }else{
                    log.info("<ws协议连接> 连接模式不正确，当前为端网云模式，parkId：{}", parkDeviceResp.getData().getParkId());
                    return false;
                }
            } else {
                log.info("<ws协议连接> 根据serialNumber: {}未查询到设备信息，不允许连接", serialNumber);
                return false;
            }
        }catch (Exception e){
            log.error("[ws协议连接]clientName[{}]", serialNumber, e);
            return false;
        }
    }

    @Override
    public String checkAndGetPark(String serialNumber) {
        try {
            ObjectResponse<ParkDevice> parkDeviceResp = parkDeviceService.getDeviceBySerialNumber(serialNumber);
            if (ObjectResponse.isSuccess(parkDeviceResp) && parkDeviceResp.getData() != null && parkDeviceResp.getData().getType() == 1) {
                ParkDevice parkDevice = parkDeviceResp.getData();
                ObjectResponse<ParkConfig> parkConfigResponse = parkService.getParkConfig(parkDevice.getParkId().longValue());
                ObjectResponse.notError(parkConfigResponse);
                ParkConfig parkConfig = parkConfigResponse.getData();
                if (!DataCollectionEnum.端网云.getType().equals(parkConfig.getDataCollection())){
                    ObjectResponse<Park> parkObjectResponse = parkService.findByParkId(parkDevice.getParkId().longValue());
                    return parkObjectResponse.getData().getParkCode();
                }else{
                    log.info("<ws协议连接> 连接模式不正确，当前为端网云模式，parkId：{}", parkDeviceResp.getData().getParkId());
                    return null;
                }
            } else {
                log.info("<ws协议连接> 根据serialNumber: {}未查询到设备信息，不允许连接", serialNumber);
                return null;
            }
        }catch (Exception e){
            log.error("[ws协议连接]clientName[{}]", serialNumber, e);
            return null;
        }
    }
    
    @Override
    public String redirect(String clientName, String params) {
        return redirect(clientName, params, null);
    }

    @Override
    public String redirect(String clientName, String params, String versionFromUrl) {
        if (clientName == null) {
            return JsonUtils.toString(ObjectResponse.failed(CodeConstants.ERROR_400));
        }
        String[] clientNameArr = clientName.split("_");
        JSONObject stringObjectMap;
        String cmd;
        try {
            stringObjectMap = JSONObject.parseObject(params);
            cmd = stringObjectMap.getString("cmd");
            if (StringUtils.isBlank(cmd)) {
                return unnormalRet(stringObjectMap, cmd, CodeEnum.缺失参数.getCode());
            }
        } catch (Exception e) {
            log.info("clientName：{}，参数格式不正确：{}", clientName, params);
            stringObjectMap = new JSONObject();
            return unnormalRet(stringObjectMap, null, CodeEnum.非法参数.getCode());
        }
        cmd = cmd.trim();
        String messageId = stringObjectMap.getString("messageId");
        P2cBaseResponse<?> p2CBaseResponse;
        try {
            if ("register_device".equals(cmd)) {
                RegisterDeviceRequest registerDeviceRequest = stringObjectMap.toJavaObject(RegisterDeviceRequest.class);
                p2CBaseResponse = Spring.getBean(RegisterDeviceServiceImpl.class).execute(registerDeviceRequest);
                return JsonUtils.toString(p2CBaseResponse);
            } else {
                String parkCode = clientNameArr[0];
                String sn = clientNameArr[1];
                TokenDeviceVo deviceToken = p2cOperHandle.getAndCacheDevice(sn, TokenDeviceVo.ProtocolTypeEnum.WS);
                //1.4版本以前，要校验token
                if (versionFromUrl == null || P2cVersionEnum.getIndex(versionFromUrl) < P2cVersionEnum.版本8.getIndex()){
                    String token = stringObjectMap.getString("token");
                    String cloudToken = deviceToken.getToken();
                    if (token != null && !token.equals(cloudToken)){
                        log.info("相机上报token已过期, cmd: {}, messageId: {}, token: {}", cmd, messageId, token);
                        return unnormalRet(stringObjectMap, cmd, CodeEnum.认证失败.getCode());
                    }
                }
                if (cmd.contains(P2cBaseResponse.CMD_SUFFIX)) {
                    // 相机响应的请求处理
                    cmd = cmd.substring(0, cmd.indexOf(P2cBaseResponse.CMD_SUFFIX));
                    ResponseService<Object> responseService = SendServiceFactory.getP2cBean(cmd, ResponseService.class);
                    P2cBaseResponse<Object> baseResponse = stringObjectMap.toJavaObject(responseService.getGenericType());
                    responseService.dealResponse(baseResponse, deviceToken.getParkId(), deviceToken.getParkCode(), deviceToken.getDeviceNo());
                    return null;
                } else {
                    // 相机主动上报的请求处理
//                    P2cBaseRequest p2cBaseRequest = JsonTools.toBean(params, P2cBaseRequest.class);
                    CallService<Object, Object> callService = SendServiceFactory.getP2cBean(cmd, CallService.class);
                    P2cBaseRequest<Object> p2cBaseRequest = stringObjectMap.toJavaObject(callService.getGenericType());
                    if (DingZhiFuncConstants.DZ003_PARKS.contains(parkCode)) {
                        if (DingZhiFuncConstants.DZ003_DEVICES.contains(clientNameArr[1])) {
                            if (ReportCmdEnum.入场上报.getCmd().equals(cmd)
                                    || ReportCmdEnum.离场上报.getCmd().equals(cmd)) {
                                return unnormalRet(stringObjectMap, cmd, CodeEnum.请求资源不存在.getCode());
                            }
                        }
                    }
                    //是否需要处理双摄相机数据，默认为否
                    boolean isDualCamera = false;
                    boolean isMaster = deviceToken.isMaster();
                    //只对入场上报和离场上报做处理，其他接口直接返回
                    if (CUSTOM_PARKS.contains(parkCode) && (ReportCmdEnum.入场上报.getCmd().equals(p2cBaseRequest.getCmd())
                            || ReportCmdEnum.离场上报.getCmd().equals(p2cBaseRequest.getCmd()))) {
                        List<ParkConnectedDeviceVo> connectedList = cacheHandle.getConnectedList(parkCode, deviceToken.getInandoutCode());
                        JSONObject bizContent = stringObjectMap.getJSONObject("bizContent");
                        // 单通道多相机，并且不是软触发时
                        if (connectedList != null && connectedList.size() > 1
                                && !TriggerTypeEnum.软触发.getVal().equals(bizContent.getInteger("triggerType"))) {
                            isDualCamera = true;
                        }
                    }
                    if (isDualCamera) {
                        //双摄相机上报前置处理流程
                        DualCameraServiceImpl.ResultCode resultCode = dualCameraService.preHandle(p2cBaseRequest, deviceToken.getParkId(), deviceToken.getParkCode(), deviceToken.getDeviceNo(), deviceToken.getInandoutCode(), deviceToken.getInandoutType(), isMaster);
                        log.info("消息[{}]: 通道：{}，双摄相机上报事件，判断结果：{}", messageId, deviceToken.getInandoutCode(), resultCode.name());
                        p2CBaseResponse = callService.execute(deviceToken, p2cBaseRequest);
                        if (resultCode.equals(DualCameraServiceImpl.ResultCode.从相机识别_主相机在线)
                                || resultCode.equals(DualCameraServiceImpl.ResultCode.主从都识别_已开闸)) {
                            //异步将结果转发给主相机处理，并返回响应给从相机的结果
                            p2CBaseResponse = dualCameraService.afterHandle(p2CBaseResponse, deviceToken.getParkId(), parkCode, deviceToken.getInandoutCode(), deviceToken.getInandoutType(), p2cBaseRequest, resultCode);
                        }
                    } else {
                        p2CBaseResponse = callService.execute(deviceToken, p2cBaseRequest);
                    }
                }
            }
        } catch (ResponseBodyException ee) {
            return unnormalRet(stringObjectMap, cmd, Integer.parseInt(ee.getErrCode()));
        } catch (Exception e) {
            log.error(String.valueOf(e.getMessage()), e);
            return unnormalRet(stringObjectMap, cmd, CodeEnum.服务器异常.getCode());
        }
        return JsonUtils.toString(p2CBaseResponse);

    }

    private String unnormalRet(Map<String, Object> paramMap, String cmd, int code) {
        P2cBaseResponse<Object> p2CBaseResponse = new P2cBaseResponse<>();
        p2CBaseResponse.setCmd(cmd + P2cBaseResponse.CMD_SUFFIX);
        p2CBaseResponse.setMessageId(MapUtils.getString(paramMap, "messageId"));
        p2CBaseResponse.setToken(MapUtils.getString(paramMap, "token"));
        p2CBaseResponse.setCode(code);
        p2CBaseResponse.setMsg(CodeEnum.getMsg(code));
        return JSONObject.toJSONString(p2CBaseResponse);
    }
}
