package com.icetech.park.service.impl;

import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.ManageService;
import com.icetech.cloudcenter.api.order.CarOrderEnterService;
import com.icetech.cloudcenter.api.order.CarOrderExitService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.cloudcenter.domain.enumeration.DataCollectionEnum;
import com.icetech.cloudcenter.domain.request.ApplyNoPlateEnterRequest;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.request.ChannelCarInfoRequest;
import com.icetech.cloudcenter.domain.request.CloseBrakeRequest;
import com.icetech.cloudcenter.domain.request.DataEnterRequest;
import com.icetech.cloudcenter.domain.request.DataExitRequest;
import com.icetech.cloudcenter.domain.request.ModifyFeeRequest;
import com.icetech.cloudcenter.domain.request.OfflineEnterRequest;
import com.icetech.cloudcenter.domain.request.OfflineExitRequest;
import com.icetech.cloudcenter.domain.request.OpenBrakeRequest;
import com.icetech.cloudcenter.domain.request.OpeningDtoRequest;
import com.icetech.cloudcenter.domain.request.PullfeeRequest;
import com.icetech.cloudcenter.domain.request.VoiceReportRequest;
import com.icetech.cloudcenter.domain.request.mor.ApplyCarVideoRequest;
import com.icetech.cloudcenter.domain.response.EnexCarInfoBaseResponse;
import com.icetech.cloudcenter.domain.response.EnterCarInfoResponse;
import com.icetech.cloudcenter.domain.response.PlateTypeDto;
import com.icetech.cloudcenter.domain.response.PullfeeResponse;
import com.icetech.cloudcenter.domain.response.p2c.CarEnterResult;
import com.icetech.cloudcenter.domain.vo.ApplyCarVideoVo;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.constants.OrderCarInfoConstant;
import com.icetech.common.constants.OrderStatusConstants;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.DateTools;
import com.icetech.order.dao.OrderPayDao;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.mongo.document.EnterRecord;
import com.icetech.park.mongo.document.ExitRecord;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.mor.impl.MorApplyCarVideoServiceImpl;
import com.icetech.park.service.handle.MorCacheHandle;
import com.icetech.park.service.handle.PublicHandle;
import com.icetech.park.service.impl.manage.CloudManageService;
import com.icetech.park.service.record.EnterRecordService;
import com.icetech.park.service.record.ExitRecordService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 为外部程序提供接口服务
 */
@Slf4j
@Service
public class ManageServiceImpl extends AbstractService implements ManageService {
    @Autowired
    private ParkService parkService;
    @Autowired
    private PublicHandle publicHandle;
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private OrderService orderService;
    @Autowired
    private CarOrderEnterService carOrderEnterService;
    @Autowired
    private CarOrderExitService carOrderExitService;
    @Autowired
    private EnterRecordService enterRecordService;
    @Autowired
    private ExitRecordService exitRecordService;
    @Autowired
    private OrderPayDao orderPayDao;
    @Autowired
    private MorApplyCarVideoServiceImpl applyCarVideoService;
    @Autowired
    private MorCacheHandle morCacheHandle;

    @Autowired
    private Map<String, CloudManageService> manageServiceMap;
    private static final String P2C_BEAN = "p2CloudManageImpl";
    private static final String FC_BEAN = "fullCloudManageImpl";
    private static final String PNC_BEAN = "pnCloudManageImpl";

    @Override
    public ObjectResponse<EnexCarInfoBaseResponse> getCarInfoFromRedis(String parkCode, String aisleCode, Integer type, String topic) {
        try {
            return getBean(parkCode).getCarInfoFromRedis(parkCode, aisleCode, type, topic);
        }catch (ResponseBodyException e){
            return ObjectResponse.failed(e.getErrCode(),e.getMessage());
        }catch (Exception e){
            log.error("参数{}", aisleCode, e);
            return ObjectResponse.failed(CodeConstantsEnum.ERROR);
        }
    }

    @Override
    public ObjectResponse<EnterCarInfoResponse> getCarEnterTraceFromRedis(String parkCode, String aisleCode) {
        try {
            return getBean(parkCode).getCarEnterTraceFromRedis(parkCode, aisleCode);
        }catch (ResponseBodyException e){
            return ObjectResponse.failed(e.getErrCode(),e.getMessage());
        }catch (Exception e){
            log.error("参数{}", aisleCode, e);
            return ObjectResponse.failed(CodeConstantsEnum.ERROR);
        }
    }

    @Override
    public ObjectResponse<EnexCarInfoBaseResponse> getCarInfoFromCamera(String parkCode, String aisleCode, Integer type, String topic) {
        try {
            return getBean(parkCode).getCarInfoFromCamera(parkCode, aisleCode, type, topic);
        }catch (ResponseBodyException e){
            return ObjectResponse.failed(e.getErrCode(),e.getMessage());
        }catch (Exception e){
            log.error("参数{}", aisleCode, e);
            return ObjectResponse.failed(CodeConstantsEnum.ERROR);
        }
    }

    @Override
    public ObjectResponse<String> getCarInfoFromCameraAsync(String parkCode, String version, String sn,String aisleCode, Integer type) {
        try {
            return getBean(parkCode).getCarInfoFromCameraAsync(parkCode, version, sn, aisleCode, type);
        }catch (ResponseBodyException e){
            return ObjectResponse.failed(e.getErrCode(),e.getMessage());
        }catch (Exception e){
            log.error("参数{}", aisleCode, e);
            return ObjectResponse.failed(CodeConstantsEnum.ERROR);
        }
    }

    @Override
    public ObjectResponse<Object> getCarExitInfoFromCacheByOrderNum(String parkCode, String orderNum) {
        try {
            return getBean(parkCode).getCarExitInfoFromCacheByOrderNum(parkCode, orderNum);
        }catch (ResponseBodyException e){
            return ObjectResponse.failed(e.getErrCode(),e.getMessage());
        }catch (Exception e){
            log.error("参数{}", orderNum, e);
            return ObjectResponse.failed(CodeConstantsEnum.ERROR);
        }
    }

    @Override
    public ObjectResponse<Void> allowEnter(DataEnterRequest enterRequest) {
        try {
            //校验参数
            verifyParams(enterRequest);
            return getBean(enterRequest.getParkCode()).allowEnter(enterRequest);
        }catch (ResponseBodyException e){
            return ObjectResponse.failed(e.getErrCode(),e.getMessage());
        }catch (Exception e){
            log.error("allowEnter参数[{}]",enterRequest,e);
            return ObjectResponse.failed(CodeConstantsEnum.ERROR);
        }
    }

    @Override
    public ObjectResponse<Void> allowExit(DataExitRequest exitRequest) {
        try {
            //参数校验
            verifyParams(exitRequest);
            String parkCode = exitRequest.getParkCode();
            return getBean(parkCode).allowExit(exitRequest);
        }catch (ResponseBodyException e){
            return ObjectResponse.failed(e.getErrCode(),e.getMessage());
        }catch (Exception e){
            log.error("allowExit异常[{}]", exitRequest, e);
            return ObjectResponse.failed(CodeConstantsEnum.ERROR);
        }
    }

    @Override
    public ObjectResponse<PullfeeResponse> pullFee(PullfeeRequest pullfeeRequest) {
        try {
            verifyParams(pullfeeRequest);
            if (StringUtils.isBlank(pullfeeRequest.getPlateNum())) {
                return ObjectResponse.failed(CodeConstants.ERROR_400, "车牌号不能为空");
            }
            return getBean(pullfeeRequest.getParkCode()).pullFee(pullfeeRequest);
        }catch (ResponseBodyException e){
            return ObjectResponse.failed(e.getErrCode(),e.getMessage());
        }catch (Exception e){
            log.error("[人工查询费用] 查询最新费用异常，参数[{}]", pullfeeRequest,e);
            return ObjectResponse.failed(CodeConstantsEnum.ERROR);
        }
    }

    @Override
    public ObjectResponse<Void> callVoiceReport(VoiceReportRequest voiceReportRequest) {
        try {
            verifyParams(voiceReportRequest);
            return getBean(voiceReportRequest.getParkCode()).callVoiceReport(voiceReportRequest);
        }catch (ResponseBodyException e){
            return ObjectResponse.failed(e.getErrCode(),e.getMessage());
        }catch (Exception e){
            log.error("语音播放异常，参数[{}]", voiceReportRequest, e);
            return ObjectResponse.failed(CodeConstantsEnum.ERROR);
        }

    }

    @Override
    public ObjectResponse<Void> requestOpenBrake(OpenBrakeRequest openBrakeRequest) {
        try {
            verifyParams(openBrakeRequest);
            return getBean(openBrakeRequest.getParkCode()).requestOpenBrake(openBrakeRequest);
        }catch (ResponseBodyException e){
            return ObjectResponse.failed(e.getErrCode(),e.getMessage());
        }catch (Exception e){
            log.error("开闸异常，参数[{}]", openBrakeRequest,e);
            return ObjectResponse.failed(CodeConstantsEnum.ERROR);
        }
    }

    @Override
    public ObjectResponse<Void> requestCloseBrake(CloseBrakeRequest closeBrakeRequest) {
        try {
            verifyParams(closeBrakeRequest);
            return getBean(closeBrakeRequest.getParkCode()).requestCloseBrake(closeBrakeRequest);
        }catch (ResponseBodyException e){
            return ObjectResponse.failed(e.getErrCode(),e.getMessage());
        }catch (Exception e){
            log.error(String.valueOf(e.getMessage()), e);
            return ObjectResponse.failed(CodeConstantsEnum.ERROR);
        }
    }

    @Override
    public ObjectResponse<Void> modifyCacheFee(ModifyFeeRequest modifyFeeRequest) {
        try {
            return getBean(modifyFeeRequest.getParkCode()).modifyCacheFee(modifyFeeRequest);
        }catch (ResponseBodyException e){
            log.info("请求参数异常[{}]", modifyFeeRequest, e);
            return ObjectResponse.failed(e.getErrCode(),e.getMessage());
        }catch (Exception e){
            log.error("请求数据异常[{}]", modifyFeeRequest, e);
            return ObjectResponse.failed(CodeConstantsEnum.ERROR);
        }
    }

    @Override
    public ObjectResponse<Void> updateExitChannelInfo(ChannelCarInfoRequest channelCarInfoRequest) {
        CarExitRequest exit = cacheHandle.getExit(channelCarInfoRequest.getParkCode(), channelCarInfoRequest.getAisleCode());
        if (exit == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_402, "操作超时，请重新计费");
        }
        if (!channelCarInfoRequest.getOrderNum().equals(exit.getOrderNum())) {
            return ObjectResponse.failed(CodeConstants.ERROR_402, "与当前通道车辆不一致，请重新识别");
        }
        exit.setMaxImage(channelCarInfoRequest.getImage());
        exit.setCarType(channelCarInfoRequest.getCarType());
        exit.setOperAccount(channelCarInfoRequest.getOperaAccount());
        exit.setExitTerminal(channelCarInfoRequest.getExitTerminal());
        exit.setExitWay(OrderCarInfoConstant.IN_OUT_WAY_SOFTWARE_MANUAL);
        cacheHandle.setExit(channelCarInfoRequest.getParkCode(), channelCarInfoRequest.getAisleCode(), exit);
        return ObjectResponse.success();
    }

    @Override
    public ObjectResponse<Map<String, Object>> offLineEnter(OfflineEnterRequest offlineEnterRequest) {
        //参数校验
        verifyParams(offlineEnterRequest);
        ObjectResponse<Park> parkObjectResponse = parkService.findByParkCode(offlineEnterRequest.getParkCode());
        if (!ObjectResponse.isSuccess(parkObjectResponse)) {
            return ObjectResponse.failed(CodeConstants.ERROR_404, "车场编号不存在");
        }
        Park park = parkObjectResponse.getData();
        ObjectResponse<ParkInoutdevice> inOutObjectResponse = parkService.getInOutDeviceByCode(park.getId(),
                offlineEnterRequest.getAisleCode());
        if (!ObjectResponse.isSuccess(inOutObjectResponse)) {
            return ObjectResponse.failed(CodeConstants.ERROR_404, "通道编号不存在");
        }
        CarEnterRequest carEnterRequest = new CarEnterRequest();
        carEnterRequest.setPlateNum(offlineEnterRequest.getPlateNum());
        carEnterRequest.setMaxImage(offlineEnterRequest.getImage());
        ObjectResponse<PlateTypeDto> plateType = orderService.getPlateType(park.getId(), offlineEnterRequest.getPlateNum(), inOutObjectResponse.getData().getRegionId());
        if (ObjectResponse.isSuccess(plateType)) {
            carEnterRequest.setType(plateType.getData().getPlateTypeEnum().getType());
        } else {
            carEnterRequest.setType(PlateTypeEnum.临时车.getType());
        }
        carEnterRequest.setCarType(offlineEnterRequest.getCarType());
        carEnterRequest.setCarDesc(offlineEnterRequest.getSpecialCar());
        carEnterRequest.setEnterTime(DateTools.unixTimestamp());
        carEnterRequest.setOperaUser(offlineEnterRequest.getOperaUser());
        //扩展参数设置
        carEnterRequest.setParkId(park.getId());
        carEnterRequest.setParkCode(offlineEnterRequest.getParkCode());
        carEnterRequest.setInandoutCode(offlineEnterRequest.getAisleCode());
        carEnterRequest.setInandoutName(inOutObjectResponse.getData().getInandoutName());
        carEnterRequest.setOrderNum(CodeTools.GenerateOrderNum());
        carEnterRequest.setEnterWay(OrderCarInfoConstant.IN_OUT_WAY_OFF_LINE);
        carEnterRequest.setEnterTerminal(2);
        // 记录上报信息
        addEnterRecord(carEnterRequest);
        ObjectResponse<CarEnterResult> objectResponse = carOrderEnterService.enter(carEnterRequest);
        if (ObjectResponse.isSuccess(objectResponse)) {
            //清除缓存中的上次异常记录
            cacheHandle.removeEntrace(offlineEnterRequest.getParkCode(), offlineEnterRequest.getAisleCode());
            CarEnterResult carEnterResult = objectResponse.getData();
            //保存开闸记录
            addEntranceOpenRecord(offlineEnterRequest, carEnterResult.getOrderNum(), carEnterRequest.getEnterTime());
            Map<String, Object> ret = new HashMap<>(1);
            ret.put("type", carEnterRequest.getType());
            return ObjectResponse.success(ret);
        } else {
            return ObjectResponse.failed(objectResponse.getCode(), objectResponse.getMsg());
        }
    }

    @Override
    public ObjectResponse<Void> offLineExit(OfflineExitRequest offlineExitRequest) {
        //参数校验
        verifyParams(offlineExitRequest);
        ObjectResponse<Park> parkObjectResponse = parkService.findByParkCode(offlineExitRequest.getParkCode());
        if (!ObjectResponse.isSuccess(parkObjectResponse)) {
            return ObjectResponse.failed(CodeConstants.ERROR_404, "车场编号不存在");
        }
        Park park = parkObjectResponse.getData();
        ObjectResponse<ParkInoutdevice> inOutObjectResponse = parkService.getInOutDeviceByCode(park.getId(),
                offlineExitRequest.getAisleCode());
        if (!ObjectResponse.isSuccess(inOutObjectResponse)) {
            return ObjectResponse.failed(CodeConstants.ERROR_404, "通道编号不存在");
        }
        Integer type;
        ObjectResponse<PlateTypeDto> plateType = orderService.getPlateType(park.getId(), offlineExitRequest.getPlateNum(), inOutObjectResponse.getData().getRegionId());
        if (ObjectResponse.isSuccess(plateType)) {
            type = plateType.getData().getPlateTypeEnum().getType();
        } else {
            type = PlateTypeEnum.临时车.getType();
        }
        CarExitRequest cacheExit = cacheHandle.getExit(offlineExitRequest.getParkCode(), offlineExitRequest.getAisleCode());
        CarExitRequest carExitRequest = new CarExitRequest();
        if (StringUtils.isNotBlank(offlineExitRequest.getOrderNum())) {
            ObjectResponse<OrderInfo> objectResponse = orderService.findByOrderNum(offlineExitRequest.getOrderNum());
            if (!ObjectResponse.isSuccess(objectResponse)) {
                return ObjectResponse.failed(CodeConstants.ERROR_402, "订单号不存在");
            }
            if (!objectResponse.getData().getServiceStatus().equals(OrderStatusConstants.IN_PARK)) {
                return ObjectResponse.failed(CodeConstants.ERROR_405, "车辆已离场");
            }
            if (cacheExit == null) {
                carExitRequest.setPlateNum(offlineExitRequest.getPlateNum());
                carExitRequest.setMaxImage(offlineExitRequest.getImage());
                carExitRequest.setCarType(offlineExitRequest.getCarType());
                carExitRequest.setExitTime(DateTools.unixTimestamp());
                //扩展参数设置
                carExitRequest.setParkId(park.getId());
                carExitRequest.setParkCode(offlineExitRequest.getParkCode());
                carExitRequest.setInandoutCode(offlineExitRequest.getAisleCode());
                carExitRequest.setInandoutName(inOutObjectResponse.getData().getInandoutName());
                carExitRequest.setOrderNum(offlineExitRequest.getOrderNum());
            } else {
                String cacheOrderNum = cacheExit.getOrderNum();
                if (cacheOrderNum != null && !offlineExitRequest.getOrderNum().equals(cacheOrderNum)) {
                    log.warn("[断电应急离场] 订单与缓存中的异常订单不匹配，缓存数据为:{},请求参数为:{}", cacheExit, offlineExitRequest);
                }
                BeanUtils.copyProperties(cacheExit, carExitRequest);
                carExitRequest.setInandoutCode(offlineExitRequest.getAisleCode());
                carExitRequest.setCarType(offlineExitRequest.getCarType());
                carExitRequest.setOrderNum(offlineExitRequest.getOrderNum());
                carExitRequest.setPlateNum(offlineExitRequest.getPlateNum());
                carExitRequest.setExitTime(cacheExit.getExitTime());
                if (offlineExitRequest.getImage() != null) {
                    carExitRequest.setMaxImage(offlineExitRequest.getImage());
                }
            }
            carExitRequest.setType(type);
            OrderPay orderPay = new OrderPay();
            orderPay.setParkId(park.getId());
            orderPay.setOrderNum(offlineExitRequest.getOrderNum());
            OrderSumFeeDto orderSumFeeDto = orderPayDao.sumFee(orderPay);
            if (orderSumFeeDto != null){
                carExitRequest.setTotalAmount(String.valueOf(orderSumFeeDto.getTotalPrice()));
                carExitRequest.setPaidAmount(String.valueOf(orderSumFeeDto.getPaidPrice()));
                carExitRequest.setDiscountAmount(String.valueOf(orderSumFeeDto.getDiscountPrice()));
            }
            // 记录上报信息
            addExitRecord(carExitRequest);
            //传0时，出场逻辑不用再查询一遍类型
            carExitRequest.setOpenFlag(0);
            carExitRequest.setExitWay(OrderCarInfoConstant.IN_OUT_WAY_OFF_LINE);
            carExitRequest.setOperAccount(offlineExitRequest.getOperaUser());
            //APP
            carExitRequest.setExitTerminal(2);
            carOrderExitService.exceptionExit(carExitRequest, 7);
        }
        if (cacheExit != null && cacheExit.getOrderNum().equals(offlineExitRequest.getOrderNum())) {
            //清除缓存中的上次异常记录
            cacheHandle.removeExit(offlineExitRequest.getParkCode(), offlineExitRequest.getAisleCode());
            cacheHandle.removeChannelFee(offlineExitRequest.getParkCode(), offlineExitRequest.getAisleCode());
            ParkInoutdevice parkInoutdevice = inOutObjectResponse.getData();
            //如果是场中场的小场出，则判断大场出口是不是当前车辆，如果是，则删除，需要重新计费
            if (Integer.valueOf(1).equals(park.getIsInterior()) && Integer.valueOf(0).equals(parkInoutdevice.getIsMaster())) {
                ObjectResponse<List<ParkInoutdevice>> objectResponse = parkService.getChannelByType(park.getId(), 2);
                ObjectResponse.notError(objectResponse, "通道列表查询失败");
                List<ParkInoutdevice> list = objectResponse.getData();
                list.forEach(inout -> {
                    if (inout.getInandoutCode().equals(offlineExitRequest.getAisleCode())) {
                        return;
                    }
                    CarExitRequest cacheHandleExit = cacheHandle.getExit(offlineExitRequest.getParkCode(), inout.getInandoutCode());
                    if (offlineExitRequest.getOrderNum().equals(cacheHandleExit.getOrderNum())) {
                        cacheHandle.removeExit(offlineExitRequest.getParkCode(), inout.getInandoutCode());
                        cacheHandle.removeChannelFee(offlineExitRequest.getParkCode(), inout.getInandoutCode());
                    }
                });
            }
        }
        //保存开闸记录
        addExitOpenRecord(offlineExitRequest, offlineExitRequest.getOrderNum(),
                carExitRequest.getExitTime() == null ? DateTools.unixTimestamp() : carExitRequest.getExitTime());
        return ObjectResponse.success();
    }

    @Override
    public ObjectResponse<Void> applyNoPlateEnter(ApplyNoPlateEnterRequest applyNoPlateEnterRequest) {
        try {
            verifyParams(applyNoPlateEnterRequest);
            String parkCode = applyNoPlateEnterRequest.getParkCode();
            return getBean(parkCode).applyNoPlateEnter(applyNoPlateEnterRequest);
        }catch (ResponseBodyException e){
            log.info("请求参数异常[{}]", applyNoPlateEnterRequest, e);
            return ObjectResponse.failed(e.getErrCode(),e.getMessage());
        }catch (Exception e){
            log.error("请求数据异常[{}]", applyNoPlateEnterRequest, e);
            return ObjectResponse.failed(CodeConstantsEnum.ERROR);
        }
    }

    @Override
    public ObjectResponse<String> applyCarVideo(ApplyCarVideoVo applyCarVideoVo) {
        ObjectResponse<ParkInoutdevice> response = parkService.getInoutDeviceById(applyCarVideoVo.getChannelId());
        ObjectResponse.notError(response);
        ObjectResponse<Park> parkObjectResponse = parkService.findByParkId(applyCarVideoVo.getParkId());
        ObjectResponse.notError(parkObjectResponse);
        String inandoutCode = response.getData().getInandoutCode();
        String serialNumber = morCacheHandle.getSerialNumber(parkObjectResponse.getData().getParkCode(), inandoutCode);
        if (serialNumber == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_3003);
        }
        ApplyCarVideoRequest applyCarVideoRequest = new ApplyCarVideoRequest();
        applyCarVideoRequest.setPlateNum(applyCarVideoVo.getPlateNum());
        applyCarVideoRequest.setRecTime(applyCarVideoVo.getRecTime());
        applyCarVideoRequest.setVideoType(applyCarVideoVo.getVideoType());
        applyCarVideoRequest.setVideoId(applyCarVideoVo.getVideoId());
        return applyCarVideoService.send(serialNumber, applyCarVideoVo.getOrderNum(), applyCarVideoVo.getParkId(), applyCarVideoRequest);
    }

    @Override
    public ObjectResponse<Void> fleetMode(String parkCode, Long parkId, String sn, Integer enable) {
        try {
            return getBean(parkCode).fleetMode(parkCode, parkId, sn , enable);
        }catch (ResponseBodyException e){
            return ObjectResponse.failed(e.getErrCode(),e.getMessage());
        }catch (Exception e){
            log.error("fleetMode异常", e);
            return ObjectResponse.failed(CodeConstantsEnum.ERROR);
        }
    }

    /**
     * 保存入场记录
     * @param enterRequest
     */
    public void addEnterRecord(CarEnterRequest enterRequest) {
        EnterRecord record = new EnterRecord();
        BeanUtils.copyProperties(enterRequest, record);
        record.setChannelId(enterRequest.getInandoutCode());
        record.setEnterNo(enterRequest.getInandoutName());
        record.setImage(enterRequest.getMaxImage());
        enterRecordService.saveRecordAsync(record);
    }
    private void addExitRecord(CarExitRequest exitRequest) {
        ExitRecord record = new ExitRecord();
        BeanUtils.copyProperties(exitRequest, record);
        record.setExitNo(exitRequest.getInandoutName());
        record.setImage(exitRequest.getMaxImage());
        record.setSmallImage(exitRequest.getSmallImage());
        exitRecordService.saveRecordAsync(record);
    }
    /**
     * 保存入场开闸记录
     * @param offlineEnterRequest
     */
    public void addEntranceOpenRecord(OfflineEnterRequest offlineEnterRequest, String orderNum, Long execTime) {
        OpeningDtoRequest openingDtoRequest = new OpeningDtoRequest();
        openingDtoRequest.setRecordType(1);
        openingDtoRequest.setParkCode(offlineEnterRequest.getParkCode());
        openingDtoRequest.setPlateNum(offlineEnterRequest.getPlateNum());
        openingDtoRequest.setExecuteTime(execTime);
        openingDtoRequest.setImgUrl(offlineEnterRequest.getImage());
        openingDtoRequest.setAisleCode(offlineEnterRequest.getAisleCode());
        openingDtoRequest.setReasonType(5);
        openingDtoRequest.setOperAccount(offlineEnterRequest.getOperaUser());
        openingDtoRequest.setSourcegate(3);
        openingDtoRequest.setOrderNum(orderNum);
        parkService.saveOpeningRecord(openingDtoRequest);
    }
    /**
     * 保存入场记录
     * @param offlineExitRequest
     */
    public void addExitOpenRecord(OfflineExitRequest offlineExitRequest, String orderNum, Long execTime) {
        OpeningDtoRequest openingDtoRequest = new OpeningDtoRequest();
        openingDtoRequest.setRecordType(2);
        openingDtoRequest.setParkCode(offlineExitRequest.getParkCode());
        openingDtoRequest.setPlateNum(offlineExitRequest.getPlateNum());
        openingDtoRequest.setExecuteTime(execTime);
        openingDtoRequest.setImgUrl(offlineExitRequest.getImage());
        openingDtoRequest.setAisleCode(offlineExitRequest.getAisleCode());
        openingDtoRequest.setReasonType(5);
        openingDtoRequest.setOperAccount(offlineExitRequest.getOperaUser());
        openingDtoRequest.setSourcegate(3);
        openingDtoRequest.setOrderNum(orderNum);
        parkService.saveOpeningRecord(openingDtoRequest);
    }

    private CloudManageService getBean(String parkCode) {
        if (DataCollectionEnum.端云.getType().equals(publicHandle.cloudType(parkCode))){
            return manageServiceMap.get(P2C_BEAN);
        } else if (DataCollectionEnum.纯云.getType().equals(publicHandle.cloudType(parkCode))){
            return manageServiceMap.get(FC_BEAN);
        } else if (DataCollectionEnum.端网云.getType().equals(publicHandle.cloudType(parkCode))){
            return manageServiceMap.get(PNC_BEAN);
        }
        return manageServiceMap.get(P2C_BEAN);
    }
}
