package com.icetech.park.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.icetech.basics.dao.park.ParkDao;
import com.icetech.park.dao.made.IotPlateMapper;
import com.icetech.park.dao.made.MadePlateDao;
import com.icetech.cloudcenter.domain.vo.MadePlateVo;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.StringUtils;
import com.icetech.oss.OssService;
import com.icetech.park.domain.entity.IotPlate;
import com.icetech.cloudcenter.domain.request.ManagerInOutRequest;
import com.icetech.cloudcenter.domain.vo.PlateRecheckVo;
import com.icetech.park.service.IotPlateService;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 车牌二次识别 服务实现类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2021-07-22
 */
@Service
public class IotPlateServiceImpl extends BaseServiceImpl<IotPlateMapper, IotPlate> implements IotPlateService {

    @Autowired
    private ParkDao parkDao;
    
    @Autowired
    private MadePlateDao madePlateDao;

    @Autowired
    private IotPlateService iotPlateService;

    @Resource
    private OssService ossService;

    @Override
    public Integer selectPlateCount(ManagerInOutRequest managerInOutRequest, String parkIds) {
        return this.baseMapper.selectPlateCount(managerInOutRequest, parkIds);
    }

    @Override
    public List<PlateRecheckVo> selectRecheckVo(ManagerInOutRequest request, String parkIds) {
        Page<?> page = new Page<>(request.getPageNo(), request.getPageSize());
        page.setSearchCount(false);
        return this.baseMapper.selectRecheckVo(page, request, parkIds);
    }

    @Override
    public List<IotPlate> selectIotPlateByOrderNum(String orderNum) {
        LambdaQueryWrapper<IotPlate> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(IotPlate::getOrderNum, orderNum);
        return list(wrapper);
    }

    @Override
    public ObjectResponse<Integer> getPlateRecheckCount(ManagerInOutRequest managerInOutRequest) {
        String[] split = managerInOutRequest.getParkCode().split(",");
        String parkIds = parkDao.selectByCodes(split);
        if (StringUtils.isNotEmpty(parkIds) && parkIds.endsWith(",")) {
            parkIds = parkIds.substring(0, parkIds.length() - 1);
        }
        return ObjectResponse.success(iotPlateService.selectPlateCount(managerInOutRequest, parkIds));
    }

    @Override
    public ObjectResponse<List<PlateRecheckVo>> getRecheckList(ManagerInOutRequest managerInOutRequest) {
        String[] split = managerInOutRequest.getParkCode().split(",");
        String parkIds = parkDao.selectByCodes(split);
        if (StringUtils.isNotEmpty(parkIds) && parkIds.endsWith(",")) {
            parkIds = parkIds.substring(0, parkIds.length() - 1);
        }
        List<PlateRecheckVo> plateRecheckVos = iotPlateService.selectRecheckVo(managerInOutRequest, parkIds);
        if (CollectionUtils.isNotEmpty(plateRecheckVos)) {
            plateRecheckVos = plateRecheckVos.stream().peek(t-> {
                if (StringUtils.isNotEmpty(t.getImage())) {
                    t.setImage(ossService.getImageUrl(t.getImage()));
                }
                if (StringUtils.isNotEmpty(t.getSmallEnterImage())) {
                    t.setSmallEnterImage(ossService.getImageUrl(t.getSmallEnterImage()));
                }
            }).collect(Collectors.toList());
        }
        return ObjectResponse.success(plateRecheckVos);
    }

    @Override
    public ObjectResponse<List<MadePlateVo>> getMadePlateList(ManagerInOutRequest managerInOutRequest) {
        String[] split = managerInOutRequest.getParkCode().split(",");
        String parkIds = parkDao.selectByCodes(split);
        if (StringUtils.isNotEmpty(parkIds) && parkIds.endsWith(",")) {
            parkIds = parkIds.substring(0, parkIds.length() - 1);
        }
        List<MadePlateVo> madePlateVos =
                madePlateDao.selectMadePlateVo(new com.baomidou.mybatisplus.extension.plugins.pagination.Page<>(managerInOutRequest.getPageNo(),
                        managerInOutRequest.getPageSize()), managerInOutRequest, parkIds);
        if (CollectionUtils.isNotEmpty(madePlateVos)) {
            madePlateVos = madePlateVos.stream().peek(t -> {
                if (StringUtils.isNotEmpty(t.getImage())) {
                    t.setImage(ossService.getImageUrl(t.getImage()));
                }
            }).collect(Collectors.toList());
        }
        return ObjectResponse.success(madePlateVos);
    }
}
