package com.icetech.park.service.impl;

import com.icetech.cloudcenter.api.order.OrderDiscountService;
import com.icetech.cloudcenter.api.order.OrderPayService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.domain.request.DiscountRequest;
import com.icetech.common.constants.PayStatusConstants;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.cloudcenter.api.ExternalService;
import com.icetech.cloudcenter.domain.request.PrepayReportRequest;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.handle.PublicHandle;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Slf4j
public class ExternalServiceImpl extends AbstractService implements ExternalService {
    @Autowired
    private OrderDiscountService orderDiscountService;
    @Autowired
    private OrderPayService orderPayService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private PublicHandle publicHandle;

    //优惠：已使用状态
    private static final int NEW_STATUS = 1;

    @Override
    public ObjectResponse prepayReport(PrepayReportRequest prepayReportRequest) {

        log.info("<预缴费上报> 参数：{}", prepayReportRequest);

        /**
         * 开始处理业务
         */
        OrderPay orderPay = new OrderPay();
        BeanUtils.copyProperties(prepayReportRequest, orderPay);
        Long parkId = getParkId(prepayReportRequest);
        orderPay.setParkId(parkId);
        String orderNum = prepayReportRequest.getOrderNum();
        if (orderNum == null){
            orderNum = publicHandle.convert2OrderNum(parkId, prepayReportRequest.getOrderId());
        }
        orderPay.setOrderNum(orderNum);
        orderPay.setPayStatus(PayStatusConstants.PAID);

        ObjectResponse objectResponse = orderPayService.addOrderPay(orderPay);
        ObjectResponse.notError(objectResponse);
        String discountNos = prepayReportRequest.getDiscountNos();
        if (discountNos != null){

            String[] discountNoArr = discountNos.split(",");
            if (discountNoArr != null && discountNoArr.length > 0){

                DiscountRequest discountRequest = new DiscountRequest();
                BeanUtils.copyProperties(orderPay, discountRequest);
                discountRequest.setOrderNum(orderNum);
                discountRequest.setDiscountNos(discountNoArr);
                discountRequest.setNewStatus(NEW_STATUS);

                objectResponse = orderDiscountService.modifyDiscount(discountRequest);
                ObjectResponse.notError(objectResponse);
                return ObjectResponse.success();
            }
        }
        return ObjectResponse.success();
    }

    /**
     * 获取parkId
     * @param prepayReportRequest
     * @return
     */
    private Long getParkId(PrepayReportRequest prepayReportRequest) {
        if (prepayReportRequest.getParkId() != null){
            return prepayReportRequest.getParkId();
        }else{
            /**
             * H5请求来源
             */
            ObjectResponse<OrderInfo> objectResponse_order = orderService.findByOrderNum(prepayReportRequest.getOrderNum());
            ObjectResponse.notError(objectResponse_order);
            return objectResponse_order.getData().getParkId();
        }

    }


}
