package com.icetech.park.service.impl;

import com.alibaba.fastjson.TypeReference;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.DebugService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.SwitchTypeEnum;
import com.icetech.cloudcenter.domain.request.BarriergateOperRequest;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.request.DataEnterRequest;
import com.icetech.cloudcenter.domain.request.EnterDebugRequest;
import com.icetech.cloudcenter.domain.request.ExitDebugRequest;
import com.icetech.cloudcenter.domain.request.PayDebugRequest;
import com.icetech.cloudcenter.domain.request.ShowSayDebugRequest;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.cloudcenter.domain.response.p2c.CarEnexResponse;
import com.icetech.cloudcenter.domain.response.p2c.CarEnterResult;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.response.p2c.RemoteSwitchResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.OrderCarInfoConstant;
import com.icetech.common.constants.PlateColorEnum;
import com.icetech.common.domain.AsyncNotifyInterface;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.DateTools;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.down.p2c.impl.P2cRemoteSwitchServiceImpl;
import com.icetech.park.service.flow.p2c.FlowCondition;
import com.icetech.park.service.flow.p2c.impl.CarExitFlowProcessImpl;
import com.icetech.park.service.handle.showsay.DownShowSayHandle;
import com.icetech.park.service.impl.base.ManageServiceBase;
import com.icetech.park.service.report.ReportParamHolder;
import com.icetech.park.service.report.p2c.impl.exit.CarExitBaseHandler;
import com.icetech.third.utils.RedisUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * 为外部程序提供接口服务
 */
@Service
@Slf4j
public class DebugServiceImpl extends ManageServiceBase implements DebugService {
    @Autowired
    private ParkService parkService;
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private CarExitBaseHandler carExitBaseHandler;
    @Autowired
    private CarExitFlowProcessImpl carExitFlowProcess;
    @Autowired
    @Qualifier("p2cRemoteSwitchServiceImpl")
    private P2cRemoteSwitchServiceImpl p2c_remoteSwitchService;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    protected DownShowSayHandle downShowSayHandle;
    @Autowired
    protected P2cRemoteSwitchServiceImpl remoteSwitchService;

    @Override
    public ObjectResponse enterDebug(EnterDebugRequest enterDebugRequest, String topic) {
        String parkCode = enterDebugRequest.getParkCode();
        String plateNum = enterDebugRequest.getPlateNum();
        String serialNumber;
        try{
            serialNumber = cacheHandle.getSerialNumber(parkCode, enterDebugRequest.getAisleCode());
        }catch (ResponseBodyException e){
            return ObjectResponse.failed(e.getErrCode(), e.getMessage());
        }
        Long parkId = getParkId(parkCode);
        ObjectResponse<ParkInoutdevice> channelResp = parkService.getInOutDeviceByCode(parkId, enterDebugRequest.getAisleCode());
        ParkInoutdevice channel = channelResp.getData();
        ObjectResponse.notError(channelResp);
        if (enterDebugRequest.getType() == 1){//判断是否允许临时车进入
            if (channel.getIsAllowTempcarrun() != null && channel.getIsAllowTempcarrun() == 0){
                //不允许开闸
                ObjectResponse objectResponse2 = downShowSayHandle.showSayExec(parkId, parkCode, channel.getId(), plateNum, enterDebugRequest.getType(),
                        FlowCondition.ResultCode.有牌车不允许临时车进入, null,
                        serialNumber, 1, enterDebugRequest.getAisleCode(), true);
                if (!ObjectResponse.isSuccess(objectResponse2)){
                    return ObjectResponse.failed(CodeConstants.ERROR_3003);
                }else{
                    return ObjectResponse.success();
                }
            }
        }
        //是否开闸
        if (enterDebugRequest.getIsOpen().equals(1)){
            String msgId = p2c_remoteSwitchService.open(SwitchTypeEnum.开闸.getType(), parkId, enterDebugRequest.getParkCode(), serialNumber, enterDebugRequest.getPlateNum());
            if (msgId == null){
                log.info("<平台入场> 开闸指令下发失败");
                return  ObjectResponse.failed(CodeConstants.ERROR_3002);
            }
        }
        FlowCondition.ResultCode resultCode= null;
        Map<String, Object> para = new HashMap<>();
        if (enterDebugRequest.getType() == 1){
            resultCode = FlowCondition.ResultCode.有牌车允许临时车进入;
        }else if (enterDebugRequest.getType() == 2){
            resultCode = FlowCondition.ResultCode.月卡车;
        }else if (enterDebugRequest.getType() == 3){
            resultCode = FlowCondition.ResultCode.有牌车允许临时车进入;
        }else if (enterDebugRequest.getType() == 4){
            resultCode = FlowCondition.ResultCode.VIP车辆;
        }else{
            para.put("isShow", 1);
            resultCode = FlowCondition.ResultCode.黑名单车;
        }
        ObjectResponse<?> objectResponse = downShowSayHandle.showSayExec(parkId, parkCode, channel.getId(), plateNum, enterDebugRequest.getType(), resultCode, para,
                serialNumber, 1, serialNumber, true);
        if (!ObjectResponse.isSuccess(objectResponse)){
            return ObjectResponse.failed(CodeConstants.ERROR_3003);
        }
        DataEnterRequest enterRequest = new DataEnterRequest();
        BeanUtils.copyProperties(enterDebugRequest, enterRequest);
        enterRequest.setCarType(1);
        enterRequest.setDebug(true);
        ObjectResponse<Void> objectResponse1 = enter(enterRequest, parkCode, serialNumber, parkId, plateNum, topic);
        if(CodeConstants.ERROR_12002.equals(objectResponse1.getCode())) {
            String messageId = objectResponse1.getMsg();
            ObjectResponse<Object> objectResponse2 = AsyncNotifyInterface.wait(messageId, 4000L,
                    () -> redisUtils.get(AsyncNotifyInterface.getMessageKey(messageId), new TypeReference<ObjectResponse<Object>>() {}));
            if (objectResponse2 == null) {
                return ObjectResponse.failed(CodeConstants.ERROR, "入场失败");
            } else {
                return ObjectResponse.instance(objectResponse2.getCode(), objectResponse2.getMsg());
            }
        }
        return objectResponse1;
    }

    @Override
    public ObjectResponse exitDebug(ExitDebugRequest exitDebugRequest) {
        Integer type = exitDebugRequest.getType();
        String parkCode = exitDebugRequest.getParkCode();
        String aisleCode = exitDebugRequest.getAisleCode();
        String plateNum = exitDebugRequest.getPlateNum();

        ObjectResponse<Park> byParkCode = parkService.findByParkCode(parkCode);
        ObjectResponse.notError(byParkCode);
        Park park = byParkCode.getData();
        Long parkId = park.getId();

        ObjectResponse<ParkInoutdevice> inOutDeviceByCode = parkService.getInOutDeviceByCode(parkId, aisleCode);
        ObjectResponse.notError(inOutDeviceByCode);
        ParkInoutdevice channel = inOutDeviceByCode.getData();
        String inandoutName = channel.getInandoutName();

        ObjectResponse<ParkConfig> parkConfigObjectResponse = parkService.getParkConfig(parkId);
        if(!ObjectResponse.isSuccess(parkConfigObjectResponse)){
            return ObjectResponse.failed(CodeConstants.ERROR, "车场高级配置未保存");
        }
        String serialNumber = null;
        try {
            serialNumber = cacheHandle.getSerialNumber(parkCode, aisleCode);
        } catch (ResponseBodyException e) {
            return ObjectResponse.failed(e.getErrCode(), e.getMessage());
        }
        boolean isSpecialCarFree = true;
        ParkConfig parkConfig = parkConfigObjectResponse.getData();
        if (parkConfig.getIsfreeSpecialcar() == 0){
            isSpecialCarFree = false;
        }
        FlowCondition.FlowRet flowRet = new FlowCondition.FlowRet();
        CarExitRequest exitRequest = new CarExitRequest();
        exitRequest.setParkCode(parkCode);
        exitRequest.setInandoutCode(aisleCode);
        exitRequest.setInandoutName(inandoutName);
        exitRequest.setPlateNum(plateNum);
        exitRequest.setParkId(parkId);
        long exitTime = DateTools.unixTimestamp();
        exitRequest.setExitTime(exitTime);
        exitRequest.setCarType(1);

        boolean isInPark = true;
        long parkTime = 0;
        ObjectResponse<OrderInfo> orderInfoObjectResponse = orderService.findInPark(plateNum, parkCode);
        if (ObjectResponse.isSuccess(orderInfoObjectResponse)){
            OrderInfo orderInfo = orderInfoObjectResponse.getData();
            exitRequest.setOrderNum(orderInfo.getOrderNum());
            exitRequest.setCarType(orderInfoObjectResponse.getData().getCarType());
            parkTime = exitTime - orderInfo.getEnterTime();
        }else{
            isInPark = false;
        }

        switch (type) {
            case 1:
                exitRequest.setType(1);
                tempHandle(parkCode, aisleCode, plateNum, parkId, isInPark, orderInfoObjectResponse, parkConfig, flowRet);
                break;
            case 2:
                exitRequest.setType(2);
                flowRet.setResultCode(FlowCondition.ResultCode.月卡车);
                break;
            case 3:
                exitRequest.setType(3);
                if (isSpecialCarFree){
                    flowRet.setResultCode(FlowCondition.ResultCode.特殊车辆免费);
                }else{
                    tempHandle(parkCode, aisleCode, plateNum, parkId, isInPark, orderInfoObjectResponse, parkConfig, flowRet);
                }
                break;
            case 4:
                exitRequest.setType(4);
                if (orderInfoObjectResponse.getData() != null){
                    ObjectResponse<QueryOrderFeeResponse> queryOrderFeeResponseObjectResponse = orderService.p2cQueryFee(orderInfoObjectResponse.getData(), parkConfig,channel.getInandoutCode());
                    ObjectResponse.notError(queryOrderFeeResponseObjectResponse);
                    QueryOrderFeeResponse orderFee = queryOrderFeeResponseObjectResponse.getData();
                    Map<String, Object> paramMap = new HashMap<>();
                    paramMap.put("orderFee", orderFee);
                    String unPayPrice = orderFee.getUnpayPrice();
                    if (Float.parseFloat(unPayPrice) == 0) {
                        String totalAmount = orderFee.getTotalAmount();
                        if (Float.parseFloat(totalAmount) == 0){
                            flowRet.setResultCode(FlowCondition.ResultCode.免费时间内);
                            paramMap.put("isreleaseFreetm", parkConfig.getIsreleaseFreetm());
                            flowRet.setPara(paramMap);
                        }else{
                            flowRet.setResultCode(FlowCondition.ResultCode.无需缴费);
                            flowRet.setPara(paramMap);
                        }
                    } else {
                        flowRet.setResultCode(FlowCondition.ResultCode.需缴费);
                        flowRet.setPara(paramMap);
                    }
                }else{
                    flowRet.setResultCode(FlowCondition.ResultCode.无入场记录);
                }
                break;
            case 5:
                exitRequest.setType(1);
                flowRet.setResultCode(FlowCondition.ResultCode.黑名单车);
                break;
            default:
                break;
        }
        P2cBaseRequest<CarExitRequest> baseRequest = new P2cBaseRequest<>();
        baseRequest.setBizContent(exitRequest);
        TokenDeviceVo deviceInfo = cacheHandle.getDeviceInfo(serialNumber);
        ReportParamHolder paramHolder = new ReportParamHolder(exitRequest.getParkId(), exitRequest.getParkCode(),
                exitRequest.getInandoutCode(), serialNumber, deviceInfo.getVersion(),
                exitRequest.getPlateNum(), 2, exitRequest.getOrderNum());
        P2cBaseResponse<CarEnexResponse> p2cBaseResponse = carExitBaseHandler.notOpenedFlowHandle(baseRequest, paramHolder, flowRet, parkTime);

        CarEnexResponse data = p2cBaseResponse.getData();
        if (data.getOpenFlag() != null && data.getOpenFlag() == 1){
            /*
             * 开闸
             */
            String msgId = remoteSwitchService.open(SwitchTypeEnum.开闸.getType(), parkId, exitDebugRequest.getParkCode(), serialNumber, exitDebugRequest.getPlateNum());
            if (msgId == null) {
                log.info("<调试助手-平台离场> 开闸指令下发失败，车牌号：{}", plateNum);
                return ObjectResponse.failed(CodeConstants.ERROR_3002);
            }
        }
        ObjectResponse objectResponse = downShowSayHandle.fixShowSayExec(parkId, parkCode, channel.getId(), plateNum, data.getShow(), data.getSay(), "",
                serialNumber, true);
        if (!ObjectResponse.isSuccess(objectResponse)) {
            log.info("<调试助手-平台离场> 语音显示指令下发失败，车牌号：{}", plateNum);
            return ObjectResponse.failed(CodeConstants.ERROR_3003);
        }
        return ObjectResponse.success();
    }

    private void tempHandle(String parkCode, String aisleCode, String plateNum, Long parkId, boolean isInPark, ObjectResponse<OrderInfo> orderInfoObjectResponse, ParkConfig parkConfig, FlowCondition.FlowRet flowRet) {
        FlowCondition.ResultCode code;
        Map<String, Object> para = new HashMap<>();
        if (isInPark){
            ObjectResponse<QueryOrderFeeResponse> queryOrderFeeResponseObjectResponse = orderService.p2cQueryFee(orderInfoObjectResponse.getData(), parkConfig,aisleCode);
            ObjectResponse.notError(queryOrderFeeResponseObjectResponse);
            QueryOrderFeeResponse orderFee = queryOrderFeeResponseObjectResponse.getData();
            para.put("orderFee", orderFee);

            String unPayPrice = orderFee.getUnpayPrice();
            if (Float.parseFloat(unPayPrice) == 0) {
                code = FlowCondition.ResultCode.无需缴费;
            } else {
                code = FlowCondition.ResultCode.需缴费;
            }
        }else{
            //todo 远程调试助手只支持小型车的固定计费
            float fixedFee = new FlowCondition().fixedFee(parkConfig,1);
            if (fixedFee == -1){
                code = FlowCondition.ResultCode.无入场记录;
            }else{
                long enterTime = DateTools.unixTimestamp();
                ObjectResponse<Park> parkResp = parkService.findByParkId(parkId);
                QueryOrderFeeResponse queryOrderFeeResponse = carExitFlowProcess.fixedFeeHandle(plateNum, parkResp.getData(), parkCode, aisleCode, PlateColorEnum.BULE.getDesc(), parkConfig, fixedFee, 1, enterTime, null);

                para.put("orderFee", queryOrderFeeResponse);
                code = FlowCondition.ResultCode.固定费用;
            }
        }
        flowRet.setResultCode(code);
        flowRet.setPara(para);
    }

    @Override
    public ObjectResponse payDebug(PayDebugRequest payDebugRequest) {
        String serialNumber;
        try {
            //验证通道相机是否在线
            serialNumber = cacheHandle.getSerialNumber(payDebugRequest.getParkCode(), payDebugRequest.getAisleCode());
        } catch (ResponseBodyException e) {
            return ObjectResponse.failed(e.getErrCode(), e.getMessage());
        }
        Park park = getPark(payDebugRequest.getParkCode());
        CarEnterRequest carEnterRequest = new CarEnterRequest();
        carEnterRequest.setParkId(park.getId());
        carEnterRequest.setParkCode(payDebugRequest.getParkCode());
        carEnterRequest.setEnterTime(DateTools.unixTimestamp());
        carEnterRequest.setPlateNum(payDebugRequest.getPlateNum());
        carEnterRequest.setType(1);
        carEnterRequest.setCarType(1);
        carEnterRequest.setOpenFlag(1);
        carEnterRequest.setEnterWay(OrderCarInfoConstant.IN_OUT_WAY_PLATE_NUM);
        ObjectResponse<CarEnterResult> objectResponse = carOrderEnterService.enter(carEnterRequest);
        if (!ObjectResponse.isSuccess(objectResponse)){
            return ObjectResponse.failed(CodeConstants.ERROR, "订单保存错误");
        }
        CarEnterResult data = objectResponse.getData();
        QueryOrderFeeResponse queryOrderFeeResponse = new QueryOrderFeeResponse();
        queryOrderFeeResponse.setOrderNum(data.getOrderNum());

        queryOrderFeeResponse.setParkName(park.getParkName());

        queryOrderFeeResponse.setPlateNum(payDebugRequest.getPlateNum());
        queryOrderFeeResponse.setEnterTime(DateTools.unixTimestamp());
        queryOrderFeeResponse.setCarType(1);
        queryOrderFeeResponse.setQueryTime(DateTools.unixTimestamp());
        queryOrderFeeResponse.setParkTime(0L);
        queryOrderFeeResponse.setTotalAmount(String.valueOf(payDebugRequest.getPrice()));
        queryOrderFeeResponse.setUnpayPrice(String.valueOf(payDebugRequest.getPrice()));
        queryOrderFeeResponse.setPaidAmount(String.valueOf(0));
        queryOrderFeeResponse.setDiscountAmount(String.valueOf(0));
        queryOrderFeeResponse.setDiscountPrice(String.valueOf(0));
        queryOrderFeeResponse.setStatus(2);
        ObjectResponse<ParkConfig> parkConfigResp = parkService.getParkConfig(park.getId());
        if (!ObjectResponse.isSuccess(parkConfigResp)){
            return ObjectResponse.failed(CodeConstants.ERROR, "车场高级配置未保存");
        }
        queryOrderFeeResponse.setFreeTime((long) parkConfigResp.getData().getIsfreeAfterpay(15));
        CarExitRequest carExitRequest = new CarExitRequest();
        carExitRequest.setParkId(park.getId());
        carExitRequest.setParkCode(payDebugRequest.getParkCode());
        carExitRequest.setExitTime(DateTools.unixTimestamp());
        carExitRequest.setPlateNum(payDebugRequest.getPlateNum());
        carExitRequest.setType(1);
        carExitRequest.setCarType(1);
        carExitRequest.setInandoutCode(payDebugRequest.getAisleCode());
        carExitRequest.setOrderNum(data.getOrderNum());

        Map<String, Object> para = new HashMap<>();
        para.put("fee", queryOrderFeeResponse.getUnpayPrice());
        para.put("parkTime", queryOrderFeeResponse.getParkTime());
        para.put("orderNum", queryOrderFeeResponse.getOrderNum());
        ObjectResponse<ParkInoutdevice> channelResp = parkService.getInOutDeviceByCode(park.getId(), payDebugRequest.getAisleCode());
        ParkInoutdevice channel = channelResp.getData();
        downShowSayHandle.showSayExec(park.getId(), park.getParkCode(), channel.getId(), payDebugRequest.getPlateNum(), carExitRequest.getType(),
                FlowCondition.ResultCode.需缴费, para,
                serialNumber, 2, serialNumber, false);
        cacheHandle.setExit(payDebugRequest.getParkCode(), payDebugRequest.getAisleCode(), carExitRequest);
        cacheHandle.setChannelFee(payDebugRequest.getParkCode(), payDebugRequest.getAisleCode(), queryOrderFeeResponse);

        return ObjectResponse.success();
    }

    @Override
    public ObjectResponse showSayDebug(ShowSayDebugRequest showSayDebugRequest) {
        String plateNum = showSayDebugRequest.getPlateNum();
        String aisleCode = showSayDebugRequest.getAisleCode();
        String parkCode = showSayDebugRequest.getParkCode();
        // 语音显示
        String show = "屏显测试/屏显测试/屏显测试/屏显测试";
        ObjectResponse<ParkInoutdevice> inoutDeviceByCode = parkService.getInoutDeviceByCode(aisleCode);
        String say = "6666";
        if (ObjectResponse.isSuccess(inoutDeviceByCode)) {
            ParkInoutdevice data = inoutDeviceByCode.getData();
            if (Integer.valueOf(1).equals(data.getLedLcdSource())) {
                if (Integer.valueOf(0).equals(data.getTtsType())) {
                    say = "<4>6666<4>";
                }
            } else {
                say = "<D3>6666<D3>";
            }
        }
        Long parkId = getParkId(parkCode);
        String serialNumber = null;
        try {
            serialNumber = cacheHandle.getSerialNumber(parkCode, aisleCode);
        }catch (ResponseBodyException e){
            log.info(e.getMessage());
            return ObjectResponse.failed(e.getErrCode(), e.getMessage());
        }

        ObjectResponse<ParkInoutdevice> channelResp = parkService.getInOutDeviceByCode(parkId, aisleCode);
        ObjectResponse.notError(channelResp);
        ParkInoutdevice channel = channelResp.getData();
        ObjectResponse<?> objectResponse = downShowSayHandle.fixShowSayExec(parkId, parkCode, channel.getId(), plateNum, show, say, "",
                serialNumber, true);
        if (!ObjectResponse.isSuccess(objectResponse)) {
            log.info("<语音屏显测试> 语音显示指令下发失败，车牌号：{}", plateNum);
            return ObjectResponse.failed(CodeConstants.ERROR_3003);
        }
        return ObjectResponse.success();
    }

    @Override
    public ObjectResponse barriergateOper(BarriergateOperRequest barriergateOperRequest) {
        String parkCode = barriergateOperRequest.getParkCode();
        Long parkId = getParkId(parkCode);
        String deviceNo = null;
        try {
            deviceNo = cacheHandle.getSerialNumber(parkCode, barriergateOperRequest.getAisleCode());
        }catch (ResponseBodyException e){
            log.info(e.getMessage());
            return ObjectResponse.failed(e.getErrCode(), e.getMessage());
        }
        ObjectResponse<RemoteSwitchResponse> objectResponse =
                p2c_remoteSwitchService.execute(barriergateOperRequest.getType(), parkId, parkCode, deviceNo, null);
        if (objectResponse != null && objectResponse.getCode().equals(CodeConstants.SUCCESS)){
            RemoteSwitchResponse remoteSwitchResponse = objectResponse.getData();
            if (remoteSwitchResponse.getResult().equals(1)){
                return ObjectResponse.success();
            }else{
                log.info("开关闸失败，返回：{}", remoteSwitchResponse);
            }
        }else{
            log.info("<手动开关闸> 开关闸指令下发失败");
        }
        return  ObjectResponse.failed(CodeConstants.ERROR_3002);
    }
    private Park getPark(String parkCode) {
        ObjectResponse<Park> byParkCode = parkService.findByParkCode(parkCode);
        ObjectResponse.notError(byParkCode);
        return byParkCode.getData();
    }

    /**
     * 通过车场编号获取车场ID
     * @param parkCode
     * @return
     */
    protected Long getParkId(String parkCode) {
        ObjectResponse<Park> byParkCode = parkService.findByParkCode(parkCode);
        ObjectResponse.notError(byParkCode);
        Park park = byParkCode.getData();
        return park.getId();
    }
}
