package com.icetech.park.service.impl;

import com.icetech.cloudcenter.api.ICommonService;
import com.icetech.cloudcenter.domain.request.p2c.PropertyInfoRequest;
import com.icetech.cloudcenter.domain.request.p2c.PropertySetRequest;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.park.service.down.p2c.impl.PropertyGetServiceImpl;
import com.icetech.park.service.down.p2c.impl.PropertySetServiceImpl;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.handle.ItcCacheHandle;
import com.icetech.park.service.handle.ItcDownHandle;
import com.icetech.park.service.handle.MorCacheHandle;
import com.icetech.park.service.handle.MorDownHandle;
import com.icetech.park.service.handle.P2cDownHandle;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.UUIDTools;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Slf4j
public class CommonServiceImpl implements ICommonService {
    @Autowired
    private PropertySetServiceImpl propertySetService;
    @Autowired
    private PropertyGetServiceImpl propertyGetService;
    @Autowired
    private P2cDownHandle downHandle;
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private MorDownHandle morDownHandle;
    @Autowired
    private MorCacheHandle morCacheHandle;
    @Autowired
    private ItcCacheHandle itcCacheHandle;
    @Autowired
    private ItcDownHandle itcDownHandle;

    @Override
    public ObjectResponse<Void> propertySet(PropertySetRequest propertySetRequest, String sn) {
        return propertySetService.send(propertySetRequest, sn);
    }

    @Override
    public ObjectResponse<PropertyInfoRequest> propertyGet(String sn, String topic) {
        return propertyGetService.send(sn, topic);
    }

    @Override
    public ObjectResponse<Void> down(String sn, Object message, String cmd) {
        TokenDeviceVo tokenInfo = cacheHandle.getDeviceInfo(sn);
        boolean success = false;
        if (tokenInfo == null){
            return ObjectResponse.failed(CodeConstants.ERROR_3003);
        }
        if (tokenInfo.getSource() == 1){
            P2cBaseRequest<Object> p2cBaseRequest = new P2cBaseRequest<>();
            p2cBaseRequest.setCmd(cmd);
            p2cBaseRequest.setBizContent(message);
            p2cBaseRequest.setMessageId(UUIDTools.getUuid());
            p2cBaseRequest.setTimestamp(DateTools.unixTimestamp());
            p2cBaseRequest.setToken(tokenInfo.getToken());
            String content = JsonUtils.toString(message);
            success = downHandle.pushAll(sn, p2cBaseRequest);
            log.info("[端云WS下发] 下发{}, sn:[{}], 内容为:{}", success ? "成功" : "失败", sn, content);
        } else {
            log.warn("[端云下发]未知下发通道[{}], sn[{}], 内容为[{}]", tokenInfo.getSource(), sn, message);
        }
        return success ? ObjectResponse.success() : ObjectResponse.failed(CodeConstants.ERROR_3003);
    }
    @Override
    public ObjectResponse<Void> commonDown(int deviceType, String sn, Object message, String cmd) {
        TokenDeviceVo tokenInfo;
        if (deviceType == 9) {
            tokenInfo = morCacheHandle.getDeviceInfo(sn);
        } else if (deviceType == 8) {
            tokenInfo = itcCacheHandle.getDeviceInfo(sn);
        } else {
            tokenInfo = cacheHandle.getDeviceInfo(sn);
        }
        boolean success = false;
        if (tokenInfo == null){
            return ObjectResponse.failed(CodeConstants.ERROR_3003);
        }
        P2cBaseRequest<Object> p2cBaseRequest = new P2cBaseRequest<>();
        p2cBaseRequest.setCmd(cmd);
        p2cBaseRequest.setBizContent(message);
        p2cBaseRequest.setMessageId(UUIDTools.getUuid());
        p2cBaseRequest.setTimestamp(DateTools.unixTimestamp());
        p2cBaseRequest.setToken(tokenInfo.getToken());
        String content = JsonUtils.toString(p2cBaseRequest);

        String protocol = "WS";
        if (deviceType == 9) {
            success = morDownHandle.pushAll(sn, p2cBaseRequest);
        } else if (deviceType == 8) {
            success = itcDownHandle.pushAll(sn, p2cBaseRequest);
        } else {
            if (tokenInfo.getSource() == 1){
                success = downHandle.pushAll(sn, p2cBaseRequest);
            }else{
                protocol = "iot";
            }
        }
        log.info("[端云" + protocol + "下发] 下发{}, sn:[{}], 内容为:{}", success ? "成功" : "失败", sn, content);
        return success ? ObjectResponse.success() : ObjectResponse.failed(CodeConstants.ERROR_3003);
    }
}
