package com.icetech.park.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.icetech.basics.dao.park.ParkDao;
import com.icetech.cloudcenter.api.park.ChannelAlarmService;
import com.icetech.park.dao.other.ChannelAlarmHandlerMapper;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.StringUtils;
import com.icetech.oss.OssService;
import com.icetech.park.domain.entity.ChannelAlarm;
import com.icetech.park.domain.entity.ChannelAlarmHandler;
import com.icetech.cloudcenter.domain.request.ManagerInOutRequest;
import com.icetech.cloudcenter.domain.vo.ChannelAlarmHandlerVo;
import com.icetech.park.service.ChannelAlarmHandlerService;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 进出口报警处理表 服务实现类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2021-07-21
 */
@Service
public class ChannelAlarmHandlerServiceImpl extends BaseServiceImpl<ChannelAlarmHandlerMapper, ChannelAlarmHandler> implements ChannelAlarmHandlerService {

    @Autowired
    private ParkDao parkDao;
    @Autowired
    private ChannelAlarmService channelAlarmService;

    @Resource
    private OssService ossService;

    /**
     * Description: 根据ID查询 进出口报警处理表对象信息 <br>
     * Version1.0 2021-07-21 by wgy创建
     *
     * @param id 对象id
     * @return ChannelAlarmHandler
     */
    @Override
    public ChannelAlarmHandler getChannelAlarmHandlerById (Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  进出口报警处理表对象信息 <br>
     * Version1.0 2021-07-21 by wgy创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addChannelAlarmHandler (ChannelAlarmHandler entity) {
        return save(entity);
    }

    /**
     * Description: 修改 进出口报警处理表对象信息 <br>
     * Version1.0 2021-07-21 by wgy创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyChannelAlarmHandler (ChannelAlarmHandler entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  进出口报警处理表对象信息 <br>
     * Version1.0 2021-07-21 by wgy创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeChannelAlarmHandlerById (Long id) {
        return removeById(id);
    }

    @Override
    public List<ChannelAlarmHandlerVo> getChannelAlarmHandlerVoList(ManagerInOutRequest managerInOutRequest, String parkIds) {
        return this.baseMapper.selectChannelAlarmHandlerVo(new Page<>(managerInOutRequest.getPageNo(), managerInOutRequest.getPageSize()), managerInOutRequest, parkIds);
    }

    @Override
    public ObjectResponse<Boolean> handlerChannelAlarm(String operAccount, Integer parkId, String channelCode) {
        List<ChannelAlarm> channelAlarmList = channelAlarmService.getChannelAlarmByPark(parkId.longValue(), channelCode);
        if (CollectionUtils.isEmpty(channelAlarmList)) {
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
        }
        ChannelAlarmHandler channelAlarmHandler = new ChannelAlarmHandler();
        channelAlarmHandler.setParkId(parkId);
        channelAlarmHandler.setChannelCode(channelCode);
        channelAlarmHandler.setImage(channelAlarmList.get(0).getImage());
        channelAlarmHandler.setOrderNum(channelAlarmList.get(0).getOrderNum());
        channelAlarmHandler.setAlarmTime(channelAlarmList.get(0).getCreateTime());
        channelAlarmHandler.setCreateTime(new Date());
        channelAlarmHandler.setUpdateTime(new Date());
        channelAlarmHandler.setRemark(channelAlarmList.get(0).getRemark());
        channelAlarmHandler.setOperator(operAccount);
        channelAlarmHandler.setChannelAlarmId(channelAlarmList.get(0).getId());
        return ObjectResponse.success(addChannelAlarmHandler(channelAlarmHandler));
    }

    @Override
    public ObjectResponse<List<ChannelAlarmHandlerVo>> getHandlerChannelAlarmList(ManagerInOutRequest managerInOutRequest) {
        String[] split = managerInOutRequest.getParkCode().split(",");
        String parkIds = parkDao.selectByCodes(split);
        if (StringUtils.isNotEmpty(parkIds) && parkIds.endsWith(",")) {
            parkIds = parkIds.substring(0, parkIds.length() - 1);
        }
        List<ChannelAlarmHandlerVo> channelAlarmHandlerVoList = getChannelAlarmHandlerVoList(managerInOutRequest, parkIds);
        if (CollectionUtils.isNotEmpty(channelAlarmHandlerVoList)) {
            channelAlarmHandlerVoList = channelAlarmHandlerVoList.stream().peek(t-> {
                if (StringUtils.isNotEmpty(t.getImage())) {
                    t.setImage(ossService.getImageUrl(t.getImage()));
                }
            }).collect(Collectors.toList());
        }
        return ObjectResponse.success(channelAlarmHandlerVoList);
    }
}
