package com.icetech.park.service.impl;

import cn.hutool.core.util.ReUtil;
import com.icetech.cloudcenter.api.AlarmService;
import com.icetech.cloudcenter.api.call.ICallMobileParkService;
import com.icetech.cloudcenter.api.park.ChannelAlarmService;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.constants.RedisConstants;
import com.icetech.park.domain.entity.ChannelAlarm;
import com.icetech.park.domain.entity.call.CallMobilePark;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.domain.vo.AisleInfoVo;
import com.icetech.third.utils.RedisUtils;
import com.icetech.basics.utils.RegStr;
import com.icetech.common.domain.response.ObjectResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

/**
 * 报警处理
 * @author fangct
 */
@Service
@Slf4j
public class AlarmServiceImpl implements AlarmService {

    @Autowired
    private ChannelAlarmService channelAlarmService;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private ParkService parkService;
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private ICallMobileParkService callMobileParkService;

    /**
     * 失败次数阈值
     */
    private static final int threshold = 2;

    @Override
    public void queryFeeFailHandler(String parkCode, Long parkId, String channelId) {
        String key = RedisConstants.QUERY_FEE_FAIL_PROFILE + parkCode + "_" + channelId;
        if (redisUtils.exists(key)){
            int cs = redisUtils.get(key, Integer.class);
            cs++;
            redisUtils.set(key, cs,60*3);
            if (cs == threshold){
                log.info("准备记录出口异常事件...");
                ChannelAlarm channelAlarm = new ChannelAlarm();
                if (parkId == null) {
                    ObjectResponse<Park> parkObjectResponse = parkService.findByParkCode(parkCode);
                    if (!ObjectResponse.isSuccess(parkObjectResponse)) {
                        log.warn("车场编号不存在[{}]", parkCode);
                        return;
                    }
                    parkId = parkObjectResponse.getData().getId();
                }
                channelAlarm.setParkId(parkId);
                channelAlarm.setChannelCode(channelId);
                channelAlarm.setStatus(1);
                channelAlarm.setAlarmType(1);
                try{
                    channelAlarmService.addAlarm(channelAlarm);
                }catch (Exception e){
                    log.error("异常", e);
                }
            }
        }else{
            redisUtils.set(key, 1,60*3);//第一次失败
        }
    }

    @Override
    public void switchFailHandler(String parkCode, Long parkId, String channelId) {
        String key = RedisConstants.SWITCH_FAIL_PROFILE + parkCode + "_" + channelId;
        if (!redisUtils.exists(key)){
            redisUtils.set(key, 1,60*3);
            if (parkId == null){
                ObjectResponse<Park> parkObjectResponse = parkService.findByParkCode(parkCode);
                ObjectResponse.notError(parkObjectResponse);
                parkId = parkObjectResponse.getData().getId();
            }
            ChannelAlarm channelAlarm = new ChannelAlarm();
            channelAlarm.setParkId(parkId);
            channelAlarm.setChannelCode(channelId);
            channelAlarm.setStatus(1);
            channelAlarm.setAlarmType(2);
            channelAlarmService.addAlarm(channelAlarm);
        }
    }

    @Override
    public void yuneasyCallHandler(String serialNumber) {
        // 设置手机号
        Long channelId = null;
        Long parkId = null;
        if (ReUtil.isMatch(RegStr.MOBILE,serialNumber)){
            CallMobilePark query = new CallMobilePark();
            query.setMobile(serialNumber);
            ObjectResponse<CallMobilePark> one = callMobileParkService.getOne(query);
            if (ObjectResponse.isSuccess(one)){
                CallMobilePark callMobilePark = one.getData();
                if (callMobilePark.getChannelId() != null) {
                    channelId = Long.valueOf(callMobilePark.getChannelId());
                }
                if (callMobilePark.getParkId() != null) {
                    parkId = Long.valueOf(callMobilePark.getParkId());
                }
            }
        }else {
            ObjectResponse<ParkDevice> parkDeviceResp = parkDeviceService.getDeviceBySerialNumber(serialNumber);
            if (!ObjectResponse.isSuccess(parkDeviceResp)) {
                return;
            }
            ParkDevice parkDevice = parkDeviceResp.getData();
            if (parkDevice.getChannelId() != null) {
                channelId = Long.valueOf(parkDevice.getChannelId());
            }
            parkId = parkDevice.getParkId();

        }

        if (parkId == null){
            return;
        }

        ParkInoutdevice parkInoutdevice = null;
        if (null != channelId){
            ObjectResponse<ParkInoutdevice> inoutDeviceObjectResponse = parkService.getInoutDeviceById(channelId);
            if (!ObjectResponse.isSuccess(inoutDeviceObjectResponse)) {
                return;
            }
            parkInoutdevice = inoutDeviceObjectResponse.getData();
        }

        ChannelAlarm channelAlarm = new ChannelAlarm();
        channelAlarm.setParkId(parkId);
        channelAlarm.setChannelCode(Objects.isNull(parkInoutdevice)?null:parkInoutdevice.getInandoutCode());
        channelAlarm.setStatus(1);
        channelAlarm.setAlarmType(3);
        channelAlarm.setRemark(serialNumber);
        channelAlarmService.addAlarm(channelAlarm);
    }

    @Override
    public void aisleDurationAlarm(AisleInfoVo aisleInfoVo) {
        ChannelAlarm channelAlarm = new ChannelAlarm();
        channelAlarm.setParkId(aisleInfoVo.getParkId());
        channelAlarm.setChannelCode(aisleInfoVo.getAisleCode());
        channelAlarm.setOrderNum(aisleInfoVo.getOrderNum());
        channelAlarm.setStatus(1);
        channelAlarm.setAlarmType(4);
        channelAlarm.setImage(aisleInfoVo.getImage());
        channelAlarmService.addAlarm(channelAlarm);
    }

    @Deprecated
    @Override
    public List<ChannelAlarm> getAlarmsByChannelCode(Long parkId, String channelCode) {
        return Collections.emptyList();
    }
}
