package com.icetech.park.service.handle.showsay;

import com.icetech.park.service.flow.p2c.FlowCondition;

import java.util.Arrays;
import java.util.List;

/**
 * 显示播报的常量
 * @author fangct
 */
public class ShowSayConstants {
    /**
     * 出口显示二维码的结果集
     */
    public static List<FlowCondition.ResultCode> QR_RESULT_LIST = Arrays.asList(new FlowCondition.ResultCode[]{
            FlowCondition.ResultCode.需缴费, FlowCondition.ResultCode.固定费用, FlowCondition.ResultCode.无牌车允许进出, FlowCondition.ResultCode.欠费补缴
    });
    /**
     * 需支付的结果集
     */
    public static List<FlowCondition.ResultCode> PAY_LIST = Arrays.asList(new FlowCondition.ResultCode[]{
            FlowCondition.ResultCode.需缴费, FlowCondition.ResultCode.固定费用, FlowCondition.ResultCode.欠费补缴
    });
    /**
     * 入口显示二维码
     */
    public static List<FlowCondition.ResultCode> ENTER_QR_RESULT_LIST = Arrays.asList(new FlowCondition.ResultCode[]{
            FlowCondition.ResultCode.无牌车允许进出, FlowCondition.ResultCode.欠费补缴
    });
    /**
     * 无需缴费的结果集
     */
    public static List<FlowCondition.ResultCode> NO_FEE_RESULT_LIST = Arrays.asList(new FlowCondition.ResultCode[]{
            FlowCondition.ResultCode.无需缴费, FlowCondition.ResultCode.免费时间内, FlowCondition.ResultCode.无入场有全免优惠
    });

}
