package com.icetech.park.service.handle.showsay;

import com.icetech.basics.domain.entity.VipType;
import com.icetech.cloudcenter.api.lcd.LcdService;
import com.icetech.cloudcenter.api.lcd.LedService;
import com.icetech.cloudcenter.api.month.MonthCarService;
import com.icetech.cloudcenter.api.month.VipCarService;
import com.icetech.cloudcenter.api.order.OrderPayService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.common.domain.response.PageQuery;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.park.dao.park.ParkFreespaceDao;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.order.domain.entity.OrderTags;
import com.icetech.park.domain.entity.lcd.LcdConfig;
import com.icetech.park.domain.entity.led.LedConfig;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.domain.request.itc.HintRequest;
import com.icetech.cloudcenter.domain.response.MonthDetailDto;
import com.icetech.park.service.flow.p2c.FlowCondition;
import com.icetech.order.service.OrderTagsService;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

@Component
@Slf4j
public class ShowSayBaseHandle {

    @Resource
    private MonthCarService monthCarService;
    @Resource
    private LedService ledSoundService;
    @Resource
    private LcdService lcdService;
    @Resource
    private ParkFreespaceDao parkFreespaceDao;
    @Resource
    private ParkService parkService;
    @Resource
    private OrderTagsService orderTagsService;
    @Resource
    private ParkRegionDao parkRegionDao;
    @Resource
    private VipCarService vipCarService;
    @Resource
    private OrderPayService orderPayService;

    public Integer getMonthCarRemainDays(Long parkId, Long channelId,
                            String plateNum, Map<String, Object> param) {
        Integer days = (Integer) param.get("days");
        if (days != null) {
            return days == -1 || days == -2 ? null : days;
        }
        param.put("days", -1);
        Long regionId = param.get("regionId") == null ? null : (Long) param.get("regionId");
        ObjectResponse<MonthDetailDto> infoObjectResponse = monthCarService.getMonthCarDetail(parkId, plateNum, regionId);
        if (!ObjectResponse.isSuccess(infoObjectResponse)) {
            return null;
        }
        MonthDetailDto dto = infoObjectResponse.getData();
        MonthDetailDto.MonthType monthType = dto.getMonthType();
        switch (monthType) {
            case 非月卡车:
            case 多位多车占用:
                //临时车
                param.put("days", -2);
                break;
            case 月卡车:
                param.put("type", 2);
                Integer ledLcdSource = (Integer) param.get("ledLcdSource");
                if (ledLcdSource == null) {
                    param.put("days", dto.getUnexpiredDays() == null ? 0 : dto.getUnexpiredDays());
                    param.put("isMonth", true);
                    break;
                }
                if (Integer.valueOf(2).equals(ledLcdSource)) {
                    ObjectResponse<LcdConfig> lcdConfigObjectResponse = lcdService.getLcdConfigByChannel(channelId);
                    LcdConfig lcdConfig = lcdConfigObjectResponse.getData();
                    Integer unexpiredDays = dto.getUnexpiredDays();
                    if (lcdConfig.getRemainDaysMc() == 0 || unexpiredDays <= lcdConfig.getRemainDaysMc()) {
                        param.put("days", unexpiredDays);
                        param.put("isMonth", true);
                        break;
                    }
                } else {
                    ObjectResponse<LedConfig> ledsoundConfigObjectResponse = ledSoundService.getLedConfigByChannel(channelId);
                    LedConfig parkLedSoundConfig = ledsoundConfigObjectResponse.getData();
                    Integer unexpiredDays = dto.getUnexpiredDays();
                    if (parkLedSoundConfig.getLedRemainDaysMc() == 0 || unexpiredDays <= parkLedSoundConfig.getLedRemainDaysMc()) {
                        param.put("days", unexpiredDays);
                        param.put("isMonth", true);
                        break;
                    }
                }
                break;
            case 过期临时车:
                param.put("days", 0);
                param.put("isMonth", false);
                break;
            case 过期月卡车:
                param.put("days", 0);
                param.put("isMonth", true);
                break;
            default:
                break;
        }
        days = (Integer) param.get("days");
        return days == -1 ||  days == -2 ? null : days;
    }

    public String getFreeSpaceName(Long parkId, Long channelId, Map<String, Object> param) {
        String freeSpaceName = (String) param.get("freeSpaceName");
        //必须用 == 判断，值为空串时，也是直接返回
        if (freeSpaceName == null) {
            getFreeSpace(parkId, channelId, param);
            freeSpaceName = (String) param.get("freeSpaceName");
        }
        return freeSpaceName;
    }
    public Integer getFreeSpace(Long parkId, Long channelId, Map<String, Object> param) {
        Integer freeSpace = (Integer) param.get("freeSpace");
        if (freeSpace != null) {
            return freeSpace;
        }
        String freeSpaceName = "";
        ObjectResponse<Park> parkObjectResponse = parkService.findByParkId(parkId);
        if (ObjectResponse.isSuccess(parkObjectResponse)) {
            Park park = parkObjectResponse.getData();
            if (NumberUtils.toPrimitive(park.getIsInterior()) == 1) {
                Integer ledLcdSource = getLedLcdSource(channelId, param);
                Long regionIdFreeSpace = 0L;
                if (ledLcdSource == 1) {
                    ObjectResponse<LedConfig> objectResponse = ledSoundService.getLedConfigByChannel(channelId);
                    if (ObjectResponse.isSuccess(objectResponse)) {
                        regionIdFreeSpace = objectResponse.getData().getRegionFreeSpace();
                    }
                } else {
                    ObjectResponse<LcdConfig> objectResponse = lcdService.getLcdConfigByChannel(channelId);
                    if (ObjectResponse.isSuccess(objectResponse)) {
                        regionIdFreeSpace = objectResponse.getData().getRegionFreeSpace();
                    }
                }
                if (regionIdFreeSpace == null || regionIdFreeSpace == 0) {
                    freeSpace = parkFreespaceDao.selectParkFree(parkId);
                } else {
                    ParkRegion parkRegion = parkRegionDao.selectById(regionIdFreeSpace);
                    if (parkRegion != null) {
                        freeSpace = parkRegion.getFreePark();
                        freeSpaceName = parkRegion.getRegionName();
                    }
                }
            } else {
                freeSpace = parkFreespaceDao.selectParkFree(parkId);
            }
        }
        if (freeSpace == null) {
            freeSpace = 0;
        }
        if (freeSpace < 0) {
            freeSpace = 0;
        }
        param.put("freeSpace", freeSpace);
        param.put("freeSpaceName", freeSpaceName);
        return freeSpace;
    }

    public Integer setAndGetPlateType(FlowCondition.ResultCode resultCode, Long parkId, Long channelId,
                                      String plateNum, Integer currType, Map<String, Object> param) {
        Integer type = (Integer) param.get("type");
        if (type != null) {
            if (param.get("showTypeStr") == null) {
                param.put("showTypeStr", PlateTypeEnum.getName(type));
                param.put("sayTypeStr", PlateTypeEnum.getName(type));
            }
            return type;
        }
        String replaceContent;
        if (resultCode.equals(FlowCondition.ResultCode.黑名单车)) {
            param.put("type", 7);
            param.put("showTypeStr", "黑名单车");
            param.put("sayTypeStr", "黑名单车");
            return 7;
        }
        if (PlateTypeEnum.VIP车辆.getType().equals(currType)) {
            if (param.get("carDesc") == null) {
                ObjectResponse<VipType> recentVipCar = vipCarService.getRecentVipCar(parkId, plateNum, null);
                if (ObjectResponse.isSuccess(recentVipCar)){
                    VipType vipType = recentVipCar.getData();
                    param.put("type", 4);
                    param.put("showTypeStr", vipType.getName());
                    param.put("sayTypeStr", vipType.getName());
                    return 4;
                }
            } else {
                param.put("type", 4);
                param.put("showTypeStr", param.get("carDesc"));
                param.put("sayTypeStr", param.get("carDesc"));
                return 4;
            }
        }
        if (resultCode.equals(FlowCondition.ResultCode.月卡车)) {
            param.put("type", 2);
            param.put("showTypeStr", PlateTypeEnum.月卡车.name());
            param.put("sayTypeStr", PlateTypeEnum.月卡车.name());
            return 2;
        }
        String typeName = PlateTypeEnum.getName(currType);
        if (!PlateTypeEnum.临时车.getType().equals(currType) && !PlateTypeEnum.月卡车.getType().equals(currType)){
            param.put("type", currType);
            param.put("showTypeStr", typeName);
            param.put("sayTypeStr", typeName);
            return currType;
        }
        String regionName = param.get("otherRegionNameMc") == null ? null : param.get("otherRegionNameMc").toString();
        if (regionName != null) {
            param.put("type", 2);
            param.put("showTypeStr", regionName + PlateTypeEnum.月卡车.name());
            param.put("sayTypeStr", regionName + PlateTypeEnum.月卡车.name());
            return 2;
        }
        String otherRegionNameVip = param.get("otherRegionNameVip") == null ? null : param.get("otherRegionNameVip").toString();
        if (otherRegionNameVip != null) {
            param.put("type", 4);
            param.put("showTypeStr", otherRegionNameVip + param.get("carDesc"));
            param.put("sayTypeStr", otherRegionNameVip + param.get("carDesc"));
            return 4;
        }
        Long regionId = param.get("regionId") == null ? null : (Long) param.get("regionId");
        ObjectResponse<MonthDetailDto> infoObjectResponse = monthCarService.getMonthCarDetail(parkId, plateNum, regionId);
        if (!ObjectResponse.isSuccess(infoObjectResponse)) {
            param.put("type", currType);
            param.put("showTypeStr", typeName);
            param.put("sayTypeStr", typeName);
            return currType;
        }
        if (FlowCondition.ResultCode.有牌车不允许临时车进入.equals(resultCode)) {
            param.put("type", PlateTypeEnum.临时车.getType());
            param.put("showTypeStr", PlateTypeEnum.临时车.name());
            param.putIfAbsent("sayTypeStr", PlateTypeEnum.临时车.name());
            return PlateTypeEnum.临时车.getType();
        }
        MonthDetailDto dto = infoObjectResponse.getData();
        MonthDetailDto.MonthType monthType = dto.getMonthType();
        String orderNum = (String) param.get("orderNum");
        switch (monthType) {
            case 非月卡车:
                replaceContent = PlateTypeEnum.临时车.name();
                param.put("type", 1);
                break;
            case 多位多车占用:
                if (StringUtils.isNotBlank(orderNum)) {
                    OrderTags orderTags = orderTagsService.getListByOrderNumAndTagId(orderNum, 1, regionId);
                    if (orderTags != null) {
                        replaceContent = PlateTypeEnum.临时车.name() + " " + orderTags.getRemark();
                        param.put("type", 1);
                        param.put("sayTypeStr", PlateTypeEnum.临时车.name());
                        break;
                    }
                }
                replaceContent = PlateTypeEnum.临时车.name();
                param.put("type", 1);
                break;
            case 过期月卡车:
                if (isShowExpireMc(dto, parkId, channelId, param)) {
                    replaceContent = "过期卡";
                    param.put("type", 8);
                } else {
                    replaceContent = PlateTypeEnum.月卡车.name();
                    param.put("type", 2);
                }
                break;
            case 过期临时车:
                if (isShowExpireMc(dto, parkId, channelId, param)) {
                    replaceContent = "过期卡";
                    param.put("type", 8);
                } else {
                    replaceContent = PlateTypeEnum.临时车.name();
                    param.put("type", 1);
                }
                break;
            case 月卡车:
                if (StringUtils.isNotBlank(orderNum)) {
                    OrderTags orderTags = orderTagsService.getListByOrderNumAndTagId(orderNum, 1, regionId);
                    if (orderTags != null) {
                        replaceContent = PlateTypeEnum.月卡车.name() + " " + orderTags.getRemark();
                        param.put("type", 2);
                        param.put("sayTypeStr", PlateTypeEnum.月卡车.name());
                        break;
                    }
                }
                replaceContent = PlateTypeEnum.月卡车.name();
                param.put("type", 2);
                break;
            default:
                replaceContent = typeName;
                param.put("type", currType);
                break;
        }
        Integer enexType = (Integer) param.get("enexType");
        String channelCode = (String) param.get("channelCode");
        if (NumberUtils.toPrimitive(enexType) == 1 && channelCode != null) {
            ParkRegion monthCardOtherRegion = monthCarService.findMonthCardOtherRegion(parkId, plateNum, channelCode);
            if (monthCardOtherRegion != null) {
                replaceContent = monthCardOtherRegion.getRegionName() + PlateTypeEnum.月卡车.name();
                param.put("type", 2);
            }
        }
        param.put("showTypeStr", replaceContent);
        param.putIfAbsent("sayTypeStr", replaceContent);
        return (Integer) param.get("type");
    }

    private boolean isShowExpireMc(MonthDetailDto monthDetailDto, Long parkId, Long channelId, Map<String, Object> param){
        Integer ledLcdSource = getLedLcdSource(channelId, param);
        if (Integer.valueOf(1).equals(ledLcdSource)) {
            if (!MonthDetailDto.MonthType.过期临时车.equals(monthDetailDto.getMonthType())
                    && !MonthDetailDto.MonthType.过期月卡车.equals(monthDetailDto.getMonthType())) {
                return false;
            }
            //根据屏显的过期月卡配置判断是否可以作为月卡车
            ObjectResponse<LedConfig> objectResponse = ledSoundService.getLedConfigByChannel(channelId);
            if (!ObjectResponse.isSuccess(objectResponse)) {
                return false;
            }
            LedConfig ledConfig = objectResponse.getData();
            return ledConfig.getLedExpireDaysMc() != null && monthDetailDto.getExpiredDays() != null
                    && ledConfig.getLedExpireDaysMc() >= monthDetailDto.getExpiredDays();
        }
        if (Integer.valueOf(2).equals(ledLcdSource)) {
            if (!MonthDetailDto.MonthType.过期临时车.equals(monthDetailDto.getMonthType())
                    && !MonthDetailDto.MonthType.过期月卡车.equals(monthDetailDto.getMonthType())) {
                return false;
            }
            //根据屏显的过期月卡配置判断是否可以作为月卡车
            ObjectResponse<LcdConfig> objectResponse = lcdService.getLcdConfigByChannel(channelId);
            if (!ObjectResponse.isSuccess(objectResponse)) {
                return false;
            }
            LcdConfig lcdConfig = objectResponse.getData();
            return lcdConfig.getExpireDaysMc() != null
                    && lcdConfig.getExpireDaysMc() >= monthDetailDto.getExpiredDays();
        }
        return false;
    }

    private Integer getLedLcdSource(Long channelId, Map<String, Object> param) {
        //LED/LCD配置的来源
        Integer ledLcdSource = (Integer) param.get("ledLcdSource");
        if (ledLcdSource == null) {
            ObjectResponse<ParkInoutdevice> channelResp = parkService.getInoutDeviceById(channelId);
            ParkInoutdevice channel = channelResp.getData();
            //LCD的道通控制卡存在LED相关表中
            ledLcdSource = channel.getLedLcdSource();
            param.put("ledLcdSource", ledLcdSource);
        }
        return ledLcdSource;
    }


    public int getSceneByResultCode(FlowCondition.ResultCode resultCode, int enexType) {
        int scene = 0;
        switch (resultCode) {
            case 月卡车:
                if (enexType == 1) {
                    scene = HintRequest.Scene.MONTH_CAR_ENTER.getVal();
                    break;
                } else {
                    scene = HintRequest.Scene.NO_FEE_EXIT.getVal();
                    break;
                }
            case 黑名单车:
                if (enexType == 1) {
                    scene = HintRequest.Scene.BLACK_NOT_ALLOW_CAR_ENTER.getVal();
                    break;
                } else {
                    scene = HintRequest.Scene.NOT_ALLOW_EXIT.getVal();
                    break;
                }
            case 有牌车允许临时车进入:
                scene = HintRequest.Scene.OTHER_ENTER.getVal();
                break;
            case 有牌车不允许临时车进入:
                scene = HintRequest.Scene.OTHER_CAR_NOT_ALLOW_ENTER.getVal();
                break;
            case 无牌车允许进出:
                if (enexType == 1) {
                    scene = HintRequest.Scene.NO_PLATE_ENTER.getVal();
                    break;
                } else {
                    scene = HintRequest.Scene.NO_PLATE_EXIT.getVal();
                    break;
                }
            case 无牌车不允许进入:
                scene = HintRequest.Scene.OTHER_CAR_NOT_ALLOW_ENTER.getVal();
                break;
            case 特殊车辆免费:
            case 免费时间内:
            case 无入场有全免优惠:
            case 预缴费未超时:
            case 无需缴费:
                scene = HintRequest.Scene.NO_FEE_EXIT.getVal();
                break;
            case 无入场记录:
                scene = HintRequest.Scene.NO_ORDER_EXIT.getVal();
                break;
            case 固定费用:
            case 需缴费:
            case 欠费补缴:
                scene = HintRequest.Scene.NEED_PAY_EXIT.getVal();
                break;
            case VIP车辆:
                scene = HintRequest.Scene.OTHER_ENTER.getVal();
                break;
            case 车位已满禁止入场:
                scene = HintRequest.Scene.FULL_NOT_ALLOW_ENTER.getVal();
                break;
            case 黄牌车禁止入场:
                scene = HintRequest.Scene.OTHER_CAR_NOT_ALLOW_ENTER.getVal();
                break;
            case 内部车辆:
                scene = HintRequest.Scene.MONTH_CAR_ENTER.getVal();
                break;
            case 过期卡:
                scene = HintRequest.Scene.OTHER_ENTER.getVal();
                break;
            case 车位已占:
                scene = HintRequest.Scene.MULTI_SPACE_NOT_ALLOW_ENTER.getVal();
                break;
            case 缴费后屏显播报:
                scene = HintRequest.Scene.NO_FEE_EXIT.getVal();
                break;
            case 访客车:
                scene = HintRequest.Scene.OTHER_ENTER.getVal();
                break;
            case 储值卡车允许进入:
                scene = HintRequest.Scene.OTHER_ENTER.getVal();
                break;
            case 储值卡车禁止进入:
                scene = HintRequest.Scene.OTHER_CAR_NOT_ALLOW_ENTER.getVal();
                break;
            case 储值卡过期:
                scene = HintRequest.Scene.OTHER_CAR_NOT_ALLOW_ENTER.getVal();
                break;
            case 储值卡车:
                scene = HintRequest.Scene.OTHER_ENTER.getVal();
                break;
            case 无入场VIP全免车:
                scene = HintRequest.Scene.NO_FEE_EXIT.getVal();
                break;
            case 不允许临时车出:
                scene = HintRequest.Scene.NOT_ALLOW_EXIT.getVal();
                break;
            default:
                break;
        }
        return scene;
    }

    public String getPayWay(Map<String, Object> param) {
        if (param == null || param.isEmpty()) {
            return null;
        }
        if (param.containsKey("payWay")) {
            return param.get("payWay") == null ? null : param.get("payWay").toString();
        }
        String orderNum = (String) param.get("orderNum");
        if (StringUtils.isEmpty(orderNum)) {
            return null;
        }
        OrderPay orderPayParam = new OrderPay();
        orderPayParam.setOrderNum(orderNum);
        orderPayParam.setPayStatus(2);
        PageQuery<OrderPay> orderPayParamPageQuery = new PageQuery<>();
        orderPayParamPageQuery.setParam(orderPayParam);
        ObjectResponse<List<OrderPay>> listObjectResponse = orderPayService.findList(orderPayParamPageQuery);
        if (!ObjectResponse.isSuccess(listObjectResponse)) {
            return null;
        }
        List<OrderPay> orderPays = listObjectResponse.getData();
        if (orderPays == null || orderPays.size() == 0) {
            return null;
        }
        String payWayStr = "";
        OrderPay orderPay = orderPays.get(0);
        Integer payWay = orderPay.getPayWay();
        if (payWay == null) {
            return payWayStr;
        }
        switch (payWay) {
            case 1:
                payWayStr = "现金";
                break;
            case 2:
                payWayStr = "微信";
                break;
            case 3:
                payWayStr = "支付宝";
                break;
            case 4:
                payWayStr = "银联";
                break;
            case 6:
                payWayStr = "ETC";
                break;
            case 10:
                payWayStr = "优惠抵扣";
                break;
            default:
                break;
        }
        return payWayStr;
    }
}
