package com.icetech.park.service.handle.showsay;

import cn.hutool.core.util.StrUtil;
import com.icetech.cloudcenter.api.lcd.LedService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.store.StoreCardService;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.park.domain.entity.led.LedConfig;
import com.icetech.park.domain.entity.led.LedShow;
import com.icetech.park.domain.entity.led.LedTips;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.domain.enumeration.ShowTypeEnum;
import com.icetech.cloudcenter.domain.response.LedShowDto;
import com.icetech.cloudcenter.domain.response.MonthDetailDto;
import com.icetech.park.service.IShowVoiceHandle;
import com.icetech.park.service.flow.p2c.FlowCondition;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;

/**
 * LED显示屏处理
 * @author fangct
 */
@Component
@Slf4j
public class LedShowHandle implements IShowVoiceHandle {

    @Autowired
    private LedService ledSoundService;
    @Value("${datacenter.exitPayUrl}")
    private String exitPayUrl;
    @Value("${datacenter.enterPayUrl}")
    private String enterPayUrl;
    @Autowired
    private StoreCardService storeCardService;
    @Autowired
    private ShowSayBaseHandle showSayBaseHandle;
    @Autowired
    private ParkRegionDao parkRegionDao;

    public static final String ROW1 = "注意安全";
    public static final String ROW2 = "一车一杆";
    public static final String ROW3 = "减速慢行";
    public static final String ROW4 = "剩余车位：%";
    public static final String SPLIT = "/";
    public static final String CUS_ROW1 = "余位%";
    public static final String CUS_ROW2 = "余位余位";
    //竖屏、小竖屏
    private static final Integer[] STYLE_ARR = {2, 3};

    /**
     * 初始化成4行屏显
     * @param freeSpace 空车位
     * @return 补全内容
     */
    public static String complement4Rows(String freeSpace){
        return complement4Rows(null, freeSpace);
    }
    /**
     * 两行屏
     */
    public static String complement2Rows(String freeSpace){
        String content = CUS_ROW1 + SPLIT + CUS_ROW2+SPLIT+CUS_ROW1 + SPLIT + CUS_ROW2;
        return content.replace("%",freeSpace);
    }

    /**
     * 获取显示类型
     * @param parkId 车场ID
     * @return 显示类型
     */
    public int getShowType(Long parkId, Long channelId){
        ObjectResponse<LedConfig> parkLedSoundConfigObjectResponse = ledSoundService.getLedConfigByChannel(channelId);
        if (ObjectResponse.isSuccess(parkLedSoundConfigObjectResponse)){
            LedConfig ledConfig = parkLedSoundConfigObjectResponse.getData();
            Integer ledQrcodeRule = ledConfig.getLedQrcodeRule();
            if (ledQrcodeRule != null && ledQrcodeRule == 1){
                return ShowTypeEnum.动态二维码.getVal();
            }else{
                return ShowTypeEnum.普通文本.getVal();
            }
        }
        return ShowTypeEnum.普通文本.getVal();
    }

    /**
     * 补全成4行屏显
     * @param content 内容
     * @param freeSpace 空车位
     * @return 响应
     */
    public static String complement4Rows(String content, String freeSpace){
        if (content == null || content.trim().length() == 0){
            return ROW1 + SPLIT + ROW2 + SPLIT + ROW3 + SPLIT + ROW4.replace("%", freeSpace);
        }
        String[] rowsContent = content.split("/");
        if (rowsContent.length == 1){
            content += SPLIT + ROW2 + SPLIT + ROW3 + SPLIT + ROW4.replace("%", freeSpace);
        }else if (rowsContent.length == 2){
            content += SPLIT + ROW3 + SPLIT + ROW4.replace("%", freeSpace);
        }else if (rowsContent.length == 3){
            content += SPLIT + ROW4.replace("%", freeSpace);
        }
        return content;
    }

    private static String line2Parks = "P1574069875, P1574069698, P1574070102, P1573036782,P1576060397," +
            "P1574069698,P1574069875,P1574070102,P1576477906,P1576478969,P1576479065,P1576479113,P1576479173," +
            "P1576479243,P1576479294,P1576479350,P1576479423,P1576479490";
    /**
     * 需缴费
     * @return 显示内容
     */
    public static String needPay(String parkCode, String plateNum, Long parkTime, String unpayPrice){
        if (line2Parks.contains(parkCode)){
            return plateNum + "/时长：" + DateTools.secondToSecondsTime(parkTime.intValue()) + "，请缴费" + unpayPrice + "元";
        }else {
            return plateNum + "/停车" + DateTools.secondToSecondsTime(parkTime.intValue())
                    + "/缴费" + unpayPrice + "元/请扫码缴费";
        }

    }

    @Autowired
    private ParkService parkService;

    public String enterHandle(Long parkId, Long channelId, String plateNum, Integer type, Map<String, Object> para) {
        if (PlateTypeEnum.月卡车.getType().equals(type) || PlateTypeEnum.VIP车辆.getType().equals(type)){
            return enterHandle(parkId, channelId, plateNum, type, FlowCondition.ResultCode.月卡车, para);
        }else{
            return enterHandle(parkId, channelId, plateNum, type, FlowCondition.ResultCode.有牌车允许临时车进入, para);
        }
    }
    @Override
    public String enterHandle(Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para) {
        if (ShowSayConstants.ENTER_QR_RESULT_LIST.contains(resultCode) && getShowType(parkId, channelId) == 2) {
            ObjectResponse<ParkInoutdevice> channelResp = parkService.getInoutDeviceById(channelId);
            ObjectResponse.notError(channelResp);
            ParkInoutdevice channel = channelResp.getData();
            //B2相机控制卡，两块屏
            if (NumberUtils.toPrimitive(channel.getLedcardType()) == 2 || NumberUtils.toPrimitive(channel.getLedcardType()) == 4){
                return StringUtils.joinWith("|", generateContent(parkId, channelId, plateNum, type, resultCode, para, LedShow.DisplayTypeEnum.入场显示.type), enterPayUrl);
            }
            return enterPayUrl;
        }
        return generateContent(parkId, channelId, plateNum, type, resultCode, para, LedShow.DisplayTypeEnum.入场显示.type);
    }

    @Override
    public String exitHandle(Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para) {
        if (ShowSayConstants.QR_RESULT_LIST.contains(resultCode) && getShowType(parkId, channelId) == 2) {
            ObjectResponse<ParkInoutdevice> channelResp = parkService.getInoutDeviceById(channelId);
            ObjectResponse.notError(channelResp);
            ParkInoutdevice channel = channelResp.getData();
            //B2相机控制卡，两块屏
            if (NumberUtils.toPrimitive(channel.getLedcardType()) == 2 || NumberUtils.toPrimitive(channel.getLedcardType()) == 4){
                return StringUtils.joinWith("|", generateContent(parkId, channelId, plateNum, type, resultCode, para, LedShow.DisplayTypeEnum.出场显示.type), exitPayUrl);
            }
            return exitPayUrl;
        }
        return generateContent(parkId, channelId, plateNum, type, resultCode, para, LedShow.DisplayTypeEnum.出场显示.type);
    }
    @Override
    public String enterFreeHandle(Long parkId, Long channelId, Map<String, Object> para) {
        return generateContent(parkId, channelId, null, null, null, para, LedShow.DisplayTypeEnum.入口空闲显示.type);
    }

    @Override
    public String exitFreeHandle(Long parkId, Long channelId, Map<String, Object> para) {
        return generateContent(parkId, channelId, null, null, null, para, LedShow.DisplayTypeEnum.出口空闲显示.type);
    }

    /**
     * 获取第四行配置内容
     * @param parkId 车场ID
     * @param plateNum 车牌号
     * @param type 车辆类型
     * @param resultCode 处理结果
     * @param para 参数MAP
     * @param displayType 显示类型
     * @return 显示内容
     */
    public String generate4LineContent(Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para, int displayType) {
        ObjectResponse<LedShowDto> ledVoObjectResponse = ledSoundService.getLedShowByType(channelId, displayType);
        String content = ledVoObjectResponse.getData().getContent();
        if (StrUtil.isNotBlank(content)){
            String[] split = content.split("/");
            if (split.length == 4){
                String line4 = split[3];
                return generateContent(parkId, channelId, plateNum, type, resultCode, para, line4);
            }
        }
        return "";
    }
    /**
     * 生成最终要显示的内容
     * @param parkId 车场ID
     * @param plateNum 车牌号
     * @param type 车辆类型
     * @param resultCode 处理结果
     * @param para 参数MAP
     * @param displayType 显示类型
     * @return 响应
     */
    private String generateContent(Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para, int displayType) {
        ObjectResponse<LedShowDto> ledVoObjectResponse = ledSoundService.getLedShowByType(channelId, displayType);
        String content = ledVoObjectResponse.getData().getContent();
        return generateContent(parkId, channelId, plateNum, type, resultCode, para, content);
    }

    private String generateContent(Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para, String content) {
        String[] dynamicValues = StringUtils.findBraceValue(content);
        for (String value : dynamicValues) {
            int dynamicValue = Integer.parseInt(value);
            if (dynamicValue == LedShow.VariateEnum.停车场名称.type) {
                Object parkName = para.get("parkName");
                if (parkName == null) {
                    ObjectResponse<Park> parkObjectResponse = parkService.findByParkId(parkId);
                    para.put("parkName", parkObjectResponse.getData().getParkName());
                }
            } else if (dynamicValue == LedShow.VariateEnum.月卡剩余天数.type && PlateTypeEnum.月卡车.getType().equals(type)) {
                Integer days = showSayBaseHandle.getMonthCarRemainDays(parkId, channelId, plateNum, para);
                if (days == null) {
                    content = content.replace("{" + dynamicValue + "}", "");
                    if (NumberUtils.toPrimitive((Integer) para.get("days")) == -2) {
                        type = PlateTypeEnum.临时车.getType();
                    }
                    continue;
                }
            }
            content = content.replace("{" + dynamicValue + "}", getReplaceContent(dynamicValue, parkId, channelId, plateNum, type, resultCode, para));
        }
        return content;
    }

    private String getReplaceContent(int dynamicValue, Long parkId, Long channelId, String plateNum, Integer type,
                                     FlowCondition.ResultCode resultCode, Map<String, Object> para) {
        String replaceContent = "";
        switch (dynamicValue) {
            case 1://当前时间
                Date date = new Date();
                replaceContent = DateTools.getFormat(DateTools.DF_CN, date);
                break;
            case 2://今日限号
                ObjectResponse<LedConfig> ledsoundConfigObjectResponse = ledSoundService.getLedConfigByChannel(channelId);
                LedConfig parkLedSoundConfig = ledsoundConfigObjectResponse.getData();
                Integer limitType = parkLedSoundConfig.getLimitType();
                int week = Integer.parseInt(DateTools.getWeek());
                if (limitType == 0){//尾号限行
                    if (week == 1){
                        replaceContent = "今日限号" + parkLedSoundConfig.getLimitDriveNum1();
                    }else if (week == 2){
                        replaceContent = "今日限号" + parkLedSoundConfig.getLimitDriveNum2();
                    }else if (week == 3){
                        replaceContent = "今日限号" + parkLedSoundConfig.getLimitDriveNum3();
                    }else if (week == 4){
                        replaceContent = "今日限号" + parkLedSoundConfig.getLimitDriveNum4();
                    }else if (week == 5){
                        replaceContent = "今日限号" + parkLedSoundConfig.getLimitDriveNum5();
                    }else{//周六、周日
                        replaceContent = "不限行";
                    }
                }else{//单双号限行
                    if (week == 0 || week == 6){
                        replaceContent = "不限行";
                    }else{
                        int day = Integer.parseInt(DateTools.getDay());
                        if (day % 2 == 0){
                            replaceContent = "单号限行";
                        }else{
                            replaceContent = "双号限行";
                        }
                    }
                }
                break;
            case 3:
                int freeSpace = showSayBaseHandle.getFreeSpace(parkId, channelId, para);
                //擎天创科控制卡
                if (getLedCardType(channelId) == 34 && Arrays.asList(STYLE_ARR).contains(getStyle(parkId, channelId))) {
                    replaceContent = String.valueOf(freeSpace);
                } else {
                    replaceContent = showSayBaseHandle.getFreeSpaceName(parkId, channelId, para) + "剩余车位" + freeSpace;
                }
                break;
            case 4:
                replaceContent = plateNum;
                break;
            case 5:
                showSayBaseHandle.setAndGetPlateType(resultCode, parkId, channelId, plateNum, type, para);
                replaceContent = (String) para.get("showTypeStr");
                break;
            case 6:
                if (PlateTypeEnum.月卡车.getType().equals(type) || FlowCondition.ResultCode.过期卡.equals(resultCode)){
                    Integer days = showSayBaseHandle.getMonthCarRemainDays(parkId, channelId, plateNum, para);;
                    if (days != null){
                        replaceContent = "剩余" + days + "天";
                    }
                }
                break;
            case 7:
                Long parkTime = (Long) para.get("parkTime");
                if(parkTime != null && parkTime != 0){
                    replaceContent = "停车" + DateTools.secondToSecondsTime(parkTime.intValue());
                }
                break;
            case 8:
                if (resultCode.equals(FlowCondition.ResultCode.过期卡)){
                    Boolean isMonth = (Boolean) para.get("isMonth");
                    replaceContent = isMonth != null && isMonth ? enterTips(parkId, channelId, FlowCondition.ResultCode.月卡车) : enterTips(parkId, channelId, FlowCondition.ResultCode.有牌车允许临时车进入);
                }else{
                    replaceContent = enterTips(parkId, channelId, resultCode);
                }
                break;
            case 9:
                String prefix = "";
                if (Boolean.TRUE.equals(para.get("hasInnerAreaFee"))
                        && (FlowCondition.ResultCode.需缴费.equals(resultCode)
                            || FlowCondition.ResultCode.固定费用.equals(resultCode)
                            || FlowCondition.ResultCode.欠费补缴.equals(resultCode))) {
                    showSayBaseHandle.setAndGetPlateType(resultCode, parkId, channelId, plateNum, type, para);
                    if (para.get("regionId") != null && (PlateTypeEnum.月卡车.getType().equals(para.get("type"))
                            || PlateTypeEnum.VIP车辆.getType().equals(para.get("type")))) {
                        Long regionId = (Long) para.get("regionId");
                        ParkRegion parkRegion = parkRegionDao.selectById(regionId);
                        prefix = parkRegion != null ? parkRegion.getRegionName() : prefix;
                    }
                }
                replaceContent = prefix + exitTips(parkId, channelId, resultCode, para);
                break;
            case 10:
                Object fee = para.get("fee");
                //擎天创科控制卡
                if (getLedCardType(channelId) == 34 && Arrays.asList(STYLE_ARR).contains(getStyle(parkId, channelId))) {
                    if (fee != null && Float.parseFloat((String) fee) > 0) {
                        replaceContent = String.valueOf(fee);
                        break;
                    }
                } else {
                    if (fee == null || Float.parseFloat((String) fee) <= 0) {
                        if (ShowSayConstants.NO_FEE_RESULT_LIST.contains(resultCode)) {
                            replaceContent = "无需缴费";
                        }
                        break;
                    }
                    replaceContent = fee + "元";
                }
                break;
            case 11:
                replaceContent = (String) para.get("parkName");
                break;
            case 12:
                if (PlateTypeEnum.储值卡车.getType().equals(type)){
                    ObjectResponse<BigDecimal> storeCardBalance = storeCardService.getStoreCardBalance(parkId, plateNum);
                    if (ObjectResponse.isSuccess(storeCardBalance)){
                        BigDecimal balance = storeCardBalance.getData();
                        replaceContent = "储值卡余额" + balance + "元";
                    }
                }
                break;
            case 13:
                replaceContent = DateTools.getFormat(DateTools.DF_TIME, new Date());
                break;
            case 14:
                week = Integer.parseInt(DateTools.getWeek());
                char ch;
                switch(week){
                    case 1:ch='一';break;
                    case 2:ch='二';break;
                    case 3:ch='三';break;
                    case 4:ch='四';break;
                    case 5:ch='五';break;
                    case 6:ch='六';break;
                    case 0:ch='日';break;
                    default:ch='一';break;
                }
                replaceContent = DateTools.getFormat(DateTools.DF_, new Date()) + " 星期" + ch;
                break;
            default:
                break;
        }
        return replaceContent;
    }
    private int getLedCardType(Long channelId) {
        ObjectResponse<ParkInoutdevice> channelResp = parkService.getInoutDeviceById(channelId);
        if (!ObjectResponse.isSuccess(channelResp)) {
            return 0;
        }
        return NumberUtils.toPrimitive(channelResp.getData().getLedcardType());
    }

    private int getStyle(Long parkId, Long channelId) {
        ObjectResponse<LedConfig> objectResponse = ledSoundService.getLedConfigByChannel(channelId);
        if (!ObjectResponse.isSuccess(objectResponse)) {
            return 0;
        }
        return NumberUtils.toPrimitive(objectResponse.getData().getStyle());
    }
    /**
     * 入场提示
     * @param parkId 车场ID
     * @param resultCode 处理结果
     * @return 提示
     */
    public String enterTips(Long parkId, Long channelId, FlowCondition.ResultCode resultCode) {
        ObjectResponse<LedTips> specialLedObjectResponse = ledSoundService.getLedTipsByChannel(channelId);
        LedTips parkLedTipsConfig = specialLedObjectResponse.getData();
        return enterTips(parkLedTipsConfig, resultCode);
    }

    public String enterTips(LedTips ledTips, FlowCondition.ResultCode resultCode) {
        if (resultCode == null) {
            return "";
        }
        switch (resultCode) {
            case 月卡车:
            case 内部车辆:
            case VIP车辆:
                return ledTips.getEnterMonthVip();
            case 有牌车允许临时车进入:
            case 储值卡车允许进入:
            case 访客车:
                return ledTips.getEnterTmpSpecial();
            case 有牌车不允许临时车进入:
            case 储值卡车禁止进入:
                return ledTips.getEnterNotAllowTmpRun();
            case 黑名单车:
                return ledTips.getEnterBlackCar();
            case 无牌车允许进出:
                return ledTips.getEnterNotAllowNocarRun();
            case 无牌车不允许进入:
                return ledTips.getEnterNotAllowTmpRun();
            case 车位已满禁止入场:
                return ledTips.getEnterNoParkingSpace();
            case 黄牌车禁止入场:
                return ledTips.getEnterNotAllowTmpRun();
            case 过期卡:
                return ledTips.getEnterMonthExpire();
            case 车位已占:
                return ledTips.getEnterMultiParkCar();
            case 欠费补缴:
                return ledTips.getEnterUnpaid();
            case 虚假车牌:
                return ledTips.getEnterShamPlate() == null ? "" : ledTips.getEnterShamPlate();
            default:
                break;
        }
        return "";
    }

    /**
     * 入场提示
     * @param parkId 车场ID
     * @param resultCode 处理结果
     * @return 提示
     */
    public String exitTips(Long parkId, Long channelId, FlowCondition.ResultCode resultCode, Map<String, Object> para) {
        ObjectResponse<LedTips> specialLedObjectResponse = ledSoundService.getLedTipsByChannel(channelId);
        LedTips parkLedTipsConfig = specialLedObjectResponse.getData();
        return exitTips(parkLedTipsConfig, resultCode, para);
    }

    public String exitTips(LedTips ledTips, FlowCondition.ResultCode resultCode, Map<String, Object> para) {
        if (resultCode == null) {
            return "";
        }
        switch (resultCode) {
            case 月卡车:
            case 内部车辆:
            case 无入场有全免优惠:
            case 免费时间内:
            case 无需缴费:
            case 特殊车辆免费:
            case 预缴费未超时:
            case 无入场VIP全免车:
                String prefix = "";
                String payWay = showSayBaseHandle.getPayWay(para);
                if (payWay != null) {
                    prefix = payWay + "支付成功 ";
                }
                return prefix + ledTips.getExitOpenGate();
            case 黑名单车:
            case 不允许临时车出:
                return ledTips.getExitNotAllowRun();
            case 需缴费:
            case 固定费用:
                return ledTips.getExitPay();
            case 无入场记录:
                return ledTips.getExitNoEnterinfo();
            case 无牌车允许进出:
                return ledTips.getExitNoCarplate();
            case 缴费后屏显播报:
                String prefix2 = "";
                String payWay2 = showSayBaseHandle.getPayWay(para);
                if (payWay2 != null) {
                    prefix2 = payWay2 + "支付成功 ";
                }
                return prefix2 + ledTips.getExitOpenGate();
            case 欠费补缴:
                return ledTips.getExitUnpaid();
            case 虚假车牌:
                return ledTips.getExitShamPlate() == null ? "" : ledTips.getExitShamPlate();
            default:
                break;
        }
        return "";
    }

    private boolean isShowExpireMc(MonthDetailDto monthDetailDto, Long parkId, Long channelId){
        if (!MonthDetailDto.MonthType.过期临时车.equals(monthDetailDto.getMonthType())
                && !MonthDetailDto.MonthType.过期月卡车.equals(monthDetailDto.getMonthType())) {
            return false;
        }
        //根据屏显的过期月卡配置判断是否可以作为月卡车
        ObjectResponse<LedConfig> objectResponse = ledSoundService.getLedConfigByChannel(channelId);
        if (!ObjectResponse.isSuccess(objectResponse)) {
            return false;
        }
        LedConfig ledConfig = objectResponse.getData();
        if (ledConfig.getLedExpireDaysMc() != null && monthDetailDto.getExpiredDays() != null
                && ledConfig.getLedExpireDaysMc() >= monthDetailDto.getExpiredDays()) {
            return true;
        }
        return false;
    }
}
