package com.icetech.park.service.handle.showsay;

import com.icetech.cloudcenter.api.lcd.LedService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.park.domain.entity.led.LedConfig;
import com.icetech.park.domain.entity.led.LedSound;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.domain.response.LedSoundDto;
import com.icetech.park.service.IShowVoiceHandle;
import com.icetech.park.service.flow.p2c.FlowCondition;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * 语音播报处理
 * @author fangct
 */
@Component
@Slf4j
public class LedSayHandle implements IShowVoiceHandle {

    private static String line2Parks = "P1574069875, P1574069698, P1574070102, P1573036782,P1576060397" +
            "P1574069698,P1574069875,P1574070102,P1576477906,P1576478969,P1576479065,P1576479113,P1576479173," +
            "P1576479243,P1576479294,P1576479350,P1576479423,P1576479490";
    /**
     * 需缴费
     * @return 语音内容
     */
    public static String needPay(String parkCode, String plateNum, String unpayPrice, Long parkTime){
        if (line2Parks.contains(parkCode)){
            return DateTools.secondToSecondsTime(parkTime.intValue()) + "、请缴费" + unpayPrice + "元";
        }else {
            return "请扫码缴费";
        }

    }
    @Autowired
    private ParkService parkService;
    @Autowired
    private LedService ledSoundService;
    @Autowired
    private ShowSayBaseHandle showSayBaseHandle;

    public String enterHandle(Long parkId, Long channelId, String plateNum, Integer type, Map<String, Object> para) {
        if (PlateTypeEnum.月卡车.getType().equals(type) || PlateTypeEnum.VIP车辆.getType().equals(type)){
            return enterHandle(parkId, channelId, plateNum, type, FlowCondition.ResultCode.月卡车, para);
        }else{
            return enterHandle(parkId, channelId, plateNum, type, FlowCondition.ResultCode.有牌车允许临时车进入, para);
        }
    }

    @Override
    public String enterHandle(Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para) {
        switch (resultCode) {
            case 月卡车:
            case VIP车辆:
            case 访客车:
            case 内部车辆:
                return generateContent(parkId, channelId, plateNum, type, resultCode, para, LedSound.SoundTypeEnum.入场月卡车_内部车辆.type);
            case 过期卡:
                if (PlateTypeEnum.月卡车.getType().equals(type)){
                    return generateContent(parkId, channelId, plateNum, type, resultCode, para, LedSound.SoundTypeEnum.入场月卡车_内部车辆.type);
                }else{
                    return generateContent(parkId, channelId, plateNum, type, resultCode, para, LedSound.SoundTypeEnum.入场临时车.type);
                }
            case 有牌车允许临时车进入:
            case 储值卡车允许进入:
                return generateContent(parkId, channelId, plateNum, type, resultCode, para, LedSound.SoundTypeEnum.入场临时车.type);
            case 有牌车不允许临时车进入:
            case 储值卡车禁止进入:
                return generateContent(parkId, channelId, plateNum, type, resultCode, para, LedSound.SoundTypeEnum.临时车禁止通行.type);
            case 黑名单车:
                return generateContent(parkId, channelId, plateNum, type, resultCode, para, LedSound.SoundTypeEnum.黑名单车辆进出场.type);
            case 无牌车允许进出:
                return generateContent(parkId, channelId, plateNum, type, resultCode, para, LedSound.SoundTypeEnum.入场无牌车.type);
            case 无牌车不允许进入:
                return generateContent(parkId, channelId, plateNum, type, resultCode, para, LedSound.SoundTypeEnum.临时车禁止通行.type);
            case 车位已满禁止入场:
                return generateContent(parkId, channelId, plateNum, type, resultCode, para, LedSound.SoundTypeEnum.车位已满.type);
            case 黄牌车禁止入场:
                return generateContent(parkId, channelId, plateNum, type, resultCode, para, LedSound.SoundTypeEnum.临时车禁止通行.type);
            case 车位已占:
                return generateContent(parkId, channelId, plateNum, type, resultCode, para, LedSound.SoundTypeEnum.多位多车车位占用.type);
            case 欠费补缴:
                return generateContent(parkId, channelId, plateNum, type, resultCode, para, LedSound.SoundTypeEnum.出场收费车辆.type);
            case 虚假车牌:
                return generateContent(parkId, channelId, plateNum, type, resultCode, para, LedSound.SoundTypeEnum.入口虚假车牌.type);
            default:
                break;
        }
        return "";
    }

    @Override
    public String exitHandle(Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para) {

        switch (resultCode) {
            case 月卡车:
                return generateContent(parkId, channelId, plateNum, type, resultCode, para, LedSound.SoundTypeEnum.出场月卡车.type);
            case 无入场有全免优惠:
            case 免费时间内:
            case 无需缴费:
            case 特殊车辆免费:
            case 预缴费未超时:
            case 内部车辆:
            case VIP车辆:
            case 无入场VIP全免车:
                return generateContent(parkId, channelId, plateNum, type, resultCode, para, LedSound.SoundTypeEnum.出场免费车辆_临时特殊.type);
            case 黑名单车:
            case 不允许临时车出:
                return generateContent(parkId, channelId, plateNum, type, resultCode, para, LedSound.SoundTypeEnum.黑名单车辆进出场.type);
            case 需缴费:
            case 固定费用:
            case 欠费补缴:
                return generateContent(parkId, channelId, plateNum, type, resultCode, para, LedSound.SoundTypeEnum.出场收费车辆.type);
            case 无入场记录:
                return generateContent(parkId, channelId, plateNum, type, resultCode, para, LedSound.SoundTypeEnum.出场无入场记录.type);
            case 无牌车允许进出:
                return generateContent(parkId, channelId, plateNum, type, resultCode, para, LedSound.SoundTypeEnum.出场无牌车.type);
            case 缴费后屏显播报:
                return generateContent(parkId, channelId, plateNum, type, resultCode, para, LedSound.SoundTypeEnum.出场支付成功.type);
            case 虚假车牌:
                return generateContent(parkId, channelId, plateNum, type, resultCode, para, LedSound.SoundTypeEnum.出口虚假车牌.type);
            default:
                break;
        }
        return "";
    }

    /**
     * 生成最终要显示的内容
     * @param parkId 车场ID
     * @param plateNum 车牌号
     * @param type 车辆类型
     * @param resultCode 处理结果
     * @param para 参数MAP
     * @param soundType 语音类型
     * @return 要播出的语音内容
     */
    private String generateContent(Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para, int soundType) {
        if (para == null){
            para = new HashMap<>();
        }
        ObjectResponse<ParkInoutdevice> channelResp = parkService.getInoutDeviceById(channelId);
        ObjectResponse.notError(channelResp);
        ParkInoutdevice channel = channelResp.getData();
        if (channel.getTtsType() == null || channel.getLedcardType() == null){
            log.info("<自定义语音转换> 未配置控制卡类型和是否支持TTS, 车场ID：{}", parkId);
            throw new ResponseBodyException(CodeConstants.ERROR_400, "请先配置控制卡类型和是否支持TTS");
        }
        para.put("enexType", channel.getInandoutType());
        ObjectResponse<LedSoundDto> soundDtoObjectResponse = ledSoundService.getLedSoundDtoByType(channelId, soundType);
        LedSoundDto soundVo = soundDtoObjectResponse.getData();
        String content = soundVo.getContent();
        String[] dynamicValues = StringUtils.findBraceValue(content);

        if(channel.getTtsType() == 0){//非TTS的特殊情况处理
            if (soundType == LedSound.SoundTypeEnum.出场无入场记录.type) {
                return "<11/>";
            } else if (soundType == LedSound.SoundTypeEnum.临时车禁止通行.type) {
                return "<13/>";
            } else if (soundType == LedSound.SoundTypeEnum.车位已满.type) {
                return "<12/>";
            } else if (soundType == LedSound.SoundTypeEnum.黑名单车辆进出场.type) {
                return "<13/>";
            }
        }

        for (String value : dynamicValues) {
            int dynamicValue = Integer.parseInt(value);
            if (dynamicValue == LedSound.VariateEnum.月卡剩余天数.type && PlateTypeEnum.月卡车.getType().equals(type)) {
                Integer days = showSayBaseHandle.getMonthCarRemainDays(parkId, channelId, plateNum, para);
                if (days == null) {
                    content = content.replace("{" + dynamicValue + "}", "");
                    if (NumberUtils.toPrimitive((Integer) para.get("days")) == -2) {
                        type = PlateTypeEnum.临时车.getType();
                    }
                    continue;
                }
            }
            if (channel.getTtsType() == 1) {//有TTS
                content = content.replace("{" + dynamicValue + "}", getTTSReplaceContent(dynamicValue, parkId, channelId, plateNum, type, resultCode, para));
            } else {
                content = content.replace("{" + dynamicValue + "}", getNoTTSReplaceContent(dynamicValue, parkId, channelId, plateNum, type, resultCode, para));
            }
        }
        return content.trim();
    }

    private String getTTSReplaceContent(int dynamicValue, Long parkId, Long channelId, String plateNum, Integer type,
                                        FlowCondition.ResultCode resultCode, Map<String, Object> para) {
        String replaceContent = "";
        switch (dynamicValue) {
            case 1://当前时间
                Date date = new Date();
                replaceContent = DateTools.getFormat(DateTools.DF_CN, date);
                break;
            case 2://今日限号
                ObjectResponse<LedConfig> ledsoundConfigObjectResponse = ledSoundService.getLedConfigByChannel(channelId);
                LedConfig parkLedSoundConfig = ledsoundConfigObjectResponse.getData();
                Integer limitType = parkLedSoundConfig.getLimitType();
                int week = Integer.parseInt(DateTools.getWeek());
                if (limitType == 0){//尾号限行
                    if (week == 1){
                        replaceContent = "今日限号" + parkLedSoundConfig.getLimitDriveNum1();
                    }else if (week == 2){
                        replaceContent = "今日限号" + parkLedSoundConfig.getLimitDriveNum2();
                    }else if (week == 3){
                        replaceContent = "今日限号" + parkLedSoundConfig.getLimitDriveNum3();
                    }else if (week == 4){
                        replaceContent = "今日限号" + parkLedSoundConfig.getLimitDriveNum4();
                    }else if (week == 5){
                        replaceContent = "今日限号" + parkLedSoundConfig.getLimitDriveNum5();
                    }else{//周六、周日
                        replaceContent = "不限行";
                    }
                }else{//单双号限行
                    if (week == 0 || week == 6){
                        replaceContent = "不限行";
                    }else{
                        int day = Integer.parseInt(DateTools.getDay());
                        if (day % 2 == 0){
                            replaceContent = "单号限行";
                        }else{
                            replaceContent = "双号限行";
                        }
                    }
                }
                break;
            case 3:
                int freeSpace = showSayBaseHandle.getFreeSpace(parkId, channelId, para);
                replaceContent = showSayBaseHandle.getFreeSpaceName(parkId, channelId, para) + "剩余车位" + freeSpace;
                break;
            case 4:
                replaceContent = plateNum;
                break;
            case 5:
                showSayBaseHandle.setAndGetPlateType(resultCode, parkId, channelId, plateNum, type, para);
                replaceContent = (String) para.getOrDefault("sayTypeStr", para.get("showTypeStr"));
                break;
            case 6:
                if (type.equals(PlateTypeEnum.月卡车.getType()) || resultCode.equals(FlowCondition.ResultCode.月卡车) || resultCode.equals(FlowCondition.ResultCode.过期卡)){
                    Integer days = showSayBaseHandle.getMonthCarRemainDays(parkId, channelId, plateNum, para);;
                    if (days != null){
                        replaceContent = "剩余" + days + "天";
                    }
                }
                break;
            case 7:
                Long parkTime = (Long) para.get("parkTime");
                if (parkTime != null && parkTime != 0){
                    replaceContent = "停车" + DateTools.secondToSecondsTime(parkTime.intValue());
                }
                break;
            case 8:
                if (para.get("fee") != null){
                    replaceContent = "请缴费"+ para.get("fee") + "元";
                    if (FlowCondition.ResultCode.欠费补缴.equals(resultCode)) {
                        LedSoundDto soundVo;
                        Integer enexType = (Integer) para.get("enexType");
                        if (NumberUtils.toPrimitive(enexType) == 1) {
                            ObjectResponse<LedSoundDto> soundDtoObjectResponse = ledSoundService.getLedSoundDtoByType(channelId, LedSound.SoundTypeEnum.入口欠费补缴.type);
                            soundVo = soundDtoObjectResponse.getData();
                        } else {
                            ObjectResponse<LedSoundDto> soundDtoObjectResponse = ledSoundService.getLedSoundDtoByType(channelId, LedSound.SoundTypeEnum.出口欠费补缴.type);
                            soundVo = soundDtoObjectResponse.getData();
                        }
                        String content = soundVo.getContent();
                        replaceContent += " " + content;
                    }
                }
                break;
            case 9:
                String payWay = showSayBaseHandle.getPayWay(para);
                if (payWay != null) {
                    replaceContent = payWay + "支付成功 一路平安";
                } else {
                    replaceContent = "一路平安";
                }
                break;
            case 10:
                replaceContent = "欢迎光临";
                break;
            case 11:
                replaceContent = "请等待人工确认";
                break;
            default:
                break;
        }
        return replaceContent;
    }
    private String getNoTTSReplaceContent(int dynamicValue, Long parkId, Long channelId, String plateNum, Integer type,
                                          FlowCondition.ResultCode resultCode, Map<String, Object> para) {
        String replaceContent = "";
        switch (dynamicValue) {
            case 4:
                replaceContent = "<4>" + plateNum + "</4>";
                break;
            case 5:
                showSayBaseHandle.setAndGetPlateType(resultCode, parkId, channelId, plateNum, type, para);
                Integer realType = (Integer) para.getOrDefault("type", 1);
                if (realType != null && realType == 2){
                    replaceContent = "<15/>";
                } else if (realType != null && realType == 1){
                    replaceContent = "<14/>";
                }
                break;
            case 6:
                if (type.equals(PlateTypeEnum.月卡车.getType()) || resultCode.equals(FlowCondition.ResultCode.月卡车) || resultCode.equals(FlowCondition.ResultCode.过期卡)){
                    Integer days = showSayBaseHandle.getMonthCarRemainDays(parkId, channelId, plateNum, para);;
                    if (days != null){
                        replaceContent = "<6>" + days + "</6>";
                    }
                }
                break;
            case 7:
                Long parkTime = (Long) para.get("parkTime");
                if(parkTime != null && parkTime != 0){
                    replaceContent = "<7>" + parkTime + "</7>";
                }
                break;
            case 8:
                if (para.get("fee") != null) {
                    int fee = (int) (Float.parseFloat((String) para.get("fee")) * 10);
                    replaceContent = "<8>"+ fee + "</8>";
                }
                break;
            case 9:
                replaceContent = "<9/>";
                break;
            case 10:
                replaceContent = "<10/>";
                break;
            case 11:
                replaceContent = "<11/>";
                break;
            case 12:
                replaceContent = "<12/>";
                break;
            case 13:
                replaceContent = "<13/>";
                break;
            default:
                break;
        }
        return replaceContent;
    }

}
