package com.icetech.park.service.handle.showsay;

import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.constants.RobotConstants;
import com.icetech.cloudcenter.domain.enumeration.ShowTypeEnum;
import com.icetech.cloudcenter.domain.request.p2c.HintRequest;
import com.icetech.cloudcenter.domain.request.p2c.LcdHintRequest;
import com.icetech.cloudcenter.domain.request.p2r.RobotHintRequest;
import com.icetech.cloudcenter.domain.request.p2r.ShowPayInfoRequest;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.DateTools;
import com.icetech.park.domain.entity.led.LedShow;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.handle.DeviceDownServiceFactory;
import com.icetech.park.service.down.ExHintService;
import com.icetech.park.service.down.itc.impl.ItcHintServiceImpl;
import com.icetech.park.service.down.p2c.impl.LcdHintServiceImpl;
import com.icetech.park.service.down.p2r.impl.ShowPayInfoServiceImpl;
import com.icetech.park.service.flow.p2c.FlowCondition;
import com.icetech.park.service.handle.ItcCacheHandle;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * 统一的显示播报处理
 * @author fangct
 */
@Service
@Slf4j
public class DownShowSayHandle {

    @Autowired
    private LcdHintServiceImpl lcdHintService;
    @Autowired
    private CommonShowHandle commonShowHandle;
    @Autowired
    private CommonSayHandle commonSayHandle;
    @Autowired
    private ParkService parkService;
    @Value("${web.url}")
    private String webUrl;
    @Autowired
    protected CacheHandle cacheHandle;
    @Autowired
    protected ItcCacheHandle itcCacheHandle;
    @Autowired
    private com.icetech.park.service.down.p2r.impl.HintServiceImpl robotHintService;
    @Autowired
    private ShowPayInfoServiceImpl showPayInfoService;
    @Autowired
    private LedShowHandle ledShowHandle;
    @Autowired
    private ShowSayBaseHandle showSayBaseHandle;
    @Autowired
    private ItcHintServiceImpl itcHintService;
    @Autowired
    private DeviceDownServiceFactory deviceDownServiceFactory;

    /**
     * 固定的显示和播报内容下发
     * @param parkId
     * @param parkCode
     * @param plateNum
     * @param show
     * @param say
     * @param qrCodeUrl
     * @param serialNumber
     * @param isReachable
     * @return
     */
    public ObjectResponse fixShowSayExec(Long parkId, String parkCode, Long channelId, String plateNum, String show, String say, String qrCodeUrl,
                                      String serialNumber, boolean isReachable) {
        ObjectResponse<ParkInoutdevice> channelResp = parkService.getInoutDeviceById(channelId);
        if (ObjectResponse.isSuccess(channelResp)){
            ParkInoutdevice channel = channelResp.getData();
            Integer ledLcdSource = channel.getLedLcdSource();
            if (ledLcdSource == 2){//LCD
                LcdHintRequest lcdHintRequest = new LcdHintRequest();
                lcdHintRequest.setSay(say);
                /*
                 * 调试助手内容
                 */
                if ("6666".equals(say)){
                    lcdHintRequest.setSay("<D3>" + say +"<D3>");
                }
                lcdHintRequest.setShow(show);
                lcdHintRequest.setPlateNum(plateNum);
                lcdHintRequest.setQrCodeUrl(qrCodeUrl);
                if (isReachable){
                    return lcdHintService.execute(parkId, parkCode, serialNumber, lcdHintRequest);
                }else{
                    String msgId = lcdHintService.showAndSay(parkId, parkCode, serialNumber, lcdHintRequest);
                    if (msgId == null){
                        log.info("<统一屏显语音下发> 下发失败，车牌号：{}", plateNum);
                        return ObjectResponse.failed(CodeConstants.ERROR_3003);
                    }
                }

            }else{//LED
                HintRequest hintRequest = new HintRequest();
                hintRequest.setShowTypeByShow(show);
                hintRequest.setSay(say);
                hintRequest.setPlateNum(plateNum);
                hintRequest.setShow(show);
                ExHintService exHintService = deviceDownServiceFactory.buildExHintService(parkCode);
                if (isReachable){
                    return exHintService.execute(parkId, parkCode, serialNumber, hintRequest);
                }else{
                    String msgId = exHintService.showAndSay(parkId, parkCode, serialNumber, hintRequest);
                    if (msgId == null){
                        log.info("<统一屏显语音下发> 下发失败，车牌号：{}", plateNum);
                        return ObjectResponse.failed(CodeConstants.ERROR_3003);
                    }
                }
            }

        }
        return ObjectResponse.success();
    }

    /**
     * 根据条件查询显示和播报内容，并下发
     * @param parkId
     * @param parkCode
     * @param plateNum
     * @param type
     * @param para
     * @param serialNumber
     * @param enexType
     * @param channelCode
     * @param isReachable
     * @return
     */
    public ObjectResponse showSayExec(Long parkId, String parkCode, Long channelId, String plateNum, Integer type,
                                      Map<String, Object> para,
                                      String serialNumber, int enexType, String channelCode, boolean isReachable) {
        TokenDeviceVo tokenDeviceVo = cacheHandle.getDeviceInfo(serialNumber);
        if (para == null){
            para = new HashMap<>();
        }
        para.put("regionId", tokenDeviceVo.getRegionId());
        para.put("enexType", enexType);
        para.put("channelCode", channelCode);
        if (PlateTypeEnum.月卡车.getType().equals(type)) {
            return showSayExec(parkId, parkCode, channelId, plateNum, type, FlowCondition.ResultCode.月卡车, para,
                    serialNumber, enexType, channelCode, isReachable);
        } else if (PlateTypeEnum.VIP车辆.getType().equals(type)) {
            return showSayExec(parkId, parkCode, channelId, plateNum, type, FlowCondition.ResultCode.VIP车辆, para,
                    serialNumber, enexType, channelCode, isReachable);
        } else if (PlateTypeEnum.储值卡车.getType().equals(type)) {
            return showSayExec(parkId, parkCode, channelId, plateNum, type, FlowCondition.ResultCode.储值卡车允许进入, para,
                    serialNumber, enexType, channelCode, isReachable);
        } else if (PlateTypeEnum.访客车辆.getType().equals(type)) {
            return showSayExec(parkId, parkCode, channelId, plateNum, type, FlowCondition.ResultCode.访客车, para,
                    serialNumber, enexType, channelCode, isReachable);
        } else {
            return showSayExec(parkId, parkCode, channelId, plateNum, type, FlowCondition.ResultCode.有牌车允许临时车进入, para,
                    serialNumber, enexType, channelCode, isReachable);
        }
    }

    /**
     * 根据条件查询显示和播报内容，并下发
     * @param parkId
     * @param parkCode
     * @param plateNum
     * @param type
     * @param resultCode
     * @param para
     * @param serialNumber
     * @param enexType
     * @param channelCode
     * @param isReachable
     * @return
     */
    public ObjectResponse showSayExec(Long parkId, String parkCode, Long channelId, String plateNum, Integer type,
                                  FlowCondition.ResultCode resultCode, Map<String, Object> para,
                                  String serialNumber, int enexType, String channelCode, boolean isReachable) {
        if (para == null){
            para = new HashMap<>();
        }
        TokenDeviceVo tokenDeviceVo = cacheHandle.getDeviceInfo(serialNumber);
        para.put("enexType", enexType);
        para.put("channelCode", channelCode);
        para.put("regionId", tokenDeviceVo.getRegionId());
        String show = null;
        String say = null;
        ObjectResponse<ParkInoutdevice> channelResp = parkService.getInoutDeviceById(channelId);
        if (ObjectResponse.isSuccess(channelResp)){
            ParkInoutdevice channel = channelResp.getData();
            Integer ledLcdSource = channel.getLedLcdSource();
            if (ledLcdSource == 2){//LCD
                LcdHintRequest lcdHintRequest = new LcdHintRequest();
                if (enexType == 1){//入场
                    show = commonShowHandle.enter(parkId, channelId, plateNum, type, resultCode, para, ledLcdSource);
                    say = commonSayHandle.enter(parkId, channelId, plateNum, type, resultCode, para, ledLcdSource);

                    lcdHintRequest.setSay(say);
                    lcdHintRequest.setShow(show);
                    lcdHintRequest.setPlateNum(plateNum);
                    if (ShowSayConstants.ENTER_QR_RESULT_LIST.contains(resultCode)){
                        String qrCodeUr = webUrl + "/noplate/enter/index?parkCode=" + parkCode + "&channelId=" + channelCode;
                        lcdHintRequest.setQrCodeUrl(qrCodeUr);
                    }

                }else{//出场
                    show = commonShowHandle.exit(parkId, channelId, plateNum, type, resultCode, para, ledLcdSource);
                    say = commonSayHandle.exit(parkId, channelId, plateNum, type, resultCode, para, ledLcdSource);

                    lcdHintRequest.setSay(say);
                    lcdHintRequest.setShow(show);
                    lcdHintRequest.setPlateNum(plateNum);
                    if (ShowSayConstants.QR_RESULT_LIST.contains(resultCode)){
                        String qrCodeUr = webUrl + "/h5/pay/exit?parkCode=" + parkCode + "&channelId=" + channelCode;
                        lcdHintRequest.setQrCodeUrl(qrCodeUr);
                    }

                }
                if (isReachable){
                    ObjectResponse objectResponse = lcdHintService.execute(parkId, parkCode, serialNumber, lcdHintRequest);
                    if (!ObjectResponse.isSuccess(objectResponse)){
                        log.info("<LCD统一屏显语音下发> 下发失败，车牌号：{}", plateNum);
                        return ObjectResponse.failed(CodeConstants.ERROR_3003);
                    }
                }else{
                    String msgId = lcdHintService.showAndSay(parkId, parkCode, serialNumber, lcdHintRequest);
                    if (msgId == null){
                        log.info("<LCD统一屏显语音下发> 下发失败，车牌号：{}", plateNum);
                        return ObjectResponse.failed(CodeConstants.ERROR_3003);
                    }
                }
            }else{//LED
                HintRequest hintRequest = new HintRequest();
                if (enexType == 1){//入场
                    show = commonShowHandle.enter(parkId, channelId, plateNum, type, resultCode, para, ledLcdSource);
                    say = commonSayHandle.enter(parkId, channelId, plateNum, type, resultCode, para, ledLcdSource);

                    hintRequest.setShowTypeByShow(show);
                    if (hintRequest.getShowType() == ShowTypeEnum.动态二维码.getVal() || hintRequest.getShowType() == ShowTypeEnum.文本和二维码.getVal()){
                        show = commonShowHandle.replacePara(show, new String[]{parkCode, channelCode});
                        if (hintRequest.getShowType() == ShowTypeEnum.文本和二维码.getVal()) {
                            String extendShow = ledShowHandle.generate4LineContent(parkId, channel.getId(), plateNum, type, resultCode, para, LedShow.DisplayTypeEnum.入场显示.type);
                            hintRequest.setExtendShow(extendShow);
                        }
                    }
                    hintRequest.setShow(show);
                    hintRequest.setSay(say);
                    hintRequest.setPlateNum(plateNum);
                }else{//出场
                    show = commonShowHandle.exit(parkId, channelId, plateNum, type, resultCode, para, ledLcdSource);
                    say = commonSayHandle.exit(parkId, channelId, plateNum, type, resultCode, para, ledLcdSource);

                    hintRequest.setShowTypeByShow(show);
                    hintRequest.setSay(say);
                    hintRequest.setPlateNum(plateNum);
                    if (hintRequest.getShowType() == ShowTypeEnum.动态二维码.getVal() || hintRequest.getShowType() == ShowTypeEnum.文本和二维码.getVal()){
                        show = replacePara(show, new String[]{parkCode, channelCode});
                        String extendShow = ledShowHandle.generate4LineContent(parkId, channelId, plateNum, type, resultCode, para, LedShow.DisplayTypeEnum.出场显示.type);
                        hintRequest.setExtendShow(extendShow);
                    }
                    hintRequest.setShow(show);
                }
                ExHintService exHintService = deviceDownServiceFactory.buildExHintService(parkCode);
                if (isReachable){
                    ObjectResponse objectResponse = exHintService.execute(parkId, parkCode, serialNumber, hintRequest);
                    if (!ObjectResponse.isSuccess(objectResponse)){
                        log.info("<LED统一屏显语音下发> 下发失败，车牌号：{}", plateNum);
                        return ObjectResponse.failed(CodeConstants.ERROR_3003);
                    }
                }else{
                    String msgId = exHintService.showAndSay(parkId, parkCode, serialNumber, hintRequest);
                    if (msgId == null){
                        log.info("<LED统一屏显语音下发> 下发失败，车牌号：{}", plateNum);
                        return ObjectResponse.failed(CodeConstants.ERROR_3003);
                    }
                }
            }
        }
        /*
         * 机器人屏显语音下发
         */
        String robotSerialNumber = cacheHandle.getChannelRobot(parkCode, channelCode);
        String itcSn = itcCacheHandle.getSerialNumber(parkCode, channelCode);
        log.info("车场：{}，通道：{}的机器人序列号为：{}", parkCode, channelCode, robotSerialNumber);
        if (robotSerialNumber != null) {

            if (ShowSayConstants.PAY_LIST.contains(resultCode)){
                String fee = (String) para.get("fee");
                String parkTime = DateTools.secondToSecondsTime((int)(long) para.get("parkTime"));
                String orderNum = (String) para.get("orderNum");
                ShowPayInfoRequest showPayInfoRequest = new ShowPayInfoRequest();
                showPayInfoRequest.setOrderNum(orderNum);
                showPayInfoRequest.setNoticeMsg(RobotConstants.PAY_NOTICE_MSG);
                showPayInfoRequest.setShow(plateNum + "/"+fee + "元" +
                        "/" + parkTime +
                        "/" + PlateTypeEnum.getName(type));
                showPayInfoRequest.setQrCodeUrl(webUrl + "/h5/pay/exit?parkCode=" + parkCode + "&channelId=" + channelCode);
                showPayInfoService.executeDown(parkId, robotSerialNumber, showPayInfoRequest);
                /*
                 * 机器人播报
                 */
                RobotHintRequest robotHintRequest = new RobotHintRequest();
                robotHintRequest.setPlateNum(plateNum);
                robotHintRequest.setShow("");
                robotHintRequest.setSay(say);
                robotHintService.executeDown(parkId, robotSerialNumber, robotHintRequest);
            }else{
                RobotHintRequest robotHintRequest = new RobotHintRequest();
                robotHintRequest.setPlateNum(plateNum);
                robotHintRequest.setShow(show);
                robotHintRequest.setSay(say);
                robotHintService.executeDown(parkId, robotSerialNumber, robotHintRequest);
            }
        }
        if (itcSn != null) {
            com.icetech.cloudcenter.domain.request.itc.HintRequest itcHintRequest = com.icetech.cloudcenter.domain.request.itc.HintRequest.builder()
                    .scene(showSayBaseHandle.getSceneByResultCode(resultCode, enexType))
                    .plateNum(plateNum)
                    .type(showSayBaseHandle.setAndGetPlateType(resultCode, parkId, channelId, plateNum, type, para))
                    .freeSpace(showSayBaseHandle.getFreeSpace(parkId, channelId, para))
                    .remainDaysMc(showSayBaseHandle.getMonthCarRemainDays(parkId, channelId, plateNum, para))
                    .unpayPrice(para.get("fee") == null ? null : (int) (Float.parseFloat((String) para.get("fee")) * 100))
                    .parkTime((Long)para.get("parkTime"))
                    .build();
            if (PlateTypeEnum.VIP车辆.getType().equals(itcHintRequest.getType())) {
                itcHintRequest.setVipTypeName((String) para.get("carDesc"));
            }
            if (enexType == 2 && ShowSayConstants.QR_RESULT_LIST.contains(resultCode)){
                itcHintRequest.setQrCodeUrl(webUrl + "/h5/pay/exit?parkCode=" + parkCode + "&channelId=" + channelCode);
            }
            if (enexType == 1 && (com.icetech.cloudcenter.domain.request.itc.HintRequest.Scene.NO_PLATE_ENTER.getVal() == itcHintRequest.getScene()
                    || com.icetech.cloudcenter.domain.request.itc.HintRequest.Scene.NEED_PAY_EXIT.getVal() == itcHintRequest.getScene())) {
                itcHintRequest.setQrCodeUrl(webUrl + "/noplate/enter/index?parkCode=" + parkCode + "&channelId=" + channelCode);
            }
            itcHintService.execute(parkId, itcSn, itcHintRequest);
        }
        return ObjectResponse.success();
    }
    /**
     * 根据条件查询显示和播报内容
     * @param parkId
     * @param plateNum
     * @param type
     * @param resultCode
     * @param para
     * @param enexType
     * @param channelCode
     * @return
     */
    public ObjectResponse<HintRequest> buildShowSayContent(Long parkId, String parkCode, Long channelId, String plateNum, Integer type,
                                      FlowCondition.ResultCode resultCode, Map<String, Object> para,
                                      Long regionId, int enexType, String channelCode) {
        if (para == null){
            para = new HashMap<>();
        }
        para.put("enexType", enexType);
        para.put("channelCode", channelCode);
        para.put("regionId", regionId);
        ObjectResponse<ParkInoutdevice> channelResp = parkService.getInoutDeviceById(channelId);
        if (!ObjectResponse.isSuccess(channelResp)){
            return ObjectResponse.failed(channelResp.getCode(), "通道不存在");
        }
        String show;
        String say;
        ParkInoutdevice channel = channelResp.getData();
        Integer ledLcdSource = channel.getLedLcdSource();
        HintRequest hintRequest = new HintRequest();
        if (enexType == 1) {//入场
            show = commonShowHandle.enter(parkId, channelId, plateNum, type, resultCode, para, ledLcdSource);
            say = commonSayHandle.enter(parkId, channelId, plateNum, type, resultCode, para, ledLcdSource);
            hintRequest.setShowTypeByShow(show);
            if (hintRequest.getShowType() == ShowTypeEnum.动态二维码.getVal() || hintRequest.getShowType() == ShowTypeEnum.文本和二维码.getVal()) {
                show = commonShowHandle.replacePara(show, new String[]{parkCode, channelCode});
                if (hintRequest.getShowType() == ShowTypeEnum.文本和二维码.getVal()) {
                    String extendShow = ledShowHandle.generate4LineContent(parkId, channel.getId(), plateNum, type, resultCode, para, LedShow.DisplayTypeEnum.入场显示.type);
                    hintRequest.setExtendShow(extendShow);
                }
            }
            hintRequest.setShow(show);
            hintRequest.setSay(say);
            hintRequest.setPlateNum(plateNum);
        } else {//出场
            show = commonShowHandle.exit(parkId, channelId, plateNum, type, resultCode, para, ledLcdSource);
            say = commonSayHandle.exit(parkId, channelId, plateNum, type, resultCode, para, ledLcdSource);

            hintRequest.setShowTypeByShow(show);
            hintRequest.setSay(say);
            hintRequest.setPlateNum(plateNum);
            if (hintRequest.getShowType() == ShowTypeEnum.动态二维码.getVal() || hintRequest.getShowType() == ShowTypeEnum.文本和二维码.getVal()) {
                show = replacePara(show, new String[]{parkCode, channelCode});
                String extendShow = ledShowHandle.generate4LineContent(parkId, channelId, plateNum, type, resultCode, para, LedShow.DisplayTypeEnum.出场显示.type);
                hintRequest.setExtendShow(extendShow);
            }
            hintRequest.setShow(show);
        }
        hintRequest.setShow(show);
        hintRequest.setSay(say);
        return ObjectResponse.success(hintRequest);
    }
    /**
     * 替换二维码动态参数
     * @param exitPayUrl
     * @param values
     * @return
     */
    private String replacePara(String exitPayUrl, String[] values){
        for (int i = 0; i < values.length; i++){
            exitPayUrl = exitPayUrl.replace("$" + (i+1), values[i]);
        }
        return exitPayUrl;
    }

}
