package com.icetech.park.service.handle.showsay;

import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.third.ThirdInfoService;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.partner.api.LuoGangService;
import com.icetech.partner.api.request.luogang.PayUrlRequest;
import com.icetech.third.domain.entity.third.ThirdInfo;
import com.icetech.park.service.flow.p2c.FlowCondition;
import com.icetech.common.domain.response.ObjectResponse;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.util.TextUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * 统一的显示查询业务
 * @author fangct
 */
@Service
@Slf4j
public class CommonShowHandle {

    @Autowired
    private LedShowHandle ledShowHandle;
    @Autowired
    private LcdShowHandle lcdShowHandle;
    @Autowired
    private ParkService parkService;
    @Autowired
    protected ThirdInfoService thirdInfoService;
    @Autowired
    protected LuoGangService luoGangService;
    private static final String LUOGANG_PID = "luoGang";

    /**
     * 入场显示
     * @param parkId
     * @param plateNum
     * @param type
     * @param resultCode
     * @param para
     * @param ledLcdSource
     * @return
     */
    public String enter(Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para, Integer ledLcdSource) {
        String content;
        para.put("ledLcdSource", ledLcdSource);
        if (ledLcdSource == 2){
            content = lcdShowHandle.enterHandle(parkId, channelId, plateNum, type, resultCode, para);
        }else{
            content = ledShowHandle.enterHandle(parkId, channelId, plateNum, type, resultCode, para);
        }
        return content;
    }

    public String enter(Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para) {
        ObjectResponse<ParkInoutdevice> channelResp = parkService.getInoutDeviceById(channelId);
        if (ObjectResponse.isSuccess(channelResp)){
            ParkInoutdevice channel = channelResp.getData();
            return enter(parkId, channelId, plateNum, type, resultCode, para, channel.getLedLcdSource());
        }else{
            log.error("未查询到高级配置，车场ID：{}", parkId);
            return "";
        }
    }
    /**
     * 出场显示
     * @param parkId
     * @param plateNum
     * @param type
     * @param resultCode
     * @param para
     * @param ledLcdSource
     * @return
     */
    public String exit(Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para, Integer ledLcdSource) {
        String content;
        if (para == null) {
            para = new HashMap<>();
        }
        para.put("ledLcdSource", ledLcdSource);
        if (ledLcdSource == 2){
            content = lcdShowHandle.exitHandle(parkId, channelId, plateNum, type, resultCode, para);
        }else{
            content = ledShowHandle.exitHandle(parkId, channelId, plateNum, type, resultCode, para);
        }
        return content;
    }

    public String exit(Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para) {
        ObjectResponse<ParkInoutdevice> channelResp = parkService.getInoutDeviceById(channelId);
        if (ObjectResponse.isSuccess(channelResp)){
            ParkInoutdevice channel = channelResp.getData();
            Integer ledLcdSource = channel.getLedLcdSource();
            return exit(parkId, channelId, plateNum, type, resultCode, para, ledLcdSource);
        }else{
            log.error("未查询到高级配置，车场ID：{}", parkId);
            return "";
        }
    }

    /**
     * 替换二维码动态参数
     * @param exitPayUrl
     * @param values
     * @return
     */
    public String replacePara(String exitPayUrl, String[] values){
        for (int i = 0; i < values.length; i++){
            exitPayUrl = exitPayUrl.replace("$" + (i+1), values[i]);
        }
        return exitPayUrl;
    }

    /**
     * 获取三方的支付链接
     * @param parkId
     * @param parkCode
     * @param channelId
     * @param orderNum
     * @return
     */
    public String getThirdPayUrl(Long parkId, String parkCode, String channelId, String orderNum, String plateNum, Map<String, Object> param){
        ThirdInfo thirdInfo = thirdInfoService.getThirdQrUrl(parkId);
        if (thirdInfo == null) {
            return "";
        }
        if (LUOGANG_PID.equals(thirdInfo.getPid())) {
            try {
                PayUrlRequest payUrlRequest = new PayUrlRequest();
                payUrlRequest.setUnPayPrice((String) param.get("fee"));
                payUrlRequest.setParkCode(parkCode);
                payUrlRequest.setPlateNum(plateNum);
                ObjectResponse<Map<String, Object>> mapObjectResponse = luoGangService.getPayUrl(payUrlRequest);
                if (mapObjectResponse.getData() != null && mapObjectResponse.getData().get("qrCodeContent") != null) {
                    Map<String, Object> data = mapObjectResponse.getData();
                    return (String) data.get("qrCodeContent");
                }
            } catch (Exception e) {
                log.error("e=", e);
            }
            return "";
        }
        if (!TextUtils.isEmpty(thirdInfo.getQrUrl())){
            return thirdInfo.getQrUrl() + "?parkCode=" + parkCode +
                    "&channelId=" + channelId + "&orderNum=" + orderNum;
        }
        return "";
    }
}
