package com.icetech.park.service.handle.showsay;

import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.park.service.flow.p2c.FlowCondition;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * 统一的播报业务
 * @author fangct
 */
@Service
@Slf4j
public class CommonSayHandle {

    @Autowired
    private LedSayHandle ledSayHandle;
    @Autowired
    private LcdSayHandle lcdSayHandle;
    @Autowired
    private ParkService parkService;

    /**
     * 入场播报
     * @param parkId
     * @param plateNum
     * @param type
     * @param resultCode
     * @param para
     * @param ledLcdSource
     * @return
     */
    public String enter(Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para, Integer ledLcdSource) {
        String content = "";
        if (ledLcdSource == 2){
            content = lcdSayHandle.enterHandle(parkId, channelId, plateNum, type, resultCode, para);
        }else{
            content = ledSayHandle.enterHandle(parkId, channelId, plateNum, type, resultCode, para);
        }
        return content;
    }

    public String enter(Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para) {
        ObjectResponse<ParkInoutdevice> channelResp = parkService.getInoutDeviceById(channelId);
        if (ObjectResponse.isSuccess(channelResp)){
            ParkInoutdevice channel = channelResp.getData();
            Integer ledLcdSource = channel.getLedLcdSource();
            return enter(parkId, channelId, plateNum, type, resultCode, para, ledLcdSource);

        }else{
            log.error("未查询到高级配置，车场ID：{}", parkId);
            return "";
        }
    }

    /**
     * 出场播报
     * @param parkId
     * @param plateNum
     * @param type
     * @param resultCode
     * @param para
     * @param displayTerminal
     * @return
     */
    public String exit(Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para, Integer displayTerminal) {
        String content = "";
        if (displayTerminal == 2){
            content = lcdSayHandle.exitHandle(parkId, channelId, plateNum, type, resultCode, para);
        }else{
            content = ledSayHandle.exitHandle(parkId, channelId, plateNum, type, resultCode, para);
        }
        return content;
    }

    public String exit(Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para) {
        ObjectResponse<ParkInoutdevice> channelResp = parkService.getInoutDeviceById(channelId);
        if (ObjectResponse.isSuccess(channelResp)){
            ParkInoutdevice channel = channelResp.getData();
            Integer ledLcdSource = channel.getLedLcdSource();
            return exit(parkId, channelId, plateNum, type, resultCode, para, ledLcdSource);
        }else{
            log.error("未查询到高级配置，车场ID：{}", parkId);
            return "";
        }
    }

}
