package com.icetech.park.service.handle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.icetech.cloudcenter.api.ops.OpsService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.constants.RedisConstants;
import com.icetech.user.domain.entity.ops.OpsUser;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.cloudcenter.domain.enumeration.DataCollectionEnum;
import com.icetech.third.utils.RedisUtils;
import com.icetech.common.constants.RedisKeyConstants;
import com.icetech.common.constants.RedisMsg;
import com.icetech.common.domain.WebSocketMessage;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.Slf4jUtils;
import com.icetech.open.domain.ApiBaseRequest;
import com.icetech.open.domain.request.sms.SmsRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Objects;

@Slf4j
@Component
public class PublicHandle {
    /**
     * 间隔查询时间，50ms
     */
    private static final int INTERVAL = 50;

    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private OrderService orderService;
    @Autowired
    private ParkService parkService;
    @Value("${datacenter.environment}")
    private String environment;
    @Value("${datacenter.monitor.notify.phone}")
    private String notifyPhone;
    @Value("${datacenter.monitor.notify.enabled}")
    private boolean enabled;
    @Autowired
    private OpsService opsService;
    @Resource
    private StringRedisTemplate stringRedisTemplate;

    /**
     * 获取data信息
     * @param messageId
     * @param timeOut
     * @return
     */
    @Deprecated
    public ObjectResponse<String> getDataFromRedis(String messageId, Long timeOut){
        return getDataFromRedis(messageId, timeOut, false);
    }
    /**
     * 获取data信息
     * @param messageId
     * @param timeOut
     * @return
     */
    @Deprecated
    public ObjectResponse<String> getDataFromRedis(String messageId, Long timeOut, boolean isTimeoutSend){
        long currentTimeMillis = System.currentTimeMillis();
        long lastTime = currentTimeMillis + timeOut;
        long halfTime = currentTimeMillis + timeOut/2;
        int n = 1;
        boolean halfFlag = false;
        boolean isOpenWs = false;
        String paraContent = "";
        String parkCode = "";
        //查询redis中是否返回
        while (lastTime > currentTimeMillis) {
            if (redisUtils.isValidity()){
                if (redisUtils.exists(messageId)){
                    ObjectResponse<String> data = redisUtils.get(messageId, new TypeReference<ObjectResponse<String>>(){});
                    log.info("The {}th read from Redis, msgid[{}], return[{}]", n , messageId, data);
                    return data;
                }else if(isTimeoutSend && halfTime < currentTimeMillis && !halfFlag){
                    paraContent = redisUtils.get(RedisConstants.SEND_MSGID_PROFILE + messageId, String.class);
                    parkCode = (String) JsonUtils.parseMap(paraContent).get("parkCode");
                    Long endtime = redisUtils.get(RedisConstants.PNC_HEART_PROFILE + parkCode, Long.class);
                    if(!Objects.isNull(endtime)){
                        if((currentTimeMillis - endtime) < (1000 * 60 * 3)){
                            log.info("处理时间已过半未返回，msgid：{} 即将切换备用协议发送请求",messageId);
                            isOpenWs = true;
                            break;
                        }else{
                            log.info("msgid：{} 3分钟未上报心跳，无法切换备用协议，将继续使用主协议发送请求",messageId);
                        }
                    }

                    // ----------- 兼容端网云WS下发 -----------
                    ObjectResponse<Park> parkResp = parkService.findByParkCode(parkCode);
                    Park park = parkResp.getData();
                    if (park == null) {
                        log.warn("找不到车场信息|{}", parkCode);
                        break;
                    }
                    String protocol =  redisUtils.hGet("pnc:protocol", park.getId().toString(), String.class);
                    boolean b = false;
                    if ("1".equals(protocol)) {
                        WebSocketMessage webSocketMessage = WebSocketMessage.buildMessage("pnc", parkCode, paraContent)
                                .setProtocolType(1).setTrace(Slf4jUtils.getTraceId());
                        redisUtils.getStringRedisTemplate().convertAndSend(RedisKeyConstants.SOCKET_MSG_TOPIC, JSON.toJSONString(webSocketMessage));
                        b = true;
                    }
                    log.info("处理时间已过半，msgid：{} 仍未获取到返回信息，再次发送mqtt消息[{}]", messageId, b);
                    halfFlag = true;
                }
            }
            try {
                Thread.sleep(INTERVAL);
            } catch (InterruptedException e) {
                log.warn(String.valueOf(e.getMessage()), e);
            }
            currentTimeMillis = System.currentTimeMillis();
            n ++;
        }
        if(isOpenWs){
            ObjectResponse objectResponse = sendWsMsg(messageId, parkCode, paraContent, timeOut);
            if(!Objects.isNull(objectResponse)){
                return objectResponse;
            }
        }
        log.info("超时未查询到msgid：{}响应的信息！", messageId);
        return null;
    }

    /**
     * 备用协议发送请求 ws
     * @param messageId
     * @param parkCode
     * @param paraJson
     * @param timeOut
     * @return
     */
    private ObjectResponse sendWsMsg(String messageId,String parkCode,String paraJson,Long timeOut){
        String clientName = parkCode ;
        String[] s = messageId.split("_");
        if(s.length > 1){
            clientName = clientName + "_" +s[0];
        }else{
            clientName = clientName + "_0";
        }
        boolean success = pushAll(clientName, paraJson);
        log.info("<端网云WS下发> 广播{}，相机:[{}]，内容为:{}", success ? "成功" : "失败", clientName, paraJson);
        String key = RedisConstants.RESP_MSG_PROFILE + messageId;
        Long currentTimeMillis = System.currentTimeMillis();
        Long lastTime = currentTimeMillis + 4000;
        int n = 1;
        //查询redis中是否返回
        while (lastTime > currentTimeMillis && success) {
            if (redisUtils.isValidity()){
                if (redisUtils.exists(key)){
                    ObjectResponse data = redisUtils.get(key, ObjectResponse.class);
                    log.info("第{}次从redis中读取到了key：{}响应的信息：{}", n , key, data);
                    return data;
                }
            }
            try {
                Thread.sleep(INTERVAL);
            } catch (InterruptedException e) {
                log.warn(String.valueOf(e.getMessage()), e);
            }
            currentTimeMillis = System.currentTimeMillis();
            n ++;
        }
        return null;
    }
    /**
     * 广播消息到各个订阅者
     * @param clientName
     * @param content
     */
    public boolean pushAll(String clientName, String content){
        try{
            content = clientName + content;
            stringRedisTemplate.convertAndSend(RedisMsg.TOPIC_PNC, content);
        }catch (Exception e){
            log.error("<redis广播发送> clientName：{} 广播失败", clientName, e);
            return false;
        }
        return true;
    }

    /**
     * 本地订单号转换成订单号
     * @param parkId
     * @param orderId
     * @return
     */
    public String convert2OrderNum(Long parkId, String orderId){
        if (orderId == null) {
            return null;
        }
        OrderInfo orderInfo = new OrderInfo();
        orderInfo.setParkId(parkId);
        orderInfo.setLocalOrderNum(orderId);
        ObjectResponse<OrderInfo> byOrderInfo = orderService.findByOrderInfo(orderInfo);
        ObjectResponse.notError(byOrderInfo);
        return byOrderInfo.getData().getOrderNum();
    }

    /**
     * 平台订单号转换成本地订单号
     * @param parkId
     * @param orderNum
     * @return
     */
    public String convert2OrderId(Long parkId, String orderNum){
        if (orderNum == null) {
            return null;
        }
        OrderInfo orderInfo = new OrderInfo();
        orderInfo.setParkId(parkId);
        orderInfo.setOrderNum(orderNum);
        ObjectResponse<OrderInfo> byOrderInfo = orderService.findByOrderInfo(orderInfo);
        ObjectResponse.notError(byOrderInfo);
        return byOrderInfo.getData().getLocalOrderNum();
    }

    public int cloudType(String parkCode){
        //查询车场配置
        ObjectResponse<ParkConfig> parkConfigResponse = parkService.getParkConfig(parkCode);
        ObjectResponse.notError(parkConfigResponse);
        ParkConfig parkConfig = parkConfigResponse.getData();
        return parkConfig.getDataCollection();
    }

    /**
     * 发送短信
     * @param content
     */
    public void sendSmg(String content){
        if (!enabled) {//如果没有开启短信通知，直接返回
            log.info("<短信提醒> 功能未开启，跳过发送！内容：{}", content);
            return;
        }
        String prefixContent = "【云平台"+environment+"环境】";
        ApiBaseRequest<SmsRequest> baseRequest = new ApiBaseRequest<>();
        SmsRequest smsRequest = new SmsRequest();
        smsRequest.setDesMobile(notifyPhone);
        smsRequest.setContent(prefixContent + content);
        smsRequest.setTimes((int)DateTools.unixTimestamp());
        baseRequest.setBizContent(smsRequest);
        try {
            //smgService.sendMsg(baseRequest);
            log.info("<短信提醒> 收信人：{}，内容：{}", smsRequest.getDesMobile(), smsRequest.getContent());
        } catch (Exception e) {
            log.info("短信发送失败，参数：{}", baseRequest, e);
        }
    }
    /**
     * 发送短信
     * @param content
     */
    @Deprecated
    public void sendSmgToOpsUser(String content, Long parkId){
        if (!enabled) {//如果没有开启短信通知，直接返回
            log.info("<短信提醒> 功能未开启，跳过发送！内容：{}", content);
            return;
        }
        String prefixContent = "";//"【云平台"+environment+"环境】";
        ApiBaseRequest<SmsRequest> baseRequest = new ApiBaseRequest<>();
        SmsRequest smsRequest = new SmsRequest();

        ObjectResponse<OpsUser> userObjectResponse = opsService.getPermissionUserByParkId(parkId);
        if (ObjectResponse.isSuccess(userObjectResponse)){
            OpsUser opsUser = userObjectResponse.getData();
            smsRequest.setDesMobile(opsUser.getPhone());
            smsRequest.setContent(prefixContent + content);
            smsRequest.setTimes((int)DateTools.unixTimestamp());
            baseRequest.setBizContent(smsRequest);
            try {
                //smgService.sendMsg(baseRequest);
                log.info("<短信提醒> 收信人：{}，内容：{}", smsRequest.getDesMobile(), smsRequest.getContent());
            } catch (Exception e) {
                log.warn("短信发送失败，参数：{}", baseRequest, e);
            }
        }else{
            log.warn("短信发送失败，未找到运维人员，车场ID：{}", parkId);
        }
    }
}
