package com.icetech.park.service.handle;

import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.DataCollectionEnum;
import com.icetech.cloudcenter.domain.vo.p2c.ParkConnectedDeviceVo;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.WebSocketMessage;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.StringUtils;
import com.icetech.common.utils.UUIDTools;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.handle.CacheHandle;
import com.icetech.third.utils.RedisUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Nullable;

@Service
@Slf4j
public class P2cOperHandle {

    @Autowired
    protected ParkDeviceService parkDeviceService;
    @Autowired
    protected ParkService parkService;
    @Autowired
    protected CacheHandle cacheHandle;
    @Autowired
    protected RedisUtils redisUtils;

    public TokenDeviceVo getAndCacheDevice(WebSocketMessage message) {
        TokenDeviceVo vo = cacheHandle.getDeviceInfo(message.getChannel());
        if (vo != null) {
            boolean update = false;
            if (StringUtils.isNotBlank(message.getOriginalIp()) && !message.getOriginalIp().equals(vo.getOriginalIp())) {
                vo.setOriginalIp(message.getOriginalIp());
                update = true;
            }
            if (StringUtils.isNotBlank(message.getOriginalServer()) && !message.getOriginalServer().equals(vo.getOriginalServer())) {
                vo.setOriginalServer(message.getOriginalServer());
                update = true;
            }
            //如果缓存中的协议类型发生变化，更新缓存
            if (TokenDeviceVo.ProtocolTypeEnum.WS.val != (vo.getSource() == null ? 0 : vo.getSource())){
                vo.setSource(TokenDeviceVo.ProtocolTypeEnum.WS.val);
                update = true;
            }
            if (update) {
                cacheHandle.updateDeviceInfo(message.getChannel(), vo);
            }
            return vo;
        }
        return cacheDevice(message.getChannel(), TokenDeviceVo.ProtocolTypeEnum.WS, message.getVersion(), message.getOriginalServer(), message.getOriginalIp());
    }

    public TokenDeviceVo getAndCacheDevice(String serialNumber, TokenDeviceVo.ProtocolTypeEnum protocolType){
        TokenDeviceVo vo = cacheHandle.getDeviceInfo(serialNumber);
        if (vo != null){
            Integer source = vo.getSource();
            //如果缓存中的协议类型发生变化，更新缓存
            if (protocolType.val != (source == null ? 0 : source)){
                vo.setSource(protocolType.val);
                cacheHandle.updateDeviceInfo(serialNumber, vo);
            }
            return vo;
        }
        return cacheDevice(serialNumber, protocolType, null, null, null);
    }

    public TokenDeviceVo cacheDevice(String serialNumber, TokenDeviceVo.ProtocolTypeEnum protocolType, String version,
                                     @Nullable String originalServer, @Nullable String originalIp) {
        log.info("[设备接入的公共类] 缓存并获取设备信息, sn[{}]", serialNumber);

        ObjectResponse<ParkDevice> parkDeviceResp = parkDeviceService.getDeviceBySerialNumber(serialNumber);
        ParkDevice parkDevice = parkDeviceResp.getData();

        if (parkDevice == null || parkDevice.getType() != 1) {
            throw new ResponseBodyException(CodeConstants.ERROR_12001, CodeConstants.getName(CodeConstants.ERROR_12001));
        }
        version = version == null ?
                (parkDevice.getProtocolVer() == null ? "default" : parkDevice.getProtocolVer()) : version;
        long parkId = parkDevice.getParkId();
        ObjectResponse<Park> byParkCode = parkService.findByParkId(parkId);
        ObjectResponse.notError(byParkCode);
        Park park = byParkCode.getData();
        String parkCode = park.getParkCode();

        ObjectResponse<ParkConfig> configObjectResponse = parkService.getParkConfig(parkId);
        ObjectResponse.notError(configObjectResponse);
        ParkConfig parkConfig = configObjectResponse.getData();
        if (DataCollectionEnum.端网云.getType().equals(parkConfig.getDataCollection())) {
            throw new ResponseBodyException(CodeConstants.ERROR_12001, "连接方式不正确");
        }

        // 根据设备信息中的channelId查询通道信息
        ObjectResponse<ParkInoutdevice> parkInoutdeviceObjectResponse = parkService.getInoutDeviceById(parkDevice.getChannelId().longValue());

        if (!ObjectResponse.isSuccess(parkInoutdeviceObjectResponse)){
            throw new ResponseBodyException(CodeConstants.ERROR_44001, CodeConstants.getName(CodeConstants.ERROR_44001));
        }
        ParkInoutdevice data = parkInoutdeviceObjectResponse.getData();
        TokenDeviceVo tokenDeviceVo = cacheHandle.getDeviceInfo(serialNumber);
        String token;
        if (tokenDeviceVo == null || tokenDeviceVo.getToken() == null){
            token = UUIDTools.getUuid();
        } else {
            token = tokenDeviceVo.getToken();
        }

        Integer inandoutType = data.getInandoutType();
        ParkConnectedDeviceVo parkConnectedDeviceVo = new ParkConnectedDeviceVo();
        parkConnectedDeviceVo.setDeviceNo(serialNumber);
        parkConnectedDeviceVo.setInandoutCode(data.getInandoutCode());
        parkConnectedDeviceVo.setRegionId(data.getRegionId());
        parkConnectedDeviceVo.setInandoutType(inandoutType);
        parkConnectedDeviceVo.setId(data.getId());
        // 默认为主相机，如果是双摄像机，并且配置为从相机，则设备为false
        parkConnectedDeviceVo.setMaster(parkDevice.getIsDualcamera() == null || parkDevice.getIsDualcamera() == 0
                || parkDevice.getIsMaster() == null || parkDevice.getIsMaster() == 1);
        //更新已连接设备列表
        cacheHandle.addParkConnectList(parkCode, parkConnectedDeviceVo);

        TokenDeviceVo tdv = new TokenDeviceVo();
        //车场属性
        tdv.setParkId(park.getId());
        tdv.setParkCode(parkCode);
        //设备属性
        tdv.setDeviceNo(serialNumber);
        tdv.setMaster(parkConnectedDeviceVo.isMaster());
        tdv.setVersion(version);
        tdv.setSource(TokenDeviceVo.ProtocolTypeEnum.WS.equals(protocolType) ? 1 : 2);
        //通道数据
        tdv.setId(data.getId());
        tdv.setInandoutName(data.getInandoutName());
        tdv.setInandoutCode(data.getInandoutCode());
        tdv.setRegionId(data.getRegionId());
        tdv.setInandoutType(data.getInandoutType());
        tdv.setToken(token);
        tdv.setOriginalServer(originalServer);
        tdv.setOriginalIp(originalIp);
        //存放token对应的相机信息
        cacheHandle.cacheDeviceInfo(serialNumber, tdv);
        //存放平台设备编号和相机序列号的映射，如果是双摄相机模式，只存主相机序列号，如果主相机不在线，从相机在线，则存从相机序列号
        cacheHandle.setChannelSn(parkCode, data.getInandoutCode(), serialNumber, parkConnectedDeviceVo.isMaster());

        return tdv;
    }
}
