package com.icetech.park.service.handle;

import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.vo.p2c.ParkConnectedDeviceVo;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.UUIDTools;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.third.utils.RedisUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Slf4j
public class MorOperHandle {

    @Autowired
    protected ParkDeviceService parkDeviceService;
    @Autowired
    protected ParkService parkService;
    @Autowired
    protected MorCacheHandle cacheHandle;
    @Autowired
    protected RedisUtils redisUtils;

    public TokenDeviceVo getAndCacheDevice(String serialNumber){
        TokenDeviceVo vo = cacheHandle.getDeviceInfo(serialNumber);
        if (vo != null){
            cacheHandle.expireDeviceInfo(serialNumber);
            cacheHandle.setChannelSn(vo.getParkCode(), vo.getInandoutCode(), serialNumber);
            cacheHandle.updateLastConnTime(serialNumber, DateTools.unixTimestamp());
            return vo;
        }
        return cacheDevice(serialNumber,  null);
    }

    public TokenDeviceVo cacheDevice(String serialNumber, String version){
        log.info("[端云监控相机接入的公共类]缓存并获取设备信息, sn[{}]", serialNumber);

        ObjectResponse<ParkDevice> parkDeviceResp = parkDeviceService.getDeviceBySerialNumber(serialNumber);
        ParkDevice parkDevice = parkDeviceResp.getData();

        if (parkDevice == null || parkDevice.getType() != 9) {
            throw new ResponseBodyException(CodeConstants.ERROR_12001, CodeConstants.getName(CodeConstants.ERROR_12001));
        }
        version = version == null ?
                (parkDevice.getProtocolVer() == null ? "default" : parkDevice.getProtocolVer()) : version;
        long parkId = parkDevice.getParkId();
        ObjectResponse<Park> byParkCode = parkService.findByParkId(parkId);
        ObjectResponse.notError(byParkCode);
        Park park = byParkCode.getData();
        String parkCode = park.getParkCode();

        // 根据设备信息中的channelId查询通道信息
        ObjectResponse<ParkInoutdevice> parkInoutdeviceObjectResponse = parkService.getInoutDeviceById(parkDevice.getChannelId().longValue());

        if (!ObjectResponse.isSuccess(parkInoutdeviceObjectResponse)){
            throw new ResponseBodyException(CodeConstants.ERROR_44001, CodeConstants.getName(CodeConstants.ERROR_44001));
        }
        ParkInoutdevice data = parkInoutdeviceObjectResponse.getData();
        TokenDeviceVo tokenDeviceVo = cacheHandle.getDeviceInfo(serialNumber);
        String token;
        if (tokenDeviceVo == null || tokenDeviceVo.getToken() == null){
            token = UUIDTools.getUuid();
        } else {
            token = tokenDeviceVo.getToken();
        }

        TokenDeviceVo tdv = new TokenDeviceVo();
        //车场属性
        tdv.setParkId(park.getId());
        tdv.setParkCode(parkCode);
        //设备属性
        tdv.setDeviceNo(serialNumber);
        tdv.setVersion(version);
        //通道数据
        tdv.setId(data.getId());
        tdv.setInandoutName(data.getInandoutName());
        tdv.setInandoutCode(data.getInandoutCode());
        tdv.setRegionId(data.getRegionId());
        tdv.setInandoutType(data.getInandoutType());
        tdv.setToken(token);
        //存放token对应的相机信息
        cacheHandle.cacheDeviceInfo(serialNumber, tdv);
        //存放平台设备编号和相机序列号的映射，如果是双摄相机模式，只存主相机序列号，如果主相机不在线，从相机在线，则存从相机序列号
        cacheHandle.setChannelSn(parkCode, data.getInandoutCode(), serialNumber);
        cacheHandle.updateLastConnTime(serialNumber, DateTools.unixTimestamp());

        ParkConnectedDeviceVo parkConnectedDeviceVo = new ParkConnectedDeviceVo();
        parkConnectedDeviceVo.setDeviceNo(serialNumber);
        parkConnectedDeviceVo.setId(data.getId());
        parkConnectedDeviceVo.setInandoutType(data.getInandoutType());
        parkConnectedDeviceVo.setRegionId(data.getRegionId());
        parkConnectedDeviceVo.setInandoutCode(data.getInandoutCode());
        cacheHandle.addParkConnectList(parkCode, parkConnectedDeviceVo);
        return tdv;
    }
}
