package com.icetech.park.service.handle;

import com.icetech.cloudcenter.domain.enumeration.MorDownCmdEnum;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.UUIDTools;
import com.icetech.park.service.down.Message;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * 端云架构的发送消息
 */
@Component
@Slf4j
public class MorDownHandle extends BaseDownHandle {
    @Autowired
    private MorCacheHandle cacheHandle;

    private static final String productKey = "05422AF9FC1CF378";
    public static final String DEVICE_PROFILE = "mor";
    /**
     * 同步返回的服务
     */
    private static final List<String> SYNC_CMD_LIST = new ArrayList<>();

    static {
        SYNC_CMD_LIST.add(MorDownCmdEnum.标记疑似跟车.getCmd());
        SYNC_CMD_LIST.add(MorDownCmdEnum.请求车辆视频.getCmd());
        SYNC_CMD_LIST.add(MorDownCmdEnum.OSS配置下发.getCmd());
    }

    /**
     * 给某一个设备发送消息
     *
     * @param serialNumber sn
     * @param message 消息结构体
     * @return messageId
     */
    @Override
    public String send(String serialNumber, Message message) {

        Integer reqServiceType = message.getReqServiceType();
        Object payload = message.getPayload();

        P2cBaseRequest<Object> p2cBaseRequest = new P2cBaseRequest<>();
        p2cBaseRequest.setCmd(MorDownCmdEnum.getCmd(reqServiceType));
        String messageId = UUIDTools.getUuid();
        p2cBaseRequest.setMessageId(messageId);
        TokenDeviceVo tokenInfo = cacheHandle.getDeviceInfo(serialNumber);
        log.info("serialNumber[{}] tokenInfo[{}]", serialNumber, tokenInfo);
        if (tokenInfo == null) {
            return null;
        }
        //p2cBaseRequest.setProductKey(productKey);
        p2cBaseRequest.setBizContent(payload);
        String paraJson = JsonUtils.toString(p2cBaseRequest);
        boolean success;
        success = pushAll(serialNumber, p2cBaseRequest, "mor");
        log.info("[监控相机WS下发] 广播{}, 设备[{}], 内容[{}]", success ? "成功" : "失败", serialNumber, paraJson);
        if (success) {
            addRequestRecord(message, messageId, payload, serialNumber);
        }
        return success ? messageId : null;
    }

    @Override
    protected List<String> getSyncCmdList() {
        return SYNC_CMD_LIST;
    }


    @Override
    protected String getDeviceProfile() {
        return DEVICE_PROFILE;
    }

}
