package com.icetech.park.service.handle;

import org.apache.commons.lang3.StringUtils;

import static com.icetech.cloudcenter.domain.constants.BatchDownMsgConstants.*;

/**
 * @author fangct
 */
public class BatchDownUtils {
    /**
     * 转换错误提示
     * @param msg
     * @return
     */
    public static String convertMsg(String msg){
        if (msg.contains("data over the limit") || msg.contains("data overlimit")){
            msg = NO_SPACE;
        }else if (msg.contains("format invalid")){
            msg = FORMAT_INVALID;
        }else if (msg.contains("invalid param")){
            msg = INVALID_PARAM;
        }
        return msg;
    }
    /**
     * 获取最新失败原因
     * @param old
     * @param append
     * @return 返回空时，不更新原因
     */
    public static String convertMsgAndGetNewMsg(String old, String append){
        append = convertMsg(append);
        if (StringUtils.isNotEmpty(old)) {
            String newMsg = old + "," + append;
            if (newMsg.length() < 256) {
                if (old.contains(append)){
                    return old;
                }else{
                    return newMsg;
                }
            }else{
                return old;
            }
        } else {
            return append;
        }
    }
}
