package com.icetech.park.service.handle;

import cn.hutool.core.util.StrUtil;
import com.icetech.cloudcenter.api.third.SendInfoService;
import com.icetech.basics.constants.TextConstant;
import com.icetech.cloudcenter.domain.base.Request;
import com.icetech.cloudcenter.domain.request.p2c.LcdConfigRequest;
import com.icetech.cloudcenter.domain.request.p2c.LedsoundConfigRequest;
import com.icetech.common.utils.DateTools;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.constants.RedisConstants;
import com.icetech.park.dao.BatchsendTaskDao;
import com.icetech.park.dao.BatchsendTaskSubDao;
import com.icetech.park.domain.entity.BatchsendTask;
import com.icetech.park.domain.entity.BatchsendTaskSub;
import com.icetech.cloudcenter.domain.vo.BatchSendRepeatVO;
import com.icetech.cloudcenter.domain.vo.BatchSendVO;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.cloudcenter.domain.enumeration.CodeEnum;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.enumeration.P2cVersionEnum;
import com.icetech.park.service.down.Message;
import com.icetech.park.handle.CacheHandle;
import com.icetech.third.utils.RedisUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import static com.icetech.cloudcenter.domain.constants.BatchDownMsgConstants.DEVICE_OFF_LINE;
import static com.icetech.cloudcenter.domain.constants.BatchDownMsgConstants.NO_CAMERA;

/**
 * @author fangct
 */
@Service
@Slf4j
public class BatchDownConfigHandle<T> {

    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private BatchsendTaskDao batchsendTaskDao;
    @Autowired
    private BatchsendTaskSubDao batchsendTaskSubDao;
    @Autowired
    private P2cDownHandle p2CDownHandle;
    @Autowired
    private SendInfoService sendInfoService;
    @Autowired
    private CacheHandle cacheHandle;

    public void batchDown(BatchSendVO vo, T data, int cmdType) {
        String parkCode = vo.getParkCode();
        Long parkId = vo.getParkId();
        List<BatchSendVO.SubTaskInfo> subTaskInfos = vo.getSubTaskInfos();
        int size = 1;

        Message<?> message = new Message<>(parkId, cmdType, data);
        for (int i = 0; i < subTaskInfos.size(); i++){
            BatchSendVO.SubTaskInfo subTaskInfo = subTaskInfos.get(i);

            //缓存子任务详情
            Integer subTaskId = subTaskInfo.getSubTaskId();
            String subTaskKey = RedisConstants.BATCH_DOWN_SUBTASK_HASH + subTaskId;
            redisUtils.hPut(subTaskKey, "totalNum", size);

            String sn = subTaskInfo.getSn();
            if (StrUtil.isBlank(sn)){
                redisUtils.hPut(subTaskKey, "status", 3);
                redisUtils.hPut(subTaskKey, "failNum", size);
                redisUtils.hPut(subTaskKey, "reason", NO_CAMERA);

                finishErrorTask(size, subTaskId, NO_CAMERA);
            }else{
                TokenDeviceVo tokenDeviceVo = cacheHandle.getDeviceInfo(sn);
                String version = tokenDeviceVo == null ? null : tokenDeviceVo.getVersion();
                if (P2cDownCmdEnum.LCD自定义语音屏显配置.getCmdType().equals(cmdType)
                        || P2cDownCmdEnum.自定义语音屏显配置.getCmdType().equals(cmdType)
                        || P2cDownCmdEnum.计费规则.getCmdType().equals(cmdType)) {
                    if (version != null && P2cVersionEnum.getIndex(version) < P2cVersionEnum.版本4.getIndex()) {
                        String error = "相机版本过低，无法下发";
                        redisUtils.hPut(subTaskKey, "status", 3);
                        redisUtils.hPut(subTaskKey, "failNum", size);
                        redisUtils.hPut(subTaskKey, "reason", error);
                        finishErrorTask(size, subTaskId, error);
                        continue;
                    }
                }

                if (P2cDownCmdEnum.自定义语音屏显配置.getCmdType().equals(cmdType)) {
                    LedsoundConfigRequest ledsoundConfigRequest = (LedsoundConfigRequest) data;
//                    if  (tokenDeviceVo == null || NumberUtils.toPrimitive(tokenDeviceVo.getInandoutType()) == 2) {
//                        if (ledsoundConfigRequest.getFreePerLineColorExit() != null) {
//                            ledsoundConfigRequest.setFreePerLineColor(ledsoundConfigRequest.getFreePerLineColorExit());
//                        }
//                        if (ledsoundConfigRequest.getBusyPerLineColorExit() != null) {
//                            ledsoundConfigRequest.setBusyPerLineColor(ledsoundConfigRequest.getBusyPerLineColorExit());
//                        }
//                    } else {
//                        ledsoundConfigRequest.setFreePerLineColor(ledsoundConfigRequest.getFreePerLineColorEnter());
//                        ledsoundConfigRequest.setBusyPerLineColor(ledsoundConfigRequest.getBusyPerLineColorEnter());
//                    }
                    message = new Message<>(parkId, cmdType, ledsoundConfigRequest);
                } else if (P2cDownCmdEnum.LCD自定义语音屏显配置.getCmdType().equals(cmdType)) {
                    LcdConfigRequest lcdConfigRequest = (LcdConfigRequest) data;
                    message = new Message<>(parkId, cmdType, lcdConfigRequest);
                }
                if (tokenDeviceVo != null && tokenDeviceVo.getVersion() != null) {
                    //根据版本号，重新构建参数
                    Object payload = message.getPayload();
                    if (payload instanceof List) {
                        List list = (List) payload;
                        Object object = list.get(0);
                        if (object instanceof Request) {
                            for (Object o : list) {
                                Request request = (Request) o;
                                request.buildByVersion(tokenDeviceVo.getVersion());
                            }
                        }
                    } else if (payload instanceof Request) {
                        Request request = (Request) payload;
                        request.buildByVersion(tokenDeviceVo.getVersion());
                    }
                }
                //下发消息，并异步处理响应结果
                String messageId = p2CDownHandle.send(parkCode, sn, message);
                redisUtils.set(RedisConstants.BATCH_DOWN_OPEN_FLAG + parkId + ":" + cmdType, 1, 600L);
                if (messageId == null) {
                    redisUtils.hPut(subTaskKey, "status", 3);
                    redisUtils.hPut(subTaskKey, "failNum", size);
                    redisUtils.hPut(subTaskKey, "reason", DEVICE_OFF_LINE);

                    finishErrorTask(size, subTaskId, DEVICE_OFF_LINE);
                } else {
                    redisUtils.hPut(subTaskKey, "status", 2);
                    redisUtils.set(RedisConstants.BATCH_DOWN_MSGID + messageId, subTaskId, 10L);
                }
            }
        }
    }

    public void repeatBatch(BatchSendRepeatVO vo, T data, int cmdType) {
        String parkCode = vo.getParkCode();
        Long parkId = vo.getParkId();
        Integer subTaskId = vo.getSubTaskId();
        String sn = vo.getSn();

        int size = 1;
        Message message = new Message(parkId, cmdType, data);

        String subTaskKey = RedisConstants.BATCH_DOWN_SUBTASK_HASH + subTaskId;
        redisUtils.expire(subTaskKey, 60 * 60);
        redisUtils.hPut(subTaskKey, "startTime", DateTools.unixTimestamp());

        TokenDeviceVo tokenDeviceVo = cacheHandle.getDeviceInfo(sn);
        String version = tokenDeviceVo == null ? null : tokenDeviceVo.getVersion();
        if (P2cDownCmdEnum.LCD自定义语音屏显配置.getCmdType().equals(cmdType)
                || P2cDownCmdEnum.自定义语音屏显配置.getCmdType().equals(cmdType)
                || P2cDownCmdEnum.计费规则.getCmdType().equals(cmdType)) {
            if (version != null && P2cVersionEnum.getIndex(version) < P2cVersionEnum.版本4.getIndex()) {
                String error = "相机版本过低，无法下发";
                redisUtils.hPut(subTaskKey, "status", 3);
                redisUtils.hPut(subTaskKey, "failNum", size);
                redisUtils.hPut(subTaskKey, "reason", error);
                finishErrorTask(size, subTaskId, error);
                return;
            }
        }
        //下发消息，并异步处理响应结果
        String messageId = p2CDownHandle.send(parkCode, sn, message);
        redisUtils.set(RedisConstants.BATCH_DOWN_OPEN_FLAG + parkId + ":" + cmdType, 1, 600L);
        String reason = redisUtils.hGet(subTaskKey, "reason", String.class);
        if (messageId == null) {
            String error = BatchDownUtils.convertMsgAndGetNewMsg(reason, DEVICE_OFF_LINE);
            redisUtils.hPut(subTaskKey, "status", 3);
            redisUtils.hPut(subTaskKey, "failNum", size);
            redisUtils.hPut(subTaskKey, "reason", error);
            finishErrorTask(size, subTaskId, error);

        } else {
            redisUtils.hPut(subTaskKey, "status", 2);
            redisUtils.set(RedisConstants.BATCH_DOWN_MSGID + messageId, subTaskId, 60L);
        }

    }


    private void finishErrorTask(int size, Integer subTaskId, String reason) {

        BatchsendTaskSub batchsendTaskSub = new BatchsendTaskSub();
        batchsendTaskSub.setId(subTaskId);
        batchsendTaskSub.setStatus(3);
        batchsendTaskSub.setTotalNum(1);
        batchsendTaskSub.setFailNum(size);
        batchsendTaskSub.setReason(reason);
        batchsendTaskSubDao.updateById(batchsendTaskSub);
    }

    public void dealBatchResponse(P2cBaseResponse<String> p2CBaseResponse, Integer subTaskId, Long parkId){
        Integer code = p2CBaseResponse.getCode();
        Integer cmdType = P2cDownCmdEnum.getCmdType(p2CBaseResponse.getCmd().replace("_resp", ""));
        String subTaskKey = RedisConstants.BATCH_DOWN_SUBTASK_HASH + subTaskId;
        if (code.equals(CodeEnum.成功.getCode())) {
            log.info("[批量配置下发响应]子任务ID处理成功[{}]", subTaskId);
            redisUtils.hPut(subTaskKey, "status", 3);
            redisUtils.hPut(subTaskKey, "successNum", 1);
            redisUtils.hPut(subTaskKey, "failNum", 0);
            redisUtils.hDelete(subTaskKey, "reason");
        }else {
            redisUtils.hPut(subTaskKey, "status", 3);
            redisUtils.hPut(subTaskKey, "failNum", 1);
            redisUtils.hPut(subTaskKey, "successNum", 0);
            redisUtils.hPut(subTaskKey, "reason", BatchDownUtils.convertMsg(p2CBaseResponse.getMsg()));
        }
        finishSubTask(subTaskId, parkId, cmdType, subTaskKey);
    }

    private void finishSubTask(Integer subTaskId, Long parkId, Integer cmdType, String subTaskKey) {

        BatchsendTaskSub batchsendTaskSub = new BatchsendTaskSub();
        batchsendTaskSub.setId(subTaskId);
        batchsendTaskSub.setStatus(3);
        batchsendTaskSub.setSuccessNum(1);
        batchsendTaskSub.setFailNum(0);
        batchsendTaskSub.setTotalNum(redisUtils.hGet(subTaskKey, "totalNum", Integer.class));
        batchsendTaskSubDao.updateById(batchsendTaskSub);

        List<Long> idLongList = new ArrayList<>();
        idLongList.add(parkId);
        sendInfoService.updateSuccessByServiceIds(idLongList, cmdType, TextConstant.getSuccessDefaultMessage(TextConstant.ONE));
        log.info("[批量配置下发响应]更新下发表状态成功,业务类型[{}],id集合[{}]", cmdType, idLongList);

        //判断其他任务是否成功
        String taskId = redisUtils.hGet(subTaskKey, "taskId", String.class);
        Integer currDataType = redisUtils.hGet(subTaskKey, "serviceType", Integer.class);
        dealOtherSubTask(parkId, cmdType, taskId, currDataType);
    }

    /**
     * 判断其他任务是否成功
     * @param parkId
     * @param cmdType
     * @param taskId
     * @param currDataType
     */
    private void dealOtherSubTask(Long parkId, Integer cmdType, String taskId, Integer currDataType) {
        String taskIdKey = RedisConstants.BATCH_DOWN_TASK_LIST + taskId;
        List<Integer> subTaskList = redisUtils.lRange(taskIdKey, 0, -1, Integer.class);
        if (subTaskList != null && subTaskList.size() > 0){
            boolean isAllDataTypeOK = true;
            boolean isAllOk = true;
            for (int i = 0; i < subTaskList.size(); i++){
                Integer subT = subTaskList.get(i);
                Integer status = redisUtils.hGet(RedisConstants.BATCH_DOWN_SUBTASK_HASH + subT, "status", Integer.class);
                Integer dataType = redisUtils.hGet(RedisConstants.BATCH_DOWN_SUBTASK_HASH + subT, "serviceType", Integer.class);
                if (status != 3){
                    isAllOk = false;
                    if (currDataType.equals(dataType)){
                        isAllDataTypeOK = false;
                    }
                    break;
                }
            }
            if (isAllOk){
                BatchsendTask batchsendTask = new BatchsendTask();
                batchsendTask.setTaskId(taskId);
                batchsendTask = batchsendTaskDao.selectOneByEntity(batchsendTask);
                batchsendTask.setStatus(3);
                batchsendTaskDao.updateById(batchsendTask);

            }
            if (isAllDataTypeOK){
                //关闭批量处理的状态
                redisUtils.remove(RedisConstants.BATCH_DOWN_OPEN_FLAG + parkId + ":" + cmdType);
                log.info("[批量配置下发响应]所有下发配置都已结束[{}],dataType[{}]", taskId, currDataType);
            }
        }
    }
}
