package com.icetech.park.service.handle;

import cn.hutool.core.io.FileUtil;
import com.alibaba.fastjson.JSON;
import com.icetech.cloudcenter.domain.constants.RedisConstants;
import com.icetech.cloudcenter.domain.enumeration.CodeEnum;
import com.icetech.cloudcenter.domain.enumeration.SendOperTypeEnum;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.common.constants.RedisKeyConstants;
import com.icetech.common.constants.TimeOutConstants;
import com.icetech.common.domain.P2cBaseMsg;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.oss.OssService;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.Message;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import com.icetech.third.utils.RedisUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

/**
 * 端云架构的发送消息
 */
@Slf4j
public class BaseDownHandle {
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private OssService ossService;
    @Autowired
    private RedisTemplate redisTemplate;

    protected List<String> getSyncCmdList() {
        return new ArrayList<>();
    }
    /**
     * 给某一个设备发送消息
     *
     * @param serialNumber
     * @param message
     * @return
     */
    public String send(String serialNumber, Message message) {
        return null;
    }

    protected String getDeviceProfile() {
        return "common";
    }

    /**
     * 响应处理
     *
     * @param p2CBaseResponse
     * @param parkId
     * @param serviceType
     * @return
     */
    public void dealResponse(P2cBaseResponse<String> p2CBaseResponse, Long parkId, Integer serviceType) {
        String messageId = p2CBaseResponse.getMessageId();
        SendInfoRecord sendinfoRecord = redisUtils.get(RedisKeyConstants.MQ_RECORD_PREFIX + messageId, SendInfoRecord.class);
        if (sendinfoRecord == null) {
            sendinfoRecord = new SendInfoRecord();
            sendinfoRecord.setServiceType(serviceType);
            sendinfoRecord.setMessageId(messageId);
            sendinfoRecord.setParkId(parkId);
        }

        Integer code = p2CBaseResponse.getCode();
        String cmd = p2CBaseResponse.getCmd();
        String msg = p2CBaseResponse.getMsg();
        cmd = cmd.substring(0, cmd.indexOf(AbstractService.CMD_SUFFIX));
        String data = p2CBaseResponse.getData();
        String key = RedisConstants.RESP_MSG_PROFILE + messageId;
        //同步返回条件：不包含数据下发业务，且业务ID为空
        if (getSyncCmdList().contains(cmd)) {
            ObjectResponse<String> retResponse = new ObjectResponse<>();
            retResponse.setCode(String.valueOf(code));
            retResponse.setMsg(msg);
            if (CodeEnum.成功.getCode().equals(code)) {//如果相机处理成功
                if (StringUtils.isNotEmpty(p2CBaseResponse.getResultPath())) {
                    //从oss 获取配置
                    File oss2File = ossService.getOSS2File(p2CBaseResponse.getResultPath());
                    //读取文件内容
                    data = FileUtil.readString(oss2File, "utf-8");
                }
            }
            retResponse.setData(data);
            redisUtils.set(key, retResponse, TimeOutConstants.REDIS_TIMEOUT);
            int valueLen = retResponse.toString().length();
            log.info("[监控相机响应处理] 写入redis成功,key[{}],value[{}]", key, valueLen > 1024
                    ? retResponse.toString().substring(0, 1024) + "..." : retResponse);
        }
    }

    /**
     * 添加请求记录
     *
     * @param message
     * @param messageId
     * @param t
     * @param serialNumber
     */
    protected void addRequestRecord(Message message, String messageId, Object t, String serialNumber) {
        SendInfoRecord<Object> sendinfoRecord = new SendInfoRecord<>();
        sendinfoRecord.setMessageId(messageId);
        sendinfoRecord.setParkId(message.getParkId());
        sendinfoRecord.setParams(t);
        sendinfoRecord.setServiceId(message.getServiceId());
        sendinfoRecord.setServiceType(message.getServiceType());
        sendinfoRecord.setTarget(serialNumber);
        sendinfoRecord.setOperType(SendOperTypeEnum.请求.getOperType());
        sendinfoRecord.setTaskId(message.getTaskId());
        sendinfoRecord.setRecordId(message.getRecordId());
        redisUtils.set(RedisKeyConstants.MQ_RECORD_PREFIX + messageId, sendinfoRecord, TimeOutConstants.REDIS_TIMEOUT);
    }

    /**
     * 广播消息到各个订阅者
     *
     * @param sn             sn
     * @param p2cBaseRequest 请求参数
     */
    public boolean pushAll(String sn, P2cBaseRequest<?> p2cBaseRequest) {
        return pushAll(sn, p2cBaseRequest, getDeviceProfile());
    }

    /**
     * 广播消息到各个订阅者
     *
     * @param sn             sn
     * @param p2cBaseRequest 请求参数
     */
    public boolean pushAll(String sn, P2cBaseRequest<?> p2cBaseRequest, String module) {
        try {
            P2cBaseMsg<?> p2cBaseMsg = new P2cBaseMsg<>();
            BeanUtils.copyProperties(p2cBaseRequest, p2cBaseMsg);
            p2cBaseMsg.setSn(sn);
            p2cBaseMsg.setModule(StringUtils.isEmpty(module) ? getDeviceProfile() : module);
            String message = JSON.toJSONString(p2cBaseMsg);
            log.info("[redis广播发送] {}", message);
            redisTemplate.convertAndSend(RedisKeyConstants.SOCKET_MSG_TOPIC, message);
            return true;
        } catch (Exception e) {
            log.error("[redis广播发送] clientName[{}]广播失败", sn, e);
            return false;
        }
    }
}
