package com.icetech.park.service.flow.p2c.impl;

import com.icetech.cloudcenter.api.discount.MerchantDiscountService;
import com.icetech.cloudcenter.api.order.OrderCarInfoService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.third.ThirdInfoService;
import com.icetech.order.domain.entity.OrderTags;
import com.icetech.cloudcenter.domain.constants.DingZhiFuncConstants;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.park.service.impl.QueryThirdFeeServiceImpl;
import com.icetech.third.domain.entity.third.ThirdInfo;
import com.icetech.basics.domain.entity.VipType;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.request.QueryOrderFeeRequest;
import com.icetech.cloudcenter.domain.request.ThirdFeeRequest;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.cloudcenter.domain.response.p2c.CarEnterResult;
import com.icetech.park.service.flow.p2c.FlowCondition;
import com.icetech.order.service.OrderTagsService;
import com.icetech.park.service.order.impl.enter.CarOrderEnterServiceImpl;
import com.icetech.park.service.report.ReportParamHolder;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.OrderCarInfoConstant;
import com.icetech.common.constants.OrderStatusConstants;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.partner.api.ThirdAutoPayService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * @author kate
 */
@RefreshScope
@Component
@Slf4j
public class CarExitFlowProcessImpl extends FlowCondition {

    @Autowired
    private OrderService orderService;
    @Autowired
    private CarOrderEnterServiceImpl carOrderEnterService;
    @Autowired
    private MerchantDiscountService merchantDiscountService;
    @Autowired
    protected ThirdAutoPayService thirdAutoPayService;
    @Autowired
    private ThirdInfoService thirdInfoService;
    @Autowired
    private QueryThirdFeeServiceImpl queryThirdFeeService;
    @Autowired
    private OrderTagsService orderTagsService;
    @Autowired
    private OrderCarInfoService orderCarInfoService;
    @Value("${exit.secondRec.freeTime:300}")
    private Integer exitSecondRecFreeTime;

    /**
     * 离场流程处理
     */
    public FlowRet flowHandle(OrderInfo orderInfo, CarExitRequest exitRequest, ReportParamHolder paramHolder) {
        String plateNum = exitRequest.getPlateNum();
        FlowRet flowRet = new FlowRet();

        ParkConfig parkConfig = paramHolder.getParkConfig();
        //获取当前通道的权限
        ParkInoutdevice parkInoutdevice = paramHolder.getParkChannel();
        if (filter(exitRequest.getParkCode(), exitRequest.getParkId(), exitRequest.getPlateNum(), parkConfig, exitRequest.getInandoutCode(), 2, exitRequest.getOriginalExitTime())){
            flowRet.setResultCode(ResultCode.离场限制);
        }else{
            if (hasPlate(plateNum)){
                flowRet = hasPlateResultCode(orderInfo, exitRequest, paramHolder);
            }else{
                if (Integer.valueOf(0).equals(parkInoutdevice.getIsAllowTempcarrun())) {
                    flowRet.setResultCode(ResultCode.不允许临时车出);
                } else {
                    ResultCode code = getNoPlateResultCode(paramHolder);
                    flowRet.setResultCode(code);
                }
            }
        }
        log.info("[离场流程处理] 车牌号[{}], 判断结果为[{}]", plateNum, flowRet.getResultCode().name());
        return flowRet;
    }

    private FlowRet hasPlateResultCode(OrderInfo orderInfo, CarExitRequest exitRequest, ReportParamHolder paramHolder) {
        if (orderInfo != null){
            return hasEnter(orderInfo, exitRequest, paramHolder);
        }else{
            return noEnter(exitRequest, paramHolder);
        }
    }

    private FlowRet hasEnter(OrderInfo orderInfo, CarExitRequest exitRequest, ReportParamHolder paramHolder) {
        Long exitTime = exitRequest.getExitTime();
        FlowRet flowRet = new FlowRet();
        Map<String, Object> paramMap = new HashMap<>();
        String parkCode = paramHolder.getParkCode();
        Integer type = orderInfo.getType();
        String channelId = exitRequest.getInandoutCode();
        ParkConfig parkConfig = paramHolder.getParkConfig();
        //获取当前通道的权限
        ParkInoutdevice parkInoutdevice = paramHolder.getParkChannel();
        Park park = paramHolder.getParkInfo();

        //同步为入场时的车辆类型
        exitRequest.setType(type);
        //判断是否是黑名单车辆
        if (isBlacklist(paramHolder) && parkInoutdevice.getIsAllowBackCar() == 0){
            queryFeeHandle(orderInfo, exitTime, flowRet, paramMap, parkCode, channelId, parkConfig);

            if (isShowBlackCar(paramHolder)){
                paramMap.put("isShow", 1);
            }else{//不显示
                paramMap.put("isShow", 0);
            }
            flowRet.setPara(paramMap);
            flowRet.setResultCode(ResultCode.黑名单车);
            return flowRet;
        }
        if (isWhitelist(paramHolder)) {
            flowRet.setResultCode(ResultCode.内部车辆);
            flowRet.setPara(paramMap);
            return flowRet;
        }
        //不是场中场的月卡或者不是主通道时才会免费放行，否则要考虑小场不是月卡的情况
        if ((NumberUtils.toPrimitive(park.getIsInterior()) == 0
                || (NumberUtils.toPrimitive(parkInoutdevice.getIsMaster()) == 0))
                && type == 2
                && (NumberUtils.toPrimitive(orderInfo.getSwitchTime()) == 0)
                && isAllDayMonthCard(paramHolder, orderInfo, exitRequest.getExitTime())) {
            flowRet.setResultCode(ResultCode.月卡车);
            flowRet.setPara(paramMap);
            return flowRet;
        }
        //不是场中场的月卡或者不是主通道时才会免费放行，场内办理月卡包含进场到出场时间的情况
        if ((NumberUtils.toPrimitive(park.getIsInterior()) == 0
                || (NumberUtils.toPrimitive(parkInoutdevice.getIsMaster()) == 0))
                && type == 1
                && inParkCreateInvalidCard(paramHolder, orderInfo, exitTime)){
            exitRequest.setType(PlateTypeEnum.月卡车.getType());
            orderInfo.setType(PlateTypeEnum.月卡车.getType());
            flowRet.setResultCode(ResultCode.月卡车);
            flowRet.setPara(paramMap);
            return flowRet;
        }
        //当前车辆类型
        if (isSpecial(type) && isSpecialFree(parkConfig)){
            flowRet.setResultCode(ResultCode.特殊车辆免费);
            flowRet.setPara(paramMap);
            return flowRet;
        }
        //判断公务车是否免费
        if (isFreeOfficialCars(parkConfig, exitRequest.getPlateNum())){
            flowRet.setResultCode(ResultCode.特殊车辆免费);
            flowRet.setPara(paramMap);
            return flowRet;
        }
        if (isInnerCar(paramHolder)){
            flowRet.setResultCode(ResultCode.内部车辆);
            flowRet.setPara(paramMap);
            return flowRet;
        }
        if (PlateTypeEnum.临时车.getType().equals(type)
                && Integer.valueOf(0).equals(parkInoutdevice.getIsAllowTempcarrun())) {
            flowRet.setResultCode(ResultCode.不允许临时车出);
            flowRet.setPara(paramMap);
            return flowRet;
        }
        //查询当前通道是否计费
        if ((NumberUtils.toPrimitive(park.getIsInterior()) == 1)
                && NumberUtils.toPrimitive(parkInoutdevice.getIsFee()) == 0) {
            flowRet.setResultCode(ResultCode.无需缴费);
            flowRet.setPara(paramMap);
            return flowRet;
        }
        queryFeeHandle(orderInfo, exitTime, flowRet, paramMap, parkCode, channelId, parkConfig);
        return flowRet;
    }

    public void queryFeeHandle(OrderInfo orderInfo, Long exitTime, FlowRet flowRet, Map<String, Object> paramMap,
                             String parkCode, String channelId, ParkConfig parkConfig) {
        //获取三方优惠信息
        getThirdReduces(orderInfo, parkCode);
        //设置计费截止时间
        orderInfo.setExitTime(exitTime);
        ObjectResponse<QueryOrderFeeResponse> queryOrderFeeResponseObjectResponse =
                orderService.p2cQueryFee(orderInfo, parkConfig, channelId);
        if (!ObjectResponse.isSuccess(queryOrderFeeResponseObjectResponse)) {
            throw new ResponseBodyException(queryOrderFeeResponseObjectResponse.getCode(),
                    queryOrderFeeResponseObjectResponse.getMsg());
        }
        /*//免费时修正车辆类型，需缴费时在缴费后开闸时修正
        Integer currType = getTypeByPlateNum(paramHolder, type);
        if (PlateTypeEnum.临时车.getType().equals(currType)
                && NumberUtils.toPrimitive(currType) != NumberUtils.toPrimitive(type)) {
            exitRequest.setType(PlateTypeEnum.临时车.getType());
            orderInfo.setType(PlateTypeEnum.临时车.getType());
        }*/
        QueryOrderFeeResponse orderFee = queryOrderFeeResponseObjectResponse.getData();
        paramMap.put("orderFee", orderFee);
        String unPayPrice = orderFee.getUnpayPrice();
        if (Float.parseFloat(unPayPrice) == 0) {
            String totalAmount = orderFee.getTotalAmount();
            if (Float.parseFloat(totalAmount) == 0) {
                flowRet.setResultCode(ResultCode.免费时间内);
                paramMap.put("isreleaseFreetm", parkConfig.getIsreleaseFreetm());
            } else {
                flowRet.setResultCode(ResultCode.无需缴费);
            }
        } else {
            flowRet.setResultCode(ResultCode.需缴费);
        }
        flowRet.setPara(paramMap);
    }

    private FlowRet noEnter(CarExitRequest exitRequest, ReportParamHolder paramHolder) {
        String plateNum = exitRequest.getPlateNum();
        Long exitTime = exitRequest.getExitTime();
        FlowRet flowRet = new FlowRet();
        //响应参数
        Map<String, Object> paramMap = new HashMap<>();
        Long parkId = paramHolder.getParkId();
        String parkCode = paramHolder.getParkCode();
        Integer type = exitRequest.getType();
        Integer carType = exitRequest.getCarType();
        String channelId = exitRequest.getInandoutCode();
        String channelName = exitRequest.getInandoutName();
        ParkConfig parkConfig = paramHolder.getParkConfig();
        //获取当前通道的权限
        ParkInoutdevice parkInoutdevice = paramHolder.getParkChannel();
        if (isBlacklist(paramHolder) && parkInoutdevice.getIsAllowBackCar() == 0 ){
            fixedFeeHandle(exitRequest, paramHolder, plateNum, exitTime, flowRet, paramMap,
                    parkId, parkCode, carType, channelId, exitRequest.getPlateColor(), parkConfig);
            if (isShowBlackCar(paramHolder)){
                paramMap.put("isShow", 1);
            }else{
                paramMap.put("isShow", 0);
            }
            flowRet.setPara(paramMap);
            flowRet.setResultCode(ResultCode.黑名单车);
            return flowRet;
        }
        if (isWhitelist(paramHolder)) {
            flowRet.setResultCode(ResultCode.内部车辆);
            flowRet.setPara(paramMap);
            return flowRet;
        }
        if (isMonthCard(paramHolder)){
            flowRet.setResultCode(ResultCode.月卡车);
            flowRet.setPara(paramMap);
            return flowRet;
        }
        if (isSpecial(type) && isSpecialFree(parkConfig)){
            flowRet.setResultCode(ResultCode.特殊车辆免费);
            flowRet.setPara(paramMap);
            return flowRet;
        }
        //判断公务车是否免费
        if (isFreeOfficialCars(parkConfig, exitRequest.getPlateNum())){
            flowRet.setResultCode(ResultCode.特殊车辆免费);
            flowRet.setPara(paramMap);
            return flowRet;
        }
        if (PlateTypeEnum.临时车.getType().equals(type)
                && Integer.valueOf(0).equals(parkInoutdevice.getIsAllowTempcarrun())) {
            flowRet.setResultCode(ResultCode.不允许临时车出);
            flowRet.setPara(paramMap);
            return flowRet;
        }
        VipType vipCar = getVipCar(paramHolder);
        if (vipCar != null && Integer.valueOf(1).equals(vipCar.getType())) {
            log.info("无入场记录, 全免VIP车牌号[{}]", plateNum);
            flowRet.setResultCode(ResultCode.无入场VIP全免车);
            paramMap.put("carDesc", vipCar.getName());
            flowRet.setPara(paramMap);
            return flowRet;
        }
        if (NumberUtils.toPrimitive(parkConfig.getVisitIscharge()) == 0 && isVisitList(paramHolder)) {
            flowRet.setResultCode(ResultCode.无需缴费);
            return flowRet;
        }
        ObjectResponse validExistedDisCountDay = merchantDiscountService.findValidExistedDisCountDay(plateNum, parkId);
        if (ObjectResponse.isSuccess(validExistedDisCountDay)) {
            log.info("无入场记录, 按天优免车牌号[{}]", plateNum);
            flowRet.setResultCode(ResultCode.无入场有全免优惠);
            flowRet.setPara(paramMap);
            return flowRet;
        }
        if (secRec(parkId, exitTime, plateNum)) {
            log.info("疑似出场未抬杆，又一次识别了离场，车牌号：{}", plateNum);
            if (DingZhiFuncConstants.DZ006_PARKS.contains(parkCode)) {
                paramMap.put("isDo", 0);
            }
            flowRet.setResultCode(ResultCode.预缴费未超时);
            flowRet.setPara(paramMap);
            return flowRet;
        }

        ThirdInfo payUrlThirdInfo = thirdInfoService.getThirdFeeUrl(parkConfig.getParkId());
        if (payUrlThirdInfo == null) {
            fixedFeeHandle(exitRequest, paramHolder, plateNum, exitTime, flowRet, paramMap,
                    parkId, parkCode, carType, channelId, exitRequest.getPlateColor(), parkConfig);
            flowRet.setPara(paramMap);
            return flowRet;
        }
        ThirdFeeRequest thirdFeeRequest = transformationThirdFeeRequest(plateNum, parkCode, channelId,carType, exitTime);
        //转换三方请求支付
        ObjectResponse<QueryOrderFeeResponse> queryOrderFeeResponseObjectResponse =
                queryThirdFeeService.getThirdFeeFromUrl(payUrlThirdInfo, thirdFeeRequest);
        //无入场记录
        if (CodeConstants.ERROR_3007.equals(queryOrderFeeResponseObjectResponse.getCode())) {
            fixedFeeHandle(exitRequest, paramHolder, plateNum, exitTime, flowRet, paramMap,
                    parkId, parkCode, carType, channelId, exitRequest.getPlateColor(), parkConfig);
            flowRet.setPara(paramMap);
            return flowRet;
        }

        if (!ObjectResponse.isSuccess(queryOrderFeeResponseObjectResponse)) {
            throw new ResponseBodyException(queryOrderFeeResponseObjectResponse.getCode(),
                    queryOrderFeeResponseObjectResponse.getMsg());
        }
        QueryOrderFeeResponse orderFee = queryOrderFeeResponseObjectResponse.getData();
        String unPayPrice = orderFee.getUnpayPrice();
        //补入场
        replenishOrder(plateNum, parkId, parkCode, carType, channelId, exitRequest.getPlateColor(),
                DateTools.unixTimestamp(), orderFee.getOrderNum(), paramHolder);
        paramMap.put("orderFee", orderFee);
        if (Float.parseFloat(unPayPrice) == 0) {
            flowRet.setResultCode(ResultCode.无需缴费);
        } else {
            flowRet.setResultCode(ResultCode.固定费用);
        }
        flowRet.setPara(paramMap);
        exitRequest.setOrderNum(orderFee.getOrderNum());
        paramHolder.setOrderNum(orderFee.getOrderNum());
        return flowRet;
    }

    private void fixedFeeHandle(CarExitRequest exitRequest, ReportParamHolder paramHolder, String plateNum, Long exitTime, FlowRet flowRet, Map<String, Object> paramMap, Long parkId, String parkCode, Integer carType, String channelId, String channelName, ParkConfig parkConfig) {
        float fixedFee = -1;
        int handleType = NumberUtils.toPrimitive(parkConfig.getNoenterHandleType());
        if (handleType == 2){
            int days = NumberUtils.toPrimitive(parkConfig.getRelLastenterRange());
            if (days > 0) {
                OrderInfo lastEnterOrder = getLastEnterOrder(parkId, plateNum, exitTime - days * 3600L * 24);
                if (lastEnterOrder == null
                        || NumberUtils.parseDouble(lastEnterOrder.getTotalPrice()) > 0
                        || Integer.valueOf(1).equals(lastEnterOrder.getNoneEnterFlag())) {
                    fixedFee = fixedFee(parkConfig, carType);
                } else {
                    //使用上一次订单的入场时间计费
                    //补入场
                    String orderNum = CodeTools.GenerateOrderNum();

                    ObjectResponse<OrderCarInfo> infoObjectResponse = orderCarInfoService.getCarInfo(orderNum, parkId);
                    replenishOrder(plateNum, parkId, parkCode, carType, channelId, exitRequest.getPlateColor(),
                            lastEnterOrder.getEnterTime(), orderNum, paramHolder, false, infoObjectResponse.getData());
                    OrderTags orderTags = OrderTags.builder()
                                    .orderNum(orderNum)
                                    .parkId(parkId)
                                    .tagId(2)
                                    .exitTime(lastEnterOrder.getExitTime())
                                    .remark(lastEnterOrder.getOrderNum()).build();
                    orderTagsService.addOrderTags(orderTags);
                    //查费
                    queryFeeHandle(paramHolder.getReplenishOrder(), exitTime, flowRet, paramMap, parkCode, channelId, parkConfig);
                    exitRequest.setOrderNum(orderNum);
                    if (paramHolder.getReplenishOrder() != null) {
                        exitRequest.setType(paramHolder.getReplenishOrder().getType());
                    }
                    paramHolder.setOrderNum(orderNum);
                    return;
                }
            }
        } else if (handleType == 3){
            fixedFee = carType == 1 ? parkConfig.getFixedfeevalue() : parkConfig.getFixedFeeValueBig();
        } else if (handleType != 1){
            log.warn("未读取到配置, 走旧的配置[{}]", plateNum);
            fixedFee = fixedFee(parkConfig, carType);
        }
        if (fixedFee == -1) {
            flowRet.setResultCode(ResultCode.无入场记录);
        } else {
            QueryOrderFeeResponse queryOrderFeeResponse = fixedFeeHandle(plateNum, paramHolder.getParkInfo(), parkCode, channelId, exitRequest.getPlateColor(),
                    parkConfig, fixedFee, carType, exitRequest.getExitTime(), paramHolder);
            paramMap.put("orderFee", queryOrderFeeResponse);
            exitRequest.setOrderNum(queryOrderFeeResponse.getOrderNum());
            paramHolder.setOrderNum(queryOrderFeeResponse.getOrderNum());
            if (fixedFee == 0) {
                flowRet.setResultCode(ResultCode.无需缴费);
            } else {
                flowRet.setResultCode(ResultCode.固定费用);
            }
        }
    }

    private String replenishOrder(String plateNum, Long parkId, String parkCode,
                                  Integer carType, String channelId, String plateColor,
                                  Long enterTime, String orderNum, ReportParamHolder reportParamHolder) {
        return replenishOrder(plateNum, parkId, parkCode, carType, channelId, plateColor, enterTime, orderNum,
                reportParamHolder, true, null);
    }
    private String replenishOrder(String plateNum, Long parkId, String parkCode,
                                  Integer carType, String channelId, String plateColor,
                                  Long enterTime, String orderNum, ReportParamHolder reportParamHolder,
                                  boolean noneEnter, OrderCarInfo orderCarInfo) {
        CarEnterRequest carEnterRequest = new CarEnterRequest();
        carEnterRequest.setPlateNum(plateNum);
        carEnterRequest.setType(1);
        carEnterRequest.setEnterTime(enterTime);
        carEnterRequest.setCarType(carType);
        carEnterRequest.setInandoutCode(channelId);
        carEnterRequest.setPlateColor(plateColor);
        carEnterRequest.setOpenFlag(1);
        carEnterRequest.setTriggerType(2);
        carEnterRequest.setProperty(2);
        carEnterRequest.setParkId(parkId);
        carEnterRequest.setParkCode(parkCode);
        carEnterRequest.setEnterWay(OrderCarInfoConstant.IN_OUT_WAY_PLATE_NUM);
        carEnterRequest.setNoneEnterFlag(noneEnter);
        carEnterRequest.setOrderNum(orderNum);
        carEnterRequest.setReplenishOrder(true);
        if (orderCarInfo != null) {
            carEnterRequest.setMaxImage(carEnterRequest.getMaxImage());
            carEnterRequest.setSmallImage(carEnterRequest.getSmallImage());
            carEnterRequest.setEnterWay(orderCarInfo.getEnterWay());
            carEnterRequest.setCarBrand(orderCarInfo.getCarBrand());
            carEnterRequest.setCarColor(orderCarInfo.getCarColor());
            carEnterRequest.setPlateColor(orderCarInfo.getPlateColor());
        }
        ObjectResponse<CarEnterResult> objectResponse = carOrderEnterService.enter(carEnterRequest, reportParamHolder);
        if (ObjectResponse.isSuccess(objectResponse)){
            return objectResponse.getData().getOrderNum();
        }else{
            return null;
        }
    }

    /**
     * 组装三方请求参数
     * @param parkCode
     * @param channelId
     * @return
     */
    private ThirdFeeRequest transformationThirdFeeRequest(String plateNum,String parkCode,
                                                          String channelId, Integer carType, Long exitTime){
        ThirdFeeRequest thirdFeeRequest = new ThirdFeeRequest();
        thirdFeeRequest.setOrderNum(CodeTools.GenerateOrderNum());
        thirdFeeRequest.setCarType(carType);
        thirdFeeRequest.setChannelCode(channelId);
        thirdFeeRequest.setParkCode(parkCode);
        thirdFeeRequest.setExitTime(exitTime);
        thirdFeeRequest.setPlateNum(plateNum);
        return thirdFeeRequest;
    }
    /**
     * 固定收费时的业务处理：模拟入场，并拼装查询费用实体的返回
     * @param plateNum
     * @param park
     * @param parkCode
     * @param channelId
     * @param parkConfig
     * @param fixedFee
     * @param carType
     * @param enterTime
     * @return 费用
     */
    public QueryOrderFeeResponse fixedFeeHandle(String plateNum, Park park, String parkCode,
                                                String channelId, String plateColor,
                                                ParkConfig parkConfig, float fixedFee,
                                                Integer carType, Long enterTime, ReportParamHolder paramHolder) {
        QueryOrderFeeResponse queryOrderFeeResponse = new QueryOrderFeeResponse();
        String orderNum = replenishOrder(plateNum, park.getId(), parkCode, carType,
                channelId, plateColor, enterTime, null, paramHolder);
        queryOrderFeeResponse.setOrderNum(orderNum);
        queryOrderFeeResponse.setParkName(park.getParkName());
        queryOrderFeeResponse.setPlateNum(plateNum);
        queryOrderFeeResponse.setEnterTime(enterTime);
        queryOrderFeeResponse.setCarType(carType);
        queryOrderFeeResponse.setQueryTime(DateTools.unixTimestamp());
        queryOrderFeeResponse.setParkTime(0L);
        queryOrderFeeResponse.setTotalAmount(String.valueOf(fixedFee));
        queryOrderFeeResponse.setUnpayPrice(String.valueOf(fixedFee));
        queryOrderFeeResponse.setPaidAmount(String.valueOf(0));
        queryOrderFeeResponse.setDiscountAmount(String.valueOf(0));
        queryOrderFeeResponse.setDiscountPrice(String.valueOf(0));
        queryOrderFeeResponse.setStatus(2);
        queryOrderFeeResponse.setFreeTime((long) parkConfig.getIsfreeAfterpay(15));
        return queryOrderFeeResponse;
    }

    /**
     * 二次识别
     *
     * @param parkId 车场ID
     * @param exitTime 离场时间
     * @param plateNum 车牌号
     * @return 标识
     */
    private boolean secRec(Long parkId, Long exitTime, String plateNum) {
        OrderInfo orderInfoPara;
        ObjectResponse<OrderInfo> objectResponse;
        orderInfoPara = new OrderInfo();
        orderInfoPara.setParkId(parkId);
        orderInfoPara.setPlateNum(plateNum);
        orderInfoPara.setServiceStatus(OrderStatusConstants.LEAVED_PARK);
        objectResponse = orderService.findByOrderInfo(orderInfoPara);
        if (ObjectResponse.isSuccess(objectResponse)
                && objectResponse.getData().getExitTime() != null
                && exitTime - objectResponse.getData().getExitTime() <= exitSecondRecFreeTime) {
            return true;
        }
        return false;
    }

    /**
     * 拉取三方优惠信息
     * @param orderInfo
     * @param parkCode
     * @return
     */
    private ObjectResponse getThirdReduces(OrderInfo orderInfo, String parkCode) {
        QueryOrderFeeRequest queryOrderFeeRequest = new QueryOrderFeeRequest();
        queryOrderFeeRequest.setOrderNum(orderInfo.getOrderNum());
        queryOrderFeeRequest.setParkCode(parkCode);
        queryOrderFeeRequest.setPlateNum(orderInfo.getPlateNum());
        queryOrderFeeRequest.setCarType(orderInfo.getCarType());
        try {
            return thirdAutoPayService.downReduces(queryOrderFeeRequest);
        } catch (Exception e) {
            log.error("e=", e);
        }
        return ObjectResponse.failed();
    }

}
