package com.icetech.park.service.flow.p2c.impl;

import com.google.common.collect.Maps;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.park.domain.dto.TagsDto;
import com.icetech.fee.domain.entity.monthcar.MonthInfo;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.domain.entity.park.ParkFreespace;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.VipType;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.response.MonthAbDto;
import com.icetech.cloudcenter.domain.response.MonthDetailDto;
import com.icetech.cloudcenter.domain.response.QueryNotPayResponse;
import com.icetech.cloudcenter.domain.response.VipDetailDto;
import com.icetech.park.service.flow.p2c.FlowCondition;
import com.icetech.park.service.report.ReportParamHolder;
import com.icetech.common.constants.DiscountTypeEnum;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.NumberUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Slf4j
@Component
public class CarEnterFlowProcessImpl extends FlowCondition {

    private static final Integer FIX_ONE = 1;

    /**
     * 新能源车牌颜色
     */
    private List<String> CHARGE_COLORS = Arrays.asList("绿色", "黄绿色");

    /**
     * 入场流程处理
     */
    public FlowRet flowHandle(CarEnterRequest enterRequest, ReportParamHolder paramHolder) {
        String plateNum = enterRequest.getPlateNum();
        Long parkId = enterRequest.getParkId();
        FlowRet flowRet = new FlowRet();
        ResultCode code;

        ParkConfig parkConfig = paramHolder.getParkConfig();
        //1 有牌车
        if (hasPlate(plateNum)){
            if(filter(enterRequest.getParkCode(), parkId, plateNum, parkConfig, enterRequest.getInandoutCode(), 1, enterRequest.getEnterTime())){
                code = ResultCode.入场限制;
                flowRet.setResultCode(code);
            }else{
                hasPlateHandle(enterRequest, paramHolder, flowRet);
            }
        //2 无牌车
        }else{
            // 区域燃油车、充电判断
            checkParkingAvailability(paramHolder, "蓝色", flowRet);
            if (flowRet.getResultCode() == ResultCode.车位已满禁止入场) {
                return flowRet;
            }
            code = getNoPlateResultCode(paramHolder);
            flowRet.setResultCode(code);
        }
        log.info("[入场流程处理] 车牌号[{}], 判断结果为[{}]", plateNum, flowRet.getResultCode().name());
        return flowRet;
    }

    private void hasPlateHandle(CarEnterRequest enterRequest, ReportParamHolder paramHolder, FlowRet flowRet) {
        String plateNum = enterRequest.getPlateNum();
        String plateColor = enterRequest.getPlateColor();
        ParkConfig parkConfig = paramHolder.getParkConfig();

        Map<String, Object> retMap = Maps.newHashMap();
        //获取当前通道的权限
        ParkInoutdevice parkInoutdevice = paramHolder.getParkChannel();
        boolean isMonthCardOccupy = false;
        boolean isBlackCar = false;
        QueryNotPayResponse queryNotPayResponse = paramHolder.queryNotPayFee();

        if (NumberUtils.parseDouble(queryNotPayResponse.getTotalNotPayPrice()) > 0) {
            retMap.put("notPayFee", queryNotPayResponse);
            flowRet.setPara(retMap);
            flowRet.setResultCode(FlowCondition.ResultCode.欠费补缴);
            return;
        }
        // 区域燃油车、充电判断
        checkParkingAvailability(paramHolder, plateColor, flowRet);
        if (flowRet.getResultCode() == ResultCode.车位已满禁止入场) {
            return;
        }
        //黑名单
        if (isBlacklist(paramHolder)){
            isBlackCar = true;
            if (parkInoutdevice.getIsAllowBackCar() == 0){
                //禁止黑名单车进入
                flowRet.setResultCode(ResultCode.黑名单车);
                if (isShowBlackCar(paramHolder)){
                    retMap.put("isShow", 1);
                }else{
                    retMap.put("isShow", 0);
                }
                flowRet.setPara(retMap);
            }else {
                flowRet.setResultCode(ResultCode.有牌车允许临时车进入);
            }
        } else if (isWhitelist(paramHolder)) {
            flowRet.setResultCode(ResultCode.内部车辆);
        } else if (isMonthCard(paramHolder)){
            Integer isAllowMonthCar = parkInoutdevice.getIsAllowMonthCar();
            if (Objects.nonNull(isAllowMonthCar) && parkInoutdevice.getIsAllowMonthCar() == 1){
                //不是全免车重复入场
                if (freeCarRepeatEntry(enterRequest, flowRet, plateNum, paramHolder.getParkConfig())) {
                    flowRet.setResultCode(ResultCode.月卡车);
                    Integer unExpiredDays = paramHolder.getMonthDetail().getUnexpiredDays();
                    Integer remainDaysMc = getRemainDaysMc(paramHolder);
                    if (remainDaysMc == 0 || unExpiredDays <= remainDaysMc){
                        retMap.put("days", unExpiredDays);
                        flowRet.setPara(retMap);
                    }
                }
            } else {
                flowRet.setResultCode(ResultCode.有牌车不允许临时车进入);
            }
        } else if (isOtherRegionMonthCard(paramHolder)){
            flowRet.setResultCode(ResultCode.有牌车允许临时车进入);
            MonthDetailDto monthDetail = paramHolder.getOtherRegionMonthDetail();
            if (monthDetail.getParkRegion() != null) {
                retMap.put("otherRegionNameMc", monthDetail.getParkRegion().getRegionName());
            }
            flowRet.setPara(retMap);
        }else if (isVipCar(paramHolder)){
            Boolean flag = Boolean.FALSE;
            //查询VIP车辆的类型
            VipType vipCar = getVipCar(paramHolder);
            if (FIX_ONE.equals(parkInoutdevice.getIsAllowVipCar())){
                String vipCarTypeId = parkInoutdevice.getVipCarTypeId();
                if (Objects.nonNull(vipCar)&& StringUtils.isNotEmpty(vipCarTypeId)){
                    String[] vipCarIds = vipCarTypeId.split(",");
                    if (Arrays.asList(vipCarIds).contains(String.valueOf(vipCar.getId()))){
                        flag = Boolean.TRUE;
                    }
                }
            }
            if (flag){
                //不是全免车重复入场
                if (!DiscountTypeEnum.全免.getType().equals(vipCar.getType())) {
                    vipAllowEnter(flowRet, vipCar);
                }else if (freeCarRepeatEntry(enterRequest, flowRet, plateNum, paramHolder.getParkConfig())) {
                    //VIP可以进入
                    vipAllowEnter(flowRet, vipCar);
                }
            }else {
                flowRet.setResultCode(ResultCode.有牌车不允许临时车进入);
            }
        }else if (isOtherRegionVipCar(paramHolder)){
            //查询VIP车辆的类型
            VipDetailDto otherRegionVipDetailDto = paramHolder.getOtherRegionVipDetailDto();
            VipType vipCar = otherRegionVipDetailDto.getVipType();
            List<ParkInoutdevice> entranceChannelList = otherRegionVipDetailDto.getEntranceChannelList();
            if (CollectionUtils.isNotEmpty(entranceChannelList)) {
                boolean flag = Boolean.FALSE;
                for (ParkInoutdevice inoutdevice : entranceChannelList) {
                    if (FIX_ONE.equals(inoutdevice.getIsAllowVipCar())){
                        String vipCarTypeId = inoutdevice.getVipCarTypeId();
                        if (Objects.nonNull(vipCar)&& StringUtils.isNotEmpty(vipCarTypeId)){
                            String[] vipCarIds = vipCarTypeId.split(",");
                            if (Arrays.asList(vipCarIds).contains(String.valueOf(vipCar.getId()))){
                                flag = Boolean.TRUE;
                                break;
                            }
                        }
                    }
                }
                if (flag){
                    flowRet.setResultCode(ResultCode.有牌车允许临时车进入);
                    retMap.put("carDesc", vipCar.getName());
                    retMap.put("otherRegionNameVip", otherRegionVipDetailDto.getParkRegion().getRegionName());
                    flowRet.setPara(retMap);
                } else {
                    log.info("[入场流程处理] 其他区域VIP, [{}]不允许[{}]类型进场", plateNum, vipCar.getName());
                    flowRet.setResultCode(ResultCode.有牌车不允许临时车进入);
                }
            } else {
                flowRet.setResultCode(ResultCode.有牌车允许临时车进入);
                retMap.put("carDesc", vipCar.getName());
                retMap.put("otherRegionNameVip", otherRegionVipDetailDto.getParkRegion().getRegionName());
                flowRet.setPara(retMap);
            }
        }else if (isVisitList(paramHolder)){
            if (FIX_ONE.equals(parkInoutdevice.getIsAllowVisitCar())){
                flowRet.setResultCode(ResultCode.访客车);
            }else {
                flowRet.setResultCode(ResultCode.有牌车不允许临时车进入);
            }
        }else if (isInnerCar(paramHolder)){
            if (FIX_ONE.equals(parkInoutdevice.getIsAllowMonthCar())){
                flowRet.setResultCode(ResultCode.内部车辆);
            }else {
                flowRet.setResultCode(ResultCode.有牌车不允许临时车进入);
            }
        }else if (isStoreCardCar(paramHolder)){
            if (parkInoutdevice.getIsAllowStoredCar() != null && parkInoutdevice.getIsAllowStoredCar()==1){
                flowRet.setResultCode(ResultCode.储值卡车允许进入);
            }else {
                flowRet.setResultCode(ResultCode.储值卡车禁止进入);
            }
        }else if (FIX_ONE.equals(parkInoutdevice.getIsAllowTempcarrun())){
            //蓝牌车 黄牌车 新能源车
            if (bluecarrun(plateColor, parkInoutdevice)
                    || yellowcarrun(plateColor, parkInoutdevice)
                    || greencarrun(plateColor, parkInoutdevice)){
                flowRet.setResultCode(ResultCode.有牌车允许临时车进入);
            }else {
                if ("蓝色".equals(plateColor) || "绿色".equals(plateColor)|| "黄绿色".equals(plateColor)){
                    flowRet.setResultCode(ResultCode.有牌车不允许临时车进入);
                }else if ("黄色".equals(plateColor)){
                    flowRet.setResultCode(ResultCode.黄牌车禁止入场);
                }else {
                    flowRet.setResultCode(ResultCode.有牌车允许临时车进入);
                }
            }
            //临时车判断是否是储值卡车
            replaceCardCode(paramHolder, flowRet);
            //修复判断是否是过期的月卡车
            MonthDetailDto monthDetail = paramHolder.getMonthDetail();
            if (monthDetail != null && (monthDetail.getMonthType() == MonthDetailDto.MonthType.过期月卡车
                    || monthDetail.getMonthType() == MonthDetailDto.MonthType.过期临时车)){
                //过期月卡是否按月卡车处理
                int diff = monthDetail.getMonthInfo() != null
                        ? DateTools.differentDays(monthDetail.getMonthInfo().getEndTime(),new Date()) : -1;
                if (FIX_ONE.equals(parkInoutdevice.getIsAllowMonthCar()) && FIX_ONE.equals(parkConfig.getIsAllowOvertimeCar())
                        && diff <= NumberUtils.toPrimitive(parkConfig.getOverTimeDay())){
                    //判断月卡车是否允许入场
                    retMap.put("days", 0);
                    retMap.put("isMonth", false);
                    if (parkConfig.getExpireMcDays() != null && diff != -1 && diff <= parkConfig.getExpireMcDays()) {
                        if(FIX_ONE.equals(parkConfig.getIsExpireMc())){
                            retMap.put("isMonth", true);
                        }
                    }
                    flowRet.setPara(retMap);
                    flowRet.setResultCode(ResultCode.过期卡);
                }
            }else if (paramHolder.getMonthDetail() != null
                    && paramHolder.getMonthDetail().getMonthType() == MonthDetailDto.MonthType.多位多车占用) {
                isMonthCardOccupy = true;
                enterRequest.setType(PlateTypeEnum.临时车.getType());
                MonthAbDto monthAbDto = paramHolder.getMonthDetail().getMonthAbDto();
                List<TagsDto> tagsDtos = new ArrayList<>();
                TagsDto tagsDto = TagsDto.builder().tagId(1).regionId(parkInoutdevice.getRegionId())
                        .remark(monthAbDto.getPlotCount() + "位"
                                + monthAbDto.getPlateNumCount() + "车第"
                                + monthAbDto.getIndex() + "车").build();
                tagsDtos.add(tagsDto);
                enterRequest.setTags(tagsDtos);
                //判断多位月卡车是否允许入场
                if (parkInoutdevice.getIsAllowAbcar() == 1){
                    //判断月卡车是否允许入场
                    if (parkInoutdevice.getIsAllowMonthCar() == 1){
                        flowRet.setResultCode(ResultCode.有牌车允许临时车进入);
                    }
                }else {
                    flowRet.setResultCode(ResultCode.有牌车不允许临时车进入);
                }
            }
        }else {
            //判断是否是过期的月卡车
            MonthDetailDto monthDetail = paramHolder.getMonthDetail();
            if (monthDetail != null && (monthDetail.getMonthType() == MonthDetailDto.MonthType.过期月卡车
                || monthDetail.getMonthType() == MonthDetailDto.MonthType.过期临时车)) {
                MonthInfo data = monthDetail.getMonthInfo();
                int diff = DateTools.differentDays(data.getEndTime(),new Date());
                if (FIX_ONE.equals(parkInoutdevice.getIsAllowMonthCar()) && FIX_ONE.equals(parkConfig.getIsAllowOvertimeCar())
                        && diff <= NumberUtils.toPrimitive(parkConfig.getOverTimeDay())){
                    //判断月卡车是否允许入场
                    retMap.put("days", 0);
                    if(monthDetail.getMonthType() == MonthDetailDto.MonthType.过期月卡车){
                        retMap.put("isMonth", true);
                    }else {
                        retMap.put("isMonth", false);
                    }
                    flowRet.setPara(retMap);
                    flowRet.setResultCode(ResultCode.过期卡);
                }else {
                    flowRet.setResultCode(ResultCode.有牌车不允许临时车进入);
                }
            }else if (paramHolder.getMonthDetail() != null && paramHolder.getMonthDetail().getMonthType() == MonthDetailDto.MonthType.多位多车占用) {
                isMonthCardOccupy = true;
                enterRequest.setType(PlateTypeEnum.临时车.getType());
                MonthAbDto monthAbDto = paramHolder.getMonthDetail().getMonthAbDto();
                List<TagsDto> tagsDtos = new ArrayList<>();
                TagsDto tagsDto = TagsDto.builder().tagId(1).regionId(parkInoutdevice.getRegionId())
                        .remark(monthAbDto.getPlotCount() + "位"
                                + monthAbDto.getPlateNumCount() + "车第"
                                + monthAbDto.getIndex() + "车").build();
                tagsDtos.add(tagsDto);
                enterRequest.setTags(tagsDtos);
                //判断多位月卡车是否允许入场
                if (parkInoutdevice.getIsAllowAbcar() == 1){
                    //判断月卡车是否允许入场
                    if (parkInoutdevice.getIsAllowMonthCar() == 1){
                        flowRet.setPara(retMap);
                        flowRet.setResultCode(ResultCode.有牌车允许临时车进入);
                    }else {
                        flowRet.setResultCode(ResultCode.有牌车不允许临时车进入);
                    }
                }else {
                    flowRet.setResultCode(ResultCode.有牌车不允许临时车进入);
                }
            }else {
                flowRet.setResultCode(ResultCode.有牌车不允许临时车进入);
                //临时车判断是否是储值卡车
                replaceCardCode(paramHolder, flowRet);
            }
            MonthDetailDto otherRegionMonthDetail = paramHolder.getOtherRegionMonthDetail();
            if (ResultCode.有牌车不允许临时车进入.equals(flowRet.getResultCode()) && otherRegionMonthDetail != null
                    && (otherRegionMonthDetail.getMonthType() == MonthDetailDto.MonthType.过期月卡车
                    || otherRegionMonthDetail.getMonthType() == MonthDetailDto.MonthType.过期临时车)) {
                MonthInfo data = otherRegionMonthDetail.getMonthInfo();
                int diff = DateTools.differentDays(data.getEndTime(),new Date());
                if (FIX_ONE.equals(parkInoutdevice.getIsAllowMonthCar()) && FIX_ONE.equals(parkConfig.getIsAllowOvertimeCar())
                        && diff <= NumberUtils.toPrimitive(parkConfig.getOverTimeDay())){
                    //判断月卡车是否允许入场
                    retMap.put("days", 0);
                    if(otherRegionMonthDetail.getMonthType() == MonthDetailDto.MonthType.过期月卡车){
                        retMap.put("isMonth", true);
                    }else {
                        retMap.put("isMonth", false);
                    }
                    if (otherRegionMonthDetail.getParkRegion() != null) {
                        retMap.put("otherRegionNameMc", otherRegionMonthDetail.getParkRegion().getRegionName());
                    }
                    flowRet.setPara(retMap);
                    flowRet.setResultCode(ResultCode.过期卡);
                }else {
                    flowRet.setResultCode(ResultCode.有牌车不允许临时车进入);
                }
            }
        }
        if (!flowRet.getResultCode().equals(ResultCode.有牌车不允许临时车进入)) {
            //车位满处理，获取车位数
            ParkFreespace parkFreespace = paramHolder.getParkFreeSpace();
            ParkRegion parkRegion = paramHolder.getParkRegion();
            if (parkFreespace != null && parkRegion != null) {
                Integer freeSpace = parkFreespace.getFreeSpace();
                Integer fullEmptynum = parkRegion.getFullEmptynum();
                if (Objects.isNull(fullEmptynum) || Objects.isNull(freeSpace)) {
                    return;
                }
                if (fullEmptynum >= freeSpace) {
                    fullForbidEnter(paramHolder, flowRet, plateNum, parkRegion, retMap, isBlackCar, parkFreespace);
                }
            }
        }
        //判断是否属于内场月卡或VIP
        if (flowRet.getResultCode().equals(ResultCode.有牌车不允许临时车进入) || flowRet.getResultCode().equals(ResultCode.车位已满禁止入场)) {
            if (retMap.get("otherRegionNameMc") != null || retMap.get("otherRegionNameVip") != null) {
                VipDetailDto otherRegionVipDetailDto = paramHolder.getOtherRegionVipDetailDto();
                MonthDetailDto otherRegionMonthDetail = paramHolder.getOtherRegionMonthDetail();

                ParkRegion otherParkRegion = otherRegionVipDetailDto == null ? null : otherRegionVipDetailDto.getParkRegion();
                ParkRegion otherParkRegion2 = otherRegionMonthDetail == null ? null : otherRegionMonthDetail.getParkRegion();
                otherParkRegion = otherParkRegion == null ? otherParkRegion2 : otherParkRegion;
                if (otherParkRegion != null) {
                    Integer freeSpace = otherParkRegion.getRealFreePark();
                    Integer fullEmptynum = otherParkRegion.getFullEmptynum();
                    if (Objects.isNull(fullEmptynum) || Objects.isNull(freeSpace)) {
                        flowRet.setResultCode(ResultCode.有牌车允许临时车进入);
                        return;
                    }
                    if (fullEmptynum >= freeSpace) {
                        fullForbidEnterOtherRegion(paramHolder, flowRet, plateNum, otherParkRegion, retMap);
                    } else {
                        flowRet.setResultCode(ResultCode.有牌车允许临时车进入);
                    }
                }
            }
        }
        if (flowRet.getResultCode().equals(ResultCode.有牌车不允许临时车进入) && isMonthCardOccupy) {
            flowRet.setResultCode(ResultCode.车位已占);
        }
    }

    private void fullForbidEnter(ReportParamHolder paramHolder, FlowRet flowRet, String plateNum, ParkRegion parkRegion,
                                 Map<String, Object> retMap, boolean isBlackCar, ParkFreespace parkFreespace) {
        log.info("车牌号:{}, 区域配置:{}", plateNum, parkRegion);
        Integer freeSpace = parkFreespace.getFreeSpace();
        Integer fullEmptynum = parkRegion.getFullEmptynum();
        if (FIX_ONE.equals(parkRegion.getIsFullForbidenter())
                && flowRet.getResultCode().equals(ResultCode.有牌车允许临时车进入)){
            log.info("临时车-车牌号 车牌号:{},空车位数:{},剩余{}空车位时", plateNum,freeSpace,fullEmptynum);
            flowRet.setResultCode(ResultCode.车位已满禁止入场);
            retMap.put("type", PlateTypeEnum.临时车.getType());
            flowRet.setPara(retMap);
        }
        if (FIX_ONE.equals(parkRegion.getIsFullForbidMonthEnter())
                && flowRet.getResultCode().equals(ResultCode.月卡车)){
            log.info("月卡车-车牌号 车牌号:{},空车位数:{},剩余{}空车位时", plateNum,freeSpace,fullEmptynum);
            retMap.put("type", PlateTypeEnum.月卡车.getType());
            flowRet.setPara(retMap);
            flowRet.setResultCode(ResultCode.车位已满禁止入场);
        }
        if (FIX_ONE.equals(parkRegion.getIsFullForbidReservEnter())
                && flowRet.getResultCode().equals(ResultCode.访客车)){
            log.info("访客车-车牌号 车牌号:{},空车位数:{},剩余{}空车位时", plateNum,freeSpace,fullEmptynum);
            retMap.put("type", PlateTypeEnum.访客车辆.getType());
            flowRet.setPara(retMap);
            flowRet.setResultCode(ResultCode.车位已满禁止入场);
        }
        if (FIX_ONE.equals(parkRegion.getIsFullForbidStoreEnter())
                && flowRet.getResultCode().equals(ResultCode.储值卡车允许进入)){
            log.info("储值卡车-车牌号 车牌号:{},空车位数:{},剩余{}空车位时", plateNum,freeSpace,fullEmptynum);
            retMap.put("type", PlateTypeEnum.储值卡车.getType());
            flowRet.setPara(retMap);
            flowRet.setResultCode(ResultCode.车位已满禁止入场);
        }
        if (flowRet.getResultCode().equals(ResultCode.VIP车辆)){
            if (FIX_ONE.equals(parkRegion.getIsFullForbidVIPEnter())) {
                log.info("VIP车-车牌号:{},车位已满禁止入场", plateNum);
                retMap.put("type", PlateTypeEnum.VIP车辆.getType());
                flowRet.setPara(retMap);
                flowRet.setResultCode(ResultCode.车位已满禁止入场);
            }else{
                VipType vipCar = getVipCar(paramHolder);
                if (vipCar != null && parkRegion.getVipCarTypeId() != null
                        && !parkRegion.getVipCarTypeId().contains(String.valueOf(vipCar.getId()))) {
                    retMap.put("type", PlateTypeEnum.VIP车辆.getType());
                    flowRet.setPara(retMap);
                    flowRet.setResultCode(ResultCode.车位已满禁止入场);
                }
            }
        }
        if (FIX_ONE.equals(parkRegion.getIsFullForbidblackenter())
                && isBlackCar){
            log.info("黑名单车-车牌号:{},车位已满禁止入场", plateNum);
            retMap.put("type", PlateTypeEnum.临时车.getType());
            flowRet.setPara(retMap);
            flowRet.setResultCode(ResultCode.车位已满禁止入场);
        }
    }

    private void fullForbidEnterOtherRegion(ReportParamHolder paramHolder, FlowRet flowRet, String plateNum, ParkRegion otherParkRegion,
                                 Map<String, Object> retMap) {
        log.info("车牌号:{}, 区域配置:{}", plateNum, otherParkRegion);
        if (retMap.get("otherRegionNameMc") != null && Integer.valueOf(0).equals(otherParkRegion.getIsFullForbidMonthEnter())) {
            flowRet.setResultCode(ResultCode.有牌车允许临时车进入);
        }
        if (retMap.get("otherRegionNameVip") != null) {
            if (Integer.valueOf(0).equals(otherParkRegion.getIsFullForbidVIPEnter())) {
                VipDetailDto otherRegionVipDetailDto = paramHolder.getOtherRegionVipDetailDto();
                if (otherRegionVipDetailDto != null) {
                    VipType vipCar = otherRegionVipDetailDto.getVipType();
                    if (vipCar != null && otherParkRegion.getVipCarTypeId() != null
                            && Arrays.asList(otherParkRegion.getVipCarTypeId().split(",")).contains(String.valueOf(vipCar.getId()))) {
                        flowRet.setResultCode(ResultCode.有牌车允许临时车进入);
                    }
                }
            }
        }
    }

    private void vipAllowEnter(FlowRet flowRet, VipType vipCar) {
        //VIP可以进入
        flowRet.setResultCode(ResultCode.VIP车辆);
        Map<String, Object> retMap = Maps.newHashMap();
        retMap.put("carDesc", vipCar.getName());
        flowRet.setPara(retMap);
    }

    /**
     * 免费车辆重复入场判断
     * @param enterRequest 入场参数
     * @param flowRet 流程处理结果
     * @param plateNum 车牌号
     * @param parkConfig 高级配置
     * @return true：可以重复入场，false：不可以重复入场
     */
    private boolean freeCarRepeatEntry(CarEnterRequest enterRequest, FlowRet flowRet, String plateNum, ParkConfig parkConfig) {
        //不让全免车重复入场
        if (Integer.valueOf(0).equals(parkConfig.getFreeCarReenter())) {
            ObjectResponse<OrderInfo> infoObjectResponse = orderService.findInPark(plateNum, enterRequest.getParkCode());
            if (ObjectResponse.isSuccess(infoObjectResponse)) {
                //按不允许入场语音播报
                flowRet.setResultCode(ResultCode.有牌车不允许临时车进入);
                return false;
            }
        }
        return true;
    }

    public void checkParkingAvailability(ReportParamHolder paramHolder, String plateColor, FlowRet flowRet) {
        Park park = paramHolder.getParkInfo();
        if (Objects.nonNull(park)) {
            // 非场中场
            if (park.getIsInterior() == null || park.getIsInterior() == 0) {
                ParkRegion parkRegion = paramHolder.getParkRegion();
                if (parkRegion != null) {
                    // 新能源车判断
                    boolean chargeFlag = CHARGE_COLORS.contains(plateColor);
                    // 检查所有车位是否已满
                    if (parkRegion.getOilCarFullFlag() == 1 && parkRegion.getChargeCarFullFlag() == 1) {
                        if (chargeFlag) {
                            checkChargeCarSpace(paramHolder, parkRegion, flowRet);
                        } else {
                            checkOilCarSpace(paramHolder, parkRegion, flowRet);
                        }
                    }
                    // 只开放油车车位
                    if (parkRegion.getOilCarFullFlag() == 1 && !chargeFlag) {
                        checkOilCarSpace(paramHolder, parkRegion, flowRet);
                    }
                    // 只开放新能源车车位
                    if (parkRegion.getChargeCarFullFlag() == 1 && chargeFlag) {
                        checkChargeCarSpace(paramHolder, parkRegion, flowRet);
                    }
                }
            }
        }
    }

    private void checkOilCarSpace(ReportParamHolder paramHolder, ParkRegion parkRegion, FlowRet flowRet) {
        Integer oilCarSpace = parkRegion.getOilCarSpace();
        Integer oilLiveCount = paramHolder.getOilLiveCount();
        if (oilCarSpace != null && oilLiveCount >= oilCarSpace) {
            flowRet.setResultCode(ResultCode.车位已满禁止入场);
        }
    }

    private void checkChargeCarSpace(ReportParamHolder paramHolder, ParkRegion parkRegion, FlowRet flowRet) {
        Integer chargeCarSpace = parkRegion.getChargeCarSpace();
        Integer chargeLiveCount = paramHolder.getChargeLiveCount();
        if (chargeCarSpace != null && chargeLiveCount >= chargeCarSpace) {
            flowRet.setResultCode(ResultCode.车位已满禁止入场);
        }
    }

}
