package com.icetech.park.service.flow.p2c;

import com.icetech.city.common.api.BlacklistApi;
import com.icetech.city.common.domain.entity.common.BlacklistPark;
import com.icetech.cloudcenter.api.lcd.LcdService;
import com.icetech.cloudcenter.api.lcd.LedService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.park.ParkVisitService;
import com.icetech.cloudcenter.api.store.StoreCardService;
import com.icetech.cloudcenter.api.user.VehicleService;
import com.icetech.cloudcenter.domain.constants.DataCommonConstants;
import com.icetech.cloudcenter.domain.response.PlateTypeDto;
import com.icetech.order.dao.OrderCarInfoDao;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.cloudcenter.domain.constants.ParkVisitMoreType;
import com.icetech.basics.domain.entity.Blacklist;
import com.icetech.park.domain.entity.lcd.LcdConfig;
import com.icetech.park.domain.entity.led.LedConfig;
import com.icetech.fee.domain.entity.monthcar.MonthInfo;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.park.domain.entity.park.ParkVisit;
import com.icetech.fee.domain.entity.storecard.StoreCard;
import com.icetech.park.domain.entity.vehicle.VehiclePlate;
import com.icetech.basics.domain.entity.VipType;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.response.MonthDetailDto;
import com.icetech.cloudcenter.domain.response.VipDetailDto;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.report.ReportParamHolder;
import com.icetech.third.utils.RedisUtils;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.NumberUtils;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

@Slf4j
public class FlowCondition {

    @Autowired
    protected ParkService parkService;
    @Autowired
    protected VehicleService vehicleService;
    @Autowired
    protected RedisUtils redisUtils;
    @Autowired
    protected OrderService orderService;
    @Autowired
    protected LedService ledSoundService;
    @Autowired
    protected ParkVisitService parkVisitService;
    @Autowired
    protected LcdService lcdService;
    @Autowired
    private OrderInfoDao orderInfoDao;
    @Autowired
    private OrderCarInfoDao orderCarInfoDao;
    @Autowired
    private CacheHandle cacheHandle;
    public static final Integer YES = 1;
    public static final Integer NO = 0;
    /**
     * 储值卡操作服务类
     */
    @Autowired
    protected StoreCardService storeCardService;
    @Autowired
    private BlacklistApi cityBlacklistApi;

    @ToString
    public enum ResultCode{
        月卡车(10),
        黑名单车(11),
        有牌车允许临时车进入(12),
        有牌车不允许临时车进入(13),
        无牌车允许进出(14),
        无牌车不允许进入(17),
        特殊车辆免费(18),
        免费时间内(19),
        无入场有全免优惠(20),
        预缴费未超时(21),
        无需缴费(22),
        无入场记录(23),
        固定费用(24),
        需缴费(25),
        VIP车辆(26),
        车位已满禁止入场(27),
        黄牌车禁止入场(28),
        入场限制(29),
        离场限制(30),
        内部车辆(31),
        过期卡(32),
        车位已占(33),
        缴费后屏显播报(34),
        访客车(35),
        储值卡车允许进入(36),
        储值卡车禁止进入(37),
        储值卡过期(38),
        储值卡车(39),
        无入场VIP全免车(40),
        不允许临时车出(41),
        欠费补缴(42),
        虚假车牌(43),
        ;
        private Integer code;
        private ResultCode(int code){
            this.code = code;
        }
        public Integer getCode() {
            return code;
        }
        public static ResultCode getInstance(int code){
            for (ResultCode resultCode : ResultCode.values()){
                if (resultCode.code == code){
                    return resultCode;
                }
            }
            return null;
        }
    }
    @Setter
    @Getter
    @ToString
    public static class FlowRet{
        private ResultCode resultCode;
        private Map<String, Object> para;
    }
    /**
     * 判断是否有牌车
     * @return
     * @param plateNum
     */
    public boolean hasPlate(String plateNum){
        if (DataCommonConstants.isNoPlate(plateNum)){
            return false;
        }else{
            return true;
        }
    }
    public Integer getTypeByPlateNum(ReportParamHolder paramHolder, Integer type){
        if (isMonthCard(paramHolder)){
            return PlateTypeEnum.月卡车.getType();
        }
        if (isVipCar(paramHolder)){
            return PlateTypeEnum.VIP车辆.getType();
        }
        if (isInnerCar(paramHolder)){
            return PlateTypeEnum.VIP车辆.getType();
        }
        if (isVisitList(paramHolder)){
            return PlateTypeEnum.访客车辆.getType();
        }
        if (isStoreCardCar(paramHolder)){
            return PlateTypeEnum.储值卡车.getType();
        }
        if (NumberUtils.toPrimitive(type) == 3){
            return PlateTypeEnum.特殊车辆.getType();
        }
        return PlateTypeEnum.临时车.getType();
    }

    public boolean isMonthCard(ReportParamHolder paramHolder){
        MonthDetailDto monthDetail = paramHolder.getMonthDetail();
        return monthDetail != null && monthDetail.getMonthType() == MonthDetailDto.MonthType.月卡车;
    }

    public boolean isOtherRegionMonthCard(ReportParamHolder paramHolder){
        MonthDetailDto monthDetail = paramHolder.getOtherRegionMonthDetail();
        return monthDetail != null
                && (monthDetail.getMonthType() == MonthDetailDto.MonthType.月卡车
                    || monthDetail.getMonthType() == MonthDetailDto.MonthType.过期月卡车);
    }
    public boolean isOtherRegionVip(ReportParamHolder paramHolder){
        MonthDetailDto monthDetail = paramHolder.getOtherRegionMonthDetail();
        return monthDetail != null
                && (monthDetail.getMonthType() == MonthDetailDto.MonthType.月卡车
                    || monthDetail.getMonthType() == MonthDetailDto.MonthType.过期月卡车);
    }

    public boolean isAllDayMonthCard(ReportParamHolder paramHolder, OrderInfo orderInfo, Long exitTime){
        MonthDetailDto monthDetail = getMonthCarDetail(paramHolder);
        if(monthDetail.getMonthType() == MonthDetailDto.MonthType.月卡车) {
            if (orderInfo != null) {
                Long enterTime = orderInfo.getEnterTime();
                MonthInfo monthInfo = monthDetail.getMonthInfo();
                if (monthInfo != null && monthInfo.getStartTime().getTime() / 1000 <= enterTime
                    && completeConvert(monthInfo.getEndTime()) >= exitTime) {
                    return monthDetail.getMonthProduct().getCardType() == 1
                            && NumberUtils.toPrimitive(monthDetail.getMonthProduct().getDiffWorkday()) == 0;
                }
            }
        }
        return false;
    }
    public boolean inParkCreateInvalidCard(ReportParamHolder paramHolder, OrderInfo orderInfo, Long exitTime){
        MonthDetailDto monthDetail = getMonthCarDetail(paramHolder);
        if(monthDetail.getMonthType() == MonthDetailDto.MonthType.月卡车
                && monthDetail.getMonthProduct().getCardType() == 1
                && NumberUtils.toPrimitive(monthDetail.getMonthProduct().getDiffWorkday()) == 0) {
            MonthInfo monthInfo = monthDetail.getMonthInfo();
            Calendar instance = Calendar.getInstance();
            instance.setTime(monthInfo.getEndTime());
            instance.set(Calendar.HOUR_OF_DAY, 23);
            instance.set(Calendar.MINUTE, 59);
            instance.set(Calendar.SECOND, 59);
            //月卡有效期包含停车时间段
            return monthInfo.getStartTime().getTime() / 1000 < orderInfo.getEnterTime()
                    && instance.getTime().getTime() / 1000 >= exitTime;
        }
        return false;
    }
    /**
     * 判断是否月卡
     * @return
     */
    public MonthInfo getMonthCard(ReportParamHolder paramHolder){
        MonthDetailDto monthDetail = getMonthCarDetail(paramHolder);
        if(monthDetail.getMonthType() == MonthDetailDto.MonthType.月卡车) {
            return monthDetail.getMonthInfo();
        }

        return null;
    }

    /**
     * 查询月卡，包含过期卡
     * @return
     */
    public MonthInfo getMonthCardAndExpire(ReportParamHolder paramHolder){
        return getMonthCarDetail(paramHolder).getMonthInfo();
    }

    /**
     * 多位多车判断占用判断是否月卡
     * @return
     */
    public boolean isMonthCardByOccupy(ReportParamHolder paramHolder){
        return getMonthCarDetail(paramHolder).getMonthType() == MonthDetailDto.MonthType.多位多车占用;
    }
    public MonthDetailDto getMonthCarDetail(ReportParamHolder paramHolder){
        return paramHolder.getMonthDetail();
    }

    /**
     * 判断是否黑名单车
     * @return
     */
    public boolean isBlacklist(ReportParamHolder paramHolder){
        ObjectResponse<Blacklist> validBlack = paramHolder.getBlacklistResp();
        if (validBlack != null && validBlack.getCode().equals(CodeConstants.SUCCESS)){
            return true;
        }
        Integer type = cityBlacklistApi.getPlateType(paramHolder.getPlateNum(), BlacklistPark.PARK_TYPE_PARK, paramHolder.getParkId());
        return com.icetech.city.common.domain.entity.common.Blacklist.PLATE_TYPE_BLACK.equals(type);
    }

    public boolean isWhitelist(ReportParamHolder paramHolder){
        Integer type = cityBlacklistApi.getPlateType(paramHolder.getPlateNum(), BlacklistPark.PARK_TYPE_PARK, paramHolder.getParkId());
        return com.icetech.city.common.domain.entity.common.Blacklist.PLATE_TYPE_WHITE.equals(type);
    }

    /**
     * 判断是否访客车辆
     * @return
     */
    public boolean isVisitList(ReportParamHolder paramHolder){
        ObjectResponse<ParkVisit> objectResponse = paramHolder.getParkVisitResp();
        //访客车 剩余进出次数大于0时才可以进入
        if(!ObjectResponse.isSuccess(objectResponse)){
            return false;
        }
        ParkVisit visit = objectResponse.getData();
        Integer inoutNum = visit.getInoutNum();
        Integer inoutMore = visit.getInoutMore();
        if (ParkVisitMoreType.ONE.getType().equals(inoutMore)
                &&Objects.nonNull(inoutNum)
                &&inoutNum>0){
            return true;
        }
        if (ParkVisitMoreType.MANY.getType().equals(inoutMore)){
            return true;
        }
        if (ParkVisitMoreType.CUSTOM.getType().equals(inoutMore)&&inoutNum>0){
            return true;
        }
        return false;
    }

    /**
     * 判断是否允许临时车入场
     * @return
     * @param data
     */
    public boolean allowTempEnter(ParkInoutdevice data){
        if (data.getIsAllowTempcarrun() != null && data.getIsAllowTempcarrun() == 1){
            return true;
        }else{
            return false;
        }
    }

    /**
     * 判断是否无牌车扫码入场
     * @return
     */
    public boolean allowNoplateScan(ParkInoutdevice data){
        if (data.getIsOpenQrcodetype() == 1){
            return true;
        }else{
            return false;
        }
    }

    /**
     * 判断是否允许无牌车入场
     * @return
     */
    public boolean allowNoplate(ParkInoutdevice data){
        if (NumberUtils.toPrimitive(data.getIsAllowTempcarrun()) == 1
                && NumberUtils.toPrimitive(data.getIsAllowNocardrun()) == 1){
            return true;
        }else{
            return false;
        }
    }

    /**
     * 判断是否特殊车辆
     * @return
     */
    public boolean isSpecial(Integer type){
        if (type == 3){
            return true;
        }else{
            return false;
        }
    }
    /**
     * 判断是否特殊车辆免费放行
     * @return
     */
    public boolean isSpecialFree(ParkConfig parkConfig){
        if (parkConfig.getIsfreeSpecialcar() == 1){
            return true;
        }else{
            return false;
        }
    }
    /**
     * 判断是否公务车辆免费放行
     * @return
     */
    public boolean isFreeOfficialCars(ParkConfig parkConfig, String plateNum){
        //公务车以G结尾
        if (NumberUtils.toPrimitive(parkConfig.getFreeOfficialCars()) == 1
                && PlateTypeDto.officialCar(plateNum)){
            return true;
        }else{
            return false;
        }
    }
    /**
     * 判断是否固定收费
     * @return
     */
    public float fixedFee(ParkConfig parkConfig,Integer carType){
        Integer val = 1;
        if (parkConfig != null && val.equals(parkConfig.getIsfixedfees()) && parkConfig.getFixedfeevalue() != null){
            return carType==1?parkConfig.getFixedfeevalue():parkConfig.getFixedFeeValueBig();
        }else{
            return -1;
        }
    }

    protected ResultCode getNoPlateResultCode(ReportParamHolder paramHolder) {
        ResultCode code;
        ParkInoutdevice data = paramHolder.getParkChannel();
        //2.1 是否允许无牌车进出
        if (allowNoplate(data)){
            code = ResultCode.无牌车允许进出;
        }else{
            code = ResultCode.无牌车不允许进入;
        }
        return code;
    }
    /**
     * 判断是否允许黄牌车入场
     * @return
     * @param data
     */
    public boolean yellowcarrun(String plateColor,  ParkInoutdevice data){
        if ("黄色".equals(plateColor) && data.getIsAllowTempcarrun() == 1 && data.getIsAllowYellowcarrun() == 1){
            return true;
        }else{
            return false;
        }
    }
    /**
     * 判断是否允许蓝牌车入场
     * @return
     * @param data
     */
    public boolean bluecarrun(String plateColor,  ParkInoutdevice data){
        if ("蓝色".equals(plateColor) && data.getIsAllowTempcarrun() == 1 && data.getIsAllowBluerun() == 1){
            return true;
        }else{
            return false;
        }
    }
    /**
     * 判断是否允许新能源车入场
     * @return
     * @param data
     */
    public boolean greencarrun(String plateColor,  ParkInoutdevice data){
        return ("黄绿色".equals(plateColor) || "绿色".equals(plateColor))
                && data.getIsAllowTempcarrun() == 1
                && data.getIsAllowNewenergycarrun() == 1;
    }
    protected boolean isVipCar(ReportParamHolder paramHolder){
        ObjectResponse<VipType> validVipCar = paramHolder.getVipTypeResp();
        return ObjectResponse.isSuccess(validVipCar);
    }
    protected boolean isOtherRegionVipCar(ReportParamHolder paramHolder){
        VipDetailDto vipDetailDto = paramHolder.getOtherRegionVipDetailDto();
        return vipDetailDto != null;
    }
    protected boolean isInnerCar(ReportParamHolder paramHolder){
        ObjectResponse<VehiclePlate> vehiclePlateObjectResponse = paramHolder.getVehiclePlateResp();
        return ObjectResponse.isSuccess(vehiclePlateObjectResponse);
    }

    protected VipType getVipCar(ReportParamHolder paramHolder){
        ObjectResponse<VipType> validVipCar = paramHolder.getVipTypeResp();
        if (ObjectResponse.isSuccess(validVipCar)){
            return validVipCar.getData();
        }
        return null;
    }

    /**
     * 是否显示播报黑名单
     * @return
     */
    protected boolean isShowBlackCar(ReportParamHolder paramHolder){
        ParkInoutdevice channel = paramHolder.getParkChannel();
        if (channel != null && channel.getLedLcdSource() != null && channel.getLedLcdSource() == 2){
            ObjectResponse<LcdConfig> objectResponse = paramHolder.getLcdConfigResp();
            LcdConfig lcdConfig = objectResponse.getData();
            if (lcdConfig.getBlackCar() == 1){//不显示
                return false;
            }else{//显示
                return true;
            }
        }else{
            ObjectResponse<LedConfig> ledConfigObjectResponse = paramHolder.getLedConfigResp();
            LedConfig parkLedSoundConfig = ledConfigObjectResponse.getData();
            if (parkLedSoundConfig.getLedBlackCar() == 1){//不显示
                return false;
            }else{//显示
                return true;
            }
        }

    }
    /**
     * 是否显示播报黑名单
     * @return
     */
    protected Integer getRemainDaysMc(ReportParamHolder paramHolder) {
        ParkInoutdevice channel = paramHolder.getParkChannel();
        if (channel != null && channel.getLedLcdSource() != null && channel.getLedLcdSource() == 2){
            ObjectResponse<LcdConfig> objectResponse = paramHolder.getLcdConfigResp();
            LcdConfig lcdConfig = objectResponse.getData();
            return lcdConfig.getRemainDaysMc();
        }else{
            ObjectResponse<LedConfig> ledConfigObjectResponse = paramHolder.getLedConfigResp();
            LedConfig parkLedSoundConfig = ledConfigObjectResponse.getData();
            return parkLedSoundConfig.getLedRemainDaysMc();
        }

    }

    public boolean isStoreCardCar(ReportParamHolder paramHolder){
        //判断是否是储值卡车
        ObjectResponse<StoreCard> objectResponse = paramHolder.getStoreCardResp();
        return ObjectResponse.isSuccess(objectResponse);
    }

    public void replaceCardCode(ReportParamHolder paramHolder, FlowCondition.FlowRet flowRet){
        boolean isStoreCard = isStoreCardCar(paramHolder);
        if (!isStoreCard){
            return;
        }
        switch (flowRet.getResultCode()){
            case 有牌车允许临时车进入:
                flowRet.setResultCode(ResultCode.储值卡车允许进入);
                break;
            case 有牌车不允许临时车进入:
                flowRet.setResultCode(ResultCode.储值卡车禁止进入);
                break;
                default:break;
        }
    }

    public FlowCondition.ResultCode tempPlateHandle(ReportParamHolder paramHolder, String plateColor) {
        FlowCondition.ResultCode code;
        ParkInoutdevice data = paramHolder.getParkChannel();

        if (!yellowcarrun(plateColor, data)){
            return FlowCondition.ResultCode.黄牌车禁止入场;
        }else{
            //1.3 是否允许临时车进入
            if (allowTempEnter(data)){
                code = FlowCondition.ResultCode.有牌车允许临时车进入;
            }else{
                code = FlowCondition.ResultCode.有牌车不允许临时车进入;
            }
            return code;
        }
    }

    /**
     * 进出场数据过滤
     * @param parkId 车场ID
     * @param plateNum 车牌号
     * @param parkConfig 高级配置
     * @param channelCode 通道编号
     * @param exType 进出场类型
     * @param eventTime 进出事件时间
     * @return true：重复过滤, false：不过滤
     */
    protected boolean filter(String parkCode, Long parkId, String plateNum, ParkConfig parkConfig, String channelCode, int exType, long eventTime) {
        if(NumberUtils.toPrimitive(parkConfig.getFilterTime()) > 0){
            Integer filterTime = parkConfig.getFilterTime();
            if (exType == 1) {
                CarEnterRequest entrance = cacheHandle.getEntrance(parkCode, channelCode);
                if (entrance != null) {
                    if (entrance.getEnterTime() != null && plateNum.equals(entrance.getPlateNum())) {
                        Long lastEnterTime = entrance.getEnterTime();
                        return lastEnterTime + filterTime >= eventTime;
                    }
                    return false;
                }
            }
            if (exType == 2) {
                CarExitRequest exit = cacheHandle.getExit(parkCode, channelCode);
                if (exit != null) {
                    if (exit.getExitTime() != null && plateNum.equals(exit.getPlateNum())) {
                        Long lastExitTime = exit.getExitTime();
                        return lastExitTime + filterTime >= eventTime;
                    }
                    return false;
                }
            }
            OrderInfo orderInfo = new OrderInfo();
            orderInfo.setParkId(parkId);
            orderInfo.setPlateNum(plateNum);
            OrderInfo orderInfoRet = orderInfoDao.selectLimitOneByIdDesc(orderInfo);
            if (orderInfoRet != null) {
                long lastEnterTime = NumberUtils.toPrimitive(orderInfoRet.getEnterTime());
                long lastExitTime = NumberUtils.toPrimitive(orderInfoRet.getExitTime());
                //车场级过滤
                if (NumberUtils.toPrimitive(parkConfig.getPlateFilterType()) == 1) {
                    boolean result = lastExitTime + filterTime >= eventTime || lastEnterTime + filterTime >= eventTime;
                    if (result) {
                        log.info("车场过滤限制, 重复的订单{}", orderInfoRet);
                    }
                    return result;
                } else {
                    //通道级过滤
                    OrderCarInfo orderCarInfo = orderCarInfoDao.selectByOrderNum(orderInfoRet.getOrderNum());
                    if (orderCarInfo == null) {
                        return false;
                    }
                    if (exType == 1 && orderCarInfo.getEnterChannelId() != null
                            && orderCarInfo.getEnterChannelId().equals(channelCode)) {
                        boolean result = lastEnterTime + filterTime >= eventTime;
                        if (result) {
                            log.info("通道过滤限制, 重复的订单{}", orderInfoRet);
                        }
                        return result;
                    }
                    if (exType == 2 && orderCarInfo.getExitChannelId() != null
                            && orderCarInfo.getExitChannelId().equals(channelCode)) {
                        return lastExitTime + filterTime >= eventTime;
                    }
                }
            }
        }
        return false;
    }

    protected OrderInfo getLastEnterOrder(Long parkId, String plateNum, long startTime) {
        OrderInfo orderInfo = new OrderInfo();
        orderInfo.setParkId(parkId);
        orderInfo.setPlateNum(plateNum);
        OrderInfo orderInfoRet = orderInfoDao.selectLimitOneOrderByEnterDesc(orderInfo);
        if (orderInfoRet != null && startTime <= orderInfoRet.getEnterTime()) {
            return orderInfoRet;
        }
        return null;
    }

    private long completeConvert(Date date) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(date);
        instance.set(Calendar.HOUR_OF_DAY, 23);
        instance.set(Calendar.MINUTE, 59);
        instance.set(Calendar.SECOND, 59);
        return instance.getTime().getTime() / 1000;
    }
}
