package com.icetech.park.service.factory;

import com.icetech.basics.utils.Spring;
import com.icetech.cloudcenter.api.DownSendService;
import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.enumeration.FullCloudDownCmdEnum;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.StringUtils;
import com.icetech.park.service.down.p2c.DownService;
import lombok.extern.slf4j.Slf4j;

/**
 * 获取下发业务实现类
 * @author fangct
 */
@Slf4j
public class SendServiceFactory {

    private static final String SERVICE_SUFFIX = "ServiceImpl";

    /**
     *
     * @param serviceType
     * @return
     */
    public static DownSendService createSendService(Integer serviceType){
        String serviceName = DownServiceEnum.getServiceName(serviceType);
        DownSendService downSendService = getServiceBean(serviceName);
        return downSendService;
    }
    /**
     *
     * @param serviceName
     * @return
     */
    public static NotifyService createNotifyService(String serviceName){
        return getNotifyServiceBean(serviceName);
    }

    /**
     * 创建端云下发的实现类
     * @param cmdType
     * @return
     */
    public static DownService createP2cSendService(Integer cmdType){
        String cmd = P2cDownCmdEnum.getCmd(cmdType);
        if (cmd == null){
            log.info("端云无需下发，cmdType：{}", cmdType);
            throw new ResponseBodyException(CodeConstants.ERROR_406, "端云无需下发");
        }
        DownService sendService = getP2cBean(cmd, DownService.class);
        return sendService;
    }
    public static DownService createFullCloudSendService(Integer cmdType){
        String cmd = FullCloudDownCmdEnum.getCmd(cmdType);
        if (cmd == null){
            log.info("端云无需下发，cmdType：{}", cmdType);
            throw new ResponseBodyException(CodeConstants.ERROR_406, "纯云无需下发");
        }
        return getFullCloudBean(cmd, DownService.class);
    }
    /**
     * 获取端云实现类
     * @param cmd
     * @return
     */
    public static <T> T getP2cBean(String cmd, Class<T> cla){
        String serviceName = "p2c";
        if (cmd.contains("_")){
            String[] s = cmd.split("_");
            for (String element : s){
                serviceName = serviceName + StringUtils.toUpperCaseFirstOne(element);
            }
        }else{
            serviceName = serviceName + StringUtils.toUpperCaseFirstOne(cmd);
        }
        try {
            return Spring.getBean(serviceName + SERVICE_SUFFIX);
        }catch(RuntimeException e){
            throw new ResponseBodyException(CodeConstants.ERROR_404, CodeConstants.getName(CodeConstants.ERROR_404));
        }
    }
    /**
     * 获取纯云实现类
     * @param cmd
     * @return
     */
    public static <T> T getFullCloudBean(String cmd, Class<T> cla){
        String serviceName = "fullCloud";
        if (cmd.contains("_")){
            String[] s = cmd.split("_");
            for (String element : s){
                serviceName = serviceName + StringUtils.toUpperCaseFirstOne(element);
            }
        }else{
            serviceName = serviceName + StringUtils.toUpperCaseFirstOne(cmd);
        }
        try {
            return Spring.getBean(serviceName + SERVICE_SUFFIX);
        }catch(RuntimeException e){
            throw new ResponseBodyException(CodeConstants.ERROR_404, CodeConstants.getName(CodeConstants.ERROR_404));
        }
    }
    /**
     * 获取端云IOT实现类
     * @param cmd
     * @return
     */
    public static <T> T getIotBean(String cmd, Class<T> cla){
        String serviceName = "iot";
        if (cmd.contains("_")){
            String[] s = cmd.split("_");
            for (String element : s){
                serviceName = serviceName + StringUtils.toUpperCaseFirstOne(element);
            }
        }else{
            serviceName = serviceName + StringUtils.toUpperCaseFirstOne(cmd);
        }
        try {
            return Spring.getBean(serviceName + SERVICE_SUFFIX);
        }catch(RuntimeException e){
            throw new ResponseBodyException(CodeConstants.ERROR_404, CodeConstants.getName(CodeConstants.ERROR_404));
        }
    }
    /**
     * 获取端云实现类
     * @param cmd
     * @return
     */
    public static <T> T getItcBean(String cmd, Class<T> cla){
        String serviceName = "itc";
        if (cmd.contains("_")){
            String[] s = cmd.split("_");
            for (String element : s){
                serviceName = serviceName + StringUtils.toUpperCaseFirstOne(element);
            }
        }else{
            serviceName = serviceName + StringUtils.toUpperCaseFirstOne(cmd);
        }
        try {
            return Spring.getBean(serviceName + SERVICE_SUFFIX);
        }catch(RuntimeException e){
            throw new ResponseBodyException(CodeConstants.ERROR_404, CodeConstants.getName(CodeConstants.ERROR_404));
        }
    }
    /**
     * 获取监控相机实现类
     * @param cmd cmd
     * @return
     */
    public static <T> T getMorBean(String cmd, Class<T> cla){
        String serviceName = "mor";
        if (cmd.contains("_")){
            String[] s = cmd.split("_");
            for (String element : s){
                serviceName = serviceName + StringUtils.toUpperCaseFirstOne(element);
            }
        }else{
            serviceName = serviceName + StringUtils.toUpperCaseFirstOne(cmd);
        }
        try {
            return Spring.getBean(serviceName + SERVICE_SUFFIX);
        }catch(RuntimeException e){
            throw new ResponseBodyException(CodeConstants.ERROR_404, CodeConstants.getName(CodeConstants.ERROR_404));
        }
    }
    /**
     * 获取端云机器人实现类
     * @param cmd
     * @return
     */
    public static <T> T getP2rBean(String cmd, Class<T> cla){
        if (cmd != null){
            cmd = cmd.replaceAll("_resp", "");
        }
        String serviceName = "p2r";
        if (cmd.contains("_")){
            String[] s = cmd.split("_");
            for (String element : s){
                serviceName = serviceName + StringUtils.toUpperCaseFirstOne(element);
            }
        }else{
            serviceName = serviceName + StringUtils.toUpperCaseFirstOne(cmd);
        }
        try {
            return Spring.getBean(serviceName + SERVICE_SUFFIX);
        }catch(RuntimeException e){
            throw new ResponseBodyException(CodeConstants.ERROR_404, CodeConstants.getName(CodeConstants.ERROR_404));
        }
    }
    /**
     * 获取云云机器人实现类
     * @param cmd
     * @return
     */
    public static <T> T getRobotPncBean(String cmd){
        String serviceName = "pnc";
        if (cmd.contains("_")){
            String[] s = cmd.split("_");
            for (String element : s){
                serviceName = serviceName + StringUtils.toUpperCaseFirstOne(element);
            }
        }else{
            serviceName = serviceName + StringUtils.toUpperCaseFirstOne(cmd);
        }
        try {
            return Spring.getBean(serviceName + SERVICE_SUFFIX);
        }catch(RuntimeException e){
            throw new ResponseBodyException(CodeConstants.ERROR_404, CodeConstants.getName(CodeConstants.ERROR_404));
        }
    }

    /**
     * 获取端网云实现类
     * @param prefix
     * @return
     */
    private static DownSendService getServiceBean(String prefix){
        String serviceName = prefix + SERVICE_SUFFIX;
        try {
            return Spring.getBean(serviceName);
        }catch(RuntimeException e){
            throw new ResponseBodyException(CodeConstants.ERROR_404, "没有下发实现类");
        }
    }
    /**
     * 获取端网云实现类
     * @param prefix
     * @return
     */
    private static NotifyService getNotifyServiceBean(String prefix){
        String serviceName = prefix + SERVICE_SUFFIX;
        try {
            return Spring.getBean(serviceName);
        }catch(RuntimeException e){
            throw new ResponseBodyException(CodeConstants.ERROR_404, "没有回调实现类");
        }
    }
}
