package com.icetech.park.service.down.pnc.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.component.AsyncNotifyClient;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.VoiceReportRequest;
import com.icetech.cloudcenter.domain.request.pnc.ShowAndSayRequest;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.NumberUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 语音显示屏内容接口
 *
 * @author fangct
 */
@Service
@Slf4j
public class ShowAndSayServiceImpl implements NotifyService<ShowAndSayRequest> {

    @Autowired
    private PncDownHandle downHandle;
    @Resource
    private AsyncNotifyClient asyncNotifyClient;

    @Autowired
    private OrderInfoDao orderInfoDao;

    public ObjectResponse<Void> execute(VoiceReportRequest voiceReportRequest) {
        ShowAndSayRequest showAndSayRequest = new ShowAndSayRequest();
        showAndSayRequest.setChannelId(voiceReportRequest.getAisleCode());
        showAndSayRequest.setType(1);
        showAndSayRequest.setInoutEvent(voiceReportRequest.getExitWay());
        showAndSayRequest.setOperAccount(voiceReportRequest.getOperAccount());
        showAndSayRequest.setExTerminal(voiceReportRequest.getExitTerminal());
        //有费用
        if (voiceReportRequest.isHasNotPay()) {
            showAndSayRequest.setHasNotPay(1);
            // 转换订单号
            if (CollectionUtils.isNotEmpty(voiceReportRequest.getOrderNums())) {
                List<OrderInfo> orderInfos = orderInfoDao.selectList(Wrappers.lambdaQuery(OrderInfo.class)
                        .in(OrderInfo::getOrderNum, voiceReportRequest.getOrderNums()));
                if (CollectionUtils.isNotEmpty(orderInfos)) {
                    showAndSayRequest.setOrderIds(orderInfos.stream()
                            .map(OrderInfo::getLocalOrderNum)
                            .filter(Objects::nonNull)
                            .collect(Collectors.joining(",")));
                }
            }
        }else {
            showAndSayRequest.setHasNotPay(0);
        }
        Map<String, Object> content = new HashMap<>();
        content.put("plateNum", voiceReportRequest.getPlateNum());
        String orderNum = voiceReportRequest.getOrderNum();
        OrderInfo orderInfo = orderInfoDao.selectByOrderNum(orderNum);
        if (Objects.nonNull(orderInfo)) {
            Long enterTime = orderInfo.getEnterTime();
            content.put("queryTime", enterTime + voiceReportRequest.getParkTime());
        }else {
            if (NumberUtils.toPrimitive(voiceReportRequest.getParkTime()) == 0) {
                content.put("queryTime", DateTools.unixTimestamp());
            } else {
                return ObjectResponse.failed(CodeConstants.ERROR_402);
            }
        }
        showAndSayRequest.setContent(content);
        String messageId = downHandle.signAndSendAsyncResult(voiceReportRequest.getParkCode(),
                        DownServiceEnum.语音显示屏内容.getServiceName(), showAndSayRequest, voiceReportRequest.getTopic());
        if (messageId == null){
            return ObjectResponse.failed(CodeConstants.ERROR_3003);
        }
        return ObjectResponse.failed(CodeConstants.ERROR_12002, messageId);
    }

    @Override
    public void notify(String messageId, ObjectResponse<String> response, SendInfoRecord<ShowAndSayRequest> sendInfoRecord) {
        asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), response);
    }

}
