package com.icetech.park.service.down.pnc.impl;

import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.park.component.AsyncNotifyClient;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.DataEnterRequest;
import com.icetech.cloudcenter.domain.request.pnc.ReqEnterRequest;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * 请求入场接口
 *
 * @author fangct
 */
@Service
public class ReqEnterServiceImpl implements NotifyService<ReqEnterRequest> {

    @Autowired
    private PncDownHandle downHandle;
    @Resource
    private AsyncNotifyClient asyncNotifyClient;

    public ObjectResponse<Void> execute(DataEnterRequest enterRequest) {
        ReqEnterRequest reqEnterRequest = new ReqEnterRequest();
        reqEnterRequest.setPlateNum(enterRequest.getPlateNum());
        reqEnterRequest.setChannelId(enterRequest.getAisleCode());
        reqEnterRequest.setCarType(enterRequest.getCarType());
        reqEnterRequest.setEnterTime(enterRequest.getEnterTime());
        reqEnterRequest.setCarDesc(enterRequest.getSpecialCar());
        reqEnterRequest.setRemark(enterRequest.getRemark());
        reqEnterRequest.setInoutEvent(enterRequest.getEnterWay());
        reqEnterRequest.setOperAccount(enterRequest.getOperaUser());
        reqEnterRequest.setExTerminal(enterRequest.getEnterTerminal());
        String messageId = downHandle.signAndSendAsyncResult(enterRequest.getParkCode(), DownServiceEnum.请求入场.getServiceName(),
                reqEnterRequest, enterRequest.getTopic());
        if (messageId == null){
            return ObjectResponse.failed(CodeConstants.ERROR_3003);
        }
        return ObjectResponse.failed(CodeConstants.ERROR_12002, messageId);
    }

    @Override
    public void notify(String messageId, ObjectResponse<String> response, SendInfoRecord<ReqEnterRequest> sendInfoRecord) {
        asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), response);
    }
}
