package com.icetech.park.service.down.pnc.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.basics.dao.VipTypeDao;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.api.AlarmService;
import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.cloudcenter.api.QueryFeeService;
import com.icetech.cloudcenter.api.order.OrderEnterService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.cloudcenter.domain.constants.RedisConstants;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.EnterRequest;
import com.icetech.cloudcenter.domain.request.QueryFeeRequest;
import com.icetech.cloudcenter.domain.request.pnc.ExitPayCautionRequest;
import com.icetech.cloudcenter.domain.response.*;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.PayStatusConstants;
import com.icetech.common.constants.SqlConstant;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.order.dao.OrderDiscountDao;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.dao.OrderPayDao;
import com.icetech.order.domain.entity.OrderDiscount;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.order.domain.entity.OrderPayDiscount;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.order.service.impl.OrderSonInfoServiceImpl;
import com.icetech.park.component.AsyncNotifyClient;
import com.icetech.park.domain.constant.RedisDiscountKeyConstant;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import com.icetech.third.utils.RedisUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 缴费查询接口
 *
 * @author fangct
 */
@Service
@Slf4j
@RefreshScope
public class QueryFeeServiceImpl implements QueryFeeService, NotifyService<QueryFeeRequest> {
    @Resource
    private PncDownHandle downHandle;
    @Resource
    private AlarmService alarmService;
    @Resource
    private AsyncNotifyClient asyncNotifyClient;
    @Resource
    private OrderDiscountDao orderDiscountDao;
    @Resource
    private OrderPayDao orderPayDao;
    @Resource
    private OrderEnterService orderEnterService;
    @Resource
    private OrderInfoDao orderInfoDao;
    @Resource
    private ParkService parkService;
    @Resource
    private OrderSonInfoServiceImpl orderSonInfoService;
    @Resource
    private ParkRegionDao parkRegionDao;
    @Resource
    private RedisUtils redisUtils;
    @Resource
    private CacheHandle cacheHandle;
    @Resource
    private VipTypeDao vipTypeDao;

    @Value("${pay.etc.lock:120}")
    private Integer etcLock;

    @Override
    public ObjectResponse<Void> queryFee(QueryFeeRequest queryFeeRequest) {

        String key = queryFeeRequest.getKey();
        Long parkId = queryFeeRequest.getParkId();

        //重置参数
        QueryFeeRequest feeRequest = buildRequest(parkId, queryFeeRequest);
        String messageId = downHandle.signAndSendAsyncResult(parkId, queryFeeRequest.getParkCode(),
                key, DownServiceEnum.缴费查询.getServiceName(), feeRequest, queryFeeRequest.getChannelId(),
                queryFeeRequest.getTopic(), queryFeeRequest.getExtraInfo());
        if (StringUtils.isEmpty(messageId)) {
            alarmService.queryFeeFailHandler(queryFeeRequest.getParkCode(), parkId, queryFeeRequest.getChannelId());
            return ObjectResponse.failed(CodeConstants.ERROR_3001, "下发消息失败");
        }
        return ObjectResponse.failed(CodeConstants.ERROR_12002, messageId);
    }

    @Override
    public void notify(String messageId, ObjectResponse<String> response, SendInfoRecord<QueryFeeRequest> sendInfoRecord) {
        QueryFeeResponse queryFeeResponse = JsonUtils.parseObject(response.getData(), QueryFeeResponse.class);
        QueryFeeRequest queryFeeRequest = sendInfoRecord.getParams();
        if (queryFeeRequest == null) {
            queryFeeRequest = new QueryFeeRequest();
        }

        ObjectResponse<Object> objectResponse = new ObjectResponse<>();
        if (response.getCode().equals(CodeConstants.ERROR_3004)
                || response.getCode().equals(CodeConstants.ERROR_3007)
                || response.getCode().equals(CodeConstants.ERROR_3008)
                || response.getCode().equals(CodeConstants.ERROR_3010)) {
            objectResponse.setCode(response.getCode());
            objectResponse.setMsg(response.getMsg());
            objectResponse.setTraceId(response.getTraceId());
        } else if (ObjectResponse.isSuccess(response)) {
            try {
                QueryOrderFeeResponse queryOrderFeeResponse = getQueryOrderFeeResponse(sendInfoRecord, queryFeeResponse, queryFeeRequest);
                objectResponse = ObjectResponse.success(queryOrderFeeResponse);
            } catch (ResponseBodyException e) {
                objectResponse.setCode(e.getErrCode());
                objectResponse.setMsg(e.getMessage());
            }
        } else {
            objectResponse.setCode(CodeConstants.ERROR_3001);
            objectResponse.setMsg(response.getMsg());
        }
        if (QueryFeeRequest.ExtraInfoEnum.PULL_FEE.val.equals(sendInfoRecord.getExtraInfo())) {
            PullfeeResponse pullfeeResponse = new PullfeeResponse();
            if (ObjectResponse.isSuccess(objectResponse)) {
                QueryOrderFeeResponse data = (QueryOrderFeeResponse) objectResponse.getData();
                String discountPrice = data.getDiscountPrice();
                String unpayPrice = data.getUnpayPrice();
                String discountAmount = data.getDiscountAmount();
                //总应收
                pullfeeResponse.setTotalPrice(data.getTotalAmount());
                //总优惠
                pullfeeResponse.setDiscountPrice(NumberUtils.decimalAdd(discountPrice, discountAmount).toString());
                pullfeeResponse.setCurrentDiscountPrice(discountPrice);
                pullfeeResponse.setPaidPrice(data.getPaidAmount());
                pullfeeResponse.setNeedPayPrice(unpayPrice);
                pullfeeResponse.setQueryTime(data.getQueryTime());
                pullfeeResponse.setLastPayTime(data.getPayTime());
                pullfeeResponse.setOrderNum(data.getOrderNum());
                pullfeeResponse.setInsideDetails(data.getInsideDetails());
                cacheHandle.setChannelFee(queryFeeRequest.getParkCode(), queryFeeRequest.getChannelId(), data);
            } else if (objectResponse.getCode().equals(CodeConstants.ERROR_3004)){
                QueryOrderFeeResponse data = cacheHandle.getChannelFee(queryFeeRequest.getParkCode(), queryFeeRequest.getChannelId());
                if (data == null){
                    log.info("[人工查询费用] 查询最新费用失败，车辆已离场[{}]", queryFeeRequest);
                } else {
                    String discountPrice = data.getDiscountPrice();
                    String discountAmount = data.getDiscountAmount();
                    //总应收
                    pullfeeResponse.setTotalPrice(data.getTotalAmount());
                    //总优惠
                    pullfeeResponse.setDiscountPrice(NumberUtils.decimalAdd(discountPrice, discountAmount).toString());
                    pullfeeResponse.setCurrentDiscountPrice(discountPrice);
                    pullfeeResponse.setPaidPrice(NumberUtils.decimalAdd(data.getPaidAmount(), data.getUnpayPrice()).toString());
                    pullfeeResponse.setNeedPayPrice("0.00");
                    pullfeeResponse.setLastPayTime(data.getPayTime());
                    pullfeeResponse.setOrderNum(data.getOrderNum());
                    pullfeeResponse.setInsideDetails(data.getInsideDetails());
                    cacheHandle.setChannelFee(queryFeeRequest.getParkCode(), queryFeeRequest.getChannelId(), data);
                }
            } else {
                objectResponse = ObjectResponse.failed(CodeConstants.ERROR_3001);
            }
            objectResponse.setData(pullfeeResponse);
        }
        ObjectResponse<Object> finalObjectResponse = objectResponse;
        asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), finalObjectResponse);
    }

    private QueryOrderFeeResponse getQueryOrderFeeResponse(SendInfoRecord<QueryFeeRequest> sendInfoRecord,
                                                           QueryFeeResponse queryFeeResponse, QueryFeeRequest queryFeeRequest) {
        if (queryFeeResponse.getPlateNum() == null && queryFeeRequest.getPlateNum() != null) {
            queryFeeResponse.setPlateNum(queryFeeRequest.getPlateNum());
        }
        QueryOrderFeeResponse queryOrderFeeResponse = new QueryOrderFeeResponse();
        BeanUtils.copyProperties(queryFeeResponse, queryOrderFeeResponse);
        List<NotPayDetail> notPayDetails = queryFeeResponse.getNotPayDetails();
        if (CollectionUtils.isNotEmpty(notPayDetails)) {
            List<String> localOrderIds = notPayDetails.stream()
                    .map(NotPayDetail::getOrderId)
                    .filter(Objects::nonNull)
                    .collect(Collectors.toList());
            List<OrderInfo> orderInfos = orderInfoDao.selectList(Wrappers.lambdaQuery(OrderInfo.class)
                    .eq(OrderInfo::getParkId, sendInfoRecord.getParkId())
                    .in(OrderInfo::getLocalOrderNum, localOrderIds));
            if (CollectionUtils.isNotEmpty(orderInfos)) {
                Map<String, OrderInfo> map = orderInfos.stream()
                        .collect(Collectors.toMap(OrderInfo::getLocalOrderNum, Function.identity(), (older, newer) -> newer));
                List<NotPayDetail> payDetails = notPayDetails.stream()
                        .peek(a -> {
                            OrderInfo orderInfo = map.get(a.getOrderId());
                            if (orderInfo != null) {
                                a.setOrderNum(orderInfo.getOrderNum());
                            }
                        }).collect(Collectors.toList());
                queryOrderFeeResponse.setNotPayDetails(payDetails);
            }
        }

        int isInside = 0;
        String localOrderNum = queryFeeResponse.getOrderId();
        boolean hasNotPay = CollectionUtils.isNotEmpty(queryFeeResponse.getNotPayDetails());
        if (StringUtils.isBlank(localOrderNum) && !hasNotPay) {
            log.warn("[端网云查费] 缴费查询返回信息有误, orderId为空，请求参数：{}", queryFeeRequest);
            throw new ResponseBodyException(CodeConstants.ERROR_3001, "查询结果有误");
        }
        ObjectResponse<Park> parkObjectResponse = parkService.findByParkId(sendInfoRecord.getParkId());
        if (!ObjectResponse.isSuccess(parkObjectResponse)) {
            log.warn("[端网云查费] 车场不存在, parkId[{}]", sendInfoRecord.getParkId());
            throw new ResponseBodyException(CodeConstants.ERROR_3001, "车场不存在");
        }
        ObjectResponse<ParkConfig> parkConfigObjectResponse = parkService.getParkConfig(sendInfoRecord.getParkId());
        if (!ObjectResponse.isSuccess(parkConfigObjectResponse)) {
            log.warn("[端网云查费] 车场高级配置不存在, parkId[{}]", sendInfoRecord.getParkId());
            throw new ResponseBodyException(CodeConstants.ERROR_3001, "车场高级配置不存在");
        }
        Park park = parkObjectResponse.getData();
        ParkConfig parkConfig = parkConfigObjectResponse.getData();
        OrderInfo orderInfo = null;
        if (StringUtils.isNotBlank(localOrderNum)) {
            // 根据本地订单号查询订单
            OrderInfo orderInfoParam = new OrderInfo();
            orderInfoParam.setLocalOrderNum(localOrderNum);
            orderInfoParam.setParkId(park.getId());
            orderInfo = orderInfoDao.selectLimitOneOrderByEnterDesc(orderInfoParam);
        }
        if (orderInfo == null) {
            log.info("[端网云查费] 云平台未查询到在场记录, 本地订单号[{}], 车牌[{}]", localOrderNum, queryOrderFeeResponse.getPlateNum());
            orderInfo = new OrderInfo();
            orderInfo.setPlateNum(queryOrderFeeResponse.getPlateNum());
            if (!hasNotPay) {
                isInside = 1;
            }
        }
        // 有牌车支付 无入场记录时，保存主订单信息
        if (StringUtils.isBlank(orderInfo.getOrderNum()) && !hasNotPay) {
            try {
                orderInfo.setParkId(park.getId());
                Long enterTime = queryFeeResponse.getEnterTime();
                orderInfo.setEnterTime(enterTime == null ? DateTools.unixTimestamp() : enterTime);

                EnterRequest enterRequest = new EnterRequest();
                enterRequest.setParkId(park.getId());
                enterRequest.setOrderId(localOrderNum);
                enterRequest.setPlateNum(queryFeeResponse.getPlateNum());
                enterRequest.setType(1);
                enterRequest.setCarType(1);
                enterRequest.setEnterTime(enterTime == null ? DateTools.unixTimestamp() : enterTime);
                enterRequest.setChannelId(queryFeeRequest.getChannelId());
                enterRequest.setIsInside(isInside);

                //当前通道为出场的话,并且不为入口缴费模式则设为true
                enterRequest.setNoneEnterFlag(true);
                if (queryFeeRequest.getChannelId() != null && Integer.valueOf(1).equals(parkConfig.getEntryPayFlag())) {
                    ObjectResponse<ParkInoutdevice> channelInfo =
                            parkService.getInOutDeviceByCode(park.getId(), queryFeeRequest.getChannelId());
                    ParkInoutdevice parkInoutdevice = channelInfo.getData();
                    //入口缴费时，不存在无入场记录的情况
                    if (Integer.valueOf(1).equals(parkInoutdevice.getInandoutType())) {
                        enterRequest.setNoneEnterFlag(false);
                    }
                }
                AtomicReference<Long> regionIdAto = new AtomicReference<>();
                if (enterRequest.getChannelId() == null) {
                    ObjectResponse<List<ParkInoutdevice>> objectResponse = parkService.getChannelByType(park.getId(), 1);
                    if (ObjectResponse.isSuccess(objectResponse)) {
                        Optional<ParkInoutdevice> optional = objectResponse.getData().stream()
                                .filter(pd -> Integer.valueOf(1).equals(pd.getIsMaster())).findAny();
                        optional.ifPresent(pd -> {
                            regionIdAto.set(pd.getRegionId());
                            enterRequest.setChannelId(pd.getInandoutCode());
                            log.info("[端网云查费] 补订单的入场通道编号[{}]", pd.getInandoutCode());
                        });
                    }
                }
                log.info("[端网云查费]无入场记录返回固定收费, 平台模拟入场参数[{}]", enterRequest);
                ObjectResponse<Map<String, Object>> enterObjectResponse =
                        orderEnterService.enter(enterRequest, park.getParkCode());
                if (ObjectResponse.isSuccess(enterObjectResponse)) {
                    Map<String, Object> objectMap = enterObjectResponse.getData();
                    orderInfo.setOrderNum((String) objectMap.get("orderNum"));
                    if (regionIdAto.get() != null) {
                        orderInfo.setRegionId(regionIdAto.get());
                    } else if (enterRequest.getChannelId() != null){
                        ObjectResponse<ParkInoutdevice> channelInfo =
                                parkService.getInOutDeviceByCode(park.getId(), enterRequest.getChannelId());
                        ParkInoutdevice parkInoutdevice = channelInfo.getData();
                        if (parkInoutdevice != null) {
                            orderInfo.setRegionId(parkInoutdevice.getRegionId());
                        }
                    }
                }
            } catch (Exception e) {
                log.error("[端网云查费]无入场记录查询费用，保存主订单信息失败.请求参数[{}]", queryFeeRequest, e);
            }
        }
        if (StringUtils.isNotBlank(orderInfo.getOrderNum())) {
            dealHistoryMoney(orderInfo.getOrderNum(), park, queryOrderFeeResponse);
        }

        float paidAmount = NumberUtils.parseFloat(queryOrderFeeResponse.getPaidAmount());
        float unPayPrice = NumberUtils.parseFloat(queryOrderFeeResponse.getUnpayPrice());
        float discountPrice = NumberUtils.parseFloat(queryOrderFeeResponse.getDiscountPrice());
        float discountAmount = NumberUtils.parseFloat(queryOrderFeeResponse.getDiscountAmount());
        float totalAmount = NumberUtils.parseFloat(queryOrderFeeResponse.getTotalAmount());
        Long payTime = queryOrderFeeResponse.getPayTime();
        if (payTime != null && 0 == payTime) {
            log.info("[端网云查费] 本地返回结果纠正，删除pay_time，参数=[{}]， 查询结果=[{}]", queryFeeRequest, queryFeeResponse);
            queryOrderFeeResponse.setPayTime(null);
        }
        int status = getFeeStatus(paidAmount, unPayPrice, discountPrice, discountAmount, totalAmount);
        queryOrderFeeResponse.setStatus(status);
        //重新获取状态
        status = queryOrderFeeResponse.getStatus();
        queryOrderFeeResponse.setEnterTime(orderInfo.getEnterTime() == null ? DateTools.unixTimestamp() : orderInfo.getEnterTime());
        queryOrderFeeResponse.setParkName(park.getParkName());
        queryOrderFeeResponse.setOrderNum(orderInfo.getOrderNum() == null ? "E" + CodeTools.GenerateOrderNum() : orderInfo.getOrderNum());
        queryOrderFeeResponse.setCarType(queryFeeRequest.getCarType());
        //查询免费时长
        if (park.getId() != null) {
            if (parkConfig != null) {
                queryOrderFeeResponse.setFreeTime((long) parkConfig.getIsfreeAfterpay(15));
            } else {
                queryOrderFeeResponse.setFreeTime(0L);
            }
        }
        if (StringUtils.isBlank(orderInfo.getOrderNum())) {
            return queryOrderFeeResponse;
        }
        //初次缴费或已缴费超时
        if (status == 2 || status == 4) {
            OrderPay orderPay = new OrderPay();
            orderPay.setParkId(orderInfo.getParkId());
            orderPay.setOrderNum(orderInfo.getOrderNum());
            orderPay.setPayStatus(PayStatusConstants.PAID);
            OrderSumFeeDto orderSumFeeDto = orderPayDao.sumFee(orderPay);
            if (orderSumFeeDto != null && orderSumFeeDto.getPaidPrice() > 0) {
                float paidPrice = orderSumFeeDto.getPaidPrice();
                float discountPrice1 = orderSumFeeDto.getDiscountPrice();
                //查询平台是已缴费，则刷新已缴费
                if ((status == 2 && NumberUtils.parseDecimal(unPayPrice).compareTo(NumberUtils.parseDecimal(paidPrice)) == 0)
                        || (status == 4 && totalAmount == NumberUtils.decimalAdd(discountPrice1, paidPrice, discountPrice).floatValue())) {
                    log.info("[端网云查费] 本地未刷新已缴费, 车牌号[{}]", queryOrderFeeResponse.getPlateNum());
                    queryOrderFeeResponse.setUnpayPrice("0.00");
                    queryOrderFeeResponse.setPaidAmount(String.valueOf(paidPrice));
                    queryOrderFeeResponse.setDiscountAmount(String.valueOf(discountPrice1));
                    queryOrderFeeResponse.setDiscountPrice("0.00");
                    queryOrderFeeResponse.setPayTime(orderSumFeeDto.getLastPayTime());
                    queryOrderFeeResponse.setStatus(3);
                }
            }
        }
        queryOrderFeeResponse.setInsideDetails(handleInsideDetails(queryOrderFeeResponse, orderInfo,
                queryFeeRequest.getChannelId() != null, Integer.valueOf(1).equals(park.getIsInterior())));
        //旧版本不上报优惠，查询平台的某个优惠
        if (NumberUtils.parseDouble(queryFeeResponse.getDiscountPrice()) > 0
                && StringUtils.isBlank(queryFeeResponse.getDiscountNos())) {
            OrderDiscount orderDiscount = orderDiscountDao.selectOne(Wrappers.lambdaQuery(OrderDiscount.class)
                    .eq(OrderDiscount::getOrderNum, orderInfo.getOrderNum())
                    .in(OrderDiscount::getStatus, Arrays.asList(0, 3))
                    .last(SqlConstant.LIMIT_ONE));
            if (orderDiscount != null) {
                queryFeeResponse.setDiscountNos(orderDiscount.getDiscountNo());
                log.info("[端网云查费] 本地没有上报优惠券编号, orderNum[{}], discountNo[{}]",
                        orderDiscount.getOrderNum(), orderDiscount.getDiscountNo());
            }
        }
        if (NumberUtils.parseDouble(queryFeeResponse.getDiscountPrice()) > 0) {
            String discountNos = queryFeeResponse.getDiscountNos();
            if (StringUtils.isNotBlank(discountNos)) {
                List<OrderDiscount> orderDiscounts = orderDiscountDao.selectList(Wrappers.lambdaQuery(OrderDiscount.class)
                        .eq(OrderDiscount::getParkId, park.getId()).in(OrderDiscount::getDiscountNo,Arrays.asList(discountNos.split(","))));
                if (orderDiscounts.size() > 0) {
                    OrderPayDiscount.MerchantCouponsInfo merchantCouponsInfo = OrderPayDiscount.getMerchantCouponsInfo(orderDiscounts,
                            NumberUtils.parseDecimal(queryFeeResponse.getMerchantDiscountPrice()));
                    OrderPayDiscount.ThirdCouponsInfo thirdCouponsInfo = OrderPayDiscount.getThirdCouponsInfo(orderDiscounts,
                            NumberUtils.parseDecimal(queryFeeResponse.getThirdDiscountPrice()));
                    if (merchantCouponsInfo != null) {
                        redisUtils.hPut(RedisDiscountKeyConstant.PAY_DISCOUNT_PRE + park.getId() + ":" + orderInfo.getOrderNum(),
                                OrderPayDiscount.DiscountSourceEnum.MERCHANT_COUPONS.getDesc(), merchantCouponsInfo, 60*60*24);
                    }
                    if (thirdCouponsInfo != null) {
                        redisUtils.hPut(RedisDiscountKeyConstant.PAY_DISCOUNT_PRE + park.getId() + ":" + orderInfo.getOrderNum(),
                                OrderPayDiscount.DiscountSourceEnum.THIRD_COUPONS.getDesc(), thirdCouponsInfo, 60*60*24);
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(queryFeeResponse.getVipTypeId())) {
                OrderPayDiscount.VipCouponsInfo vipCouponsInfo = new OrderPayDiscount.VipCouponsInfo();
                for (Integer typeId : queryFeeResponse.getVipTypeId()) {
                    setVipCouponsInfo(typeId, NumberUtils.parseDecimal(queryFeeResponse.getVipDiscountPrice()), vipCouponsInfo);
                }
                redisUtils.hPut(RedisDiscountKeyConstant.PAY_DISCOUNT_PRE + park.getId() + ":" + orderInfo.getOrderNum(),
                        OrderPayDiscount.DiscountSourceEnum.VIP_COUPONS.getDesc(), vipCouponsInfo, 60*60*24);
            }
        }
        //标记使用优惠券
        redisUtils.set(RedisDiscountKeyConstant.DISCOUNT_USE_PRE +park.getId()+":"+orderInfo.getOrderNum(),queryFeeResponse.getDiscountNos(),60*60*24);

        return queryOrderFeeResponse;
    }

    /**
     * 处理分账信息
     * @param response
     * @param mainOrder
     * @param isChannelQueryFee
     * @param isInterior 是否场中场
     * @return
     */
    private List<QueryFeeRegionDetail> handleInsideDetails(QueryOrderFeeResponse response, OrderInfo mainOrder, boolean isChannelQueryFee, boolean isInterior) {
        List<QueryFeeRegionDetail> validInsideDetails = new ArrayList<>(2);
        if (CollectionUtils.isEmpty(response.getInsideDetails())) {
            if (!isInterior) {
                return null;
            }
            QueryFeeRegionDetail insideDetail = new QueryFeeRegionDetail(null,
                    NumberUtils.decimalAdd(response.getUnpayPrice(), response.getDiscountPrice()).toString(),
                    NumberUtils.parseDecimal(response.getDiscountPrice()).toString(), null,
                    NumberUtils.parseDecimal(response.getUnpayPrice()).toString(),
                    NumberUtils.parseDecimal(response.getUnpayPrice()).toString(),
                    mainOrder.getRegionId(), null, mainOrder.getEnterTime(),
                    isChannelQueryFee ? response.getQueryTime() : null, response.getPlateNum(), null);
            validInsideDetails.add(insideDetail);
            log.info("子账单信息{}", validInsideDetails);
            return validInsideDetails;
        }

        Set<String> regionCodes = response.getInsideDetails().stream().map(QueryFeeRegionDetail::getRegionCode).collect(Collectors.toSet());
        Map<String, Long> parkRegionMap = parkRegionDao.selectList(Wrappers.lambdaQuery(ParkRegion.class)
                        .eq(ParkRegion::getParkId, mainOrder.getParkId())
                        .in(ParkRegion::getRegionCode, regionCodes))
                .stream().collect(Collectors.toMap(ParkRegion::getRegionCode, ParkRegion::getId));
        if (parkRegionMap.isEmpty()) {
            log.info("分账信息区域无效或无对象子订单");
            return null;
        }
        Map<Long, OrderSonInfo> orderSonInfoMap = orderSonInfoService.getInfosByOrderNum(mainOrder.getParkId(), mainOrder.getOrderNum())
                .stream().collect(Collectors.toMap(OrderSonInfo::getRegionId, Function.identity()));
        List<OrderSonInfo> updated = new ArrayList<>(orderSonInfoMap.size());

        BigDecimal totalPrice = NumberUtils.decimalAdd(response.getUnpayPrice(), response.getDiscountPrice());
//        BigDecimal paidPrice = NumberUtils.parseDecimal(response.getPaidAmount());
        BigDecimal discountPrice = NumberUtils.parseDecimal(response.getDiscountPrice());
        BigDecimal unpaidPrice = NumberUtils.parseDecimal(response.getUnpayPrice());
        for (QueryFeeRegionDetail insideDetail : response.getInsideDetails()) {
            double insideTotalAmount = NumberUtils.parseDouble(insideDetail.getTotalAmount());
            if (insideTotalAmount <= 0) {
                log.info("区域金额为0, 暂不记录明细信息|{}|{}", mainOrder.getOrderNum(), insideDetail.getRegionCode());
                continue;
            }
            totalPrice = NumberUtils.decimalSubtract(totalPrice, insideDetail.getTotalAmount());
            discountPrice = NumberUtils.decimalSubtract(discountPrice, insideDetail.getDiscountPrice());
            unpaidPrice = NumberUtils.decimalSubtract(unpaidPrice, insideDetail.getUnpayPrice());
            Long regionId = parkRegionMap.get(insideDetail.getRegionCode());
            if (regionId == null) {
                log.info("无法找到对应区域信息|{}|{}", mainOrder.getOrderNum(), insideDetail.getRegionCode());
                continue;
            }
            insideDetail.setRegionId(regionId);
            insideDetail.setPlateNum(response.getPlateNum());
            if (!orderSonInfoMap.isEmpty()) {
                OrderSonInfo orderSonInfo = orderSonInfoMap.get(regionId);
                if (orderSonInfo == null) {
                    log.info("无法找到对应区域子订单信息|{}|{}|{}", mainOrder.getOrderNum(), insideDetail.getRegionCode(), regionId);
                    insideDetail.setEnterTime(mainOrder.getEnterTime());
                    continue;
                }
                insideDetail.setOrderSonId(orderSonInfo.getId());
                insideDetail.setEnterTime(orderSonInfo.getEnterTime());
                if (orderSonInfo.getExitTime() != null) {
                    insideDetail.setExitTime(orderSonInfo.getExitTime());
                }
            } else {
                insideDetail.setEnterTime(mainOrder.getEnterTime());
            }
            validInsideDetails.add(insideDetail);
        }

        OrderSonInfo orderSonInfo = orderSonInfoMap.get(mainOrder.getRegionId());
        if (orderSonInfo == null) {
            log.info("无法找到主订单对应子订单信息|{}|{}", mainOrder.getOrderNum(), mainOrder.getRegionId());
        } else {
            QueryFeeRegionDetail insideDetail = new QueryFeeRegionDetail(null,
                    totalPrice.toString(), discountPrice.toString(), null, unpaidPrice.toString(), unpaidPrice.toString(),
                    orderSonInfo.getRegionId(), orderSonInfo.getId(), orderSonInfo.getEnterTime(),
                    isChannelQueryFee ? response.getQueryTime() : null, response.getPlateNum(), null);
            validInsideDetails.add(insideDetail);
        }
        log.info("子账单信息{}", validInsideDetails);
        return validInsideDetails;
    }

    private Integer getFeeStatus(Float paidAmount, Float unPayPrice, Float discountPrice, Float discountAmount, Float totalAmount) {
        log.info("判断费用状态参数：{}，{}，{}，{}，{}", paidAmount, unPayPrice, discountPrice, discountAmount, totalAmount);
        if (totalAmount == 0) {
            // 免费时长内无需缴费
            return 1;
        }
        if (discountAmount.equals(totalAmount)) {
            // 已缴费未超时
            return 3;
        }
        if ((unPayPrice > 0 || discountPrice >= totalAmount) && paidAmount == 0 && discountAmount == 0) {
            // 初次缴费
            return 2;
        }
        if (unPayPrice == 0 && paidAmount > 0) {
            // 已缴费未超时
            return 3;
        }
        if (unPayPrice > 0 && (paidAmount > 0 || discountAmount > 0)) {
            // 已缴费已超时
            return 4;
        }
        if (unPayPrice > 0) {
            // 初次缴费
            return 2;
        } else {
            // 免费时长内无需缴费
            return 1;
        }
    }

    /**
     * 处理历史金额
     *
     * @param orderNum 订单号
     * @param park 车场
     * @param queryOrderFeeResponse 响应
     */
    private void dealHistoryMoney(String orderNum, Park park, QueryOrderFeeResponse queryOrderFeeResponse) {
        // 如果历史金额返回不完整时，则汇总平台金额并赋值
        if (StringUtils.isBlank(queryOrderFeeResponse.getTotalAmount())
                || StringUtils.isBlank(queryOrderFeeResponse.getPaidAmount())
                || StringUtils.isBlank(queryOrderFeeResponse.getDiscountAmount())) {
            OrderPay orderPay = new OrderPay();
            orderPay.setParkId(park.getId());
            orderPay.setOrderNum(orderNum);
            orderPay.setPayStatus(PayStatusConstants.PAID);
            OrderSumFeeDto orderSumFeeDto = orderPayDao.sumFee(orderPay);
            if (orderSumFeeDto != null) {
                BigDecimal totalPrice = NumberUtils.decimalAdd(orderSumFeeDto.getTotalPrice(), queryOrderFeeResponse.getUnpayPrice(), queryOrderFeeResponse.getDiscountPrice());
                queryOrderFeeResponse.setTotalAmount(String.valueOf(totalPrice));
                queryOrderFeeResponse.setPaidAmount(String.valueOf(orderSumFeeDto.getPaidPrice()));
                queryOrderFeeResponse.setDiscountAmount(String.valueOf(orderSumFeeDto.getDiscountPrice()));
                queryOrderFeeResponse.setPayTime(orderSumFeeDto.getLastPayTime());
            } else {
                BigDecimal totalPrice = NumberUtils.decimalAdd(queryOrderFeeResponse.getUnpayPrice(), queryOrderFeeResponse.getDiscountPrice());
                queryOrderFeeResponse.setTotalAmount(String.valueOf(totalPrice));
                queryOrderFeeResponse.setPaidAmount("0.00");
                queryOrderFeeResponse.setDiscountAmount("0.00");
            }
        }
    }

    public QueryFeeRequest buildRequest(Long parkId, QueryFeeRequest queryFeeRequest) {
        QueryFeeRequest feeRequest = new QueryFeeRequest();
        BeanUtils.copyProperties(queryFeeRequest, feeRequest);
        feeRequest.setKey(null);
        feeRequest.setParkId(null);
        feeRequest.setTopic(null);
        feeRequest.setExtraInfo(null);
        String key = RedisConstants.PNC_EXIT_PAY_ORDER_PROFILE + parkId + "_" + queryFeeRequest.getOrderId();
        //如果是按场内预缴费流程支付，且有出口缴费信号时，则下发抬杆指令
        if (redisUtils.exists(key)) {
            ExitPayCautionRequest exitPayCautionRequest = redisUtils.get(key, ExitPayCautionRequest.class);
            log.info("<端网云-缴费查询> 通道有待缴费车辆，参数：{}", exitPayCautionRequest);
            if (exitPayCautionRequest != null && exitPayCautionRequest.getPlateNum().equals(queryFeeRequest.getPlateNum())) {
                feeRequest.setChannelId(exitPayCautionRequest.getChannelId());
                feeRequest.setPlateNum(null);
                feeRequest.setOrderId(null);
            }
        }
        return feeRequest;
    }

    private void setVipCouponsInfo(Integer vipTypeId, BigDecimal discountPrice, OrderPayDiscount.VipCouponsInfo vipCouponsInfo) {
        VipTypeDto vipTypeDto = vipTypeDao.selectById(vipTypeId);
        if (vipTypeDto == null) {
            return;
        }
        vipCouponsInfo.addTypeId(vipTypeId);
        vipCouponsInfo.addDiscountType(vipTypeDto.getType());
        vipCouponsInfo.setDiscountPrice(discountPrice);
    }
}
