package com.icetech.park.service.down.pnc.impl;

import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.p2c.P2rBaseRequest;
import com.icetech.cloudcenter.domain.request.p2r.TicketGotRequest;
import com.icetech.cloudcenter.domain.request.pnc.PncGetticketSuccessRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2rBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.park.service.report.p2r.IRobotEventService;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.utils.AssertTools;
import com.icetech.common.utils.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


/**
 * 云云，机器人小票领取成功通知实现 <br>
 * 接口功能：车主领取完小票后，云平台将收到的小票领取成功信息通知给第三方平台；
 */
@Service
@Slf4j
public class PncTicketGotServiceImpl extends AbstractService implements IRobotEventService {

    @Autowired
    private PncDownHandle downHandle;

    @Override
    public P2rBaseResponse executeEvent(P2rBaseRequest p2rBaseRequest, String cmd, TokenDeviceVo tokenDeviceVo) {
        // 获取bizContent请求参数
        TicketGotRequest ticketGotRequest = JsonUtils.convert2bean(p2rBaseRequest.getBizContent(), TicketGotRequest.class);

        // 必填项参数校验
        verifyParams(ticketGotRequest);

        // 封装响应结构，封装下发京能MQTT需要的参数
        PncGetticketSuccessRequest pncGetticketSuccessRequest = new PncGetticketSuccessRequest();
        pncGetticketSuccessRequest.setChannelId(tokenDeviceVo.getInandoutCode());
        pncGetticketSuccessRequest.setOrderId(ticketGotRequest.getOrderNum());

        // 下发京能MQTT消息
        String messageId = downHandle.signAndSend(tokenDeviceVo.getParkCode(), DownServiceEnum.小票领取下发.getServiceName(), pncGetticketSuccessRequest);
        AssertTools.notNull(messageId, CodeConstants.ERROR_3003, "下发小票领取成功通知失败");

        return P2rBaseResponse.success(p2rBaseRequest);
    }
}
