package com.icetech.park.service.down.pnc.impl;

import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.park.component.AsyncNotifyClient;
import com.icetech.park.dao.other.ChannelAlarmDao;
import com.icetech.cloudcenter.domain.constants.RedisConstants;
import com.icetech.park.domain.entity.ChannelAlarm;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.CloseBrakeRequest;
import com.icetech.cloudcenter.domain.request.OpenBrakeRequest;
import com.icetech.cloudcenter.domain.request.OpeningDtoRequest;
import com.icetech.cloudcenter.domain.request.RemoteSwitchRequest;
import com.icetech.cloudcenter.domain.response.p2c.RemoteSwitchResponse;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.park.service.impl.AlarmServiceImpl;
import com.icetech.third.utils.RedisUtils;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.LogWarnTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Map;


/**
 * 远程控制开关闸接口
 *
 * @author fangct
 */
@Service
@Slf4j
public class PncRemoteSwitchServiceImpl implements NotifyService<RemoteSwitchRequest> {

    @Autowired
    private PncDownHandle downHandle;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private AlarmServiceImpl alarmService;
    @Autowired
    private ChannelAlarmDao channelAlarmDao;
    @Autowired
    private ParkService parkService;
    @Resource
    private AsyncNotifyClient asyncNotifyClient;

    public ObjectResponse<Void> remoteSwitch(RemoteSwitchRequest remoteSwitchRequest, String topic, RemoteSwitchRequest.ExtraInfo extraInfo) {
        String parkCode = remoteSwitchRequest.getParkCode();
        remoteSwitchRequest.setParkCode(null);
        String messageId = downHandle.signAndSendAsyncResult(parkCode, DownServiceEnum.远程开关闸.getServiceName(),
                remoteSwitchRequest, topic, JsonUtils.toString(extraInfo));
        if (StringUtils.isEmpty(messageId)){
            alarmService.switchFailHandler(parkCode, null, remoteSwitchRequest.getChannelId());
            return ObjectResponse.failed(CodeConstants.ERROR,"下发消息失败");
        }
        return ObjectResponse.failed(CodeConstants.ERROR_12002, messageId);
    }

    @Override
    public void notify(String messageId, ObjectResponse<String> objectResponse, SendInfoRecord<RemoteSwitchRequest> sendInfoRecord) {
        RemoteSwitchRequest remoteSwitchRequest = sendInfoRecord.getParams();
        boolean success = false;
        Map<String, Object> stringObjectMap = null;
        if (ObjectResponse.isSuccess(objectResponse)){
            stringObjectMap = JsonUtils.parseMap(objectResponse.getData());
            if (stringObjectMap != null) {
                Integer resultStatus = (Integer) stringObjectMap.get("resultStatus");
                //3和4状态码分别代表超时和故障
                if (resultStatus != 3 && resultStatus != 4) {
                    success = true;
                }
            }
        }

        if (!success){
            log.warn("[监控埋点] alarmType:[{}],keyword1:[{}],keyword2:[{}]",
                    LogWarnTypeEnum.开闸失败.name() + "-" + "端网云", remoteSwitchRequest, objectResponse);
            alarmService.switchFailHandler(sendInfoRecord.getParkCode(), sendInfoRecord.getParkId(), remoteSwitchRequest.getChannelId());

            asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), ObjectResponse.failed(CodeConstants.ERROR_3002));
            return;
        }

        RemoteSwitchResponse remoteSwitchResponse = new RemoteSwitchResponse();
        Object executeTime = stringObjectMap.get("executeTime");
        String image = (String) stringObjectMap.get("image");
        remoteSwitchResponse.setExecuteTime(executeTime == null ? DateTools.unixTimestamp() : ((long) (Integer) executeTime));
        if (image == null) {
            image = redisUtils.get(RedisConstants.PNC_FILEID_PROFILE + sendInfoRecord.getParkCode() + messageId, String.class);
        }
        remoteSwitchResponse.setImage(image);
        RemoteSwitchRequest.ExtraInfo extraInfo = JsonUtils.parseObject(sendInfoRecord.getExtraInfo(), RemoteSwitchRequest.ExtraInfo.class);
        if (RemoteSwitchRequest.ExtraInfoEnum.CLOSE.val.equals(extraInfo.getBiz())) {
            CloseBrakeRequest closeBrakeRequest = JsonUtils.parseObject(JsonUtils.toString(extraInfo.getRequestVO()),
                    CloseBrakeRequest.class);
            //添加开关闸记录
            OpeningDtoRequest openingDtoRequest = new OpeningDtoRequest();
            BeanUtils.copyProperties(closeBrakeRequest, openingDtoRequest);
            openingDtoRequest.setImgUrl(closeBrakeRequest.getImagePath() == null ? remoteSwitchResponse.getImage() : closeBrakeRequest.getImagePath() + "," + remoteSwitchResponse.getImage());
            openingDtoRequest.setExecuteTime(remoteSwitchResponse.getExecuteTime());
            openingDtoRequest.setSourcegate(4);
            parkService.saveOpeningRecord(openingDtoRequest);
        } else if (RemoteSwitchRequest.ExtraInfoEnum.OPEN.val.equals(extraInfo.getBiz())) {
            addOpeningRecord(JsonUtils.parseObject(JsonUtils.toString(extraInfo.getRequestVO()), OpenBrakeRequest.class),
                    image, remoteSwitchResponse.getExecuteTime());
            // 更新滞留车辆
            ChannelAlarm channelAlarm = new ChannelAlarm();
            channelAlarm.setParkId(sendInfoRecord.getParkId());
            channelAlarm.setChannelCode(remoteSwitchRequest.getChannelId());
            channelAlarm.setStatus(ChannelAlarm.Status.已处理.getStatus());
            channelAlarmDao.update(channelAlarm);
        }
        asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), ObjectResponse.success());

    }

    public void addOpeningRecord(Object openBrakeRequest, String image, Long executeTime) {
        //添加开闸记录
        OpeningDtoRequest openingDtoRequest = new OpeningDtoRequest();
        BeanUtils.copyProperties(openBrakeRequest, openingDtoRequest);
        openingDtoRequest.setImgUrl(image);
        openingDtoRequest.setExecuteTime(executeTime);
        parkService.saveOpeningRecord(openingDtoRequest);
    }
}
