package com.icetech.park.service.down.pnc.impl;

import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.p2c.P2rBaseRequest;
import com.icetech.cloudcenter.domain.request.p2r.RecCashRequest;
import com.icetech.cloudcenter.domain.request.pnc.PncCashMsgReqeust;
import com.icetech.cloudcenter.domain.response.p2c.P2rBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.park.service.report.p2r.IRobotEventService;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.utils.AssertTools;
import com.icetech.common.utils.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


/**
 * 云云，机器人现金收费通知接口 <br>
 * 接口功能：云平台将机器人收到的现金情况通知第三方平台；
 */
@Service
@Slf4j
public class PncRecCashServiceImpl extends AbstractService implements IRobotEventService {

    /**
     * 签名并下发MQTT
     */
    @Autowired
    private PncDownHandle downHandle;

    @Override
    public P2rBaseResponse executeEvent(P2rBaseRequest p2rBaseRequest, String cmd, TokenDeviceVo tokenDeviceVo) {
        // 获取机器人上报的bizContent请求参数
        RecCashRequest recCashRequest = JsonUtils.convert2bean(p2rBaseRequest.getBizContent(), RecCashRequest.class);

        // 必填项参数校验
        verifyParams(recCashRequest);

        // 封装响应结构，将机器人上报的参数转为下报京能MQTT需要的格式
        PncCashMsgReqeust pncCashMsgReqeust = new PncCashMsgReqeust();
        pncCashMsgReqeust.setOrderId(recCashRequest.getOrderNum());
        pncCashMsgReqeust.setChannelId(tokenDeviceVo.getInandoutCode());
        pncCashMsgReqeust.setExpectCash(recCashRequest.getExpectCash());
        pncCashMsgReqeust.setTotalCashAmount(recCashRequest.getTotalCashAmount());
        pncCashMsgReqeust.setTotalCashNum(recCashRequest.getTotalCashNum());
        pncCashMsgReqeust.setDetails(recCashRequest.getDetails());

        // 下发MQTT
        String messageId = downHandle.signAndSend(tokenDeviceVo.getParkCode(), DownServiceEnum.接收现金下发.getServiceName(), pncCashMsgReqeust);
        AssertTools.notNull(messageId, CodeConstants.ERROR_3003, "下发现金收费通知消息失败");

        return P2rBaseResponse.success(p2rBaseRequest);
    }

}
