package com.icetech.park.service.down.pnc.impl;

import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.DownPayCodeRequest;
import com.icetech.cloudcenter.domain.request.p2c.P2rBaseRequest;
import com.icetech.cloudcenter.domain.request.p2r.PayCodeRequest;
import com.icetech.cloudcenter.domain.request.pnc.PncPayCodeRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2rBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.park.service.report.p2r.IRobotEventService;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.AssertTools;
import com.icetech.common.utils.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


/**
 * 云云，支付码推送实现
 */
@Service
@Slf4j
public class PncPayCodeServiceImpl extends AbstractService implements IRobotEventService {

    @Autowired
    private PncDownHandle downHandle;

    @Override
    public P2rBaseResponse executeEvent(P2rBaseRequest p2rBaseRequest, String cmd, TokenDeviceVo tokenDeviceVo) {
        // 获取bizContent请求参数
        PayCodeRequest payCodeRequest = JsonUtils.convert2bean(p2rBaseRequest.getBizContent(), PayCodeRequest.class);

        //参数校验
        verifyParams(payCodeRequest);

        // 封装响应结构
        PncPayCodeRequest pncPayCodeRequest = new PncPayCodeRequest();
        pncPayCodeRequest.setChannelId(tokenDeviceVo.getInandoutCode());
        pncPayCodeRequest.setOrderId(payCodeRequest.getOrderNum());
        pncPayCodeRequest.setPayCode(payCodeRequest.getPayCode());

        // 下发京能MQTT消息
        String messageId = downHandle.signAndSend(tokenDeviceVo.getParkCode(), cmd, pncPayCodeRequest);
        AssertTools.notNull(messageId, CodeConstants.ERROR_3003, "下发支付码推送失败");

        return P2rBaseResponse.success(p2rBaseRequest);
    }

    /**
     * 下发支付码
     */
    public ObjectResponse<String> downPayCode(DownPayCodeRequest downPayCodeRequest, String parkCode) {
        log.info("[端网云]下发支付码推送,parkCode[{}],payCode[{}],channelId[{}],orderNum[{}]",
                parkCode, downPayCodeRequest.getPayCode(), downPayCodeRequest.getChannelId(),
                downPayCodeRequest.getOrderNum());

        // 封装响应结构
        PncPayCodeRequest pncPayCodeRequest = new PncPayCodeRequest();
        pncPayCodeRequest.setChannelId(downPayCodeRequest.getChannelId());
        pncPayCodeRequest.setOrderId(downPayCodeRequest.getOrderNum());
        pncPayCodeRequest.setPayCode(downPayCodeRequest.getPayCode());

        String messageId = downHandle.signAndSend(parkCode, DownServiceEnum.支付码下发.getServiceName(), pncPayCodeRequest);
        AssertTools.notNull(messageId, CodeConstants.ERROR_3003, "下发支付码推送失败");

        return ObjectResponse.success();
    }

}
