package com.icetech.park.service.down.pnc.impl;

import com.icetech.cloudcenter.api.AlarmService;
import com.icetech.cloudcenter.api.NoplateExitService;
import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.component.AsyncNotifyClient;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.NoplateExitRequest;
import com.icetech.cloudcenter.domain.request.pnc.PncNoplateExitRequest;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * 缴费通知下发接口
 *
 * @author fangct
 */
@Service
public class PncNoplateExitServiceImpl implements NoplateExitService, NotifyService<NoplateExitRequest> {

    @Autowired
    private PncDownHandle downHandle;
    @Autowired
    private OrderService orderService;
    @Autowired
    private ParkService parkService;
    @Autowired
    private AlarmService alarmService;
    @Resource
    private AsyncNotifyClient asyncNotifyClient;

    @Override
    public ObjectResponse<Void> noplateExit(NoplateExitRequest noplateExitRequest) {
        String parkCode = noplateExitRequest.getParkCode();
        noplateExitRequest.setParkCode(null);
        PncNoplateExitRequest pncNoplateExitRequest = new PncNoplateExitRequest();
        BeanUtils.copyProperties(noplateExitRequest, pncNoplateExitRequest);
        pncNoplateExitRequest.setInoutEvent(noplateExitRequest.getExitWay());
        pncNoplateExitRequest.setExTerminal(noplateExitRequest.getExitTerminal());
        pncNoplateExitRequest.setOperAccount(noplateExitRequest.getOperAccount());
        ObjectResponse<Park> parkObjectResponse = parkService.findByParkCode(parkCode);
        Park park = parkObjectResponse.getData();
        OrderInfo orderInfoParm = new OrderInfo();
        //有订单号时，只按订单号查询，车牌有可能被修改
        if (noplateExitRequest.getOrderNum() == null){
            orderInfoParm.setPlateNum(pncNoplateExitRequest.getPlateNum());
        }
        orderInfoParm.setOrderNum(noplateExitRequest.getOrderNum());
        orderInfoParm.setParkId(park.getId());
        ObjectResponse<OrderInfo> orderInfoObjectResponse = orderService.findByOrderInfo(orderInfoParm);
        if (ObjectResponse.isSuccess(orderInfoObjectResponse)){
            OrderInfo orderInfo = orderInfoObjectResponse.getData();
            pncNoplateExitRequest.setOrderId(orderInfo.getLocalOrderNum());
            String messageId = downHandle.signAndSendAsyncResult(park.getId(), parkCode, park.getKey(), DownServiceEnum.无牌车离场.getServiceName(),
                    pncNoplateExitRequest, pncNoplateExitRequest.getChannelId(), noplateExitRequest.getTopic(), null);
            if (messageId != null){
                return ObjectResponse.failed(CodeConstants.ERROR_12002, messageId);
            }
        } else {
            alarmService.switchFailHandler(parkCode, park.getId(), noplateExitRequest.getChannelId());
            return ObjectResponse.failed(CodeConstants.ERROR_3002, "当前车辆不在场内");
        }
        alarmService.switchFailHandler(parkCode, park.getId(), noplateExitRequest.getChannelId());
        return ObjectResponse.failed(CodeConstants.ERROR_3002);
    }

    @Override
    public void notify(String messageId, ObjectResponse<String> response, SendInfoRecord<NoplateExitRequest> sendInfoRecord) {
        asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), response);
    }

}
